/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationRequestServlet
extends HttpServlet {
    private static String COMMON_ERROR_PAGE = "";
    private String locale = null;
    private FSAllianceManager instAlliance = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationRequestServlet Init");
        }
        this.instAlliance = FSServiceUtils.getAllianceInstance();
    }

    protected void setTerminationURL(String string) {
        try {
            if (this.instAlliance != null) {
                COMMON_ERROR_PAGE = this.instAlliance.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(this.request);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor;
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSTerminationRequestServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSTerminationRequestServlet", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.instAlliance == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        try {
            fSHostedProviderDescriptor = this.instAlliance.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.locale = FSServiceUtils.getLocale(httpServletRequest);
        this.request = httpServletRequest;
        this.setTerminationURL(fSHostedProviderDescriptor.getProviderID());
        FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification();
        try {
            fSFederationTerminationNotification = FSFederationTerminationNotification.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        catch (SAMLException sAMLException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        if (fSFederationTerminationNotification == null) {
            this.showBadRequestErrorPage(httpServletResponse);
        } else {
            this.doRequestProcessing(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, fSFederationTerminationNotification);
        }
    }

    private void doRequestProcessing(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSFederationTerminationNotification fSFederationTerminationNotification) {
        Object object;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationRequestServlet::doRequestProcessing");
        }
        String string = fSFederationTerminationNotification.getProviderId();
        boolean bl = true;
        if (FSServiceUtils.isSigningOn()) {
            try {
                object = this.instAlliance.getProvider(string);
                if (object == null) {
                    FSUtils.debug.error("Remote provider metadata not found.");
                    FSUtils.debug.error("Cannot retrieve provider descriptor.");
                    FSUtils.error("FSTerminationRequestServlet::doRequestProcessing", FSUtils.bundle.getString("termination-invalid-provider"));
                    this.returnToSource(httpServletResponse, string);
                    return;
                }
                FSUtils.debug.message("Calling verifyTerminationSignature");
                bl = this.verifyTerminationSignature(httpServletRequest, (FSProviderDescriptor)object);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("Remote provider metadata not found.");
                FSUtils.debug.error("Cannot retrieve provider descriptor.");
                FSUtils.error("FSTerminationRequestServlet::doRequestProcessing", FSUtils.bundle.getString("termination-invalid-provider"));
                this.returnToSource(httpServletResponse, string);
                return;
            }
            catch (FSException fSException) {
                FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on termination request is invalidCannot proceed federation termination");
                FSUtils.error("FSFedTerminationHandler", FSUtils.bundle.getString("termination-invalid-signature"));
                this.returnToSource(httpServletResponse, string);
                return;
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on termination request is invalidCannot proceed federation termination");
                FSUtils.error("FSFedTerminationHandler", FSUtils.bundle.getString("termination-invalid-signature"));
                this.returnToSource(httpServletResponse, string);
                return;
            }
        }
        if (bl) {
            object = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
            if (object != null) {
                if (object.contains(string)) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSFedTerminationHandler fSFedTerminationHandler = fSServiceManager.getFedTerminationHandler(fSFederationTerminationNotification, fSHostedProviderDescriptor);
                        if (fSFedTerminationHandler != null) {
                            fSFedTerminationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                            fSFedTerminationHandler.processTerminationRequest(httpServletRequest, httpServletResponse, fSFederationTerminationNotification);
                            return;
                        }
                        FSUtils.debug.error("Unable to get termination handler. User account Not valid");
                    } else {
                        FSUtils.debug.error("FSServiceManager instance is null Cannot process termination request");
                    }
                } else {
                    FSUtils.debug.error("Remote provider not in trusted list");
                }
            } else {
                FSUtils.debug.error("Remote provider not in trusted list");
                FSUtils.debug.error("Trusted provider list is empty.");
            }
        } else {
            FSUtils.debug.error("FSTerminationRequestServlet::doRequestProcesing Signature on termination request is invalidCannot proceed federation termination");
            FSUtils.error("FSFedTerminationHandler", FSUtils.bundle.getString("termination-invalid-signature"));
        }
        this.returnToSource(httpServletResponse, string);
    }

    private void returnToSource(HttpServletResponse httpServletResponse, String string) {
        try {
            String string2 = "";
            if (this.instAlliance != null) {
                string2 = this.instAlliance.getProvider(string).getFederationTerminationServiceReturnURL();
                if (string2 == null || string2.length() < 1) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(COMMON_ERROR_PAGE);
                    char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("termination-invalid-federation")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSUtils.debug.message("returnToSource returns URL : " + string2);
                httpServletResponse.sendRedirect(string2);
                return;
            }
            FSUtils.debug.message("Alliance Manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(COMMON_ERROR_PAGE);
                char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("termination-invalid-federation")));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Redirect/sendError failed. Control halted");
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted" + iOException.getMessage());
        }
    }

    private boolean verifyTerminationSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::verifyTerminationSignature");
        }
        String string = "";
        string = fSProviderDescriptor.getKeyInfo();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler.signTerminationRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string))) {
            FSUtils.debug.error("Termination request is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Termination request is properly signed");
        }
        return true;
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMON_ERROR_PAGE);
        char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("termination-request-improper")));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("termination-failed-locally")));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }
}

