/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRegistrationRequestServlet
extends HttpServlet {
    private static String COMMON_ERROR_PAGE = "";
    private FSAllianceManager instAlliance = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationRequestServlet Init");
        }
        this.instAlliance = FSServiceUtils.getAllianceInstance();
    }

    protected void setRegistrationURL(String string) {
        try {
            if (this.instAlliance != null) {
                COMMON_ERROR_PAGE = this.instAlliance.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(this.request);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor;
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSRegistrationRequestServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSRegistrationRequestServlet", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.instAlliance == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        try {
            fSHostedProviderDescriptor = this.instAlliance.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = httpServletRequest;
        this.setRegistrationURL(fSHostedProviderDescriptor.getProviderID());
        FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest();
        try {
            fSNameRegistrationRequest = FSNameRegistrationRequest.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        catch (SAMLException sAMLException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        if (fSNameRegistrationRequest == null) {
            this.showBadRequestErrorPage(httpServletResponse);
        } else {
            this.doRequestProcessing(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, fSNameRegistrationRequest);
        }
    }

    private void doRequestProcessing(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSNameRegistrationRequest fSNameRegistrationRequest) {
        Object object;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationRequestServlet::doRequestProcessing");
        }
        String string = fSNameRegistrationRequest.getProviderId();
        boolean bl = true;
        if (FSServiceUtils.isSigningOn()) {
            try {
                object = this.instAlliance.getProvider(string);
                if (object == null) {
                    FSUtils.debug.error("Remote provider metadata not found.");
                    FSUtils.debug.error("Cannot retrieve provider descriptor.");
                    FSUtils.error("FSRegistrationRequestServlet::doRequestProcessing", FSUtils.bundle.getString("registration-invalid-provider"));
                    this.returnToSource(httpServletResponse, string);
                    return;
                }
                FSUtils.debug.message("Calling verifyRegistrationSignature");
                bl = this.verifyRegistrationSignature(httpServletRequest, (FSProviderDescriptor)object);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("Remote provider metadata not found.");
                FSUtils.debug.error("Cannot retrieve provider descriptor.");
                FSUtils.error("FSRegistrationRequestServlet::doRequestProcessing", FSUtils.bundle.getString("registration-invalid-provider"));
                this.returnToSource(httpServletResponse, string);
                return;
            }
            catch (FSException fSException) {
                FSUtils.debug.error("FSRegistrationRequestServlet::processRegistrationRequest Signature on registration request is invalidCannot proceed federation registration");
                FSUtils.error("FSRegistrationRequestServlet", FSUtils.bundle.getString("registration-invalid-signature"));
                this.returnToSource(httpServletResponse, string);
                return;
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSRegistrationRequestServlet::processRegistrationRequest Signature on registration request is invalidCannot proceed federation registration");
                FSUtils.error("FSRegistrationRequestServlet", FSUtils.bundle.getString("registration-invalid-signature"));
                this.returnToSource(httpServletResponse, string);
                return;
            }
        }
        if (bl) {
            object = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
            if (object != null) {
                if (object.contains(string)) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSNameRegistrationHandler fSNameRegistrationHandler = fSServiceManager.getNameRegistrationHandler(fSNameRegistrationRequest, fSHostedProviderDescriptor);
                        if (fSNameRegistrationHandler != null) {
                            fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                            fSNameRegistrationHandler.processRegistrationRequest(httpServletRequest, httpServletResponse, fSNameRegistrationRequest);
                            return;
                        }
                        FSUtils.debug.error("Unable to get registration handler. User account Not valid");
                    } else {
                        FSUtils.debug.error("FSServiceManager instance is null Cannot process registration request");
                    }
                } else {
                    FSUtils.debug.error("Remote provider not in trusted list");
                }
            } else {
                FSUtils.debug.error("Remote provider not in trusted list");
                FSUtils.debug.error("Trusted provider list is empty.");
            }
        } else {
            FSUtils.debug.error("FSRegistrationRequestServlet::doRequestProcesing Signature on registration request is invalidCannot proceed name registration");
            FSUtils.error("FSRegistrationRequestServlet", FSUtils.bundle.getString("registration-invalid-signature"));
        }
        this.returnToSource(httpServletResponse, string);
    }

    private void returnToSource(HttpServletResponse httpServletResponse, String string) {
        try {
            String string2 = "";
            if (this.instAlliance != null) {
                string2 = this.instAlliance.getProvider(string).getNameRegistrationReturnURL();
                if (string2 == null || string2.length() < 1) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(COMMON_ERROR_PAGE);
                    char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(FSUtils.bundle.getString("registration-failed"));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(FSUtils.bundle.getString("metadata-error-check"));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSUtils.debug.message("returnToSource returns URL : " + string2);
                httpServletResponse.sendRedirect(string2);
                return;
            }
            FSUtils.debug.message("Alliance Manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(COMMON_ERROR_PAGE);
                char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(FSUtils.bundle.getString("registration-failed"));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(FSUtils.bundle.getString("metadata-error-check"));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Redirect/sendError failed. Control halted");
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted" + iOException.getMessage());
        }
    }

    private boolean verifyRegistrationSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationRequestServlet::verifyRegistrationSignature");
        }
        String string = "";
        string = fSProviderDescriptor.getKeyInfo();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSRegistrationRequestServlet.verifyRegistrationSignature: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string))) {
            FSUtils.debug.error("Registration request is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Registration request is properly signed");
        }
        return true;
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMON_ERROR_PAGE);
        char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(FSUtils.bundle.getString("registration-request-improper"));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(FSUtils.bundle.getString("registration-failed"));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }
}

