/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class FSLogoutUtil {
    static FSAllianceManager allianceInst = null;
    static FSAccountManager accountInst = null;

    protected static boolean destroyPrincipalSession(String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered destroyPrincipalSession for user : " + string);
        }
        Vector vector = FSLogoutUtil.getSessionObjectList(string, string2);
        FSLogoutUtil.invalidateActiveSessionIds(vector);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("To call cleanSessionMap for user : " + string);
        }
        FSLogoutUtil.cleanSessionMap(string, string2);
        return true;
    }

    protected static boolean destroyLocalSession(SSOToken sSOToken) {
        SSOProviderImpl sSOProviderImpl;
        try {
            sSOProviderImpl = new SSOProviderImpl();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("SSOException in invalidateActiveSessionIds" + sSOException.getMessage());
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered method destroyPrincipalSession");
        }
        try {
            sSOProviderImpl.destroyToken(sSOToken);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Completed Destroying token for sessionID :" + sSOToken.getTokenID());
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("Session " + sSOToken.getTokenID() + "timed out or is old session.");
            return false;
        }
        return true;
    }

    protected static boolean invalidateActiveSessionIds(Vector vector) {
        SSOProviderImpl sSOProviderImpl;
        try {
            sSOProviderImpl = new SSOProviderImpl();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("SSOException in invalidateActiveSessionIds" + sSOException.getMessage());
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered method invalidateActiveSessionIds");
        }
        if (vector != null && !vector.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message(vector.size() + " Active Session exists");
            }
            int n = 0;
            while (n < vector.size()) {
                String string = ((FSSession)vector.elementAt(n)).getSessionID();
                if (string != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("To Invalidate session : " + string);
                    }
                    SSOToken sSOToken = null;
                    try {
                        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                        sSOToken = sSOTokenManager.createSSOToken(string);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Destroying token : " + sSOToken.getPrincipal().toString());
                        }
                        sSOProviderImpl.destroyToken(sSOToken);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Completed Destroying token for sessionID :" + string);
                        }
                    }
                    catch (SSOException sSOException) {
                        FSUtils.debug.error("invalidateActiveSessionIds -- SSOException");
                        FSUtils.debug.message("Session " + string + "timed out or is old session.Continue cleanup");
                    }
                }
                ++n;
            }
            return true;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("No active Session exists");
        }
        return true;
    }

    protected static Vector getSessionObjectList(String string, String string2) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getSessionObjectList for user : " + string);
        }
        Vector<FSSession> vector = new Vector<FSSession>();
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string2);
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string);
            if (list != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session list is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    vector.addElement(fSSession);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Returning session list with number of elements = " + vector.size());
                }
                Vector<FSSession> vector2 = vector;
                return vector2;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Session list is null");
            }
            Vector vector3 = null;
            return vector3;
        }
    }

    public static void cleanSessionMapPartnerList(String string, String string2, String string3) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("In cleanSessionMapPartnerList for user : " + string + "and provider : " + string2);
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string3);
        synchronized (fSSessionManager2) {
            fSSessionManager.removeProvider(string, string2);
        }
    }

    protected static void cleanSessionWithNoPartners(String string, String string2, String string3) {
        FSSessionManager fSSessionManager;
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string3);
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string);
            if (list != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session list is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (!fSSession.getSessionPartners().isEmpty()) continue;
                    fSSessionManager.removeSession(string, fSSession);
                }
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Session list is null");
            }
        }
    }

    protected static boolean cleanSessionMap(String string, String string2) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered cleanSessionMap");
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string2);
        synchronized (fSSessionManager2) {
            fSSessionManager.removeSessionList(string);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Leaving cleanSessionMap");
        }
        return true;
    }

    protected static SSOToken getValidToken(HttpServletRequest httpServletRequest) {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("SSOToken is not valid,redirecting for authentication" + sSOToken.getTokenID());
                }
                return null;
            }
            return sSOToken;
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SSOException caught: " + (Object)((Object)sSOException));
            }
            return null;
        }
    }

    protected static FSAccountFedInfo getCurrentWorkingAccount(String string, String string2) {
        try {
            if (accountInst != null) {
                FSAccountFedInfo fSAccountFedInfo = accountInst.readAccountFedInfo(string, string2);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSPFedTerminationHandler::getCurrentWorkingAccount after readAccountFedInfo");
                }
                return fSAccountFedInfo;
            }
            return null;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSLogoutUtil::getCurrentWorkingAccount readAccountFedInfo failed" + fSAccountMgmtException.getMessage());
            return null;
        }
    }

    protected static HashMap getCurrentProvider(String string, String string2) {
        return FSLogoutUtil.getCurrentProvider(string, string2, null);
    }

    protected static HashMap getCurrentProvider(String string, String string2, SSOToken sSOToken) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getCurrentProvider for user : " + string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            FSSessionManager fSSessionManager;
            String string3 = "";
            FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string2);
            synchronized (fSSessionManager2) {
                List list = fSSessionManager.getSessionList(string);
                if (list != null && !list.isEmpty()) {
                    Object object;
                    Object object2;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("sessionList is not null");
                    }
                    Object object3 = null;
                    String string4 = sSOToken == null ? null : sSOToken.getTokenID().toString();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object2 = (FSSession)iterator.next();
                        object = ((FSSession)object2).getSessionPartners();
                        if (object == null || object.isEmpty()) continue;
                        arrayList.add(object2);
                        if (string4 == null || !((FSSession)object2).getSessionID().equals(string4)) continue;
                        FSUtils.debug.message("preferred session found");
                        object3 = object2;
                        break;
                    }
                    if (!arrayList.isEmpty()) {
                        if (object3 == null) {
                            FSUtils.debug.message("no preferred session found");
                            object3 = (FSSession)arrayList.get(0);
                        }
                        object2 = ((FSSession)object3).getSessionPartners();
                        object = object2.iterator();
                        FSSessionPartner fSSessionPartner = (FSSessionPartner)object.next();
                        String string5 = ((FSSession)object3).getSessionIndex();
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Provider is " + fSSessionPartner.getPartner() + "\nSession index is " + string5);
                        }
                        hashMap.put("PartnerSession", fSSessionPartner);
                        hashMap.put("SessionIndex", string5);
                        HashMap<String, Object> hashMap2 = hashMap;
                        return hashMap2;
                    }
                    FSUtils.debug.message("no live session");
                    object2 = null;
                    return object2;
                }
                FSUtils.debug.message("sessionList is null or empty");
                HashMap hashMap3 = null;
                return hashMap3;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            FSUtils.debug.error("getCurrentProvider:NoSuchElementException.Returns no provider.");
            return null;
        }
    }

    public static boolean getCurrentProviderRole(String string, String string2, String string3) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getCurrentProviderRole for user : " + string);
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string3);
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string);
            if (list != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sessionList is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    List list2 = fSSession.getSessionPartners();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator2.next();
                        if (!fSSessionPartner.isEquals(string2)) continue;
                        boolean bl = fSSessionPartner.getIsRoleIDP();
                        return bl;
                    }
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sessionList is null");
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    protected static boolean liveConnectionsExist(String string, String string2) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered liveConnectionsExist for user : " + string);
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string2);
        synchronized (fSSessionManager2) {
            List list;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("About to call getSessionList");
            }
            if ((list = fSSessionManager.getSessionList(string)) != null && !list.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("List is not empty");
                }
                Iterator iterator = list.iterator();
                FSSession fSSession = null;
                while (iterator.hasNext()) {
                    fSSession = (FSSession)iterator.next();
                    if (fSSession.getSessionPartners().isEmpty()) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("List is  empty");
            }
            boolean bl = false;
            return bl;
        }
    }

    protected static boolean cleanSessionMapProviders(String string, Vector vector, String string2) {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("cleaning provider " + (String)vector.elementAt(n) + " from session map");
                }
                FSLogoutUtil.cleanSessionMapPartnerList(string, (String)vector.elementAt(n), string2);
                ++n;
            }
        }
        return true;
    }

    protected static HashMap getLogoutGETProviders(String string, String string2, String string3, String string4) {
        try {
            FSSessionManager fSSessionManager;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSLogoutUtil::getLogoutGETProviders");
            }
            HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
            Vector<String> vector = new Vector<String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            vector.addElement(string2);
            hashMap2.put(string2, string3);
            FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string4);
            synchronized (fSSessionManager2) {
                Object object;
                List list;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("About to call getSessionList");
                }
                if ((list = fSSessionManager.getSessionList(string)) != null && !list.isEmpty()) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Session List is not empty");
                    }
                    object = list.iterator();
                    while (object.hasNext()) {
                        FSSession fSSession = (FSSession)object.next();
                        if (fSSession.getSessionPartners().isEmpty()) continue;
                        String string5 = fSSession.getSessionIndex();
                        List list2 = fSSession.getSessionPartners();
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            String string6;
                            FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator.next();
                            if (fSSessionPartner.getIsRoleIDP() || !allianceInst.getProvider(string6 = fSSessionPartner.getPartner()).getSLOProtocolProfile().equals("http://projectliberty.org/profiles/slo-idp-http-get")) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("provider " + string6 + " Added for GET");
                            }
                            vector.addElement(string6);
                            hashMap2.put(string6, string5);
                        }
                    }
                } else if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session List is  empty, returning current provider from getLogoutGETProviders");
                }
                hashMap.put("Provider", vector);
                hashMap.put("SessionIndex", hashMap2);
                object = hashMap;
                return object;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException in function  getLogoutGETProviders");
            return null;
        }
    }

    public static String getUserDN(FSLogoutNotification fSLogoutNotification, String string) {
        Object object;
        String string2 = "";
        try {
            object = allianceInst.getHostedProvider(string);
            string2 = ((FSHostedProviderDescriptor)object).getLocalConfiguration().getAssociatedOrgDN();
            FSUtils.debug.message("OrgDN : " + string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.message("In FSAllianceManagementException :: cannot get hosted provider information " + fSAllianceManagementException.getMessage());
            return null;
        }
        try {
            FSAccountFedInfoKey fSAccountFedInfoKey;
            object = "";
            String string3 = fSLogoutNotification.getNameIdentifier().getName().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name : " + string3);
            }
            String string4 = fSLogoutNotification.getNameIdentifier().getNameQualifier().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name Qualifier : " + string4);
            }
            if ((object = accountInst.getUserDN(fSAccountFedInfoKey = new FSAccountFedInfoKey(string, string3), string2)) == null && (object = accountInst.getUserDN(fSAccountFedInfoKey = new FSAccountFedInfoKey(fSLogoutNotification.getProviderId(), string3), string2)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("UserDn is null");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user dn is " + (String)object);
            }
            return object;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.message("In FSAccountMgmtException :: " + fSAccountMgmtException.getMessage());
            return null;
        }
    }

    public static void removeTokenFromSession(SSOToken sSOToken, String string) {
        FSSessionManager fSSessionManager;
        String string2 = "";
        String string3 = "";
        try {
            string2 = sSOToken.getPrincipal().toString();
            string3 = sSOToken.getTokenID().toString();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("SSOException in removeTokenFromSession " + sSOException.getMessage());
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered removeTokenFromSession for user: " + string2);
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string);
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string2);
            if (list != null && !list.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sessionList is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (fSSession == null || !fSSession.getSessionID().equals(string3)) continue;
                    FSUtils.debug.message("Have a current session with matching tokenId");
                    fSSessionManager.removeSession(string2, fSSession);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("End of iterating thru FSSession list");
                }
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("sessionList is null");
            }
            return;
        }
    }

    static {
        try {
            accountInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("Failed to get Account Manager Instance");
        }
        allianceInst = FSServiceUtils.getAllianceInstance();
    }
}

