/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.messaging.OnewayListener;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class FSSSOAndFedService
extends JAXMServlet
implements OnewayListener {
    private HttpServletResponse respSave;
    private HttpServletRequest reqSave;
    private static FSSOAPService soapService = FSSOAPService.getInstance();

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSUtils.debug.message("FSSSOAndFedService.doGet: Called");
        if (httpServletRequest == null || httpServletResponse == null) {
            FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("nullInputParameter"));
            FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = httpServletRequest.getParameter("Authn");
        if (string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.doGet:Pre Authentication SSO");
            }
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.doGet:Post Authentication SSO");
            }
            bl = true;
            String string2 = httpServletRequest.getParameter("LECP");
            if (string2 == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService.doGet:non LECP request");
                }
                bl2 = false;
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService.doGet:post Authn LECP request");
                }
                bl2 = true;
            }
            String string3 = httpServletRequest.getParameter("RequestID");
            String string4 = httpServletRequest.getParameter("_liberty_idp");
            String string5 = httpServletRequest.getParameter("AuthnContext");
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string4);
            FSAuthnRequest fSAuthnRequest = fSSessionManager.getAuthnRequest(string3);
            if (fSAuthnRequest == null) {
                FSUtils.debug.message("FSSSOAndFedService.doGet: authnRequest is null");
            }
            if (string5 == null || string5.equals("")) {
                FSUtils.debug.message("FSSSOAndFedService.doGet: authnContext is null. using default password");
                string5 = "http://www.projectliberty.org/schemas/authctx/classes/Password";
            }
            if (fSAuthnRequest != null && string4 != null && !string4.equals("") && string5 != null && !string5.equals("")) {
                this.handleAuthnRequest(httpServletRequest, httpServletResponse, fSAuthnRequest, string4, bl2, string5);
                return;
            }
            FSUtils.error("FSSSOAndFedService: ", FSUtils.bundle.getString("nullInput"));
            FSUtils.debug.error("FSSSOAndFedService.doGet: AuthnRequest not found in FSSessionManager");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInput"));
            return;
        }
        bl = false;
        FSAuthnRequest fSAuthnRequest = null;
        try {
            fSAuthnRequest = FSAuthnRequest.parseURLEncodedRequest(httpServletRequest);
            if (fSAuthnRequest == null) {
                FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest"));
                FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("invalidAuthnRequest"));
                httpServletResponse.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
                return;
            }
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest") + fSException.getMessage());
            FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("invalidAuthnRequest") + fSException.getMessage());
            httpServletResponse.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
            return;
        }
        String string6 = FSServiceUtils.getHostedProviderID(httpServletRequest);
        this.handleAuthnRequest(httpServletRequest, httpServletResponse, fSAuthnRequest, bl, bl2, string6);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSUtils.debug.message("FSSSOAndFedService.doPost: Called");
        if (httpServletRequest == null || httpServletResponse == null) {
            FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        if (this.isLECPRequest(httpServletRequest, httpServletResponse)) {
            this.respSave = httpServletResponse;
            this.reqSave = httpServletRequest;
            String string = (String)httpServletRequest.getAttribute("forwardrequest");
            if (string != null && string.equals("yes")) {
                FSUtils.debug.message("FSSSOAndFedService.doPost: LECP forward");
                this.doGet(httpServletRequest, httpServletResponse);
            } else {
                super.doPost(httpServletRequest, httpServletResponse);
            }
            return;
        }
        String string = httpServletRequest.getParameter("LAREQ");
        if (string == null) {
            this.doGet(httpServletRequest, httpServletResponse);
            return;
        }
        string = string.replace(' ', '\n');
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedService.doPost: BASE64 encoded AuthnRequest at the RECEIVER: " + string);
        }
        FSAuthnRequest fSAuthnRequest = null;
        try {
            fSAuthnRequest = FSAuthnRequest.parseBASE64EncodedString(string);
            if (fSAuthnRequest == null) {
                FSUtils.debug.error("FSSSOAndFedService: " + FSUtils.bundle.getString("invalidAuthnRequest"));
                FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("invalidAuthnRequest"));
                httpServletResponse.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService: AuthnRequest received:" + fSAuthnRequest.toXMLString());
            }
        }
        catch (FSException fSException) {
            FSUtils.error("FSSSOAndFedService", FSUtils.bundle.getString("invalidAuthnRequest") + fSException.getMessage());
            httpServletResponse.sendError(400, FSUtils.bundle.getString("invalidAuthnRequest"));
            return;
        }
        String string2 = FSServiceUtils.getHostedProviderID(httpServletRequest);
        this.handleAuthnRequest(httpServletRequest, httpServletResponse, fSAuthnRequest, false, false, string2);
    }

    private boolean isLECPRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getHeader("Liberty-Enabled");
        if (string != null) {
            FSUtils.debug.message("FSSSOAndFedService: is LECP request.");
            return true;
        }
        return false;
    }

    private void handleAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, String string, boolean bl, String string2) {
        block17: {
            Object object;
            Object object2;
            Object object3;
            FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Called");
            String string3 = httpServletRequest.getParameter("nameregis");
            boolean bl2 = false;
            try {
                bl2 = FSServiceUtils.getAllianceInstance().getHostedProvider(string).getNameRegistrationAfterSSO();
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                // empty catch block
            }
            SSOToken sSOToken = null;
            try {
                object3 = SSOTokenManager.getInstance();
                sSOToken = object3.createSSOToken(httpServletRequest);
                if (sSOToken == null) {
                    FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: SSOToken is null.");
                    return;
                }
                if (!object3.isValidToken(sSOToken)) {
                    FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: SSOToken is not valid.");
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: SSOToken is valid.");
                }
                object2 = FSSessionManager.getInstance(string);
                object = new FSSession(sSOToken.getTokenID().toString());
                ((FSSession)object).setAuthnContext(string2);
                ((FSSessionManager)object2).addSession(sSOToken.getPrincipal().getName(), (FSSession)object);
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: " + sSOException.getMessage());
                return;
            }
            try {
                object3 = null;
                try {
                    object3 = sSOToken.getPrincipal().toString();
                }
                catch (SSOException sSOException) {
                    FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest:SSOException" + sSOException.getMessage());
                    FSUtils.error("FSSSOAndFedService.handleAuthnRequest:n", FSUtils.bundle.getString("actmgmt-user-not-found"));
                }
                if (object3 == null) {
                    return;
                }
                object2 = fSAuthnRequest.getProviderId();
                object = FSAccountManager.getInstance();
                ((FSAccountManager)object).readAccountFedInfo((String)object3, (String)object2);
                if (!bl2 || string3 != null && string3.equals("true") || fSAuthnRequest.getFederate()) break block17;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("RequestID", fSAuthnRequest.getRequestID());
                hashMap.put("_liberty_idp", string);
                hashMap.put("AuthnContext", string2);
                FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                if (fSServiceManager == null) break block17;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest:FSServiceManager Instance not null");
                }
                try {
                    FSNameRegistrationHandler fSNameRegistrationHandler = fSServiceManager.getNameRegistrationHandler((String)object2, (String)object3);
                    FSProviderDescriptor fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider((String)object2);
                    FSHostedProviderDescriptor fSHostedProviderDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(string);
                    if (fSNameRegistrationHandler != null) {
                        fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                        fSNameRegistrationHandler.setRemoteDescriptor(fSProviderDescriptor);
                        boolean bl3 = fSNameRegistrationHandler.handleNameRegistration(httpServletRequest, httpServletResponse, sSOToken, hashMap);
                        FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest:Control returned from name registration");
                        if (!this.isRegisProfileSOAP(sSOToken.getPrincipal().toString(), (String)object2, fSHostedProviderDescriptor, fSProviderDescriptor)) {
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest:Error in invoking Name registration. returning");
                    return;
                }
            }
            catch (FSAccountMgmtException fSAccountMgmtException) {
                FSUtils.debug.message("FSSSOAndFedService:: handleAuthnRequest() No account information avialable for user. So no invocation  of name registration. " + fSAccountMgmtException.getMessage());
            }
        }
        this.handleAuthnRequest(httpServletRequest, httpServletResponse, fSAuthnRequest, true, bl, string);
    }

    private void handleAuthnRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, boolean bl, boolean bl2, String string) {
        FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Called");
        try {
            Object object;
            if (!bl) {
                object = FSSessionManager.getInstance(string);
                ((FSSessionManager)object).setAuthnRequest(fSAuthnRequest.getRequestID(), fSAuthnRequest);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.handleAuthnRequest: Trying to handle AuthnRequest message: " + fSAuthnRequest.toXMLString());
            }
            object = FSServiceManager.getInstance();
            FSSSOAndFedHandler fSSSOAndFedHandler = null;
            fSSSOAndFedHandler = !bl2 ? ((FSServiceManager)object).getSSOAndFedHandler(httpServletRequest, httpServletResponse, fSAuthnRequest) : ((FSServiceManager)object).getLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest);
            if (fSSSOAndFedHandler == null) {
                FSUtils.debug.error("FSSSOAndFedService.handleAuthnRequest: could not create SSOAndFedHandler");
                FSUtils.error("FSSSOAndFedService:", FSUtils.bundle.getString("requestProcessingFailed"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("requestProcessingFailed"));
                return;
            }
            fSSSOAndFedHandler.setHostProviderId(string);
            fSSSOAndFedHandler.setMetaAlias(FSServiceUtils.getMetaAlias(httpServletRequest));
            fSSSOAndFedHandler.processAuthnRequest(fSAuthnRequest, bl);
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService: Exception occured " + exception.getMessage());
            try {
                httpServletResponse.sendError(500, exception.getMessage());
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSSSOAndFedService: Exception occured " + iOException.getMessage());
            }
            return;
        }
    }

    private boolean validateServiceRequest(HttpServletRequest httpServletRequest) {
        return true;
    }

    private boolean isRegisProfileSOAP(String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSProviderDescriptor fSProviderDescriptor) {
        FSAccountFedInfo fSAccountFedInfo = null;
        try {
            fSAccountFedInfo = FSAccountManager.getInstance().readAccountFedInfo(string, string2);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.message("in excpetion" + fSAccountMgmtException.getMessage());
            return true;
        }
        FSUtils.debug.message("host profile is " + fSHostedProviderDescriptor.getNameRegistrationProfile());
        FSUtils.debug.message("remote profile is " + fSProviderDescriptor.getNameRegistrationProfile());
        if (fSAccountFedInfo.isRoleIDP()) {
            if (fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                return true;
            }
            if (fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                return false;
            }
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
            return true;
        }
        if (fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
            return true;
        }
        if (fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
            return false;
        }
        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
        return true;
    }

    public void onMessage(SOAPMessage sOAPMessage) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedService.onMessage: Called");
        }
        try {
            Element element = soapService.parseSOAPMessage(sOAPMessage);
            if (element == null) {
                FSUtils.debug.error("FSSSOAndFedService.onMessage: Error in processing. Invalid SOAPMessage");
                this.respSave.setStatus(500);
                this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                return;
            }
            String string = element.getTagName().trim();
            String string2 = element.getNamespaceURI().trim();
            String string3 = element.getLocalName().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedService.onMessage: tagName: " + string + " namespaceUri: " + string2 + " localName: " + string3);
            }
            if (string3.equalsIgnoreCase("AuthnRequest") && string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12")) {
                SOAPMessage sOAPMessage2 = null;
                try {
                    FSAuthnRequest fSAuthnRequest = new FSAuthnRequest(element);
                    String string4 = FSServiceUtils.getHostedProviderID(this.reqSave);
                    FSSessionManager fSSessionManager = FSSessionManager.getInstance(string4);
                    fSSessionManager.setAuthnRequest(fSAuthnRequest.getRequestID(), fSAuthnRequest);
                    this.handleLECPRequest(this.reqSave, this.respSave, fSAuthnRequest);
                    sOAPMessage2 = null;
                }
                catch (FSException fSException) {
                    FSUtils.debug.error("FSSSOAndFedService.onMessage: Error in processing lecp AuthnRequest:" + fSException.getMessage());
                    this.respSave.setStatus(500);
                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                    return;
                }
                this.returnSOAPMessage(sOAPMessage2, this.respSave);
                return;
            }
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Invalid SOAP Request:" + string3);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Error in processing Request: Exception occured: " + exception.getMessage());
            this.respSave.setStatus(500);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            FSUtils.debug.error(byteArrayOutputStream.toString());
            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
            return;
        }
        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
    }

    private void handleLECPRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedService.handleLECPRequest:");
        }
        try {
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            FSSSOLECPProfileHandler fSSSOLECPProfileHandler = fSServiceManager.getLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest);
            fSSSOLECPProfileHandler.setHostProviderId(string);
            fSSSOLECPProfileHandler.setMetaAlias(FSServiceUtils.getMetaAlias(httpServletRequest));
            fSSSOLECPProfileHandler.processLECPAuthnRequest(fSAuthnRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.handleLECPRequest: processing LECP request failed." + exception);
            return;
        }
    }

    private void returnSOAPMessage(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) {
        try {
            if (sOAPMessage != null) {
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.returnSOAPMessage: Exception::" + exception.getMessage());
            return;
        }
    }
}

