/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserArtifactProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.messaging.OnewayListener;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSSOAPReceiver
extends JAXMServlet
implements OnewayListener {
    private HttpServletResponse respSave;
    private HttpServletRequest reqSave;
    private static FSSOAPService soapService = FSSOAPService.getInstance();

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSUtils.debug.message("FSSOAPReceiver.doPost: Called");
        FSUtils.checkHTTPRequestLength(httpServletRequest);
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSSOAPReceiver: notLibertyEnabled");
            FSUtils.error("FSSOAPReceiver", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        this.respSave = httpServletResponse;
        this.reqSave = httpServletRequest;
        super.doPost(httpServletRequest, httpServletResponse);
    }

    public void onMessage(SOAPMessage sOAPMessage) {
        block69: {
            FSUtils.debug.message("FSSOAPReceiver.onMessage: Called");
            try {
                Element element = soapService.parseSOAPMessage(sOAPMessage);
                if (element == null) {
                    FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing saml:Request. Invalid SOAPMessage");
                    this.respSave.setStatus(500);
                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                    return;
                }
                String string = element.getTagName().trim();
                String string2 = element.getNamespaceURI().trim();
                String string3 = element.getLocalName().trim();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.onMessage: tagName: " + string + " namespaceUri: " + string2 + " localName: " + string3);
                }
                if (string3.equalsIgnoreCase("Request") && string2.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:protocol")) {
                    SOAPMessage sOAPMessage2 = null;
                    try {
                        FSSAMLRequest fSSAMLRequest = new FSSAMLRequest(element);
                        FSResponse fSResponse = this.handleSAMLRequest(this.reqSave, this.respSave, fSSAMLRequest, element, sOAPMessage);
                        if (fSResponse != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver.onMessage: SAML Response created: " + fSResponse.toXMLString());
                            }
                        } else {
                            FSUtils.debug.error("FSSOAPReceiver.onMessage: SAML Response is null");
                            this.respSave.setStatus(500);
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                            return;
                        }
                        sOAPMessage2 = soapService.bindSAMLResponse(fSResponse);
                        if (FSServiceUtils.isSigningOn()) {
                            List list = fSResponse.getAssertion();
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                FSAssertion fSAssertion = (FSAssertion)iterator.next();
                                String string4 = fSAssertion.getID();
                                Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage2);
                                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                                if (fSAllianceManager == null) {
                                    FSUtils.debug.error("FSSOAPReceiver.onMessage: could not create alliance instance");
                                    this.respSave.setStatus(500);
                                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                                    return;
                                }
                                String string5 = fSAllianceManager.getProvider(FSServiceUtils.getHostedProviderID(this.reqSave)).getKeyInfo();
                                if (string5 == null) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("SOAPReceiver.onMessage: couldn't obtain this site's cert alias.");
                                    }
                                    throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
                                }
                                XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                                xMLSignatureManager.signXML(document, string5, SAMLUtils.bundle.getString("xmlsigalgorithm"), string4);
                                sOAPMessage2 = FSServiceUtils.convertDOMToSOAP(document);
                            }
                        }
                        if (sOAPMessage2 == null) {
                            FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing saml:Request");
                            this.respSave.setStatus(500);
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                            return;
                        }
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing saml:Request:", (Throwable)sAMLException);
                        this.respSave.setStatus(500);
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                        return;
                    }
                    this.returnSOAPMessage(sOAPMessage2, this.respSave);
                    return;
                }
                if (string3.equalsIgnoreCase("AuthnRequest") && string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12")) {
                    SOAPMessage sOAPMessage3 = null;
                    try {
                        FSAuthnRequest fSAuthnRequest = new FSAuthnRequest(element);
                        String string6 = FSServiceUtils.getHostedProviderID(this.reqSave);
                        FSSessionManager fSSessionManager = FSSessionManager.getInstance(string6);
                        fSSessionManager.setAuthnRequest(fSAuthnRequest.getRequestID(), fSAuthnRequest);
                        this.handleLECPRequest(this.reqSave, this.respSave, fSAuthnRequest);
                        sOAPMessage3 = null;
                    }
                    catch (FSException fSException) {
                        FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing lecp AuthnRequest:" + fSException.getMessage());
                        this.respSave.setStatus(500);
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                        return;
                    }
                    this.returnSOAPMessage(sOAPMessage3, this.respSave);
                    return;
                }
                if (string3.equalsIgnoreCase("RegisterNameIdentifierRequest") && string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12")) {
                    SOAPMessage sOAPMessage4 = null;
                    boolean bl = false;
                    FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
                    try {
                        Object object;
                        FSAllianceManager fSAllianceManager;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPReceiver.onMessage: Handling NameRegistrationRequest");
                        }
                        if ((fSAllianceManager = FSServiceUtils.getAllianceInstance()) == null) {
                            FSUtils.debug.message("Unable to get alliance manager");
                            bl = true;
                        } else {
                            object = FSServiceUtils.getMetaAlias(this.reqSave);
                            if (object == null || ((String)object).length() < 1) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
                                }
                                bl = true;
                            }
                            try {
                                fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias((String)object);
                                if (fSHostedProviderDescriptor == null) {
                                    throw new FSAllianceManagementException(null);
                                }
                            }
                            catch (FSAllianceManagementException fSAllianceManagementException) {
                                FSUtils.debug.error("Unable to find Hosted Provider. Cannot process request");
                                bl = true;
                            }
                        }
                        if (bl || fSHostedProviderDescriptor == null) {
                            this.returnSOAPMessage(sOAPMessage4, this.respSave);
                            return;
                        }
                        object = this.handleRegistrationRequest(element, sOAPMessage, fSHostedProviderDescriptor);
                        if (object == null) {
                            FSUtils.debug.message("Error in processing Name Registration request");
                            FSUtils.debug.error("Error in creating NameRegistration Response");
                            this.respSave.setStatus(500);
                            sOAPMessage4 = soapService.FormSOAPError("Server", "cannotProcessRequest", null);
                        } else {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver.onMessage: Completed creating response");
                            }
                            sOAPMessage4 = soapService.bindRegistrationResponse((FSNameRegistrationResponse)object);
                            FSUtils.debug.message("Completed bindRegistrationResponse");
                            if (sOAPMessage4 == null) {
                                FSUtils.debug.error("Error in processing NameRegistration Response");
                                this.respSave.setStatus(500);
                                sOAPMessage4 = soapService.FormSOAPError("Server", "cannotProcessRequest", null);
                            } else if (FSServiceUtils.isSigningOn()) {
                                try {
                                    int n = ((FSNameRegistrationResponse)object).getMinorVersion();
                                    if (n == 0) {
                                        sOAPMessage4 = this.signRegistrationResponse(sOAPMessage4, "id", ((FSNameRegistrationResponse)object).getID(), fSHostedProviderDescriptor);
                                    } else if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("invalid minor version.");
                                    }
                                }
                                catch (SAMLException sAMLException) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationResponse failed");
                                    }
                                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                                    return;
                                }
                                catch (FSMsgException fSMsgException) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationResponse failed");
                                    }
                                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                                    return;
                                }
                            }
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            object = null;
                            String string7 = null;
                            object = new ByteArrayOutputStream();
                            sOAPMessage4.writeTo((OutputStream)object);
                            string7 = ((ByteArrayOutputStream)object).toString("UTF-8");
                            FSUtils.debug.message("return SOAP message:" + string7);
                        }
                        this.returnSOAPMessage(sOAPMessage4, this.respSave);
                        return;
                    }
                    catch (Exception exception) {
                        FSUtils.debug.error("Error in processing Name Registration request" + exception.getMessage());
                        this.respSave.setStatus(500);
                        sOAPMessage4 = soapService.FormSOAPError("Server", "cannotProcessRequest", null);
                        this.returnSOAPMessage(sOAPMessage4, this.respSave);
                        break block69;
                    }
                }
                if (string3.equalsIgnoreCase("FederationTerminationNotification") && string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12")) {
                    try {
                        boolean bl;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("calling FSSOAPReceiver::handleTerminationRequest");
                        }
                        if (bl = this.handleTerminationRequest(element, sOAPMessage)) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Completed sucessful processing terminationRequest");
                            }
                            this.returnTerminationStatus(this.respSave);
                            return;
                        }
                        FSUtils.debug.message("Failed processing terminationRequest");
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                        return;
                    }
                    catch (Exception exception) {
                        FSUtils.debug.error("Error in processing Federation Termination Request" + exception.getMessage());
                        FSUtils.error("FSSOAPReceiver::OnMessage", "termination-request-processing-failed");
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                        return;
                    }
                }
                if (!string3.equalsIgnoreCase("LogoutRequest") || !string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12")) break block69;
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("calling FSSOAPReceiver::handleLogoutRequest");
                    }
                    SOAPMessage sOAPMessage5 = this.handleLogoutRequest(element, sOAPMessage);
                    FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
                    String string8 = SAMLUtils.generateID();
                    String string9 = fSLogoutNotification.getRequestID();
                    String string10 = fSLogoutNotification.getProviderId();
                    String string11 = fSLogoutNotification.getRelayState();
                    FSLogoutResponse fSLogoutResponse = null;
                    if (sOAPMessage5 == null) {
                        object3 = new StatusCode("samlp:Failure");
                        object2 = new Status((StatusCode)object3);
                        fSLogoutResponse = new FSLogoutResponse(string8, string9, (Status)object2, string10, string11);
                    } else {
                        StatusCode statusCode;
                        object3 = sOAPMessage5.getSOAPPart();
                        object2 = object3.getEnvelope();
                        object = object2.getBody();
                        if (object.hasFault()) {
                            statusCode = new StatusCode("lib:Unsupported");
                            StatusCode statusCode2 = new StatusCode("samlp:Failure", statusCode);
                            Status status = new Status(statusCode2);
                            fSLogoutResponse = new FSLogoutResponse(string8, string9, status, string10, string11);
                        } else {
                            statusCode = new StatusCode("samlp:Success");
                            Status status = new Status(statusCode);
                            fSLogoutResponse = new FSLogoutResponse(string8, string9, status, string10, string11);
                        }
                    }
                    fSLogoutResponse.setID("logout-sig-ID");
                    fSLogoutResponse.setMinorVersion(fSLogoutNotification.getMinorVersion());
                    sOAPMessage5 = soapService.bindFSLogoutResponse(fSLogoutResponse);
                    if (FSServiceUtils.isSigningOn()) {
                        try {
                            object3 = null;
                            object2 = FSServiceUtils.getAllianceInstance();
                            object = FSServiceUtils.getMetaAlias(this.reqSave);
                            object3 = ((FSAllianceManager)object2).getHostedProviderByMetaAlias((String)object);
                            int n = fSLogoutResponse.getMinorVersion();
                            if (n == 0) {
                                sOAPMessage5 = this.signLogoutResponse(sOAPMessage5, "id", fSLogoutResponse.getID(), (FSHostedProviderDescriptor)object3);
                            } else if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("invalid minor version.");
                            }
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("LogoutResponse failed");
                            }
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                            return;
                        }
                        catch (FSMsgException fSMsgException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("LogoutResponse failed");
                            }
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.returnSOAPMessage(sOAPMessage5, this.respSave);
                    return;
                }
                catch (Exception exception) {
                    FSUtils.debug.error("Error in processing logout Request" + exception.getMessage());
                    FSUtils.error("FSSOAPReceiver::OnMessage", "logout-request-processing-failed");
                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                    return;
                }
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing Request: Exception occured: " + exception.getMessage());
                this.respSave.setStatus(500);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(byteArrayOutputStream));
                FSUtils.debug.error(byteArrayOutputStream.toString());
                this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
                return;
            }
        }
        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), this.respSave);
    }

    private FSNameRegistrationResponse handleRegistrationRequest(Element element, SOAPMessage sOAPMessage, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return null;
            }
            if (!FSServiceUtils.isSigningOn() || this.verifyRegistrationSignature(element, sOAPMessage)) {
                Set set;
                FSUtils.debug.message("Registration Signature successfully passed");
                FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest(element);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.onMessage: Completed forming request FSNameRegistrationRequest");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(fSNameRegistrationRequest.getProviderId())) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSNameRegistrationHandler fSNameRegistrationHandler = fSServiceManager.getNameRegistrationHandler(fSNameRegistrationRequest, fSHostedProviderDescriptor);
                        fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                        FSNameRegistrationResponse fSNameRegistrationResponse = fSNameRegistrationHandler.processRegistrationRequest(fSNameRegistrationRequest);
                        return fSNameRegistrationResponse;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process registration request");
                    }
                    return null;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.message("Registration Signature failed verification");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationHandler.doPost.doGet: Exception occured " + exception.getMessage());
            return null;
        }
    }

    private boolean handleTerminationRequest(Element element, SOAPMessage sOAPMessage) {
        try {
            if (!FSServiceUtils.isSigningOn() || this.verifyTerminationSignature(element, sOAPMessage)) {
                Set set;
                FSHostedProviderDescriptor fSHostedProviderDescriptor;
                FSUtils.debug.message("Termination Signature successfully verified");
                String string = FSServiceUtils.getMetaAlias(this.reqSave);
                if (string == null || string.length() < 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
                    }
                    return false;
                }
                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                if (fSAllianceManager == null) {
                    FSUtils.debug.message("Unable to get alliance manager");
                    return false;
                }
                try {
                    fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string);
                    if (fSHostedProviderDescriptor == null) {
                        throw new FSAllianceManagementException(null);
                    }
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to find Hosted Provider. Cannot process request");
                    }
                    return false;
                }
                FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification(element);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Completed forming request FSFederationTerminationNotification");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(fSFederationTerminationNotification.getProviderId())) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSFedTerminationHandler fSFedTerminationHandler = fSServiceManager.getFedTerminationHandler(fSFederationTerminationNotification, fSHostedProviderDescriptor);
                        if (fSFedTerminationHandler != null) {
                            fSFedTerminationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                            boolean bl = fSFedTerminationHandler.processTerminationRequest(fSFederationTerminationNotification);
                            return bl;
                        }
                        FSUtils.debug.message("Unable to get Termination Handler");
                        return false;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process termination request");
                    }
                    return false;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return false;
            }
            FSUtils.debug.message("Termination Signature failed verification");
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPService::handleTerminationRequest failed " + exception.getMessage());
            return false;
        }
    }

    private SOAPMessage handleLogoutRequest(Element element, SOAPMessage sOAPMessage) {
        try {
            if (!FSServiceUtils.isSigningOn() || this.verifyLogoutSignature(element, sOAPMessage)) {
                Set set;
                FSHostedProviderDescriptor fSHostedProviderDescriptor;
                FSUtils.debug.message("Logout Signature successfully verified");
                String string = FSServiceUtils.getMetaAlias(this.reqSave);
                if (string == null || string.length() < 1) {
                    FSUtils.debug.message("Unable to retrieve alias, Hosted Provider Cannot process logout request");
                    return null;
                }
                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                if (fSAllianceManager == null) {
                    FSUtils.debug.error("Unable to get alliance manager ");
                    FSUtils.debug.error("Cannot process logout request");
                    return null;
                }
                try {
                    fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string);
                    if (fSHostedProviderDescriptor == null) {
                        throw new FSAllianceManagementException(null);
                    }
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    FSUtils.debug.error("Unable to find Hosted Provider. Cannot process logout request");
                    return null;
                }
                FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: Completed forming request FSLogoutNotification");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(fSLogoutNotification.getProviderId())) {
                    Object object;
                    StringBuffer stringBuffer;
                    Object object2;
                    Object object3;
                    Object object4;
                    FSLogoutUtil fSLogoutUtil = new FSLogoutUtil();
                    String string2 = FSLogoutUtil.getUserDN(fSLogoutNotification, fSHostedProviderDescriptor.getProviderID());
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest found userDN = " + string2);
                    }
                    if (!this.isUserExists(string2, fSHostedProviderDescriptor.getProviderID())) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestUser does not exist locally. Finding remotely");
                        }
                        if ((object4 = WebtopNaming.getPlatformServerList()) == null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestplatformList is null");
                            }
                            return null;
                        }
                        object3 = ((AbstractList)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            stringBuffer = new StringBuffer((String)object2);
                            stringBuffer.append(SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor"));
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestremoteServerURL = " + (String)object2 + " and self serverUrl =" + FSServiceUtils.getBaseURL());
                            }
                            if (FSServiceUtils.getBaseURL().equalsIgnoreCase(((String)object2).toString()) || !((FSAssertionManagerClient)(object = new FSAssertionManagerClient(fSHostedProviderDescriptor.getProviderID(), this.getFullServiceURL((String)object2)))).isUserExists(string2, fSHostedProviderDescriptor.getProviderID())) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestuser found here  = " + (String)object2);
                            }
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(((String)object2).toString());
                            stringBuffer2.append("/amserver");
                            stringBuffer2.append("/SOAPReceiver");
                            stringBuffer2.append("/");
                            stringBuffer2.append("metaAlias");
                            stringBuffer2.append("/");
                            stringBuffer2.append(string);
                            FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                            SOAPMessage sOAPMessage2 = null;
                            if (fSSOAPService != null) {
                                try {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Forwarding logout request to " + stringBuffer2.toString());
                                    }
                                    sOAPMessage2 = fSSOAPService.sendLogoutMessage(sOAPMessage, stringBuffer2.toString());
                                    return sOAPMessage2;
                                }
                                catch (SOAPException sOAPException) {
                                    FSUtils.debug.error("FSSOAPException in doSOAPProfile Cannot send request" + sOAPException.getMessage());
                                    return sOAPMessage2;
                                }
                            }
                            return null;
                        }
                    }
                    if ((object4 = FSServiceManager.getInstance()) != null) {
                        object3 = ((FSServiceManager)object4).getPreLogoutHandler();
                        if (object3 != null) {
                            ((FSPreLogoutHandler)object3).setHostedDescriptor(fSHostedProviderDescriptor);
                            object2 = ((FSPreLogoutHandler)object3).processSingleLogoutRequest(fSLogoutNotification);
                            if (((FSLogoutStatus)object2).getStatus().equalsIgnoreCase("samlp:Success")) {
                                stringBuffer = MessageFactory.newInstance();
                                object = stringBuffer.createMessage();
                                return object;
                            }
                            if (((FSLogoutStatus)object2).getStatus().equalsIgnoreCase("lib:Unsupported")) {
                                return soapService.getLogoutSOAPFault();
                            }
                            return null;
                        }
                        FSUtils.debug.error("Unable to get PreLogoutHandler");
                        FSUtils.debug.error("Cannot process request");
                        return null;
                    }
                    FSUtils.debug.message("FSServiceManager instance is null. Cannot process termination request");
                    return null;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.message("Logout Signature failed verification");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPService::handleLogoutRequest failed " + exception.getMessage());
            return null;
        }
    }

    private FSResponse handleSAMLRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSSAMLRequest fSSAMLRequest, Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("FSSOAPReceiver.handleSAMLRequest: Called");
        try {
            Object object;
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            if (string == null) {
                object = FSServiceUtils.getMetaAlias(httpServletRequest);
                string = FSServiceUtils.getAllianceInstance().getHostedProviderByMetaAlias((String)object).getProviderID();
            }
            object = FSServiceManager.getInstance();
            FSSSOBrowserArtifactProfileHandler fSSSOBrowserArtifactProfileHandler = (FSSSOBrowserArtifactProfileHandler)((FSServiceManager)object).getBrowserArtifactSSOAndFedHandler(httpServletRequest, httpServletResponse, fSSAMLRequest);
            fSSSOBrowserArtifactProfileHandler.setSOAPMessage(sOAPMessage);
            fSSSOBrowserArtifactProfileHandler.setSAMLRequestElement(element);
            fSSSOBrowserArtifactProfileHandler.setHostProviderId(string);
            return fSSSOBrowserArtifactProfileHandler.processSAMLRequest(fSSAMLRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured " + exception.getMessage());
            return null;
        }
    }

    private void handleLECPRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSSOAPReceiver.handleLECPRequest: Called");
        try {
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            FSSSOLECPProfileHandler fSSSOLECPProfileHandler = fSServiceManager.getLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest);
            fSSSOLECPProfileHandler.setHostProviderId(string);
            fSSSOLECPProfileHandler.processLECPAuthnRequest(fSAuthnRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured " + exception.getMessage());
            return;
        }
    }

    protected boolean verifyRegistrationSignature(Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Name Registration.verifyRegistrationSignature: Called");
        try {
            FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest(element);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSNameRegistrationRequest.getProviderId()).getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Registration.verifyRegistrationSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("NameRegistration.verifyRegistrationSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("Request : " + fSNameRegistrationRequest.toXMLString(true, true));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("NameRegistration.verifyRegistrationSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyTerminationSignature(Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Federation Termination.verifyTerminationSignature: Called");
        try {
            FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification(element);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSFederationTerminationNotification.getProviderId()).getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Federation Termination.verifyTerminationSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Federation Termination.verifyTerminationSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("Federation Termination.verifyTerminationSignature: xmlString to be verified: " + XMLUtils.print(element));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("Federation Termination.verifyTerminationSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyLogoutSignature(Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature: Called");
        try {
            FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
            FSUtils.debug.message("Completed forming request FSLogoutNotification");
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSLogoutNotification.getProviderId()).getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.verifyLogoutSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature : Provider's certAlias is found : " + string);
            FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature: xmlString to be verified: " + XMLUtils.print(element));
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOPAReceiver::verifyLogoutSignature  Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected SOAPMessage signRegistrationResponse(SOAPMessage sOAPMessage, String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::signRegistrationResponse");
        String string3 = fSHostedProviderDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSNameRegistrationHandler::RegistrationResponse:Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string2, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    protected SOAPMessage signLogoutResponse(SOAPMessage sOAPMessage, String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws SAMLException, FSMsgException {
        FSUtils.debug.message("SOAPReceiver::Entered signLogoutResponse::");
        String string3 = fSHostedProviderDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("signLogoutResponse::signRegistrationResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("signLogoutResponse::Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string2, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    private void returnSOAPMessage(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) {
        try {
            if (sOAPMessage != null) {
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnSOAPMessage: Exception::" + exception.getMessage());
            return;
        }
    }

    private void returnTerminationStatus(HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setStatus(204);
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnFedTerminationStatus: Exception::" + exception.getMessage());
            return;
        }
    }

    private boolean isUserExists(String string, String string2) {
        try {
            FSSessionManager fSSessionManager;
            FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string2);
            synchronized (fSSessionManager2) {
                List list;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("About to call getSessionList");
                }
                if ((list = fSSessionManager.getSessionList(string)) == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("AMC:isUserExists:List is empty");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AMC:isUserExists: List is not emptyUser found: " + string);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            String string3 = "fsassertionmanager";
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)string3, (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }
}

