/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDPEntry {
    public static final int LIB_TYPE_IDP = 0;
    public static final int LIB_TYPE_BROKER = 1;
    private String providerID = null;
    private String providerName = null;
    private String location = null;

    public IDPEntry() {
    }

    public IDPEntry(String string, String string2, String string3) {
        this.providerID = string;
        this.providerName = string2;
        this.location = string3;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String string) {
        this.providerID = string;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String string) {
        this.providerName = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        stringBuffer.append("<").append(string).append("IDPEntry").append(string2).append(">\n");
        if (this.providerID != null) {
            stringBuffer.append("<").append(string).append("ProviderID").append(">").append(this.providerID).append("</").append(string).append("ProviderID").append(">\n");
        }
        if (this.providerName != null) {
            stringBuffer.append("<").append(string).append("ProviderName").append(">").append(this.providerName).append("</").append(string).append("ProviderName").append(">\n");
        }
        if (this.location != null) {
            stringBuffer.append("<").append(string).append("Loc").append(">").append(this.location).append("</").append(string).append("Loc").append(">\n");
        }
        stringBuffer.append("</").append(string).append("IDPEntry").append(">\n");
        return stringBuffer.toString();
    }

    public IDPEntry(Element element) throws FSMsgException {
        if (element == null) {
            SAMLUtils.debug.message("IDPEntry.parseXML: null input.");
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("IDPEntry")) {
            FSUtils.debug.message("IDPEntry.parseXML: wrong input.");
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("ProviderID")) {
                    if (this.providerID != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("IDPEntry(Element): shouldcontain only one ProviderID");
                        }
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.providerID = XMLUtils.getElementValue((Element)node);
                } else if (string2.equals("ProviderName")) {
                    if (this.providerName != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("IDPEntry(Element): shouldcontain only one ProviderName");
                        }
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.providerName = XMLUtils.getElementValue((Element)node);
                } else if (string2.equals("Loc")) {
                    if (this.location != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("IDPEntry(Element): shouldcontain only one Loc");
                        }
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.location = XMLUtils.getElementValue((Element)node);
                }
            }
            ++n2;
        }
    }
}

