/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.protocol.AuthenticationQuery;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSRequest
extends Request {
    protected String id = null;

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    protected FSRequest() {
    }

    private void parseContents(List list) throws SAMLException {
        int n = 0;
        int n2 = 0;
        if (list == null || (n = list.size()) == 0) {
            FSUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e instanceof AuthenticationQuery) {
                if (this.contentType != -1 || n2 != n - 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request: should contain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 0;
                this.query = (AuthenticationQuery)e;
            } else if (e instanceof AuthorizationDecisionQuery) {
                if (this.contentType != -1 || n2 != n - 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request: should contain only one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 1;
                this.query = (AuthorizationDecisionQuery)e;
            } else if (e instanceof AttributeQuery) {
                if (this.contentType != -1 || n2 != n - 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request: should contain only one AttributeQuery.");
                    }
                    throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 4;
                this.query = (AttributeQuery)e;
            } else if (e instanceof AssertionIDReference) {
                if (this.contentType != -1 && this.contentType != 2) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request: should contain one or more AssertionIDReference.");
                    }
                    throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 2;
                if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                    this.assertionIDRefs = new ArrayList();
                }
                this.assertionIDRefs.add((AssertionIDReference)e);
            } else if (e instanceof AssertionArtifact) {
                if (this.contentType != -1 && this.contentType != 3) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request: should contain  one or more AssertionArtifact.");
                    }
                    throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 3;
                if (this.artifacts == Collections.EMPTY_LIST) {
                    this.artifacts = new ArrayList();
                }
                this.artifacts.add((AssertionArtifact)e);
            } else {
                FSUtils.debug.message("Request: wrong input.");
                throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
            }
            ++n2;
        }
    }

    public FSRequest(String string, Query query) throws SAMLException {
        super(string, query);
    }

    public FSRequest(String string, List list) throws SAMLException {
        super(string, list);
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public static Request parseXML(String string) throws SAMLException {
        Document document = XMLUtils.toDOMDocument(string);
        Element element = document.getDocumentElement();
        return new FSRequest(element);
    }

    public FSRequest(Element element) throws SAMLException {
        Object object;
        String string = null;
        if (element == null) {
            FSUtils.debug.message("Request(Element): null input.");
            throw new SAMLRequesterException(FSUtils.bundle.getString("nullInput"));
        }
        string = element.getLocalName();
        if (string == null || !string.equals("Request")) {
            FSUtils.debug.message("Request(Element): wrong input");
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        this.id = element.getAttribute("id");
        List list = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = list.size();
        if (n == 1) {
            object = XMLSignatureManager.getInstance();
            this.valid = ((XMLSignatureManager)object).verifyXMLSignature(element);
            if (!this.valid && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): couldn't verify Request's signature.");
            }
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
        } else if (n != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("moreElement"));
        }
        this.requestID = element.getAttribute("RequestID");
        if (this.requestID == null || this.requestID.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): Request doesn't have a RequestID.");
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("missingAttribute"));
        }
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        object = element.getAttribute("IssueInstant");
        if (object == null || ((String)object).equals("")) {
            FSUtils.debug.message("Request(Element): missing IssueInstant");
            throw new SAMLRequesterException(FSUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = FSUtils.stringToDate((String)object);
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): could not parse IssueInstant:" + exception.getMessage());
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = nodeList.getLength();
        while (n2 < n3) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("RespondWith")) {
                    String string3 = XMLUtils.getElementValue((Element)node);
                    if (string3.length() == 0) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): wrong RespondWith value.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    if (this.respondWiths == Collections.EMPTY_LIST) {
                        this.respondWiths = new ArrayList();
                    }
                    this.respondWiths.add(string3);
                } else if (string2.equals("Signature")) {
                    this.signature = (Element)node;
                } else if (string2.equals("AuthenticationQuery")) {
                    if (this.contentType != -1) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): shouldcontain only one AuthenticationQuery.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 0;
                    this.query = new AuthenticationQuery((Element)node);
                } else if (string2.equals("AuthorizationDecisionQuery")) {
                    if (this.contentType != -1) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): shouldcontain only one AuthorizationDecisionQuery.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 1;
                    this.query = new AuthorizationDecisionQuery((Element)node);
                } else if (string2.equals("AttributeQuery")) {
                    if (this.contentType != -1) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): shouldcontain only one AttributeQuery.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 4;
                    this.query = new AttributeQuery((Element)node);
                } else if (string2.equals("AssertionIDReference")) {
                    if (this.contentType != -1 && this.contentType != 2) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): contained mixed contents.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 2;
                    if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                        this.assertionIDRefs = new ArrayList();
                    }
                    this.assertionIDRefs.add(new AssertionIDReference(XMLUtils.getElementValue((Element)node)));
                } else if (string2.equals("AssertionArtifact")) {
                    if (this.contentType != -1 && this.contentType != 3) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): contained mixed contents.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 3;
                    if (this.artifacts == Collections.EMPTY_LIST) {
                        this.artifacts = new ArrayList();
                    }
                    this.artifacts.add(new AssertionArtifact(XMLUtils.getElementValue((Element)node)));
                } else if (string2.equals("Query") || string2.equals("SubjectQuery")) {
                    this.parseQuery(node);
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): invalid node" + string2);
                    }
                    throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.contentType == -1) {
            FSUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
    }

    private String checkAndGetRespondWith(String string) throws SAMLException {
        if (string == null || string.equals("")) {
            FSUtils.debug.message("Request: empty RespondWith Value.");
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        if (string.indexOf(":") == -1) {
            return "saml:" + string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            FSUtils.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.length() == 0) {
            FSUtils.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        return "saml:" + string2;
    }

    private void parseMajorVersion(String string) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Request(Element):MajorVersion of the Request is too high.");
                }
                throw new SAMLRequestVersionTooHighException(FSUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element):MajorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException(FSUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion > 0) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too high.");
            throw new SAMLRequestVersionTooHighException(FSUtils.bundle.getString("requestVersionTooHigh"));
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too low.");
            throw new SAMLRequestVersionTooLowException(FSUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseQuery(Node node) throws SAMLException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getLocalName();
            if (string != null && string.equals("type")) {
                String string2 = attr.getNodeValue();
                if (string2.equals("AuthenticationQueryType")) {
                    if (this.contentType != -1) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): should contain only one AuthenticationQuery.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 0;
                    this.query = new AuthenticationQuery((Element)node);
                } else if (string2.equals("AuthorizationDecisionQueryType")) {
                    if (this.contentType != -1) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): should contain one AuthorizationDecisionQuery.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 1;
                    this.query = new AuthorizationDecisionQuery((Element)node);
                } else if (string2.equals("AttributeQueryType")) {
                    if (this.contentType != -1) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Request(Element): should contain one AttributeQuery.");
                        }
                        throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 4;
                    this.query = new AttributeQuery((Element)node);
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): This type of " + string + " is not supported.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("queryNotSupported"));
                }
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): missing xsi:type definition in " + node.getLocalName());
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
    }

    public String toXMLString() {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) {
        Iterator iterator;
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (bl) {
            string = "samlp:";
            string2 = "lib:";
        }
        if (bl2) {
            string3 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
            string4 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string5 = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        String string6 = null;
        try {
            string6 = FSUtils.dateToString(this.issueInstant);
        }
        catch (Exception exception) {
            FSUtils.debug.error("Request.toString: could not convert issueInstant to String: ", (Throwable)exception);
        }
        stringBuffer.append("<").append(string).append("Request").append(string3).append(" ").append(string4).append(" ").append(string5);
        if (this.id != null && !this.id.equals("")) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(" RequestID=\"").append(this.requestID).append("\"").append(" MajorVersion=\"").append(this.majorVersion).append("\"").append(" MinorVersion=\"").append(this.minorVersion).append("\"").append(" IssueInstant=\"").append(string6).append("\"");
        stringBuffer.append(" xsi:type").append("=\"").append(string2).append("SignedSAMLRequestType").append("\"").append(">");
        if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
            iterator = this.respondWiths.iterator();
            String string7 = null;
            while (iterator.hasNext()) {
                string7 = (String)iterator.next();
                stringBuffer.append("<").append(string).append("RespondWith>");
                if (string7.startsWith("saml:")) {
                    stringBuffer.append(string7);
                } else {
                    try {
                        stringBuffer.append(this.checkAndGetRespondWith(string7));
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("Request.toString: ", (Throwable)sAMLException);
                        stringBuffer.append(string7);
                    }
                }
                stringBuffer.append("</").append(string).append("RespondWith>");
            }
        }
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        switch (this.contentType) {
            case 0: {
                stringBuffer.append(((AuthenticationQuery)this.query).toString(bl, false));
                break;
            }
            case 1: {
                stringBuffer.append(((AuthorizationDecisionQuery)this.query).toString(bl, false));
                break;
            }
            case 4: {
                stringBuffer.append(((AttributeQuery)this.query).toString(bl, false));
                break;
            }
            case 2: {
                iterator = this.assertionIDRefs.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(((AssertionIDReference)iterator.next()).toString(true, true));
                }
                break;
            }
            case 3: {
                iterator = this.artifacts.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(((AssertionArtifact)iterator.next()).toString(bl, false));
                }
                break;
            }
        }
        stringBuffer.append("</").append(string).append("Request>");
        return stringBuffer.toString();
    }
}

