/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.login.FSPostLogin;
import com.sun.identity.federation.login.FSPostLoginException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSFederationHandler
extends HttpServlet {
    public static boolean messageEnabled = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            messageEnabled = true;
        }
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("action");
        if (string != null) {
            string = string.trim();
        }
        if (string.equalsIgnoreCase("cancel")) {
            String string2;
            if (messageEnabled) {
                FSUtils.debug.message("FSFederationHandler:: user pressed cancel proceding to lrurl");
            }
            if ((string2 = httpServletRequest.getParameter("RelayState")) != null) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSFederationHandler:: Redirecting to  " + string2);
                }
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string2);
                return;
            }
            FSUtils.debug.error("FSFederationHandler::  LRURL is null in reqest ");
            return;
        }
        try {
            String string3;
            String string4 = httpServletRequest.getParameter("metaAlias");
            String string5 = httpServletRequest.getParameter("selectedprovider");
            if (string4 == null || string5 == null) {
                FSUtils.debug.error("FSFederationHandler:: No MetaAlias in request. Redirecting to error page");
                String string6 = null;
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
                return;
            }
            FSPostLogin fSPostLogin = new FSPostLogin();
            if (messageEnabled) {
                FSUtils.debug.message("FSFederationHandler:: selected provider is " + string5);
            }
            if ((string3 = fSPostLogin.doFederation(httpServletRequest, httpServletResponse)) != null) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSFederationHandler::Redirecting to" + string3 + " after postLogin");
                }
                httpServletResponse.sendRedirect(string3);
                return;
            }
            FSUtils.debug.error("FSFederationHandler::  LRURL is null from postlogin ");
            return;
        }
        catch (FSPostLoginException fSPostLoginException) {
            FSUtils.debug.error("FSFederationHandler::FSPostLogin Exception" + fSPostLoginException.getMessage());
            return;
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

