/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.common;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.common.FSUtils;

public class FSCommonManager {
    private static SSOToken ssoToken = null;

    private FSCommonManager() {
    }

    protected static synchronized SSOToken getSSOToken() throws SSOException, SessionException {
        if (ssoToken == null) {
            String string = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            SessionService sessionService = SessionService.getSessionService();
            Session session = sessionService.getAuthenticationSession(string, null);
            if (session == null) {
                FSUtils.debug.error("FSCommonManager: getSSOToken() failed to get auth session");
                throw new SessionException(SessionBundle.rbName, "sessionNotObtained", null);
            }
            session.setProperty("Principal", session.getClientID());
            session.setProperty("Organization", string);
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            ssoToken = sSOTokenManager.createSSOToken(session.getID().toString());
        }
        return ssoToken;
    }
}

