/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.common.SAMLUtils;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FSProviderDescriptor {
    protected String providerID = null;
    protected String providerName = null;
    protected String providerStatus = null;
    protected String providerType = null;
    protected String providerRole = null;
    protected Set listOfCOTs = null;
    protected String providerSuccinctID = null;
    protected String keyInfo = null;
    protected String SOAPEndPoint = null;
    protected String SLOServiceURL = null;
    protected String SLOServiceReturnURL = null;
    protected String federationTerminationServiceURL = null;
    protected String federationTerminationServiceReturnURL = null;
    protected String assertionConsumerServiceURL = null;
    protected String federationTerminationProtocolProfile = null;
    protected String SLOProtocolProfile = null;
    protected String nameRegistrationProfile = null;
    protected String nameRegistrationURL = null;
    protected String nameRegistrationReturnURL = null;
    protected boolean authnRequestSigned = false;
    protected boolean nameRegistrationAfterSSO = false;
    protected String SSOServiceURL = null;
    protected boolean nameRegistrationIndicator = false;

    public FSProviderDescriptor(String string, String string2) throws FSAllianceManagementException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSProviderDescriptor::constructor Id is null");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        this.providerID = string;
        this.setProviderStatus(string2);
        this.providerSuccinctID = this.generateSuccinctID(string);
    }

    public FSProviderDescriptor(String string, String string2, String string3) throws FSAllianceManagementException {
        this(string, string2);
        this.setProviderRole(string3);
    }

    FSProviderDescriptor(String string, Map map) {
        this.providerID = string;
        this.providerName = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-name");
        this.providerStatus = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-status");
        this.providerSuccinctID = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-succinctid");
        this.providerType = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-type");
        this.providerRole = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-role");
        this.listOfCOTs = (Set)map.get("iplanet-am-list-of-authenticationdomains");
        this.keyInfo = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-certificate-alias");
        this.SOAPEndPoint = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-soap-end-point");
        this.SLOServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-service-url");
        this.SLOServiceReturnURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-service-return-url");
        this.federationTerminationServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-service-url");
        this.federationTerminationServiceReturnURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-service-return-url");
        this.assertionConsumerServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-consumer-service-url");
        this.federationTerminationProtocolProfile = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-protocol-profile");
        this.SLOProtocolProfile = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-protocol-profile");
        this.nameRegistrationProfile = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-profile");
        this.nameRegistrationURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-url");
        this.nameRegistrationReturnURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-return-url");
        String string2 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authnrequest-signed");
        this.authnRequestSigned = string2.equalsIgnoreCase("true");
        String string3 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-after-sso");
        this.nameRegistrationAfterSSO = string3.equalsIgnoreCase("true");
        this.SSOServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-sso-service-url");
        String string4 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-indicator");
        this.nameRegistrationIndicator = string4.equalsIgnoreCase("true");
    }

    String getProviderType() {
        return this.providerType;
    }

    void setProviderType(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("hosted") && !string.equalsIgnoreCase("remote")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerType = string;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderStatus() {
        return this.providerStatus;
    }

    public String getProviderRole() {
        return this.providerRole;
    }

    public String getKeyInfo() {
        return this.keyInfo;
    }

    public String getProviderSuccinctID() {
        return this.providerSuccinctID;
    }

    public Set getListOfCOTs() {
        return this.listOfCOTs;
    }

    public String getSLOServiceURL() {
        return this.SLOServiceURL;
    }

    public String getSLOServiceReturnURL() {
        return this.SLOServiceReturnURL;
    }

    public String getNameRegistrationProfile() {
        return this.nameRegistrationProfile;
    }

    public String getNameRegistrationURL() {
        return this.nameRegistrationURL;
    }

    public String getNameRegistrationReturnURL() {
        return this.nameRegistrationReturnURL;
    }

    public String getSOAPEndPoint() {
        return this.SOAPEndPoint;
    }

    public String getFederationTerminationServiceURL() {
        return this.federationTerminationServiceURL;
    }

    public String getFederationTerminationServiceReturnURL() {
        return this.federationTerminationServiceReturnURL;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public String getFederationTerminationProtocolProfile() {
        return this.federationTerminationProtocolProfile;
    }

    public String getSLOProtocolProfile() {
        return this.SLOProtocolProfile;
    }

    public boolean getAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public boolean getNameRegistrationAfterSSO() {
        return this.nameRegistrationAfterSSO;
    }

    public boolean getNameRegistrationIndicator() {
        return this.nameRegistrationIndicator;
    }

    public void setNameRegistrationIndicator(boolean bl) {
        this.nameRegistrationIndicator = bl;
    }

    public String getSSOServiceURL() {
        return this.SSOServiceURL;
    }

    public void setProviderName(String string) {
        this.providerName = string;
    }

    public void setProviderStatus(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("active") && !string.equalsIgnoreCase("inactive")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerStatus = string;
    }

    public void setProviderRole(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("SP") && !string.equalsIgnoreCase("IDP") && !string.equalsIgnoreCase("IDP/SP")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerRole = string;
    }

    public void setKeyInfo(String string) {
        this.keyInfo = string;
    }

    public void setListOfCOTs(Set set) {
        this.listOfCOTs = set;
    }

    public void setSLOServiceURL(String string) {
        this.SLOServiceURL = string;
    }

    public void setSLOServiceReturnURL(String string) {
        this.SLOServiceReturnURL = string;
    }

    public void setNameRegistrationProfile(String string) {
        this.nameRegistrationProfile = string;
    }

    public void setNameRegistrationURL(String string) {
        this.nameRegistrationURL = string;
    }

    public void setNameRegistrationReturnURL(String string) {
        this.nameRegistrationReturnURL = string;
    }

    public void setSOAPEndPoint(String string) {
        this.SOAPEndPoint = string;
    }

    public void setFederationTerminationServiceURL(String string) {
        this.federationTerminationServiceURL = string;
    }

    public void setFederationTerminationServiceReturnURL(String string) {
        this.federationTerminationServiceReturnURL = string;
    }

    public void setAssertionConsumerServiceURL(String string) {
        this.assertionConsumerServiceURL = string;
    }

    public void setFederationTerminationProtocolProfile(String string) {
        this.federationTerminationProtocolProfile = string;
    }

    public void setSLOProtocolProfile(String string) {
        this.SLOProtocolProfile = string;
    }

    public void setAuthnRequestSigned(boolean bl) {
        this.authnRequestSigned = bl;
    }

    public void setNameRegistrationAfterSSO(boolean bl) {
        this.nameRegistrationAfterSSO = bl;
    }

    public void setSSOServiceURL(String string) {
        this.SSOServiceURL = string;
    }

    public void setProviderSuccinctID(String string) {
        this.providerSuccinctID = string;
    }

    Map getAttributes() {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-name", this.providerName);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-status", this.providerStatus);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-type", this.providerType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-role", this.providerRole);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-succinctid", this.providerSuccinctID);
        if (this.listOfCOTs != null) {
            hashMap.put("iplanet-am-list-of-authenticationdomains", this.listOfCOTs);
        }
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-certificate-alias", this.keyInfo);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-soap-end-point", this.SOAPEndPoint);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-service-url", this.SLOServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-service-return-url", this.SLOServiceReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-profile", this.nameRegistrationProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-url", this.nameRegistrationURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-return-url", this.nameRegistrationReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-service-url", this.federationTerminationServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-service-return-url", this.federationTerminationServiceReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-consumer-service-url", this.assertionConsumerServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-protocol-profile", this.federationTerminationProtocolProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-protocol-profile", this.SLOProtocolProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-sso-service-url", this.SSOServiceURL);
        String string = this.authnRequestSigned ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authnrequest-signed", string);
        String string2 = this.nameRegistrationAfterSSO ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-after-sso", string2);
        String string3 = this.nameRegistrationIndicator ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-indicator", string3);
        return hashMap;
    }

    public String generateSuccinctID(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = null;
        string2 = SAMLUtils.byteArrayToHexString(byArray2);
        return string2;
    }
}

