/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.am.util.FileLookup;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.federation.alliance.FSAllianceManagementConstants;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import java.io.File;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSLocalConfigurationDescriptor {
    private ServiceConfig sc = null;
    private String providerAlias = null;
    private String providerAuthType = null;
    private String authnfedProfile = null;
    private String orgDN = null;
    private boolean forceAuthentication = false;
    private boolean isPassive = false;
    private String respondWiths = null;
    private String libertyVersionURI = null;
    private Set trustedProviders = null;
    private String authnDecisionProvider = null;
    private String defaultAuthenticationContext = null;
    private int assertionInterval = 60;
    private int artifactTimeout = 120;
    private int cleanupInterval = 180;
    private int assertionLimit = 1000;
    private Map spAuthContextInfo = null;
    private Map idpAuthContextInfo = null;
    private Set authDomainURLList = null;
    private String providerHomePageURL = null;
    private String providerCommonLoginPageURL = null;
    private String installDir = SystemProperties.get((String)"com.iplanet.am.install.basedir");
    private String nameIdentifierImpl = null;

    public FSLocalConfigurationDescriptor() {
        this.orgDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        this.respondWiths = "lib:AuthenticationStatement";
        this.setDefaultValuesForAuth();
    }

    public FSLocalConfigurationDescriptor(String string, String string2) {
        this.setDefaultValuesForURLs(string, string2);
        this.providerAlias = string2;
        this.orgDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        this.respondWiths = "lib:AuthenticationStatement";
        this.setDefaultValuesForAuth();
    }

    FSLocalConfigurationDescriptor(ServiceConfig serviceConfig, Map map) throws SSOException, SMSException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.providerAlias = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-alias");
        this.providerAuthType = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-auth-type");
        this.authnfedProfile = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authnfed-profile");
        this.orgDN = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-orgdn");
        String string = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-force-authentication");
        this.forceAuthentication = string.equalsIgnoreCase("true");
        String string2 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-is-passive");
        this.isPassive = string2.equalsIgnoreCase("true");
        this.respondWiths = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-respond-withs");
        this.libertyVersionURI = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-liberty-version-url");
        this.nameIdentifierImpl = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-identifier-implementation");
        this.trustedProviders = (Set)map.get("iplanet-am-trusted-providers");
        this.authnDecisionProvider = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-decision-provider");
        this.defaultAuthenticationContext = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-default-authncontext");
        this.providerHomePageURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-homepage-url");
        this.providerCommonLoginPageURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-sso-fail-redirect-url");
        String string3 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-interval");
        this.assertionInterval = Integer.parseInt(string3);
        String string4 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-cleanup-interval");
        this.cleanupInterval = Integer.parseInt(string4);
        String string5 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-artifact-timeout");
        this.artifactTimeout = Integer.parseInt(string5);
        String string6 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-limit");
        this.assertionLimit = Integer.parseInt(string6);
        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig("SPAuthenticationContextInfo");
        Set set = null;
        if (serviceConfig2 != null) {
            set = serviceConfig2.getSubConfigNames();
            this.spAuthContextInfo = new HashMap();
            if (set != null) {
                object4 = set.iterator();
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    object2 = null;
                    if (object3 == null || ((String)object3).length() <= 0 || (object = serviceConfig2.getSubConfig((String)object3)) == null) continue;
                    object2 = new FSSPAuthenticationContextInfo(((ServiceConfig)object).getAttributes());
                    this.spAuthContextInfo.put(((FSSPAuthenticationContextInfo)object2).getAuthenticationContext(), object2);
                }
            }
        }
        if ((object4 = serviceConfig.getSubConfig("IDPAuthenticationContextInfo")) != null) {
            this.idpAuthContextInfo = new HashMap();
            set = ((ServiceConfig)object4).getSubConfigNames();
            if (set != null) {
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object = (String)object3.next();
                    FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = null;
                    if (((String)object).length() <= 0 || (object2 = ((ServiceConfig)object4).getSubConfig((String)object)) == null) continue;
                    fSIDPAuthenticationContextInfo = new FSIDPAuthenticationContextInfo(((ServiceConfig)object2).getAttributes());
                    this.idpAuthContextInfo.put(fSIDPAuthenticationContextInfo.getAuthenticationContext(), fSIDPAuthenticationContextInfo);
                }
            }
        }
    }

    public String getProviderAlias() {
        return this.providerAlias;
    }

    public void setProviderAlias(String string) {
        this.providerAlias = string;
    }

    public String getProviderAuthType() {
        return this.providerAuthType;
    }

    public void setProviderAuthType(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("remote") && !string.equalsIgnoreCase("local")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerAuthType = string;
    }

    public String getDoFederationPageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("Federate.jsp", httpServletRequest);
    }

    public String getLogoutDonePageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("LogoutDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getFederationDonePageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("FederationDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getErrorPageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("Error.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getNameIdentifierImpl() {
        return this.nameIdentifierImpl;
    }

    public void setNameIdentifierImpl(String string) {
        this.nameIdentifierImpl = string;
    }

    public String getAssociatedOrgDN() {
        return this.orgDN;
    }

    public void setAssociatedOrgDN(String string) {
        this.orgDN = string;
    }

    public String getAuthnfedProfile() {
        return this.authnfedProfile;
    }

    public void setAuthnfedProfile(String string) {
        this.authnfedProfile = string;
    }

    public boolean getForceAuthentication() {
        return this.forceAuthentication;
    }

    public void setForceAuthentication(boolean bl) {
        this.forceAuthentication = bl;
    }

    public boolean getIsPassive() {
        return this.isPassive;
    }

    public void setIsPassive(boolean bl) {
        this.isPassive = bl;
    }

    public String getRespondWiths() {
        return this.respondWiths;
    }

    public void setRespondWiths(String string) {
        this.respondWiths = string;
    }

    public String getLibertyVersionURI() {
        return this.libertyVersionURI;
    }

    public void setLibertyVersionURI(String string) {
        this.libertyVersionURI = string;
    }

    public Set getTrustedProviders() {
        return this.trustedProviders;
    }

    public void setTrustedProviders(Set set) {
        this.trustedProviders = set;
    }

    public String getListOfCOTsPageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("ListOfCOTs.jsp", httpServletRequest);
    }

    public String getTerminationDonePageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("TerminationDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getNameRegistrationDonePageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("NameRegistrationDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getProviderCommonLoginPageURL(HttpServletRequest httpServletRequest) {
        return this.providerCommonLoginPageURL;
    }

    public String getProviderCommonLoginPageURL() {
        return this.providerCommonLoginPageURL;
    }

    public String getProviderHomePageURL() {
        return this.providerHomePageURL;
    }

    public void setProviderHomePageURL(String string) {
        this.providerHomePageURL = string;
    }

    public void setProviderCommonLoginPageURL(String string) {
        this.providerCommonLoginPageURL = string;
    }

    public String getAuthDecisionProvider() {
        return this.authnDecisionProvider;
    }

    public void setAuthDecisionProvider(String string) {
        this.authnDecisionProvider = string;
    }

    public String getDefaultAuthenticationContext() {
        return this.defaultAuthenticationContext;
    }

    public void setDefaultAuthenticationContext(String string) {
        this.defaultAuthenticationContext = string;
    }

    public int getAssertionInterval() {
        return this.assertionInterval;
    }

    public void setAssertionInterval(int n) {
        this.assertionInterval = n;
    }

    public int getAssertionLimit() {
        return this.assertionLimit;
    }

    public void setAssertionLimit(int n) {
        this.assertionLimit = n;
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(int n) {
        this.cleanupInterval = n;
    }

    public int getArtifactTimeout() {
        return this.artifactTimeout;
    }

    public void setArtifactTimeout(int n) {
        this.artifactTimeout = n;
    }

    public Map getSPAuthContextInfo() {
        return this.spAuthContextInfo;
    }

    public Map getIDPAuthContextInfo() {
        return this.idpAuthContextInfo;
    }

    public void setSPAuthContextInfo(Map map) {
        this.spAuthContextInfo = map;
    }

    public void setIDPAuthContextInfo(Map map) {
        this.idpAuthContextInfo = map;
    }

    public Set getAuthDomainURLList() {
        return this.authDomainURLList;
    }

    void setAuthDomainURLList(Set set) {
        this.authDomainURLList = set;
    }

    Map getAttributes() {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-alias", this.providerAlias);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-auth-type", this.providerAuthType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authnfed-profile", this.authnfedProfile);
        String string = this.forceAuthentication ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-force-authentication", string);
        String string2 = this.isPassive ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-is-passive", string2);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-orgdn", this.orgDN);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-respond-withs", this.respondWiths);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-liberty-version-url", this.libertyVersionURI);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-identifier-implementation", this.nameIdentifierImpl);
        if (this.trustedProviders != null) {
            hashMap.put("iplanet-am-trusted-providers", this.trustedProviders);
        }
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-decision-provider", this.authnDecisionProvider);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-homepage-url", this.providerHomePageURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-sso-fail-redirect-url", this.providerCommonLoginPageURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-default-authncontext", this.defaultAuthenticationContext);
        String string3 = String.valueOf(this.assertionInterval);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-interval", string3);
        String string4 = String.valueOf(this.assertionLimit);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-limit", string4);
        String string5 = String.valueOf(this.artifactTimeout);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-artifact-timeout", string5);
        String string6 = String.valueOf(this.cleanupInterval);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-cleanup-interval", string6);
        return hashMap;
    }

    public Set getActiveTrustedProviders() {
        if (this.trustedProviders == null) {
            return this.trustedProviders;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.trustedProviders.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                if (!this.isActiveProvider(string)) continue;
                hashSet.add(string);
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSLocalConfigurationDescriptor ::getActiveTrustedProviders() exception", (Throwable)exception);
                hashSet = null;
            }
        }
        return hashSet;
    }

    boolean isActiveProvider(String string) throws Exception {
        String string2;
        String string3;
        String string4;
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string4 = (String)AccessController.doPrivileged(new AdminDNAction())), string3 = (String)AccessController.doPrivileged(new AdminPasswordAction()));
        FSAllianceManager fSAllianceManager = new FSAllianceManager(sSOToken);
        FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string);
        return fSProviderDescriptor != null && (string2 = fSProviderDescriptor.getProviderStatus()) != null && string2.equalsIgnoreCase("active");
    }

    private String getAbsoluteFileName(String string, HttpServletRequest httpServletRequest) {
        String string2 = null;
        int n = this.installDir.lastIndexOf("/");
        string2 = n != -1 ? this.installDir.substring(0, n) : this.installDir;
        String string3 = string2 + "/config/federation";
        String string4 = "/" + this.providerAlias;
        if (this.providerAlias == null) {
            string4 = "/default";
        }
        File file = null;
        String string5 = FSServiceUtils.getLocale(httpServletRequest);
        AuthD authD = AuthD.getAuth();
        String string6 = authD.getFilePath(authD.getClientType(httpServletRequest));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLocalConfigurationDescriptor.getAbsoluteFileName() filePath :: " + string6);
        }
        try {
            String string7;
            String string8;
            file = FileLookup.getFirstExisting((String)string4, (String)string5, null, (String)string6, (String)string, (String)string3, (boolean)true);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message(file.getPath());
            }
            if ((string8 = (string7 = file.getPath()).substring(string2.length(), string7.length())).indexOf("\\") != -1) {
                string8 = string8.replace('\\', '/');
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("relativeFileName : " + string8);
            }
            return string8;
        }
        catch (Exception exception) {
            FSUtils.debug.warning("No file found, returing default", (Throwable)exception);
            return "/config/federation/default/" + string;
        }
    }

    void setDefaultValuesForURLs(String string, String string2) {
        String string3 = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
        if (string3 == null || string3.length() <= 0) {
            string3 = "DEPLOY_URI";
        }
        String string4 = "/config/federation/default";
        String string5 = string + string3 + string4;
        this.providerHomePageURL = string5 + "/index.html";
        this.providerCommonLoginPageURL = string5 + "/CommonLogin.jsp";
    }

    void setDefaultValuesForAuth() {
        String[] stringArray = new String[10];
        int n = FSAllianceManagementConstants.SPAUTHLEVEL_DEFAULT;
        FSSPAuthenticationContextInfo[] fSSPAuthenticationContextInfoArray = new FSSPAuthenticationContextInfo[10];
        stringArray[0] = "http://www.projectliberty.org/schemas/authctx/classes/MobileContract";
        fSSPAuthenticationContextInfoArray[0] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileContract", n);
        stringArray[1] = "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID";
        fSSPAuthenticationContextInfoArray[1] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID", n);
        stringArray[2] = "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered";
        fSSPAuthenticationContextInfoArray[2] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered", n);
        stringArray[3] = "http://www.projectliberty.org/schemas/authctx/classes/Password";
        fSSPAuthenticationContextInfoArray[3] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Password", n);
        stringArray[4] = "http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport";
        fSSPAuthenticationContextInfoArray[4] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport", n);
        stringArray[5] = "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session";
        fSSPAuthenticationContextInfoArray[5] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Previous-Session", n);
        stringArray[6] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard";
        fSSPAuthenticationContextInfoArray[6] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard", n);
        stringArray[7] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI";
        fSSPAuthenticationContextInfoArray[7] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI", n);
        stringArray[8] = "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI";
        fSSPAuthenticationContextInfoArray[8] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Software-PKI", n);
        stringArray[9] = "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token";
        fSSPAuthenticationContextInfoArray[9] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token", n);
        String[] stringArray2 = new String[10];
        int n2 = FSAllianceManagementConstants.IDPAUTHPRIORITY_DEFAULT;
        String string = FSAllianceManagementConstants.IDP_MODULE_KEY;
        String string2 = FSAllianceManagementConstants.IDP_MODULE_VALUE;
        boolean bl = FSAllianceManagementConstants.IDP_SUPPORTED;
        FSIDPAuthenticationContextInfo[] fSIDPAuthenticationContextInfoArray = new FSIDPAuthenticationContextInfo[10];
        stringArray2[0] = "http://www.projectliberty.org/schemas/authctx/classes/MobileContract";
        fSIDPAuthenticationContextInfoArray[0] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileContract", n2, string, string2, bl);
        stringArray2[1] = "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID";
        fSIDPAuthenticationContextInfoArray[1] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID", n2, string, string2, bl);
        stringArray2[2] = "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered";
        fSIDPAuthenticationContextInfoArray[2] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered", n2, string, string2, bl);
        stringArray2[3] = "http://www.projectliberty.org/schemas/authctx/classes/Password";
        fSIDPAuthenticationContextInfoArray[3] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Password", n2, string, string2, bl);
        stringArray2[4] = "http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport";
        fSIDPAuthenticationContextInfoArray[4] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport", n2, string, string2, bl);
        stringArray2[5] = "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session";
        fSIDPAuthenticationContextInfoArray[5] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Previous-Session", n2, string, string2, bl);
        stringArray2[6] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard";
        fSIDPAuthenticationContextInfoArray[6] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard", n2, string, string2, bl);
        stringArray2[7] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI";
        fSIDPAuthenticationContextInfoArray[7] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI", n2, string, string2, bl);
        stringArray2[8] = "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI";
        fSIDPAuthenticationContextInfoArray[8] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Software-PKI", n2, string, string2, bl);
        stringArray2[9] = "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token";
        fSIDPAuthenticationContextInfoArray[9] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token", n2, string, string2, bl);
        this.spAuthContextInfo = new HashMap();
        this.idpAuthContextInfo = new HashMap();
        int n3 = 0;
        while (n3 < 10) {
            this.spAuthContextInfo.put(stringArray[n3], fSSPAuthenticationContextInfoArray[n3]);
            this.idpAuthContextInfo.put(stringArray2[n3], fSIDPAuthenticationContextInfoArray[n3]);
            ++n3;
        }
    }
}

