/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSCache;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public final class FSAllianceManager {
    private String orgDN = null;
    private SSOToken token = null;
    private ServiceConfigManager providerManager = null;
    private ServiceConfigManager authDomainManager = null;
    private ServiceConfig authDomainConfig = null;
    private ServiceConfig providerConfig = null;
    private boolean messageEnabled = false;
    private static boolean cacheOn = true;

    public FSAllianceManager(SSOToken sSOToken) throws FSAllianceManagementException {
        this(sSOToken, SystemProperties.get((String)"com.iplanet.am.defaultOrg"));
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::Constructor with ssoToken only");
        }
    }

    public FSAllianceManager(SSOToken sSOToken, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::Constructor orgDN invalid");
            throw new FSAllianceManagementException("alliance_management_org_exception", null);
        }
        if (sSOToken == null) {
            FSUtils.debug.error("FSAllianceManager::Constructor ssoToken is null");
            throw new FSAllianceManagementException("alliance_management_sso_exception", null);
        }
        this.token = sSOToken;
        this.messageEnabled = FSUtils.debug.messageEnabled();
        try {
            this.authDomainManager = new ServiceConfigManager(this.token, "iPlanetAMAuthenticationDomainConfigService", "1.0");
            if (this.authDomainManager == null || (this.authDomainConfig = this.authDomainManager.getOrganizationConfig(string, null)) == null) {
                FSUtils.debug.error("FSAllianceManager::Constructor Service Configuration not done properly for iPlanetAMAuthenticationDomainConfigServiceservice");
                throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::Constructor Finished AuthDomainConfig");
            }
            this.providerManager = new ServiceConfigManager(this.token, "iPlanetAMProviderConfigService", "1.0");
            if (this.providerManager == null || (this.providerConfig = this.providerManager.getOrganizationConfig(string, null)) == null) {
                FSUtils.debug.error("FSAllianceManager::Constructor Service Configuration not done properly for iPlanetAMProviderConfigServiceService");
                throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::Constructor Finished ProviderConfig");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::Constructor SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::Constructor SSOException ", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
    }

    public void createCircleOfTrust(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) throws FSInvalidNameException, FSAllianceManagementException {
        String string = null;
        if (fSCircleOfTrustDescriptor == null || (string = fSCircleOfTrustDescriptor.getCircleOfTrustName()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Name in the given COT descriptor: " + string + " is invalid");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        if (this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrustExists");
            throw new FSAllianceManagementException("alliance_management_authdomain_exists", null);
        }
        Object var3_3 = null;
        Map map = fSCircleOfTrustDescriptor.getAttributes();
        try {
            this.authDomainConfig.addSubConfig(string, "AuthenticationDomain", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createCircleOfTrust created " + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("COT_Created") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Couldn't add subconfig for AuthenticationDomainCreation", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Couldn't add subconfig for AuthenticationDomainCreation", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_creation_exception", null);
        }
    }

    public void deleteCircleOfTrust(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust Name is null or such COT does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            this.authDomainConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteCircleOfTrust deleted " + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("COT_Deleted") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust SMSException while deleting", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_deletion_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust SSOException while deleting", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_deletion_exception", null);
        }
    }

    public void modifyCircleOfTrust(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        String string;
        if (fSCircleOfTrustDescriptor == null || (string = fSCircleOfTrustDescriptor.getCircleOfTrustName()) == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::modifyCircleOfTrust Name in the given COT descriptor is nullor such a COT does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.authDomainConfig.getSubConfig(string);
            serviceConfig.setAttributes(fSCircleOfTrustDescriptor.getAttributes());
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::modifyCircleOfTrust modified " + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("COT_Modified") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::modifyCircleOfTrust SMSException while modifying", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_modification_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyCircleOfTrust SSOException while modifying", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_modification_exception", null);
        }
    }

    public FSCircleOfTrustDescriptor getCircleOfTrust(String string) throws FSAllianceManagementException, FSInvalidNameException {
        ServiceConfig serviceConfig = null;
        if (string == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::getCircleOfTrust Name of COT is null or this does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            serviceConfig = this.authDomainConfig.getSubConfig(string);
            return new FSCircleOfTrustDescriptor(string, serviceConfig.getAttributes());
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCircleOfTrust SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getCircleOfTrust SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllCirclesOfTrust(String string) throws FSAllianceManagementException {
        Object var3_2 = null;
        try {
            Set set = string.equals("*") ? this.authDomainConfig.getSubConfigNames() : this.authDomainConfig.getSubConfigNames(string);
            return set;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCirclesOfTrust could not get CirclesOfTrust got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllActiveCirclesOfTrust() throws FSAllianceManagementException {
        Set set = new HashSet();
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        try {
            set = this.authDomainConfig.getSubConfigNames();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Map map = this.authDomainConfig.getSubConfig(string).getAttributes();
                    if (!FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authenticationdomain-status").equalsIgnoreCase("active")) continue;
                    hashSet.add(string);
                }
            }
            return hashSet;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCirclesOfTrust couldn't get COT got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getCirclesOfTrust couldn't get COT got SSSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllCirclesOfTrust() throws FSAllianceManagementException {
        return this.getAllCirclesOfTrust("*");
    }

    public void deleteCirclesOfTrust(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.deleteCircleOfTrust((String)iterator.next());
        }
    }

    public void createProvider(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string = null;
        if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createProvider  ID in the given ProviderDescriptor is null");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        if (this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::createProvider Provider already exists");
            throw new FSAllianceManagementException("alliance_management_provider_exists", null);
        }
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::createProvider valid provider ID");
        }
        Map map = fSProviderDescriptor.getAttributes();
        try {
            Set set = fSProviderDescriptor.getListOfCOTs();
            if (!this.isValidCOTList(set)) {
                FSUtils.debug.error("FSAllianceManager.java:: createProvider ListOfCOTs invalid");
                throw new FSAllianceManagementException("cotlist_invalid", null);
            }
            if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSProviderDescriptor")) {
                map = fSProviderDescriptor.getAttributes();
                this.providerConfig.addSubConfig(string, "Provider", 0, map);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Remote Provider Node created");
                }
                FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("RemoteProvider_Created") + string);
            } else if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
                fSProviderDescriptor.setProviderType("hosted");
                map = fSProviderDescriptor.getAttributes();
                this.providerConfig.addSubConfig(string, "Provider", 0, map);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Created Hosted Provider General attrs nodeabout to set LocalConfiguration");
                }
                ServiceConfig serviceConfig = this.providerConfig.getSubConfig(string);
                FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration();
                if (fSLocalConfigurationDescriptor != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    if (fSLocalConfigurationDescriptor.getIsPassive() && fSLocalConfigurationDescriptor.getForceAuthentication()) {
                        FSUtils.debug.error("FSAllianceManager.java:: createProvider LocalConfig Invalid");
                        throw new FSAllianceManagementException("localconfig_invalid", null);
                    }
                    Set set2 = fSLocalConfigurationDescriptor.getTrustedProviders();
                    if (!this.isValidProviderList(set, set2)) {
                        this.providerConfig.removeSubConfig(string);
                        FSUtils.debug.error("FSAllianceManager.java:: createProvider trusted provider list invalid");
                        throw new FSAllianceManagementException("trustedproviderlist_invalid", null);
                    }
                    serviceConfig.addSubConfig("LocalConfiguration", "LocalConfiguration", 0, fSLocalConfigurationDescriptor.getAttributes());
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::createProvider Finished setting LocalConfig");
                    }
                    FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("HostedProvider_Created") + string);
                    ServiceConfig serviceConfig2 = serviceConfig.getSubConfig("LocalConfiguration");
                    Map map2 = fSLocalConfigurationDescriptor.getSPAuthContextInfo();
                    if (map2 != null) {
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProvider SPAuthInfo is not null");
                        }
                        serviceConfig2.addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                        object5 = serviceConfig2.getSubConfig("SPAuthenticationContextInfo");
                        object4 = map2.keySet();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            object2 = (FSSPAuthenticationContextInfo)map2.get((String)object3.next());
                            if (object2 == null || (object = ((FSSPAuthenticationContextInfo)object2).getAuthenticationContext()) == null || ((String)object).length() <= 0) continue;
                            ((ServiceConfig)object5).addSubConfig((String)object, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object2).getAttributes());
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProvider finished SPAuth information saved in DS");
                        }
                    }
                    if ((object5 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                        serviceConfig2.addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                        object4 = serviceConfig2.getSubConfig("IDPAuthenticationContextInfo");
                        object3 = object5.keySet();
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            String string2;
                            object = (FSIDPAuthenticationContextInfo)object5.get((String)object2.next());
                            if (object == null || (string2 = ((FSIDPAuthenticationContextInfo)object).getAuthenticationContext()) == null || string2.length() <= 0) continue;
                            ((ServiceConfig)object4).addSubConfig(string2, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object).getAttributes());
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProviderfinished IDPAuth information");
                        }
                    }
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::createProvider createdHostedProvider");
                    }
                }
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
    }

    public void deleteProvider(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider providerID " + string + "is invalid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            this.providerConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteProvider deleted" + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("Provider_Deleted") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider could not delete provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider could not delete provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
        }
    }

    public FSProviderDescriptor getProvider(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::getProvider null or empty providerID");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        FSProviderDescriptor fSProviderDescriptor = null;
        if (cacheOn && (fSProviderDescriptor = FSCache.getProviderDescriptor(string)) != null) {
            return fSProviderDescriptor;
        }
        fSProviderDescriptor = this.getProviderInternal(string);
        if (cacheOn && fSProviderDescriptor != null) {
            FSCache.setProviderDescriptor(fSProviderDescriptor);
        }
        return fSProviderDescriptor;
    }

    private FSProviderDescriptor getProviderInternal(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::getProvider providerID: " + string + "is invalid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.providerConfig.getSubConfig(string);
            Map map = serviceConfig.getAttributes();
            FSProviderDescriptor fSProviderDescriptor = new FSProviderDescriptor(string, map);
            String string2 = fSProviderDescriptor.getProviderType();
            if (string2.equalsIgnoreCase("remote")) {
                return fSProviderDescriptor;
            }
            FSHostedProviderDescriptor fSHostedProviderDescriptor = new FSHostedProviderDescriptor(string, map);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig("LocalConfiguration");
            if (serviceConfig2 == null) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::getProvider No LocalConfig for hostedProvider");
                }
                return fSHostedProviderDescriptor;
            }
            Map map2 = serviceConfig2.getAttributes();
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = new FSLocalConfigurationDescriptor(serviceConfig2, map2);
            try {
                Set set = this.getAuthDomainURLList(fSLocalConfigurationDescriptor.getAssociatedOrgDN());
                fSLocalConfigurationDescriptor.setAuthDomainURLList(set);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSAllianceManager.java::getProvider AuthDomainURLs not read ");
            }
            fSHostedProviderDescriptor.setLocalConfiguration(fSLocalConfigurationDescriptor);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::getProvider finished setting Local Config");
            }
            return fSHostedProviderDescriptor;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getProvider  couldn't get provider SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getProvider couldn't get provider SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public void modifyProvider(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSProviderDescriptor == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyProvider providerDescriptor not valid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        String string = fSProviderDescriptor.getProviderID();
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::ModifyProvider providerID :" + string + "not valid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.providerConfig.getSubConfig(string);
            if (serviceConfig != null) {
                FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
                Map map = fSProviderDescriptor.getAttributes();
                Set set = fSProviderDescriptor.getListOfCOTs();
                if (!this.isValidCOTList(set)) {
                    FSUtils.debug.error("FSAllianceManager.java:: modifyProvider ListOfCOTs invalid");
                    throw new FSAllianceManagementException("cotlist_invalid", null);
                }
                Map map2 = serviceConfig.getAttributes();
                if (!map2.equals(map)) {
                    serviceConfig.setAttributes(map);
                }
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::ModifyProvider set general attributes");
                }
                if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor") && (fSLocalConfigurationDescriptor = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration()) != null) {
                    if (fSLocalConfigurationDescriptor.getIsPassive() && fSLocalConfigurationDescriptor.getForceAuthentication()) {
                        FSUtils.debug.error("FSAllianceManager.java:: modifyProvider LocalConfig Invalid");
                        throw new FSAllianceManagementException("localconfig_invalid", null);
                    }
                    Set set2 = fSLocalConfigurationDescriptor.getTrustedProviders();
                    if (!this.isValidProviderList(set, set2)) {
                        FSUtils.debug.error("FSAllianceManager.java:: modifyProvider trusted provider list invalid");
                        throw new FSAllianceManagementException("trustedproviderlist_invalid", null);
                    }
                    ServiceConfig serviceConfig2 = serviceConfig.getSubConfig("LocalConfiguration");
                    map = fSLocalConfigurationDescriptor.getAttributes();
                    if (serviceConfig2 == null) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        serviceConfig.addSubConfig("LocalConfiguration", "LocalConfiguration", 0, map);
                        serviceConfig2 = serviceConfig.getSubConfig("LocalConfiguration");
                        Map map3 = fSLocalConfigurationDescriptor.getSPAuthContextInfo();
                        if (map3 != null) {
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider SPAuthInfo Not null");
                            }
                            serviceConfig2.addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider SPAuthContext Node created ");
                            }
                            object5 = serviceConfig2.getSubConfig("SPAuthenticationContextInfo");
                            object4 = map3.keySet();
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                object2 = (FSSPAuthenticationContextInfo)map3.get((String)object3.next());
                                if (object2 == null || (object = ((FSSPAuthenticationContextInfo)object2).getAuthenticationContext()) == null || ((String)object).length() <= 0) continue;
                                ((ServiceConfig)object5).addSubConfig((String)object, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object2).getAttributes());
                            }
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager.java::createProvider finished SP Auth information");
                        }
                        if ((object5 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                            serviceConfig2.addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider IDPAuthode created");
                            }
                            object4 = serviceConfig2.getSubConfig("IDPAuthenticationContextInfo");
                            object3 = object5.keySet();
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                String string2;
                                object = (FSIDPAuthenticationContextInfo)object5.get((String)object2.next());
                                if (object == null || (string2 = ((FSIDPAuthenticationContextInfo)object).getAuthenticationContext()) == null || string2.length() <= 0) continue;
                                ((ServiceConfig)object4).addSubConfig(string2, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object).getAttributes());
                            }
                        }
                    } else {
                        Object object;
                        Object object6;
                        Object object7;
                        Object object8;
                        Object object9;
                        Map map4;
                        ServiceConfig serviceConfig3;
                        map2 = serviceConfig2.getAttributes();
                        if (!map2.equals(map)) {
                            serviceConfig2.setAttributes(map);
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAlliaceManager::ModifyProvider set LocalConfiguration");
                        }
                        if ((serviceConfig3 = serviceConfig2.getSubConfig("SPAuthenticationContextInfo")) == null) {
                            serviceConfig2.addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider created Node for SPAuthConfig Info ");
                            }
                            serviceConfig3 = serviceConfig2.getSubConfig("SPAuthenticationContextInfo");
                        }
                        if ((map4 = fSLocalConfigurationDescriptor.getSPAuthContextInfo()) != null) {
                            object9 = map4.keySet();
                            object8 = object9.iterator();
                            while (object8.hasNext()) {
                                object7 = (FSSPAuthenticationContextInfo)map4.get((String)object8.next());
                                if (object7 == null || (object6 = ((FSSPAuthenticationContextInfo)object7).getAuthenticationContext()) == null || ((String)object6).length() <= 0) continue;
                                object = serviceConfig3.getSubConfig((String)object6);
                                if (object != null) {
                                    ((ServiceConfig)object).setAttributes(((FSSPAuthenticationContextInfo)object7).getAttributes());
                                    continue;
                                }
                                serviceConfig3.addSubConfig((String)object6, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object7).getAttributes());
                            }
                        }
                        if ((object8 = serviceConfig2.getSubConfig("IDPAuthenticationContextInfo")) == null) {
                            serviceConfig2.addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider createdNode for IDPAuthConfig Info ");
                            }
                            object8 = serviceConfig2.getSubConfig("IDPAuthenticationContextInfo");
                        }
                        if ((object9 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                            object7 = object9.keySet();
                            object6 = object7.iterator();
                            while (object6.hasNext()) {
                                String string3;
                                object = (FSIDPAuthenticationContextInfo)object9.get((String)object6.next());
                                if (object == null || (string3 = ((FSIDPAuthenticationContextInfo)object).getAuthenticationContext()) == null || string3.length() <= 0) continue;
                                ServiceConfig serviceConfig4 = ((ServiceConfig)object8).getSubConfig(string3);
                                if (serviceConfig4 != null) {
                                    serviceConfig4.setAttributes(((FSIDPAuthenticationContextInfo)object).getAttributes());
                                    continue;
                                }
                                ((ServiceConfig)object8).addSubConfig(string3, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object).getAttributes());
                            }
                        }
                    }
                }
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::modifyPovider Modified provider");
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("Provider_Modified") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::modifyProvider SMSException while modifying", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_modification_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyProvider SSOException while modifying", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_modification_exception", null);
        }
    }

    public Set getAllProviderIds() throws FSAllianceManagementException {
        return this.getAllProviderIds("*");
    }

    public Set getAllProviderIds(String string) throws FSAllianceManagementException {
        try {
            Set set = string.equals("*") ? this.providerConfig.getSubConfigNames() : this.providerConfig.getSubConfigNames(string);
            return set;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAllProviderIds SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllActiveProviderIds() throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public Set getAllHostedProviderIds() throws FSAllianceManagementException {
        return this.getAllHostedProviderIds("*");
    }

    public Set getAllHostedProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllProviderIds(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string3);
                    if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderType()) == null || !string2.equalsIgnoreCase("hosted")) continue;
                    hashSet.add(string3);
                }
            }
            return hashSet;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllHostedProviders, SMSException");
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllActiveHostedProviderIds() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllHostedProviderIds();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                    if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                    hashSet.add(string2);
                }
            }
            return hashSet;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllActiveHostedProviderIds SMSException", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllRemoteProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllProviderIds(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string3);
                    if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderType()) == null || !string2.equalsIgnoreCase("remote")) continue;
                    hashSet.add(string3);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllRemoteProviders SMSException", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_sms_exception", null, (Throwable)((Object)fSAllianceManagementException));
        }
        return hashSet;
    }

    public Set getAllRemoteProviderIds() throws FSAllianceManagementException {
        return this.getAllRemoteProviderIds("*");
    }

    public Set getAllActiveRemoteProviderIds() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.getAllRemoteProviderIds();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public void deleteProviders(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.deleteProvider((String)iterator.next());
            }
        }
    }

    public FSProviderDescriptor getProviderBySuccinctID(String string) throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            FSProviderDescriptor fSProviderDescriptor = this.getProvider((String)iterator.next());
            if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderSuccinctID()) == null || !string2.equalsIgnoreCase(string)) continue;
            return fSProviderDescriptor;
        }
        throw new FSAllianceManagementException("alliance_management_provider_succinctid_invalid", null);
    }

    public FSHostedProviderDescriptor getHostedProviderByMetaAlias(String string) throws FSAllianceManagementException {
        Set set = this.getAllHostedProviderIds();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
            FSHostedProviderDescriptor fSHostedProviderDescriptor = this.getHostedProvider((String)iterator.next());
            if (fSHostedProviderDescriptor == null || (fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration()) == null || (string2 = fSLocalConfigurationDescriptor.getProviderAlias()) == null || !string2.equalsIgnoreCase(string)) continue;
            return fSHostedProviderDescriptor;
        }
        throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_metaalias_invalid"));
    }

    public FSHostedProviderDescriptor getHostedProvider(String string) throws FSAllianceManagementException {
        FSProviderDescriptor fSProviderDescriptor = this.getProvider(string);
        if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
            return (FSHostedProviderDescriptor)fSProviderDescriptor;
        }
        FSUtils.debug.error("FSAllianceManager::getHostedProviderDescriptor given provider is not a hosted provider");
        throw new FSAllianceManagementException("alliance_management_providerid_invalid", null);
    }

    Set getAuthDomainURLList(String string) throws FSAllianceManagementException {
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(this.token);
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            Set set = aMOrganization.getAttribute("sunPreferredDomain");
            set.addAll(aMOrganization.getAttribute("associatedDomain"));
            DN dN = new DN(string);
            set.add(((RDN)dN.getRDNs().firstElement()).getValues()[0]);
            return set;
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAllianceManager::getURLMappingList AMException while reading", (Throwable)aMException);
            throw new FSAllianceManagementException("alliance_management_sms_exception", null, aMException);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getURLMappingList SSOException while reading", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_sso_exception", null, sSOException);
        }
    }

    public Set getProspectiveTrustedProviders(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = this.getHostedProvider(string);
        Set set = fSHostedProviderDescriptor.getListOfCOTs();
        if (set == null) {
            FSUtils.debug.message("FSAllianceManager::getProspectiveTrustedProviders No Prospective provider");
            return hashSet;
        }
        Set set2 = this.getAllProviderIds();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
            Set set3 = fSProviderDescriptor.getListOfCOTs();
            if (set3 == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                if (!set3.contains(iterator2.next())) continue;
                hashSet.add(string2);
            }
        }
        hashSet.remove(string);
        return hashSet;
    }

    boolean isValidCOTList(Set set) throws FSAllianceManagementException {
        Set set2 = this.getAllCirclesOfTrust();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (set2.contains(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    boolean isValidProviderList(Set set, Set set2) throws FSAllianceManagementException {
        Set set3 = this.getAllProviderIds();
        if (set2 != null) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!set3.contains(string)) {
                    return false;
                }
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string);
                Set set4 = fSProviderDescriptor.getListOfCOTs();
                if (set4 == null || set == null) {
                    return false;
                }
                boolean bl = false;
                Iterator iterator2 = set4.iterator();
                while (iterator2.hasNext()) {
                    if (!set.contains(iterator2.next())) continue;
                    bl = true;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    static {
        try {
            String string = SystemProperties.get((String)"com.sun.identity.federation.alliance.cache.enabled");
            if (string.equalsIgnoreCase("false")) {
                cacheOn = false;
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("Could not get cacheOn signal from config.  Take default value.");
            cacheOn = true;
        }
    }
}

