/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.accountmgmt.FSAccountUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FSAccountManager {
    private static FSAccountManager instance = null;
    private static String defaultOrgDN = "";
    private static String adminDN = "";
    private static String adminPW = "";
    private static SSOToken ssoToken = null;
    private AMStoreConnection amStoreCnct = null;
    private static boolean msgEnabled = false;

    private FSAccountManager() throws FSAccountMgmtException {
        defaultOrgDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        if (FSUtils.debug.messageEnabled()) {
            msgEnabled = true;
        }
        adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
        adminPW = (String)AccessController.doPrivileged(new AdminPasswordAction());
        SSOTokenManager sSOTokenManager = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            ssoToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(adminDN), adminPW);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.getInstance() : SSOException : ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            FSUtils.debug.error("FSAccountManager.getInstance() : UnsupportedOperationException: ", (Throwable)unsupportedOperationException);
            throw new FSAccountMgmtException(unsupportedOperationException.getMessage());
        }
    }

    public static synchronized FSAccountManager getInstance() throws FSAccountMgmtException {
        if (instance == null) {
            instance = new FSAccountManager();
        }
        if (instance != null) {
            FSUtils.debug.message("FSAccountManager: instantiated");
        }
        return instance;
    }

    private void getAMStoreConnection() throws FSAccountMgmtException {
        try {
            if (this.amStoreCnct == null) {
                if (msgEnabled) {
                    FSUtils.debug.message("FSAccountManager.getAMStoreConnection() : amStoreCnct is null calling AMStoreConnection()");
                }
                this.amStoreCnct = new AMStoreConnection(ssoToken);
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.getAMStoreConnection():SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
    }

    public void writeAccountFedInfo(String string, FSAccountFedInfoKey fSAccountFedInfoKey, FSAccountFedInfo fSAccountFedInfo) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo() : called");
        if (fSAccountFedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : FedInfo key is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        if (fSAccountFedInfo == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : FedInfo is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-object-is-null", null);
        }
        this.getAMStoreConnection();
        try {
            Object object;
            Object object2;
            Object object3;
            AMUser aMUser = this.amStoreCnct.getUser(string);
            if (aMUser == null) {
                FSUtils.debug.error("FSAccountManager.writeAccountFedInfo() : Unable to get amUser object with userDN :" + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            HashSet<Object> hashSet = aMUser.getAttribute("iplanet-am-user-federation-info-key");
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
            } else if (!hashSet.isEmpty()) {
                object3 = hashSet.iterator();
                object2 = "";
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (((String)object2).indexOf(FSAccountUtils.createFilter(fSAccountFedInfoKey)) < 0) continue;
                    if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo():AccountFedInfo Key Already Exists, will overwrite.");
                    }
                    hashSet.remove(object2);
                    break;
                }
            }
            object3 = FSAccountUtils.objectToKeyString(fSAccountFedInfoKey);
            hashSet.add(object3);
            object2 = new HashMap();
            object2.put("iplanet-am-user-federation-info-key", hashSet);
            HashSet<Object> hashSet2 = aMUser.getAttribute("iplanet-am-user-federation-info");
            if (hashSet2 == null) {
                hashSet2 = new HashSet<Object>();
            } else if (!hashSet2.isEmpty()) {
                object = hashSet2.iterator();
                String string2 = "";
                while (object.hasNext()) {
                    string2 = (String)object.next();
                    if (string2.indexOf(FSAccountUtils.createFilter(fSAccountFedInfo.getProviderID())) < 0) continue;
                    if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo() : AccountFedInfo Already Exists, will overwrite");
                    }
                    hashSet2.remove(string2);
                    break;
                }
            }
            object = FSAccountUtils.objectToInfoString(fSAccountFedInfo);
            hashSet2.add(object);
            object2.put("iplanet-am-user-federation-info", hashSet2);
            aMUser.setAttributes((Map)object2);
            aMUser.store();
            if (msgEnabled) {
                FSUtils.debug.message("FSAccountManager.writeAccountFedInfo(): Key : " + (String)object3 + ", Value : " + (String)object + " : Added ");
            }
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo(): AMException : ", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo(): SSOException : ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
    }

    public void writeAccountFedInfo(String string, FSAccountFedInfoKey fSAccountFedInfoKey, FSAccountFedInfo fSAccountFedInfo, FSAccountFedInfoKey fSAccountFedInfoKey2) throws FSAccountMgmtException {
        this.removeAccountFedInfoKey(string, fSAccountFedInfoKey2);
        this.writeAccountFedInfo(string, fSAccountFedInfoKey, fSAccountFedInfo);
    }

    private void removeAccountFedInfoKey(String string, FSAccountFedInfoKey fSAccountFedInfoKey) throws FSAccountMgmtException {
        block7: {
            FSUtils.debug.message("FSAccountManager.removeAccountFedInfoKey():called");
            if (fSAccountFedInfoKey == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():Invalid Argument : FedInfo key is NULL");
                throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
            }
            this.getAMStoreConnection();
            try {
                AMUser aMUser = this.amStoreCnct.getUser(string);
                if (aMUser == null) {
                    FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey(): Unable to get amUser object with userDN:" + string);
                    throw new FSAccountMgmtException("actmgmt-user-not-found", null);
                }
                HashMap<String, Set> hashMap = new HashMap<String, Set>();
                Set set = aMUser.getAttribute("iplanet-am-user-federation-info-key");
                if (set == null || set.isEmpty()) break block7;
                Iterator iterator = set.iterator();
                String string2 = "";
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.indexOf(FSAccountUtils.createFilter(fSAccountFedInfoKey)) < 0) continue;
                    if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.removeAccountFedInfoKey():Account Fed Info Key Exists, will remove it");
                    }
                    set.remove(string2);
                    hashMap.put("iplanet-am-user-federation-info-key", set);
                    aMUser.setAttributes(hashMap);
                    aMUser.store();
                    break;
                }
            }
            catch (AMException aMException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():AMException:", (Throwable)aMException);
                throw new FSAccountMgmtException(aMException.getMessage());
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():SSOException:", (Throwable)sSOException);
                throw new FSAccountMgmtException(sSOException.getMessage());
            }
        }
    }

    public void removeAccountFedInfo(String string, FSAccountFedInfoKey fSAccountFedInfoKey, String string2) throws FSAccountMgmtException {
        block13: {
            FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():called");
            if (fSAccountFedInfoKey == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : FedInfo key is NULL");
                throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
            }
            if (string2 == null || string2.length() <= 0) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : providerID is NULL");
                throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
            }
            this.getAMStoreConnection();
            try {
                Object object;
                Object object2;
                AMUser aMUser = this.amStoreCnct.getUser(string);
                if (aMUser == null) {
                    FSUtils.debug.error("FSAccountManager.removeAccountFedInfo(): Unable to get amUser object with userDN:" + string);
                    throw new FSAccountMgmtException("actmgmt-user-not-found", null);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                boolean bl = false;
                Set set = aMUser.getAttribute("iplanet-am-user-federation-info-key");
                if (set != null && !set.isEmpty()) {
                    object2 = set.iterator();
                    object = "";
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        if (((String)object).indexOf(FSAccountUtils.createFilter(fSAccountFedInfoKey)) < 0) continue;
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():Account Fed Info Key Exists, will remove it");
                        }
                        set.remove(object);
                        hashMap.put("iplanet-am-user-federation-info-key", set);
                        bl = true;
                        break;
                    }
                }
                if ((object2 = aMUser.getAttribute("iplanet-am-user-federation-info")) != null && !object2.isEmpty()) {
                    object = object2.iterator();
                    String string3 = "";
                    while (object.hasNext()) {
                        string3 = (String)object.next();
                        if (string3.indexOf(FSAccountUtils.createFilter(string2)) < 0) continue;
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():Account Fed Info Exists, will remove it");
                        }
                        object2.remove(string3);
                        hashMap.put("iplanet-am-user-federation-info", object2);
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    aMUser.setAttributes(hashMap);
                    aMUser.store();
                    break block13;
                }
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Account Federation Info not Found");
                throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
            }
            catch (AMException aMException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():AMException:", (Throwable)aMException);
                throw new FSAccountMgmtException(aMException.getMessage());
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():SSOException:", (Throwable)sSOException);
                throw new FSAccountMgmtException(sSOException.getMessage());
            }
        }
    }

    public FSAccountFedInfo readAccountFedInfo(String string, String string2) throws FSAccountMgmtException {
        Object object;
        FSUtils.debug.message("FSAccountManager.readAccountFedInfo() : called");
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():Invalid Argument : providerID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        this.getAMStoreConnection();
        Set set = null;
        try {
            object = this.amStoreCnct.getUser(string);
            if (object == null) {
                FSUtils.debug.error("FSAccountManager.readAccountFedInfo(): Unable to get amUser object with userDN:" + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = object.getAttribute("iplanet-am-user-federation-info");
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():AMException:", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set != null && !set.isEmpty()) {
            object = set.iterator();
            while (object.hasNext()) {
                FSAccountFedInfo fSAccountFedInfo;
                String string3 = (String)object.next();
                if (string3.indexOf(FSAccountUtils.createFilter(string2)) < 0) continue;
                if (msgEnabled) {
                    FSUtils.debug.message("FSAccountManager.readAccountFedInfo():  value found: " + string3);
                }
                if (!(fSAccountFedInfo = FSAccountUtils.stringToObject(string3)).isFedStatusActive()) {
                    return null;
                }
                return fSAccountFedInfo;
            }
        }
        if (msgEnabled) {
            FSUtils.debug.message("FSAccountManager.readAccountFedInfo():  value with userDN : " + string + " and providerID : " + string2 + " not found");
        }
        return null;
    }

    public Set readAllFederatedProviderID(String string) throws FSAccountMgmtException {
        Object object;
        FSUtils.debug.message("FSAccountManager.readAllFederatedProviderID() : called");
        this.getAMStoreConnection();
        Set set = null;
        try {
            object = this.amStoreCnct.getUser(string);
            if (object == null) {
                FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID(): Unable to get amUser object with userDN : " + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = object.getAttribute("iplanet-am-user-federation-info");
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():AMException:", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        object = new HashSet();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            String string2 = "";
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string2);
                if (!fSAccountFedInfo.isFedStatusActive()) continue;
                object.add(fSAccountFedInfo.getProviderID());
            }
        }
        return object;
    }

    public void activateFederation(String string, String string2) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.activateFederation() : called");
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.activateFederation():Invalid Argument : ProviderID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        this.getAMStoreConnection();
        try {
            AMUser aMUser = this.amStoreCnct.getUser(string);
            if (aMUser == null) {
                FSUtils.debug.error("FSAccountManager.activateFederation(): Unable to get amUser object with userDN:" + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            Set set = aMUser.getAttribute("iplanet-am-user-federation-info");
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3.indexOf(FSAccountUtils.createFilter(string2)) < 0) continue;
                    FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string3);
                    String string4 = "";
                    if (!fSAccountFedInfo.isFedStatusActive()) {
                        set.remove(string3);
                        fSAccountFedInfo.activateFedStatus();
                        string4 = FSAccountUtils.objectToInfoString(fSAccountFedInfo);
                        set.add(string4);
                        HashMap<String, Set> hashMap = new HashMap<String, Set>();
                        hashMap.put("iplanet-am-user-federation-info", set);
                        aMUser.setAttributes(hashMap);
                        aMUser.store();
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.activateFederation():  Value : " + string4 + " Activated ");
                        }
                    } else if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.activateFederation():  Value : " + string4 + " Already Active ");
                    }
                    return;
                }
            }
            FSUtils.debug.error("FSAccountManager.activateFederation():Account Federation Info not Found");
            throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.activateFederation():AMException:", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.activateFederation():SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
    }

    public void deActivateFederation(String string, String string2) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.deActivateFederation():called");
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation():Invalid Argument : ProviderID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        this.getAMStoreConnection();
        try {
            AMUser aMUser = this.amStoreCnct.getUser(string);
            if (aMUser == null) {
                FSUtils.debug.error("FSAccountManager.deActivateFederation(): Unable to get amUser object with userDN:" + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            Set set = aMUser.getAttribute("iplanet-am-user-federation-info");
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                String string3 = "";
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    if (string3.indexOf(FSAccountUtils.createFilter(string2)) < 0) continue;
                    FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string3);
                    String string4 = "";
                    if (fSAccountFedInfo.isFedStatusActive()) {
                        set.remove(string3);
                        fSAccountFedInfo.deActivateFedStatus();
                        string4 = FSAccountUtils.objectToInfoString(fSAccountFedInfo);
                        set.add(string4);
                        HashMap<String, Set> hashMap = new HashMap<String, Set>();
                        hashMap.put("iplanet-am-user-federation-info", set);
                        aMUser.setAttributes(hashMap);
                        aMUser.store();
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.deActivateFederation():  Value : " + string4 + " deActivated ");
                        }
                    } else if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.deActivateFederation():  Value : " + string4 + " Already InActive ");
                    }
                    return;
                }
            }
            FSUtils.debug.error("FSAccountManager.deActivateFederation() : Account Federation Info not Found");
            throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation() : AMException: ", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation() : SSOException: ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
    }

    public boolean isFederationActive(String string, String string2) throws FSAccountMgmtException {
        Object object;
        FSUtils.debug.message("FSAccountManager.isFederationActive() : called");
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : Invalid Argument : ProviderID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        this.getAMStoreConnection();
        Set set = null;
        try {
            object = this.amStoreCnct.getUser(string);
            if (object == null) {
                FSUtils.debug.error("FSAccountManager.isFederationActive(): Unable to get amUser object with userDN:" + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = object.getAttribute("iplanet-am-user-federation-info");
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : AMException: ", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : SSOException: ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set != null && !set.isEmpty()) {
            object = set.iterator();
            while (object.hasNext()) {
                FSAccountFedInfo fSAccountFedInfo;
                String string3 = (String)object.next();
                if (string3.indexOf(FSAccountUtils.createFilter(string2)) < 0) continue;
                if (msgEnabled) {
                    FSUtils.debug.message("FSAccountManager.isFederationActive(): value found: " + string3);
                }
                return (fSAccountFedInfo = FSAccountUtils.stringToObject(string3)).isFedStatusActive();
            }
        }
        FSUtils.debug.error("FSAccountManager.isFederationActive() : Account Federation Info not Found");
        throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
    }

    public boolean hasAnyActiveFederation(String string) throws FSAccountMgmtException {
        Object object;
        FSUtils.debug.message("FSAccountManager.hasAnyActiveFederation():called");
        this.getAMStoreConnection();
        Set set = null;
        try {
            object = this.amStoreCnct.getUser(string);
            if (object == null) {
                FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():Unable to get amUser object with userDN: " + string);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = object.getAttribute("iplanet-am-user-federation-info");
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():AMException: ", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():SSOException: ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set != null && !set.isEmpty()) {
            object = set.iterator();
            String string2 = "";
            while (object.hasNext()) {
                string2 = (String)object.next();
                FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string2);
                if (!fSAccountFedInfo.isFedStatusActive() || !fSAccountFedInfo.isRoleIDP()) continue;
                return true;
            }
            return false;
        }
        FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():Account Federation Info not Found");
        throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
    }

    public String getUserDN(FSAccountFedInfoKey fSAccountFedInfoKey) throws FSAccountMgmtException {
        return this.getUserDN(fSAccountFedInfoKey, defaultOrgDN);
    }

    public String getUserDN(FSAccountFedInfoKey fSAccountFedInfoKey, String string) throws FSAccountMgmtException {
        Object object;
        Object object2;
        FSUtils.debug.message("FSAccountManager.getUserDN() : called");
        if (fSAccountFedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.getUserDN():Invalid Argument : fedInfoKey is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        this.getAMStoreConnection();
        Set set = null;
        try {
            object2 = this.amStoreCnct.getOrganization(string);
            object = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(FSAccountUtils.objectToKeyString(fSAccountFedInfoKey));
            object.put("iplanet-am-user-federation-info-key", hashSet);
            set = object2.searchUsers("*", (Map)object, 2);
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAccountManager.getUserDN() : AMException:", (Throwable)aMException);
            throw new FSAccountMgmtException(aMException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.getUserDN() : SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set == null || set.isEmpty()) {
            FSUtils.debug.message("FSAccountManager.getUserDN(): Not Found");
            return null;
        }
        if (set.size() > 1) {
            FSUtils.debug.error("FSAccountManager.getUserDN() : Multiple match found");
            throw new FSAccountMgmtException("actmgmt-multiple-uid-matched", null);
        }
        object2 = set.iterator();
        object = (String)object2.next();
        FSUtils.debug.message("FSAccountManager.getUserDN(): Found: " + (String)object);
        return object;
    }

    public void deActivateFederation(FSAccountFedInfoKey fSAccountFedInfoKey, String string) throws FSAccountMgmtException {
        String string2 = this.getUserDN(fSAccountFedInfoKey);
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation():User Not Found ");
            throw new FSAccountMgmtException("actmgmt-user-not-found", null);
        }
        this.deActivateFederation(string2, string);
    }

    public void deActivateFederation(FSAccountFedInfoKey fSAccountFedInfoKey, String string, String string2) throws FSAccountMgmtException {
        String string3 = this.getUserDN(fSAccountFedInfoKey, string2);
        if (string3 == null || string3.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation():User Not Found ");
            throw new FSAccountMgmtException("actmgmt-user-not-found", null);
        }
        this.deActivateFederation(string3, string);
    }
}

