/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.NameIdentifier;

public class FSAccountFedInfo {
    private String providerID = "";
    private NameIdentifier localNameIdentifier = null;
    private NameIdentifier remoteNameIdentifier = null;
    private boolean isActive = true;
    private boolean isRoleIDP = true;

    FSAccountFedInfo() {
    }

    public FSAccountFedInfo(String string, NameIdentifier nameIdentifier, int n, boolean bl) throws FSAccountMgmtException {
        if (n == 0) {
            this.init(string, nameIdentifier, null, bl);
        } else if (n == 1) {
            this.init(string, null, nameIdentifier, bl);
        } else {
            FSUtils.debug.error("FSAccountFedInfo.Constructor() : Invalid Argument : Invalid Name Identifier Type");
            throw new FSAccountMgmtException("actmgmt-nameIdentifierType-invalid", null);
        }
    }

    public FSAccountFedInfo(String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2, boolean bl) throws FSAccountMgmtException {
        this.init(string, nameIdentifier, nameIdentifier2, bl);
    }

    private void init(String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2, boolean bl) throws FSAccountMgmtException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAccountFedInfo.init(): Invalid Argument: providerID is " + string);
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        if (nameIdentifier == null && nameIdentifier2 == null) {
            FSUtils.debug.error("FSAccountFedInfo.Constructor(): Invalid Argument: both NameIdentifiers are null");
            throw new FSAccountMgmtException("actmgmt-name-identifier-is-null", null);
        }
        this.providerID = string;
        this.localNameIdentifier = nameIdentifier;
        this.remoteNameIdentifier = nameIdentifier2;
        this.isRoleIDP = bl;
        this.isActive = true;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountFedInfo.init() : providerID :: " + this.providerID + ", isRoleIDP :: " + this.isRoleIDP);
            if (nameIdentifier != null) {
                FSUtils.debug.message("FSAccountFedInfo.init() : localNameIdentifier" + this.localNameIdentifier.toString());
            }
            if (nameIdentifier2 != null) {
                FSUtils.debug.message("FSAccountFedInfo.init() : remoteNameIdentifier" + this.remoteNameIdentifier.toString());
            }
        }
    }

    public String getProviderID() {
        return this.providerID;
    }

    void setProviderID(String string) {
        this.providerID = string;
    }

    public void setLocalNameIdentifier(NameIdentifier nameIdentifier) {
        this.localNameIdentifier = nameIdentifier;
    }

    public NameIdentifier getLocalNameIdentifier() {
        return this.localNameIdentifier;
    }

    public void setRemoteNameIdentifier(NameIdentifier nameIdentifier) {
        this.remoteNameIdentifier = nameIdentifier;
    }

    public NameIdentifier getRemoteNameIdentifier() {
        return this.remoteNameIdentifier;
    }

    public void activateFedStatus() {
        this.isActive = true;
    }

    public void deActivateFedStatus() {
        this.isActive = false;
    }

    public boolean isFedStatusActive() {
        return this.isActive;
    }

    public boolean isRoleIDP() {
        return this.isRoleIDP;
    }

    void setRole(boolean bl) {
        this.isRoleIDP = bl;
    }
}

