/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.FileLookup;
import com.iplanet.am.util.FileLookupException;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.StreamSubstituter;
import com.sun.identity.security.EncodeAction;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthUtils {
    static Hashtable authContextHash = new Hashtable();
    static Hashtable loginStateHash = new Hashtable();
    private static boolean setRequestEncoding = false;
    public static final String ERROR_MESSAGE = "Error_Message";
    public static final String ERROR_TEMPLATE = "Error_Template";
    private static AuthD ad;

    public AuthUtils() {
        if (ad == null) {
            ad = AuthD.getAuth();
        }
        AuthD.debug.message("AuthUtil: constructor");
    }

    public InternalSession getSession(AuthContextLocal authContextLocal) {
        InternalSession internalSession = AuthUtils.getLoginState(authContextLocal).getSession();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("returning session : " + internalSession);
        }
        return internalSession;
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, boolean bl2) throws AuthException {
        return AuthUtils.getAuthContext(httpServletRequest, httpServletResponse, bl, bl2, false);
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, boolean bl2, boolean bl3) throws AuthException {
        AuthContextLocal authContextLocal;
        block19: {
            AuthD.debug.message("In AuthUtils:getAuthContext");
            authContextLocal = null;
            LoginState loginState = null;
            if (ad == null) {
                ad = AuthD.getAuth();
            }
            try {
                Hashtable hashtable = AuthUtils.parseRequestParameters(httpServletRequest);
                SessionID sessionID = new SessionID(httpServletRequest);
                authContextLocal = (AuthContextLocal)authContextHash.get(sessionID);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("AuthUtil:getAuthContext:sid is.. .: " + sessionID);
                    AuthD.debug.message("AuthUtil:getAuthContext:authContext is.. .: " + authContextLocal);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("isSessionUpgrade  :" + bl);
                    AuthD.debug.message("BACK with Request method POST : " + bl2);
                }
                if (authContextLocal == null && bl3) {
                    return null;
                }
                if (authContextLocal == null || bl || bl2) {
                    try {
                        loginState = new LoginState();
                        if (bl) {
                            loginState.setPrevAuthContext(authContextLocal);
                            loginState.setSessionUpgrade(bl);
                        } else if (bl2) {
                            loginState.setPrevAuthContext(authContextLocal);
                        }
                        authContextLocal = loginState.createAuthContext(httpServletRequest, httpServletResponse, sessionID, hashtable);
                        loginStateHash.put(authContextLocal, loginState);
                        String string = AuthUtils.getQueryOrgName(httpServletRequest, ad.getOrgParam(hashtable));
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("query org is .. : " + string);
                        }
                        loginState.setQueryOrg(string);
                        break block19;
                    }
                    catch (AuthException authException) {
                        AuthD.debug.message("Error creating AuthContextLocal : ");
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("Exception ", (Throwable)((Object)authException));
                        }
                        throw new AuthException((Throwable)((Object)authException));
                    }
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("getAuthContext: found existing request.");
                }
                try {
                    authContextLocal = AuthUtils.processAuthContext(authContextLocal, httpServletRequest, httpServletResponse, hashtable, sessionID);
                    loginState = AuthUtils.getLoginState(authContextLocal);
                    loginState.setRequestType(false);
                }
                catch (AuthException authException) {
                    AuthD.debug.message("Error Retrieving AuthContextLocal");
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("Exception ", (Throwable)((Object)authException));
                    }
                    throw new AuthException("102", null);
                }
            }
            catch (Exception exception) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Error creating AuthContextLocal : " + exception.getMessage());
                }
                throw new AuthException(exception);
            }
        }
        AuthD.debug.message("AuthUtils:getAuthContext returning AuthContextLocal.");
        return authContextLocal;
    }

    static AuthContextLocal processAuthContext(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, SessionID sessionID) throws AuthException {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        InternalSession internalSession = null;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("in processAuthContext : " + authContextLocal);
            AuthD.debug.message("in processAuthContext : " + httpServletRequest);
            AuthD.debug.message("in processAuthContext : " + httpServletResponse);
            AuthD.debug.message("in processAuthContext : " + sessionID);
        }
        if (AuthUtils.newSessionArgExists(hashtable, sessionID) && loginState.getLoginStatus() == 3) {
            AuthD.debug.message("newSession arg exists");
            AuthUtils.destroySession(loginState, authContextLocal);
            try {
                loginState = new LoginState();
                authContextLocal = loginState.createAuthContext(httpServletRequest, httpServletResponse, sessionID, hashtable);
                loginStateHash.put(authContextLocal, loginState);
                String string = AuthUtils.getQueryOrgName(httpServletRequest, ad.getOrgParam(hashtable));
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("query org is .. : " + string);
                }
                loginState.setQueryOrg(string);
            }
            catch (AuthException authException) {
                AuthD.debug.message("Error creating AuthContextLocal");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception ", (Throwable)((Object)authException));
                }
                throw new AuthException("102", null);
            }
        } else {
            AuthD.debug.message("new session arg does not exist");
            loginState.setHttpServletRequest(httpServletRequest);
            loginState.setHttpServletResponse(httpServletResponse);
            loginState.setParamHash(hashtable);
            internalSession = ad.getSession(httpServletRequest);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("AuthUtil :Session is .. : " + internalSession);
            }
            loginState.setSession(internalSession);
            loginState.persistentCookieArgExists();
        }
        return authContextLocal;
    }

    public static LoginState getLoginState(AuthContextLocal authContextLocal) {
        if (authContextLocal == null) {
            return null;
        }
        LoginState loginState = null;
        try {
            loginState = (LoginState)loginStateHash.get(authContextLocal);
            return loginState;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hashtable parseRequestParameters(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        return AuthUtils.decodeHash(httpServletRequest, enumeration);
    }

    private static Hashtable decodeHash(HttpServletRequest httpServletRequest, Enumeration enumeration) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = httpServletRequest.getParameter("gx_charset");
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthUtils::decodeHash:enc = " + string);
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = httpServletRequest.getParameter(string2);
            if (setRequestEncoding) {
                hashtable.put(string2, Locale.URLDecodeField((String)string3, (String)string, (Debug)AuthD.debug));
                continue;
            }
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    public Hashtable getRequestParameters(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            return loginState.getRequestParamHash();
        }
        return new Hashtable();
    }

    public static void removeSessionFromHash(SessionID sessionID) {
        if (sessionID != null) {
            authContextHash.remove(sessionID);
        }
    }

    public static void removeLoginStateFromHash(AuthContextLocal authContextLocal) {
        if (authContextLocal != null) {
            loginStateHash.remove(authContextLocal);
        }
    }

    public static void removeLoginStateFromHash(String string) {
        AuthContextLocal authContextLocal = (AuthContextLocal)authContextHash.get(new SessionID(string));
        if (authContextLocal != null) {
            loginStateHash.remove(authContextLocal);
        }
    }

    public static String getSidString(AuthContextLocal authContextLocal) throws AuthException {
        InternalSession internalSession = null;
        String string = null;
        try {
            LoginState loginState;
            if (authContextLocal != null && (loginState = (LoginState)loginStateHash.get(authContextLocal)) != null) {
                internalSession = loginState.getSession();
                string = internalSession.getID().toString();
            }
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error retreiving sid.. :" + exception.getMessage());
            }
            throw new AuthException("noSid", new Object[]{exception.getMessage()});
        }
        return string;
    }

    public Cookie getCookieString(AuthContextLocal authContextLocal, String string) {
        Cookie cookie;
        block3: {
            cookie = null;
            try {
                String string2 = AuthUtils.getSidString(authContextLocal);
                cookie = this.createCookie(string2, string);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block3;
                AuthD.debug.message("Error getting sid : " + exception.getMessage());
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Cookie is set : " + cookie);
        }
        return cookie;
    }

    public Cookie getLogoutCookieString(AuthContextLocal authContextLocal, String string) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        SessionID sessionID = loginState.getSession().getID();
        String string2 = AuthUtils.getLogoutCookieString(sessionID);
        return this.createCookie(string2, string);
    }

    public Cookie getLogoutCookieString(SessionID sessionID, String string) {
        String string2 = AuthUtils.getLogoutCookieString(sessionID);
        return this.createCookie(string2, string);
    }

    public static String getLogoutCookieString(SessionID sessionID) {
        String string;
        block3: {
            string = null;
            try {
                string = (String)AccessController.doPrivileged(new EncodeAction("LOGOUT@" + sessionID.getSessionServerProtocol() + "@" + sessionID.getSessionServer() + "@" + sessionID.getSessionServerPort() + "@" + sessionID.getSessionDomain(), Crypt.getHardcodedKeyEncryptor()));
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Logout cookie : " + string);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block3;
                AuthD.debug.message("Error creating cookie : " + exception.getMessage());
            }
        }
        return string;
    }

    public Cookie createCookie(String string, String string2) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("cookieValue : " + string);
            AuthD.debug.message("cookieDomain : " + string2);
        }
        String string3 = ad.getCookieName();
        return this.createCookie(string3, string, string2);
    }

    public boolean isNewRequest(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState.isNewRequest()) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("this is a newRequest");
            }
            return true;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("this is an existing request");
        }
        return false;
    }

    public String getLoginSuccessURL(AuthContextLocal authContextLocal) {
        String string = null;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        string = loginState == null ? AuthD.getAuth().defaultSuccessURL : AuthUtils.getLoginState(authContextLocal).getSuccessLoginURL();
        return string;
    }

    public String getNewLoginSuccessURL(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest) {
        String string = null;
        if (httpServletRequest != null) {
            string = httpServletRequest.getParameter("goto");
        }
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("null")) {
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            string = loginState == null ? AuthD.getAuth().defaultSuccessURL : AuthUtils.getLoginState(authContextLocal).getConfiguredSuccessLoginURL();
        }
        return string;
    }

    public String getLoginFailedURL(AuthContextLocal authContextLocal) {
        try {
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            if (loginState == null) {
                return AuthD.getAuth().defaultFailureURL;
            }
            String string = loginState.getFailureLoginURL();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("AuthUtils: getLoginFailedURL " + string);
            }
            return string;
        }
        catch (Exception exception) {
            AuthD.debug.message("Exception ", (Throwable)exception);
            return null;
        }
    }

    public String getFileName(AuthContextLocal authContextLocal, String string) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        String string2 = null;
        if (loginState != null) {
            String string3 = LoginState.getInstallDir();
            String string4 = AuthUtils.getLoginState(authContextLocal).getFileName(string);
            string2 = this.getRelativeFileName(string4, string3);
        }
        return string2;
    }

    public String getFileName(AuthContextLocal authContextLocal, String string, String string2) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        String string3 = null;
        if (loginState != null) {
            String string4 = loginState.getFileName(string, string2);
            string3 = this.getRelativeFileName(string4, string2);
        }
        return string3;
    }

    public boolean getInetDomainStatus(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).getInetDomainStatus();
    }

    public static boolean newSessionArgExists(Hashtable hashtable, SessionID sessionID) {
        String string = (String)hashtable.get("arg");
        if (string != null && string.equals("newsession")) {
            return sessionID != null && authContextHash.contains(sessionID);
        }
        return false;
    }

    public String encodeURL(String string, AuthContextLocal authContextLocal, HttpServletResponse httpServletResponse) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        String string2 = loginState == null ? string : loginState.encodeURL(string, httpServletResponse);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthUtils:encoded url is :" + string2);
        }
        return string2;
    }

    public String getLocale(AuthContextLocal authContextLocal) {
        if (authContextLocal == null) {
            return ad.getPlatformLocale();
        }
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return ad.getPlatformLocale();
        }
        return loginState.getLocale();
    }

    public String getQueryOrg(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).getQueryOrg();
    }

    public static String getQueryOrgName(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        if (string != null && !string.equals("")) {
            string2 = string;
        } else if (httpServletRequest != null) {
            string2 = httpServletRequest.getServerName();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("queryOrg is :" + string2);
        }
        return string2;
    }

    static void destroySession(LoginState loginState, AuthContextLocal authContextLocal) {
        try {
            loginState.destroySession();
            AuthUtils.removeLoginStateFromHash(authContextLocal);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error destroySEssion : ", (Throwable)exception);
        }
    }

    public void destroySession(AuthContextLocal authContextLocal) {
        if (authContextLocal == null) {
            return;
        }
        try {
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            if (loginState != null) {
                loginState.destroySession();
            }
            AuthUtils.removeLoginStateFromHash(authContextLocal);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error destroying session ", (Throwable)exception);
        }
    }

    public static void printCookies(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            AuthD.debug.message("No Cookie in header");
            return;
        }
        int n = 0;
        while (n < cookieArray.length) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Received Cookie:" + cookieArray[n].getName() + " = " + cookieArray[n].getValue());
            }
            ++n;
        }
    }

    public boolean sessionTimedOut(AuthContextLocal authContextLocal) {
        boolean bl = false;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            bl = loginState.isTimedOut();
            if (!bl) {
                InternalSession internalSession = loginState.getSession();
                bl = internalSession == null || internalSession.isTimedOut();
                loginState.setTimedOut(bl);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("AuthUtils.sessionTimedOut: " + bl);
            }
        }
        return bl;
    }

    public static void printHash(Hashtable hashtable) {
        block7: {
            try {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("AuthRequest: In printHash" + hashtable);
                }
                if (hashtable == null) {
                    return;
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = hashtable.get(k);
                    AuthD.debug.message("printHash Key is : " + k);
                    if (!(v instanceof String[])) continue;
                    String[] stringArray = (String[])v;
                    int n = 0;
                    while (n < stringArray.length) {
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("printHash : String[] keyname (" + k + ") = " + stringArray[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block7;
                AuthD.debug.warning("Exception: printHash :", (Throwable)exception);
            }
        }
    }

    public void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthContextLocal authContextLocal, String string) throws Exception {
        try {
            String string2 = this.getReqURL(httpServletRequest, string);
            String string3 = ad.getClientType(httpServletRequest);
            if (ad.isUrlRewrite(string3)) {
                string2 = this.encodeURL(string2, authContextLocal, httpServletResponse);
            }
            if (!ad.isGenericHTMLClient(string3)) {
                this.buildRedirectBody(httpServletResponse, authContextLocal, string2);
            }
            httpServletResponse.sendRedirect(string2);
        }
        catch (Exception exception) {
            AuthD.debug.error("Error redirecting");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Exception ", (Throwable)exception);
            }
            throw new Exception("102");
        }
    }

    public void buildRedirectBody(HttpServletResponse httpServletResponse, AuthContextLocal authContextLocal, String string) throws Exception {
        try {
            String string2 = SystemProperties.get((String)"com.iplanet.am.install.basedir");
            File file = new File(this.getFileName(authContextLocal, "redirect.template", string2));
            if (file == null) {
                throw new Exception("102");
            }
            if (!file.canRead()) {
                throw new Exception("102");
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            StreamSubstituter streamSubstituter = new StreamSubstituter();
            streamSubstituter.define("XurlX", string);
            streamSubstituter.filter(file, printWriter);
            printWriter.close();
            ServletOutputStream servletOutputStream = null;
            servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.println(stringWriter.toString());
            servletOutputStream.close();
        }
        catch (Exception exception) {
            AuthD.debug.error("Error accessing redirect template");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Exception ", (Throwable)exception);
            }
            throw new Exception(exception.getMessage());
        }
    }

    public String getReqURL(HttpServletRequest httpServletRequest, String string) throws Exception {
        try {
            if (!string.regionMatches(true, 0, "http://", 0, 7) && !string.regionMatches(true, 0, "https://", 0, 7)) {
                StringBuffer stringBuffer = this.getRequestServer(httpServletRequest);
                URL uRL = new URL(stringBuffer.toString());
                String string2 = uRL.getProtocol();
                StringBuffer stringBuffer2 = new StringBuffer().append(string2).append("://").append(uRL.getHost()).append(":");
                int n = uRL.getPort();
                if (string2.equals("http") && n <= 0) {
                    n = 80;
                } else if (string2.equals("https") && n <= 0) {
                    n = 443;
                }
                stringBuffer2.append(n).append(string);
                return stringBuffer2.toString();
            }
        }
        catch (Exception exception) {
            throw new Exception(AuthUtils.ad.bundle.getString("errorConstructingURL"));
        }
        return string;
    }

    public StringBuffer getRequestServer(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        boolean bl = false;
        String string2 = httpServletRequest.getScheme();
        stringBuffer.append(string2);
        stringBuffer.append("://");
        bl = new Boolean(ad.getIgnoreHostHeader(ad.getClientType(httpServletRequest)));
        if (!bl) {
            string = httpServletRequest.getHeader("host");
        }
        if (string == null) {
            stringBuffer.append(httpServletRequest.getServerName());
            int n = httpServletRequest.getServerPort();
            if (string2.equals("http") && n != 80 || string2.equals("https") && n != 443) {
                stringBuffer.append(':');
                stringBuffer.append(httpServletRequest.getServerPort());
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public boolean isPersistentCookieOn(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).isPersistentCookieOn();
    }

    public boolean getPersistentCookieMode(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).getPersistentCookieMode();
    }

    public Cookie getPersistentCookieString(AuthContextLocal authContextLocal, String string) {
        return null;
    }

    public String searchPersistentCookie(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        return loginState.searchPersistentCookie();
    }

    public static String DNtoName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        string2 = n2 == -1 ? string.substring(n + 1).trim() : string.substring(n + 1, n2).trim();
        return string2;
    }

    public Cookie createPersistentCookie(AuthContextLocal authContextLocal, String string) throws AuthException {
        Cookie cookie = null;
        try {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("cookieDomain : " + string);
            }
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            cookie = loginState.setPersistentCookie(string);
            return cookie;
        }
        catch (Exception exception) {
            AuthD.debug.message("Unable to create persistent Cookie");
            throw new AuthException("102", null);
        }
    }

    public static Cookie createPersistentCookie(String string, String string2, int n, String string3) {
        Cookie cookie = CookieUtils.newCookie((String)string, (String)string2, (String)"/", (String)string3);
        if (n >= 0) {
            cookie.setMaxAge(n);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("pCookie is.. :" + cookie);
        }
        return cookie;
    }

    public Cookie createlbCookie(AuthContextLocal authContextLocal, String string, boolean bl) throws AuthException {
        Cookie cookie = null;
        try {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("cookieDomain : " + string);
            }
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            cookie = loginState.setlbCookie(string, bl);
            return cookie;
        }
        catch (Exception exception) {
            AuthD.debug.message("Unable to create Load Balance Cookie");
            throw new AuthException("102", null);
        }
    }

    public void setlbCookie(AuthContextLocal authContextLocal, HttpServletResponse httpServletResponse) throws AuthException {
        String string = ad.getlbCookieName();
        if (string != null && string.length() != 0) {
            Set set = ad.getCookieDomains();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Cookie cookie = this.createlbCookie(authContextLocal, string2, false);
                    httpServletResponse.addCookie(cookie);
                }
            } else {
                httpServletResponse.addCookie(this.createlbCookie(authContextLocal, null, false));
            }
        }
    }

    public Cookie createCookie(String string, String string2, String string3) {
        Cookie cookie;
        block4: {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("cookieName   : " + string);
                AuthD.debug.message("cookieValue  : " + string2);
                AuthD.debug.message("cookieDomain : " + string3);
            }
            cookie = null;
            try {
                cookie = CookieUtils.newCookie((String)string, (String)string2, (String)"/", (String)string3);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block4;
                AuthD.debug.message("Error creating cookie. : " + exception.getMessage());
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("createCookie Cookie is set : " + cookie);
        }
        return cookie;
    }

    public Cookie clearPersistentCookie(String string, AuthContextLocal authContextLocal) {
        String string2 = LoginState.encodePCookie();
        int n = 0;
        Cookie cookie = LoginState.createPersistentCookie(ad.getPersistentCookieName(), string2, n, string);
        return cookie;
    }

    public void clearlbCookie(HttpServletResponse httpServletResponse) {
        String string = ad.getlbCookieName();
        if (string != null && string.length() != 0) {
            Set set = ad.getCookieDomains();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Cookie cookie = this.clearlbCookie(string2);
                    httpServletResponse.addCookie(cookie);
                }
            } else {
                httpServletResponse.addCookie(this.clearlbCookie((String)null));
            }
        }
    }

    public Cookie clearlbCookie(String string) {
        String string2 = ad.getlbCookieName();
        if (string2 != null && string2.length() != 0) {
            return AuthUtils.createPersistentCookie(string2, "LOGOUT", 0, string);
        }
        return null;
    }

    public AuthContext.IndexType getIndexType(AuthContextLocal authContextLocal) {
        try {
            AuthContext.IndexType indexType = null;
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            if (loginState != null) {
                indexType = loginState.getIndexType();
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("in getIndexType, index type : " + indexType);
            }
            return indexType;
        }
        catch (Exception exception) {
            AuthD.debug.message("ERROR in getIndexType : ", (Throwable)exception);
            return null;
        }
    }

    public Callback[] getRecdCallback(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        Callback[] callbackArray = null;
        if (loginState != null) {
            callbackArray = loginState.getRecdCallback();
        }
        if (callbackArray != null) {
            if (AuthD.debug.messageEnabled()) {
                int n = 0;
                while (n < callbackArray.length) {
                    AuthD.debug.message("in getRecdCallback, recdCallback[" + n + "] :" + callbackArray[n]);
                    ++n;
                }
            }
        } else {
            AuthD.debug.message("in getRecdCallback, recdCallback is null");
        }
        return callbackArray;
    }

    public String getErrorMessage(String string) {
        String string2 = ad.getErrorVal(string, ERROR_MESSAGE);
        return string2;
    }

    public String getErrorTemplate(String string) {
        String string2 = ad.getErrorVal(string, ERROR_TEMPLATE);
        return string2;
    }

    public String getDefaultFileName(HttpServletRequest httpServletRequest, String string) {
        String string2 = ad.getPlatformLocale();
        String string3 = ad.getFilePath(ad.getClientType(httpServletRequest));
        String string4 = File.separator + "default";
        String string5 = LoginState.getTemplateDir();
        File file = null;
        try {
            file = FileLookup.getFirstExisting((String)string4, (String)string2, null, (String)string3, (String)string, (String)string5, (boolean)true);
        }
        catch (FileLookupException fileLookupException) {
            AuthD.debug.message("Error retreiving file : ", (Throwable)fileLookupException);
        }
        String string6 = this.getRelativeFileName(file.getPath(), LoginState.getInstallDir());
        return string6;
    }

    String getRelativeFileName(String string, String string2) {
        String string3 = string.substring(string2.length(), string.length());
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthUtils: filename is.. : " + string);
            AuthD.debug.message("AuthUtils: returning relative filename :" + string3);
        }
        if (string3.indexOf("\\") != -1) {
            String string4 = string3.replace('\\', '/');
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("relativeFileName : " + string4);
            }
            return string4;
        }
        return string3;
    }

    public String getOrgDN(AuthContextLocal authContextLocal) {
        String string = null;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            string = loginState.getOrgDN();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("orgDN is : " + string);
        }
        return string;
    }

    public static AuthContextLocal getAuthContext(String string) throws AuthException {
        return AuthUtils.getAuthContext(string, "0", false);
    }

    public static AuthContextLocal getAuthContext(String string, String string2) throws AuthException {
        return AuthUtils.getAuthContext(string, string2, false);
    }

    public static AuthContextLocal getAuthContext(String string, String string2, boolean bl) throws AuthException {
        AuthContextLocal authContextLocal;
        block24: {
            authContextLocal = null;
            SessionID sessionID = null;
            LoginState loginState = null;
            boolean bl2 = false;
            if (ad == null) {
                ad = AuthD.getAuth();
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("orgName : " + string);
                AuthD.debug.message("sessionID is " + string2);
                AuthD.debug.message("sessionID is " + string2.length());
                AuthD.debug.message("isLogout : " + bl);
            }
            try {
                Object object;
                if (string2 != null && !string2.equals("0")) {
                    sessionID = new SessionID(string2);
                    authContextLocal = (AuthContextLocal)authContextHash.get(sessionID);
                    object = AuthUtils.getLoginState(authContextLocal);
                    InternalSession internalSession = null;
                    if (object != null) {
                        internalSession = ((LoginState)object).getSession();
                    }
                    if (internalSession == null) {
                        bl2 = false;
                    } else {
                        int n = internalSession.getState();
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("sid from sess is : " + internalSession.getID());
                            AuthD.debug.message("sess is : " + n);
                        }
                        bl2 = true;
                        if (n == 0 || bl) {
                            bl2 = false;
                        }
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("session upgrade is : " + bl2);
                        }
                    }
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("AuthUtil:getAuthContext:sid is.. .: " + sessionID);
                    AuthD.debug.message("AuthUtil:getAuthContext:authContext is.. .: " + authContextLocal);
                    AuthD.debug.message("AuthUtil:getAuthContext:sessionUpgrade is.. .: " + bl2);
                }
                if (string == null && authContextLocal == null) {
                    AuthD.debug.error("Cannot create authcontext with null org ");
                    throw new AuthException("102", null);
                }
                if (string != null && (authContextLocal == null || bl2)) {
                    try {
                        loginState = new LoginState();
                        if (bl2) {
                            loginState.setPrevAuthContext(authContextLocal);
                            loginState.setSessionUpgrade(bl2);
                        }
                        authContextLocal = loginState.createAuthContext(sessionID, string);
                        loginStateHash.put(authContextLocal, loginState);
                        object = AuthUtils.getQueryOrgName(null, string);
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("query org is .. : " + (String)object);
                        }
                        loginState.setQueryOrg((String)object);
                        break block24;
                    }
                    catch (AuthException authException) {
                        AuthD.debug.message("Error creating AuthContextLocal 2: ");
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("Exception ", (Throwable)((Object)authException));
                        }
                        throw new AuthException((Throwable)((Object)authException));
                    }
                }
                try {
                    object = ad.getSession(string2);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("AuthUtil :Session is .. : " + object);
                    }
                    loginState = AuthUtils.getLoginState(authContextLocal);
                    loginState.setSession((InternalSession)object);
                    loginState.setRequestType(false);
                }
                catch (Exception exception) {
                    AuthD.debug.message("Error Retrieving AuthContextLocal");
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("Exception ", (Throwable)exception);
                    }
                    throw new AuthException("102", null);
                }
            }
            catch (Exception exception) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Error creating AuthContextLocal 2: " + exception.getMessage());
                }
                throw new AuthException(exception);
            }
        }
        AuthD.debug.message("AuthUtils:getAuthContext returning AuthContextLocal.");
        return authContextLocal;
    }

    public static boolean retainSupportedModules(Collection collection, String string) {
        if (!AuthD.getAuth().isClientDetectionEnabled()) {
            return false;
        }
        Hashtable hashtable = AuthD.getAuth().getSupportedAuthenticators();
        if (hashtable == null || hashtable.isEmpty()) {
            AuthD.debug.message("No supported modules found");
            return false;
        }
        Set set = (Set)hashtable.get(string);
        if (set != null && !set.isEmpty()) {
            return collection.retainAll(set);
        }
        return false;
    }

    public static AppConfigurationEntry[] retainSupportedModules(AppConfigurationEntry[] appConfigurationEntryArray, String string) {
        if (!AuthD.getAuth().isClientDetectionEnabled()) {
            return appConfigurationEntryArray;
        }
        Hashtable hashtable = AuthD.getAuth().getSupportedAuthenticators();
        if (hashtable == null || hashtable.isEmpty()) {
            AuthD.debug.message("No supported modules found");
            return appConfigurationEntryArray;
        }
        Set set = (Set)hashtable.get(string);
        if (set != null && !set.isEmpty()) {
            AppConfigurationEntry[] appConfigurationEntryArray2;
            int n = appConfigurationEntryArray.length;
            ArrayList<AppConfigurationEntry> arrayList = new ArrayList<AppConfigurationEntry>();
            int n2 = 0;
            while (n2 < n) {
                appConfigurationEntryArray2 = appConfigurationEntryArray[n2].getLoginModuleName();
                String string2 = AuthUtils.getModuleName((String)appConfigurationEntryArray2);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("retainModules, process " + string2);
                }
                if (set.contains(string2)) {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("retainModules, retain " + string2);
                    }
                    arrayList.add(appConfigurationEntryArray[n2]);
                }
                ++n2;
            }
            n = arrayList.size();
            appConfigurationEntryArray2 = new AppConfigurationEntry[n];
            int n3 = 0;
            while (n3 < n) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("retainModules, " + n3 + "=" + arrayList.get(n3));
                }
                appConfigurationEntryArray2[n3] = (AppConfigurationEntry)arrayList.get(n3);
                ++n3;
            }
            return appConfigurationEntryArray2;
        }
        return appConfigurationEntryArray;
    }

    public static String getModuleName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static Set getAuthModules(int n, String string, String string2) {
        return AMAuthLevelManager.getInstance().getModulesForLevel(n, string, string2);
    }

    public AuthContextLocal getPrevAuthContext(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        AuthContextLocal authContextLocal2 = loginState.getPrevAuthContext();
        return authContextLocal2;
    }

    public LoginState getPrevLoginState(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal);
    }

    public AuthContextLocal getOrigAuthContext(HttpServletRequest httpServletRequest) throws AuthException {
        AuthContextLocal authContextLocal = null;
        if (ad == null) {
            ad = AuthD.getAuth();
        }
        try {
            SessionID sessionID = new SessionID(httpServletRequest);
            authContextLocal = (AuthContextLocal)authContextHash.get(sessionID);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("AuthUtil:getAuthContext:sid is.. .: " + sessionID);
                AuthD.debug.message("AuthUtil:getAuthContext:authContext is.. .:" + authContextLocal);
            }
            InternalSession internalSession = AuthUtils.getLoginState(authContextLocal).getSession();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Session is : " + internalSession);
                AuthD.debug.message("Returning AuthContext : " + authContextLocal);
            }
            if (internalSession == null) {
                return null;
            }
            int n = internalSession.getState();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("sessionState : " + n);
            }
            if (n == 0) {
                return null;
            }
            return authContextLocal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSessionActive(AuthContextLocal authContextLocal) {
        try {
            InternalSession internalSession = this.getSession(authContextLocal);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Sess is : " + internalSession);
            }
            boolean bl = false;
            if (internalSession != null) {
                if (internalSession.getState() == 1) {
                    bl = true;
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Sess State is : " + internalSession.getState());
                    AuthD.debug.message("Is Session Active : " + bl);
                }
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getSessionProperty(String string, AuthContextLocal authContextLocal) {
        String string2 = null;
        try {
            InternalSession internalSession = this.getSession(authContextLocal);
            if (internalSession != null) {
                string2 = internalSession.getProperty(string);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Error : ", (Throwable)exception);
        }
        return string2;
    }

    public boolean isSessionUpgrade(AuthContextLocal authContextLocal) {
        boolean bl = false;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            bl = loginState.isSessionUpgrade();
        }
        return bl;
    }

    public void setCookieSupported(AuthContextLocal authContextLocal, boolean bl) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("set cookieSupported to : " + bl);
            AuthD.debug.message("set cookieDetect to false");
        }
        loginState.setCookieSupported(bl);
    }

    public boolean isCookieSupported(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return false;
        }
        return loginState.isCookieSupported();
    }

    public boolean isCookieSet(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return false;
        }
        return loginState.isCookieSet();
    }

    public boolean checkForCookies(HttpServletRequest httpServletRequest, AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            AuthD.debug.message("set cookieSet to false.");
            loginState.setCookieSet(false);
            loginState.setCookieDetect(false);
        }
        return CookieUtils.getCookieValueFromReq((HttpServletRequest)httpServletRequest, (String)ad.getCookieName()) != null;
    }

    public String getLoginURL(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return null;
        }
        return loginState.getLoginURL();
    }

    public static AuthContextLocal getAuthContextFromHash(SessionID sessionID) {
        AuthContextLocal authContextLocal = null;
        if (sessionID != null) {
            authContextLocal = (AuthContextLocal)authContextHash.get(sessionID);
        }
        return authContextLocal;
    }

    public static void removeLoginStateFromSidHash(String string) {
        if (string != null) {
            AMLoginContext.loginHash.remove(string);
        }
    }

    public Map getQueryParamsMap(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return null;
        }
        return loginState.getQueryParamsMap();
    }

    public String getOrigLoginURL(HttpServletRequest httpServletRequest) {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOTokenManager.isValidToken(sSOToken)) {
                String string = sSOToken.getProperty("loginURL");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Original LoginURL: " + string);
                }
                if (httpServletRequest.getQueryString() != null) {
                    string = string + "?" + httpServletRequest.getQueryString();
                }
                return string;
            }
        }
        catch (SSOException sSOException) {
            return null;
        }
        return null;
    }

    public Callback[] getCallbacksPerState(AuthContextLocal authContextLocal, String string) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        Callback[] callbackArray = null;
        if (loginState != null) {
            callbackArray = loginState.getCallbacksPerState(string);
        }
        if (callbackArray != null) {
            if (AuthD.debug.messageEnabled()) {
                int n = 0;
                while (n < callbackArray.length) {
                    AuthD.debug.message("in getCallbacksPerState, recdCallback[" + n + "] :" + callbackArray[n]);
                    ++n;
                }
            }
        } else {
            AuthD.debug.message("in getCallbacksPerState, recdCallback is null");
        }
        return callbackArray;
    }

    public void setCallbacksPerState(AuthContextLocal authContextLocal, String string, Callback[] callbackArray) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            loginState.setCallbacksPerState(string, callbackArray);
        }
        if (callbackArray != null) {
            if (AuthD.debug.messageEnabled()) {
                int n = 0;
                while (n < callbackArray.length) {
                    AuthD.debug.message("in setCallbacksPerState, callbacks[" + n + "] :" + callbackArray[n]);
                    ++n;
                }
            }
        } else {
            AuthD.debug.message("in setCallbacksPerState, callbacks is null");
        }
    }

    public static String addLogoutCookieToURL(String string, String string2, boolean bl) {
        String string3 = null;
        if (string2 == null || bl) {
            string3 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(URLEncoder.encode(ad.getCookieName())).append("=").append(URLEncoder.encode(string2));
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string.indexOf("?") != -1) {
                stringBuffer.insert(0, "&amp;");
            } else {
                stringBuffer.insert(0, "?");
            }
            stringBuffer.insert(0, string);
            string3 = stringBuffer.toString();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("cookieString is : " + stringBuffer);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("logoutURL is : " + string3);
        }
        return string3;
    }

    public SessionID getSidValue(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest) {
        SessionID sessionID = null;
        if (authContextLocal != null) {
            AuthD.debug.message("AuthContext is not null");
            try {
                String string = AuthUtils.getSidString(authContextLocal);
                if (string != null) {
                    sessionID = new SessionID(string);
                }
            }
            catch (Exception exception) {
                AuthD.debug.message("Exception getting sid", (Throwable)exception);
            }
        }
        if (sessionID == null) {
            AuthD.debug.message("Sid is null");
            sessionID = new SessionID(httpServletRequest);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("sid is : " + sessionID);
        }
        return sessionID;
    }

    public boolean isCookieSupported(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest) {
        boolean bl;
        if (authContextLocal != null) {
            AuthD.debug.message("AuthContext is not null");
            bl = this.isCookieSupported(authContextLocal);
        } else {
            bl = this.checkForCookies(httpServletRequest, null);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Cookie supported" + bl);
        }
        return bl;
    }

    static {
        String string = AuthD.getWebContainerName();
        if (string != null && string.length() > 0 && string.indexOf("BEA") >= 0) {
            setRequestEncoding = true;
        }
    }
}

