/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMEventListener;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.cdm.AuthClient;
import com.iplanet.services.cdm.Client;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.service.AuthSessionListener;
import com.sun.identity.authentication.service.AuthenticatorManager;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.log.Logger;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import netscape.ldap.util.DN;

public class AuthD
implements AMEventListener {
    public static Debug debug;
    public ResourceBundle bundle = null;
    private static Map bundles;
    private static AuthD authInstance;
    private static boolean authInitFailed;
    private AuthenticatorManager authManager;
    private String defaultOrg;
    private String cookieName;
    private String persistentCookieName;
    private String loginURL;
    private String platformLocale;
    private String platformCharset;
    private Set platformClientCharsets;
    private String loadBalanceCookieName;
    private String loadBalanceCookieValue;
    private SessionService sessionService = null;
    private SSOToken ssoAuthSession = null;
    private Session authSession = null;
    private AMStoreConnection dpStore = null;
    private Map orgMap = new HashMap();
    private String superAdmin = SystemProperties.get((String)"com.sun.identity.authentication.super.user", (String)"");
    private Map orgStatusMap = new HashMap();
    private Map peopleContainerMap = Collections.synchronizedMap(new HashMap());
    private static final String DEFAULT_CLIENT_TYPE = "genericHTML";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_FILE_PATH = "html";
    private static final boolean DEFAULT_COOKIE_SUPPORT = false;
    private static final String DSAME_VERSION = "5.2";
    public static final int LOG_ACCESS = 0;
    public static final int LOG_ERROR = 1;
    boolean clientDetectionEnabled = false;
    String clientDetectionClass = null;
    String defaultClientType = "html";
    public AMClientDetector clientDetector = null;
    public static Hashtable sAuth;
    private static FQDNUtils fqdnUtils;
    public static String platLocale;
    private static String webContainer;
    private String defaultAuthLocale;
    ServiceSchema platformSchema;
    ServiceSchema sessionSchema;
    private static Map templatesMap;
    private static boolean logStatus;
    public Set defaultSuccessURLSet = new HashSet();
    public String defaultSuccessURL = null;
    public Set defaultFailureURLSet = new HashSet();
    public String defaultFailureURL = null;
    public static final String MSG_DELIMITER = "|";
    public static final String BUNDLE_NAME = "amAuth";
    Logger logger = null;
    private static String dsameVersion;
    String rootSuffix = null;
    static /* synthetic */ Class class$com$sun$identity$authentication$service$AuthD;

    private AuthD() {
        debug.message("AuthD initializing");
        try {
            this.cookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            this.loadBalanceCookieName = SystemProperties.get((String)"com.iplanet.am.lbcookie.name");
            this.loadBalanceCookieValue = SystemProperties.get((String)"com.iplanet.am.lbcookie.value");
            this.persistentCookieName = SystemProperties.get((String)"com.iplanet.am.pcookie.name");
            this.rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
            this.defaultOrg = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            dsameVersion = SystemProperties.get((String)"com.iplanet.am.version");
            if (!this.defaultOrg.equals(this.rootSuffix)) {
                this.defaultOrg = this.defaultOrg + "," + this.rootSuffix;
            }
            this.initAuthSessions();
            this.dpStore = new AMStoreConnection(this.ssoAuthSession);
            this.authSession.addSessionListenerOnAllSessions((SessionListener)new AuthSessionListener());
            this.initAuthServiceGlobalSettings();
            this.initPlatformServiceGlobalSettings();
            this.initSessionServiceDynamicSettings();
            this.initDefaultClientType();
            this.bundle = com.iplanet.am.util.Locale.getInstallResourceBundle((String)BUNDLE_NAME);
            ResourceBundle resourceBundle = com.iplanet.am.util.Locale.getInstallResourceBundle((String)"amPlatform");
            this.platformCharset = resourceBundle.getString("iplanet-am-platform-html-char-set");
            this.updateOrgMap();
            this.printProfileAttrs();
            authInitFailed = false;
        }
        catch (Exception exception) {
            debug.error("AuthD init()", (Throwable)exception);
            authInitFailed = true;
        }
    }

    private void initAuthServiceGlobalSettings() throws SMSException, SSOException, Exception {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthService", this.ssoAuthSession);
        ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationSchema();
        Map map = serviceSchema.getAttributeDefaults();
        serviceSchema = serviceSchemaManager.getGlobalSchema();
        map.putAll(serviceSchema.getAttributeDefaults());
        if (debug.messageEnabled()) {
            debug.message("attrs : " + map);
        }
        this.defaultAuthLocale = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-locale");
        this.authManager = new AuthenticatorManager(map, serviceSchemaManager);
        sAuth = new Hashtable();
        this.clientDetectionEnabled = this.authManager.isDetectionEnabled();
        this.clientDetector = this.authManager.getClientDetectionInterface();
        this.defaultSuccessURLSet = this.authManager.getDefaultSuccessURLSet();
        this.defaultFailureURLSet = this.authManager.getDefaultFailureURLSet();
    }

    private void initDefaultClientType() {
        try {
            Client client = AuthClient.getDefaultInstance(null);
            if (client == null) {
                debug.warning("Failed to get the defaut Auth Client instance");
                this.defaultClientType = DEFAULT_CLIENT_TYPE;
                return;
            }
            this.defaultClientType = client.getClientType();
            if (debug.messageEnabled()) {
                debug.message("AuthD.getDefaultClientType, ClientType=" + this.defaultClientType);
            }
        }
        catch (Exception exception) {
            debug.error("getDefaultClientType", (Throwable)exception);
            this.defaultClientType = DEFAULT_CLIENT_TYPE;
        }
    }

    private void initPlatformServiceGlobalSettings() throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", this.ssoAuthSession);
        this.platformSchema = serviceSchemaManager.getGlobalSchema();
        Map map = this.platformSchema.getAttributeDefaults();
        this.platformLocale = Misc.getMapAttr((Map)map, (String)"iplanet-am-platform-locale");
        this.loginURL = Misc.getMapAttr((Map)map, (String)"iplanet-am-platform-login-url");
        if (this.clientDetectionEnabled) {
            this.platformClientCharsets = (Set)map.get("iplanet-am-platform-client-charsets");
        }
    }

    private void initSessionServiceDynamicSettings() throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMSessionService", this.ssoAuthSession);
        this.sessionSchema = serviceSchemaManager.getDynamicSchema();
        Map map = this.sessionSchema.getAttributeDefaults();
        String string = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-session-time", (String)"120");
        String string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-idle-time", (String)"30");
        String string3 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-caching-time", (String)"3");
        if (debug.messageEnabled()) {
            debug.message("AuthD.defaultMaxSessionTime=" + string + "\nAuthD.defaultMaxIdleTime=" + string2 + "\nAuthD.defaultMaxCachingTime=" + string3);
        }
    }

    String getDefaultMaxSessionTime() {
        return Misc.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-session-time", (String)"120");
    }

    String getDefaultMaxIdleTime() {
        return Misc.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-idle-time", (String)"30");
    }

    String getDefaultMaxCachingTime() {
        return Misc.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-caching-time", (String)"3");
    }

    public static AuthD getAuth() {
        if (authInstance == null) {
            Class clazz = class$com$sun$identity$authentication$service$AuthD == null ? (class$com$sun$identity$authentication$service$AuthD = AuthD.class$("com.sun.identity.authentication.service.AuthD")) : class$com$sun$identity$authentication$service$AuthD;
            synchronized (clazz) {
                if (authInstance == null) {
                    authInstance = new AuthD();
                    if (authInitFailed) {
                        authInstance = null;
                    }
                }
            }
        }
        return authInstance;
    }

    public void destroySession(SessionID sessionID) {
        AuthD.getSS().destroyInternalSession(sessionID);
    }

    public void logoutSession(SessionID sessionID) {
        AuthD.getSS().logoutInternalSession(sessionID);
    }

    public InternalSession newSession(String string, HttpSession httpSession) {
        InternalSession internalSession = null;
        try {
            internalSession = AuthD.getSS().newInternalSession(string, httpSession);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            debug.error("Error creating session: ", (Throwable)exception);
        }
        return internalSession;
    }

    public InternalSession getSession(String string) {
        if (debug.messageEnabled()) {
            debug.message("getSession for " + string);
        }
        SessionID sessionID = new SessionID(string);
        InternalSession internalSession = AuthD.getSS().getInternalSession(sessionID);
        if (internalSession == null) {
            debug.message("getSession returned null");
        }
        return internalSession;
    }

    public InternalSession getSession(HttpServletRequest httpServletRequest) {
        SessionID sessionID = new SessionID(httpServletRequest);
        return AuthD.getSS().getInternalSession(sessionID);
    }

    public String getAuthenticatorForName(String string) {
        return this.authManager.getAuthenticatorClassName(string);
    }

    public boolean containsAuthenticator(String string) {
        return this.authManager.containsAuthenticator(string);
    }

    public Iterator getAuthenticators() {
        return this.authManager.getAuthenticators();
    }

    public int getAuthenticatorCount() {
        return this.authManager.getAuthenticatorCount();
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public String getPlatformCharset() {
        return this.platformCharset;
    }

    public String getPlatformLocale() {
        return this.platformLocale;
    }

    public String getCoreAuthLocaleFromAuthService() {
        return this.defaultAuthLocale;
    }

    public String getDefaultAuthLocale() {
        if (this.defaultAuthLocale == null || this.defaultAuthLocale.length() == 0) {
            return "en_US";
        }
        return this.defaultAuthLocale;
    }

    public void logIt(String string, int n, Hashtable hashtable) {
        if (string == null) {
            return;
        }
        try {
            if (logStatus) {
                com.sun.identity.log.LogRecord logRecord = null;
                logRecord = hashtable == null ? new com.sun.identity.log.LogRecord(Level.INFO, string, (Object)this.ssoAuthSession) : new com.sun.identity.log.LogRecord(Level.INFO, string, hashtable);
                switch (n) {
                    case 0: {
                        this.logger = (Logger)Logger.getLogger((String)"amAuthentication.access");
                        this.logger.log((LogRecord)logRecord, (Object)this.ssoAuthSession);
                        break;
                    }
                    case 1: {
                        this.logger = (Logger)Logger.getLogger((String)"amAuthentication.error");
                        this.logger.log((LogRecord)logRecord, (Object)this.ssoAuthSession);
                        break;
                    }
                    default: {
                        this.logger = (Logger)Logger.getLogger((String)"amAuthentication.access");
                        this.logger.log((LogRecord)logRecord, (Object)this.ssoAuthSession);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            debug.error("Logging exception:", (Throwable)exception);
        }
    }

    public Set getCookieDomains() {
        Set set = (Set)this.platformSchema.getAttributeDefaults().get("iplanet-am-platform-cookie-domains");
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getPersistentCookieName() {
        return this.persistentCookieName;
    }

    public String getlbCookieName() {
        return this.loadBalanceCookieName;
    }

    public String getlbCookieValue() {
        return this.loadBalanceCookieValue;
    }

    public AMStoreConnection getSDK() {
        return this.dpStore;
    }

    void printProfileAttrs() {
        String string;
        if (!debug.messageEnabled()) {
            return;
        }
        debug.message("Authd Profile Attributes");
        debug.message("cookieDomains");
        Iterator iterator = this.getCookieDomains().iterator();
        while (iterator.hasNext()) {
            debug.message("  " + (String)iterator.next());
        }
        debug.message("cookieName->" + this.cookieName);
        String string2 = string = this.authManager.getAdminAuthModule();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        if (debug.messageEnabled()) {
            debug.message("adminAuthModule->" + string + "\nadminAuthName->" + string2 + "\nclientDetectionEnabled->" + this.clientDetectionEnabled + "\ndefaultOrg->" + this.defaultOrg + "\nlocale->" + this.platformLocale + "\ncharset>" + this.platformCharset);
        }
    }

    static SessionService getSS() {
        SessionService sessionService = SessionService.getSessionService();
        if (sessionService == null) {
            debug.error("AuthD failed to get session service instance");
        }
        return sessionService;
    }

    public String getDefaultOrg() {
        return this.defaultOrg;
    }

    public Session getAuthSession() {
        return this.authSession;
    }

    public SSOToken getSSOAuthSession() {
        return this.ssoAuthSession;
    }

    private void initAuthSessions() throws SSOException, SessionException {
        if (this.authSession == null) {
            this.authSession = AuthD.getSS().getAuthenticationSession(this.defaultOrg, null);
            if (this.authSession == null) {
                debug.error("AuthD failed to get auth session");
                throw new SessionException(BUNDLE_NAME, "gettingSessionFailed", null);
            }
            this.authSession.setProperty("Principal", this.authSession.getClientID());
            this.authSession.setProperty("Organization", this.defaultOrg);
            this.authSession.setProperty("Host", this.authSession.getID().getSessionServer());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            this.ssoAuthSession = sSOTokenManager.createSSOToken(this.authSession.getID().toString());
        }
    }

    public AMPeopleContainer getPeopleContainer(String string) {
        AMPeopleContainer aMPeopleContainer;
        block5: {
            aMPeopleContainer = null;
            try {
                aMPeopleContainer = (AMPeopleContainer)this.peopleContainerMap.get(string);
                if (aMPeopleContainer != null) break block5;
                aMPeopleContainer = this.dpStore.getPeopleContainer(string);
                Map map = this.peopleContainerMap;
                synchronized (map) {
                    this.peopleContainerMap.put(string, aMPeopleContainer);
                }
            }
            catch (SSOException sSOException) {
                debug.error("SSO ", (Throwable)sSOException);
            }
        }
        return aMPeopleContainer;
    }

    private Set getOrgsAndSubOrgs() {
        AMOrganization aMOrganization = null;
        String string = null;
        Object object = new OrderedSet();
        try {
            string = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
            aMOrganization = this.dpStore.getOrganization(string);
        }
        catch (Exception exception) {
            debug.error("getOrgsAndSubOrgs:getOrganization exception: " + exception);
            return object;
        }
        if (debug.messageEnabled()) {
            debug.message("getOrgsAndSubOrgs:adding org " + string);
        }
        try {
            String string2 = "*";
            HashMap hashMap = new HashMap();
            int n = 2;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("iPlanetAMAuthService");
            hashMap.put("iplanet-am-service-status", hashSet);
            object = aMOrganization.searchSubOrganizations(string2, hashMap, n);
            if (debug.messageEnabled()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    debug.message("getOrgsAndSubOrgs:new search: org = " + string3);
                }
            }
        }
        catch (Exception exception) {
            debug.error("getOrgsAndSubOrgs():new exception: " + exception);
        }
        return object;
    }

    private synchronized void updateOrgMap() {
        if (this.orgMap != null) {
            this.orgMap.clear();
        }
        try {
            Set set = this.getOrgsAndSubOrgs();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.updateSingleOrgMap(string, true);
            }
        }
        catch (Exception exception) {
            debug.error("Error updating orgMap ", (Throwable)exception);
        }
    }

    private void updateSingleOrgMap(String string, boolean bl) {
        Map map = this.orgMap;
        synchronized (map) {
            Map map2 = this.orgStatusMap;
            synchronized (map2) {
                try {
                    AMOrganization aMOrganization;
                    Set set;
                    if (debug.messageEnabled()) {
                        debug.message("Updating Single Org Map : " + string);
                    }
                    if ((set = (aMOrganization = this.dpStore.getOrganization(string)).getAttribute("inetdomainstatus")) != null && !set.isEmpty()) {
                        String string2 = (String)set.iterator().next();
                        if (string2.equalsIgnoreCase("active")) {
                            this.orgStatusMap.put(string, new Boolean("true"));
                        } else {
                            this.orgStatusMap.put(string, new Boolean("false"));
                        }
                        if (debug.messageEnabled()) {
                            debug.message(string + " inetdomainstatus=" + string2);
                        }
                    } else {
                        this.orgStatusMap.put(string, new Boolean("true"));
                    }
                    if (debug.messageEnabled()) {
                        debug.message("updateSingleOrgMap:: orgDN : " + string + "\n org : " + aMOrganization);
                    }
                    this.orgMap.put(string, aMOrganization);
                    if (bl) {
                        aMOrganization.addEventListener(this);
                    }
                }
                catch (Exception exception) {
                    debug.error("updateSingleOrgMap " + string, (Throwable)exception);
                }
            }
        }
    }

    boolean getInetDomainStatus(String string) {
        Boolean bl = (Boolean)this.orgStatusMap.get(string);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public AMOrganization getOrgProfile(String string) {
        block4: {
            AMOrganization aMOrganization = (AMOrganization)this.orgMap.get(string);
            if (aMOrganization != null) {
                return aMOrganization;
            }
            try {
                aMOrganization = this.dpStore.getOrganization(string);
                if (aMOrganization.isExists()) {
                    this.updateSingleOrgMap(string, true);
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block4;
                debug.message("AuthD.getOrgProfile, check " + string, (Throwable)exception);
            }
        }
        return (AMOrganization)this.orgMap.get(string);
    }

    String stripPort(String string) {
        try {
            URL uRL = new URL(string);
            return uRL.getProtocol() + "://" + uRL.getHost() + uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public boolean isClientDetectionEnabled() {
        return this.authManager.isDetectionEnabled();
    }

    public String getClientType(HttpServletRequest httpServletRequest) {
        if (this.isClientDetectionEnabled() && this.clientDetector != null) {
            if (debug.messageEnabled()) {
                debug.message("ClientDetection enabled clientdet = " + this.clientDetector);
                debug.message("clienttype = " + this.clientDetector.getClientType(httpServletRequest));
            }
            return this.clientDetector.getClientType(httpServletRequest);
        }
        return this.defaultClientType;
    }

    public Client getClientInstance(String string) {
        if (string.equals(this.defaultClientType)) {
            return AuthClient.getDefaultInstance(null);
        }
        try {
            return AuthClient.getInstance(string, null);
        }
        catch (Exception exception) {
            debug.warning("getClientInstance()", (Throwable)exception);
            return Client.getDefaultInstance();
        }
    }

    public String getFilePath(String string) {
        String string2 = this.getProperty(string, "filePath");
        if (string2 == null) {
            return DEFAULT_FILE_PATH;
        }
        return string2;
    }

    public String getContentType(String string) {
        String string2 = this.getProperty(string, "contentType");
        if (string2 == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        return string2;
    }

    public String getCookieSupport(String string) {
        String string2 = this.getProperty(string, "cookieSupport");
        return string2;
    }

    public boolean isGenericHTMLClient(String string) {
        String string2 = this.getProperty(string, DEFAULT_CLIENT_TYPE);
        if (string2 == null) {
            return false;
        }
        return string2.equals("true");
    }

    public String getIgnoreHostHeader(String string) {
        String string2 = this.getProperty(string, "ignoreHostHeader");
        if (string2 == null) {
            return "false";
        }
        return string2;
    }

    public Vector getCharSets(String string) {
        Vector<String> vector;
        block8: {
            String string2;
            block7: {
                vector = new Vector<String>();
                string2 = null;
                try {
                    string2 = this.getProperty(string, "charsets");
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block7;
                    debug.message("getCharSets: Exception :", (Throwable)exception);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("getCharSets::clientType : " + string);
                debug.message("getCharSets::charsets  : " + string2);
            }
            if (string2 == null || string2.equals("")) {
                return vector;
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                vector.clear();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    vector.add(string3);
                    debug.message(" Charset ->" + string3);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block8;
                debug.warning("getCharSets : ", (Throwable)exception);
            }
        }
        return vector;
    }

    private String getProperty(String string, String string2) {
        try {
            return this.getClientInstance(string).getProperty(string2);
        }
        catch (Exception exception) {
            debug.warning("Error retrieving Client Data : " + string2, (Throwable)exception);
            return this.getDefaultProperty(string2);
        }
    }

    public String getDefaultProperty(String string) {
        try {
            return Client.getDefaultInstance().getProperty(string);
        }
        catch (Exception exception) {
            debug.warning("Could not get " + string, (Throwable)exception);
            return null;
        }
    }

    public Hashtable getSupportedAuthenticators() {
        return this.authManager.getSupportedAuthenticators();
    }

    public String getClientPlatformCharset(Vector vector, String string) {
        String string2;
        block11: {
            block10: {
                String string3;
                if (debug.messageEnabled()) {
                    debug.message("platform charset : " + this.platformCharset);
                }
                if ((string3 = this.getClientCharsets(string)) != null && string3.length() > 0) {
                    return string3;
                }
                string2 = null;
                try {
                    if (vector.contains(this.platformCharset)) {
                        string2 = this.platformCharset;
                    }
                }
                catch (Exception exception) {
                    if (!debug.warningEnabled()) break block10;
                    debug.warning("Exception: getClientPlatformCharset :", (Throwable)exception);
                }
            }
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            try {
                string2 = (String)vector.firstElement();
                if (debug.messageEnabled()) {
                    debug.message("Platform CharSet is.. :" + string2);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block11;
                debug.warning("Exception:getPlatformCharsets :", (Throwable)exception);
            }
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return this.platformCharset;
    }

    public String getDefaultClientType() {
        return this.defaultClientType;
    }

    String getClientCharsets(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                Iterator iterator = this.platformClientCharsets.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    int n;
                    String string4 = (String)iterator.next();
                    if (string4 == null || string4.length() <= 0 || (n = string4.indexOf(MSG_DELIMITER)) == -1 || !(string3 = string4.substring(0, n)).equals(string)) continue;
                    string2 = string4.substring(n + 1);
                    if (debug.messageEnabled()) {
                        debug.message("clientCharset:" + string2);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("Exception:getClientCharsets : ", (Throwable)exception);
            }
        }
        return string2;
    }

    public String getDefaultClient() {
        return DEFAULT_CLIENT_TYPE;
    }

    public void objectChanged(AMEvent aMEvent) {
        String string = aMEvent.getSourceDN();
        if (debug.messageEnabled()) {
            debug.message("AuthD.objectChanged, DN=" + string);
        }
        this.updateSingleOrgMap(string, false);
    }

    public void objectRemoved(AMEvent aMEvent) {
        String string = aMEvent.getSourceDN();
        if (debug.messageEnabled()) {
            debug.message("AuthD.objectRemoved, DN=" + string);
        }
        this.orgMap.remove(string);
    }

    public void objectRenamed(AMEvent aMEvent) {
        String string = aMEvent.getSourceDN();
        if (debug.messageEnabled()) {
            debug.message("AuthD.objectRenamed, DN=" + string);
        }
        this.orgMap.remove(string);
    }

    public boolean isSuperAdmin(String string) {
        boolean bl = false;
        if (string != null && DN.isDN(string) && this.superAdmin != null) {
            String string2 = new DN(string).toRFCString().toLowerCase();
            String string3 = new DN(this.superAdmin).toRFCString().toLowerCase();
            bl = string2.equals(string3);
            if (debug.messageEnabled()) {
                debug.message("passed dn is :" + string);
                debug.message("normalied dn is :" + string2);
                debug.message("normalized super dn is :" + string3);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("is Super Admin :" + bl);
        }
        return bl;
    }

    public AMTemplate getOrganizationTemplate(String string, String string2) throws SSOException, AMException {
        String string3 = string + ":" + string2;
        AMTemplate aMTemplate = (AMTemplate)templatesMap.get(string3);
        if (aMTemplate != null) {
            return aMTemplate;
        }
        Map map = templatesMap;
        synchronized (map) {
            aMTemplate = (AMTemplate)templatesMap.get(string3);
            if (aMTemplate == null) {
                AMOrganization aMOrganization = this.getOrgProfile(string);
                aMTemplate = aMOrganization.getTemplate(string2, 302);
                templatesMap.put(string3, aMTemplate);
            }
        }
        return aMTemplate;
    }

    public String getErrorVal(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = this.bundle.getString(string);
        if (debug.messageEnabled()) {
            debug.message("errorCod is.. : " + string);
            debug.message("resProperty is.. : " + string5);
        }
        if (string5 != null && !string5.equals("")) {
            int n = string5.indexOf(MSG_DELIMITER);
            if (n != -1) {
                string4 = string5.substring(n + 1, string5.length());
                string3 = string5.substring(0, n);
            } else {
                string3 = string5;
            }
        }
        if (string2.equals("Error_Message")) {
            return string3;
        }
        if (string2.equals("Error_Template")) {
            return string4;
        }
        return null;
    }

    public static String getDSAMEVersion() {
        return dsameVersion;
    }

    public String getDefaultCharset(HttpServletRequest httpServletRequest) {
        Vector vector = null;
        String string = null;
        String string2 = this.getClientType(httpServletRequest);
        if (!string2.equals(this.getDefaultClient())) {
            vector = this.getCharSets(string2);
        }
        String string3 = this.getPlatformLocale();
        String string4 = httpServletRequest.getHeader("Accept-Language");
        Locale locale = Locale.ENGLISH;
        if (string4 != null && string4.length() > 0) {
            locale = com.iplanet.am.util.Locale.getLocaleObjFromAcceptLangHeader((String)string4);
        }
        string = this.getCharSet(string2, locale);
        return string;
    }

    public ResourceBundle getResourceBundle(String string) {
        if (string == null) {
            return this.bundle;
        }
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = com.iplanet.am.util.Locale.getResourceBundle((String)BUNDLE_NAME, (String)string);
            if (resourceBundle == null) {
                resourceBundle = this.bundle;
            }
            bundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    public String getCharSet(String string, Locale locale) {
        String string2 = this.getClientInstance(string).getCharset(locale);
        if (debug.messageEnabled()) {
            debug.message("Charset from Client is : " + string2);
        }
        return string2;
    }

    public long getDefaultSleepTime() {
        return this.authManager.getDefaultSleepTime();
    }

    public static boolean isValidFQDNRequest(String string) {
        boolean bl;
        if (debug.messageEnabled()) {
            debug.message("hostName is : " + string);
        }
        if (bl = fqdnUtils.isHostnameValid(string)) {
            debug.message("hostname  and fqdnDefault match returning true");
        } else {
            debug.message("hostname and fqdnDefault don't match");
        }
        if (debug.messageEnabled()) {
            debug.message("retVal is : " + bl);
        }
        return bl;
    }

    public static String getValidFQDNResource(String string, HttpServletRequest httpServletRequest) {
        String string2;
        if (debug.messageEnabled()) {
            debug.message("Get mapping for " + string);
        }
        if ((string2 = fqdnUtils.getFullyQualifiedHostName(string)) == null) {
            string2 = string;
        }
        if (debug.messageEnabled()) {
            debug.message("fully qualified hostname :" + string2);
        }
        String string3 = AuthD.constructURL(string2, httpServletRequest);
        if (debug.messageEnabled()) {
            debug.message("Request URL :" + string3);
        }
        return string3;
    }

    public static String getHostName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("host");
        if (string != null) {
            int n = string.indexOf(":");
            if (n != -1) {
                string = string.substring(0, n);
            }
        } else {
            string = httpServletRequest.getServerName();
        }
        if (debug.messageEnabled()) {
            debug.message("Returning host name : " + string);
        }
        return string;
    }

    static String constructURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = RequestUtils.getRedirectProtocol((String)httpServletRequest.getScheme(), (String)string);
        int n = httpServletRequest.getServerPort();
        String string3 = httpServletRequest.getRequestURI();
        String string4 = httpServletRequest.getQueryString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2).append("://").append(string).append(":").append(n).append(string3);
        if (string4 != null) {
            stringBuffer.append("?").append(string4);
        }
        String string5 = stringBuffer.toString();
        if (debug.messageEnabled()) {
            debug.message("returning new url : " + string5);
        }
        return string5;
    }

    public boolean getCookieDetect(String string) {
        boolean bl;
        boolean bl2 = bl = this.clientDetectionEnabled && (string == null || string.equalsIgnoreCase("cookieDetect"));
        if (debug.messageEnabled()) {
            debug.message("CookieDetect : " + bl);
        }
        return bl;
    }

    public boolean isUrlRewrite(String string) {
        boolean bl = this.setCookieVal(string, "false");
        if (debug.messageEnabled()) {
            debug.message("rewriteURL : " + bl);
        }
        return bl;
    }

    public boolean isSetCookie(String string) {
        boolean bl = this.setCookieVal(string, "true");
        if (debug.messageEnabled()) {
            debug.message("setCookie : " + bl);
        }
        return bl;
    }

    public boolean setCookieVal(String string, String string2) {
        boolean bl;
        String string3 = this.getCookieSupport(string);
        boolean bl2 = this.getCookieDetect(string3);
        boolean bl3 = string3 != null && (string3.equals(string2) || string3.equals("cookieDetect"));
        boolean bl4 = bl = bl3 || bl2;
        if (debug.messageEnabled()) {
            debug.message("cookieSupport : " + string3);
            debug.message("cookieDetect : " + bl2);
            debug.message(" setCookie is : " + bl);
        }
        return bl;
    }

    public String getOrgDN(String string) {
        DN dN = new DN(string);
        DN dN2 = new DN(this.rootSuffix);
        String string2 = null;
        if (debug.messageEnabled()) {
            debug.message("userOrg is : " + string);
            debug.message("rootSuffix is : " + this.rootSuffix);
            debug.message("rootSuffixDN is : " + dN2);
            debug.message("userOrgDN is : " + dN);
        }
        string2 = dN.equals(dN2) || dN.isDescendantOf(dN2) ? dN.toString() : new StringBuffer(50).append(dN.toString()).append(",").append(dN2).toString();
        if (debug.messageEnabled()) {
            debug.message("Returning OrgDN is : " + string2);
        }
        return string2.toString();
    }

    public static String getWebContainerName() {
        return webContainer;
    }

    public String getOrganizationDN(String string, boolean bl, HttpServletRequest httpServletRequest) {
        String string2;
        block7: {
            block6: {
                string2 = null;
                try {
                    string2 = this.dpStore.getOrganizationDN(string, null);
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block6;
                    debug.message("Could not get orgName", (Throwable)exception);
                }
            }
            if ((string2 == null || string2.equals("")) && bl && httpServletRequest != null) {
                String string3 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                int n = string3.indexOf(";");
                string = n != -1 ? this.stripPort(string3.substring(0, n)) : this.stripPort(string3);
                try {
                    string2 = this.dpStore.getOrganizationDN(string, null);
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block7;
                    debug.message("Could not get orgName" + string, (Throwable)exception);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("getOrganizationDN : orgParam... :" + string);
            debug.message("getOrganizationDN : orgDN ... :" + string2);
        }
        return string2;
    }

    public String getDomainNameByRequest(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        boolean bl = false;
        String string = this.getOrgParam(hashtable);
        if (debug.messageEnabled()) {
            debug.message("orgParam is.. :" + string);
        }
        if (string == null || string.equals("")) {
            bl = true;
            string = httpServletRequest.getServerName();
            if (debug.messageEnabled()) {
                debug.message("Hostname : " + string);
            }
        }
        String string2 = this.getOrganizationDN(string, bl, httpServletRequest);
        if (debug.messageEnabled()) {
            debug.message("orgDN is " + string2);
        }
        return string2;
    }

    public String getOrgParam(Hashtable hashtable) {
        String string = null;
        if (hashtable != null && !hashtable.isEmpty() && ((string = (String)hashtable.get("domain")) == null || string.equals(""))) {
            string = (String)hashtable.get("org");
        }
        return string;
    }

    public String getSuperAdminUser() {
        return this.superAdmin;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bundles = new HashMap();
        authInitFailed = false;
        fqdnUtils = new FQDNUtils();
        platLocale = SystemProperties.get((String)"com.iplanet.am.locale");
        webContainer = SystemProperties.get((String)"com.sun.identity.webcontainer");
        templatesMap = new HashMap();
        logStatus = false;
        String string = "INACTIVE";
        string = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (string.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
        debug = Debug.getInstance((String)BUNDLE_NAME);
        dsameVersion = DSAME_VERSION;
    }
}

