/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMAccountLockout;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthLevel;
import com.sun.identity.authentication.service.AuthThreadManager;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.DSAMECallbackHandler;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStatus;
import com.sun.identity.authentication.service.UserPrincipal;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.MessageLoginException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;

public class AMLoginContext
extends Thread {
    DSAMECallbackHandler dsameCallbackHandler;
    String configName;
    LoginContext lc;
    LoginStatus st;
    LoginState loginState;
    Callback[] setSubmittedInfo;
    Callback[] getRequiredInfo;
    Callback[] recdCallback;
    AuthContextLocal authContext;
    Subject subject;
    private static AuthD ad = AuthD.getAuth();
    private HashMap loginParamsMap;
    AuthContext.IndexType indexType;
    String indexName;
    Principal principal;
    char[] password;
    String clientType;
    String authLevel;
    String role;
    String orgDN = null;
    String roleDN = null;
    boolean pCookieMode = false;
    String lockoutMsg = null;
    Set moduleSet = new HashSet();
    static final String LIST_DELIMITER = "|";
    public static AuthThreadManager authThread = new AuthThreadManager();
    String sid = null;
    static Hashtable loginHash = new Hashtable();
    boolean accountLocked = false;
    boolean isFailed = false;
    boolean internalAuthError = false;
    boolean processDone = false;
    private static final String bundleName = "amAuth";
    ResourceBundle bundle;

    public AMLoginContext(AuthContextLocal authContextLocal) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AMLoginContext:initialThread name is... :" + Thread.currentThread().getName());
        }
        this.authContext = authContextLocal;
        this.st = new LoginStatus();
        this.st.setStatus(2);
        this.bundle = AMLoginContext.ad.bundle;
    }

    public void executeLogin(HashMap hashMap) throws AuthLoginException {
        boolean bl = false;
        this.internalAuthError = false;
        this.processDone = false;
        this.isFailed = false;
        this.setLoginHash();
        if (this.loginState != null) {
            String string = this.loginState.getLocale();
            Locale locale = com.iplanet.am.util.Locale.getLocale((String)string);
            this.bundle = AMResourceBundleCache.getInstance().getResBundle(bundleName, locale);
        }
        if (hashMap == null) {
            AuthD.debug.error("Error: loginParams is null");
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.st.setStatus(4);
            this.internalAuthError = true;
            loginHash.remove(this.sid);
            throw new AuthLoginException(bundleName, "102", null);
        }
        this.parseLoginParams(hashMap);
        this.loginState = (LoginState)loginHash.get(this.sid);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState : " + this.loginState);
        }
        if (this.loginState == null) {
            AuthD.debug.error("Error: loginState is null");
            this.st.setStatus(4);
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.internalAuthError = true;
            loginHash.remove(this.sid);
            throw new AuthLoginException(bundleName, "102", null);
        }
        this.orgDN = this.loginState.getOrgDN();
        this.clientType = this.loginState.getClientType();
        this.loginState.setIndexType(this.indexType);
        this.loginState.setIndexName(this.indexName);
        try {
            if (this.processIndexType(this.indexType, this.indexName)) {
                return;
            }
        }
        catch (AuthLoginException authLoginException) {
            AuthD.debug.message("Error  : ", (Throwable)authLoginException);
            loginHash.remove(this.sid);
            throw new AuthLoginException(authLoginException);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error : ", (Throwable)exception);
            loginHash.remove(this.sid);
            throw new AuthLoginException(exception);
        }
        this.configName = this.getConfigName(this.indexType, this.indexName, this.orgDN, this.clientType);
        if (this.configName == null) {
            this.loginState.setErrorCode("105");
            AuthD.debug.message("Config not found");
            this.setErrorMsgAndTemplate();
            this.internalAuthError = true;
            this.st.setStatus(4);
            this.loginState.logFailed(this.bundle.getString("noConfig"));
            loginHash.remove(this.sid);
            throw new AuthLoginException(bundleName, "105", null);
        }
        this.dsameCallbackHandler = new DSAMECallbackHandler(this);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Creating login context object\n\n orgDN : " + this.orgDN + "\n configName : " + this.configName);
        }
        try {
            this.lc = this.subject != null ? new LoginContext(this.configName, this.subject, this.dsameCallbackHandler) : new LoginContext(this.configName, this.dsameCallbackHandler);
        }
        catch (LoginException loginException) {
            AuthD.debug.message("error creating LoginContext. ");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Exception ", (Throwable)loginException);
            }
            this.loginState.setErrorCode("102");
            this.loginState.logFailed(this.bundle.getString("loginContextCreateFailed"));
            this.setErrorMsgAndTemplate();
            this.st.setStatus(4);
            this.internalAuthError = true;
            loginHash.remove(this.sid);
            throw new AuthLoginException(bundleName, "102", null, loginException);
        }
        catch (SecurityException securityException) {
            AuthD.debug.message("Error creating LoginContext. ");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Exception ", (Throwable)securityException);
            }
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.loginState.logFailed(this.bundle.getString("loginContextCreateFailed"));
            this.internalAuthError = true;
            this.st.setStatus(4);
            loginHash.remove(this.sid);
            throw new AuthLoginException(bundleName, "102", null);
        }
        try {
            this.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.st.setStatus(7);
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.internalAuthError = true;
            loginHash.remove(this.sid);
            throw new AuthLoginException(bundleName, "102", null);
        }
        AuthD.debug.message("AMLoginContext:Thread started... returning.");
    }

    public void run() {
        boolean bl;
        String string;
        Thread thread;
        block33: {
            thread = Thread.currentThread();
            AuthD.debug.message("AMLoginContext:starting loginprocess.." + thread);
            string = this.bundle.getString("loginFailed");
            AMAccountLockout aMAccountLockout = null;
            bl = false;
            try {
                this.lc.login();
                AuthD.debug.message("user authenication successful");
                this.subject = this.lc.getSubject();
                this.loginState = (LoginState)loginHash.get(this.sid);
                this.loginState.setSubject(this.subject);
                AuthD.debug.message("searchUserProfile for Subject :");
                boolean bl2 = this.loginState.searchUserProfile(this.subject, this.indexType, this.indexName);
                bl = true;
                if (!bl2) {
                    AuthD.debug.error("Profile not found ");
                    string = this.bundle.getString("noUserProfile");
                    this.loginState.setErrorCode("100");
                    this.isFailed = true;
                    break block33;
                }
                aMAccountLockout = new AMAccountLockout(this.loginState);
                if (aMAccountLockout.isLockedOut()) {
                    AuthD.debug.message("User locked out!!");
                    string = this.bundle.getString("lockOut");
                    this.loginState.setErrorCode("112");
                    this.isFailed = true;
                    break block33;
                }
                boolean bl3 = false;
                if (!this.loginState.ignoreProfile()) {
                    bl3 = aMAccountLockout.isAccountExpired();
                }
                if (bl3) {
                    AuthD.debug.message("Account expired!!");
                    string = this.bundle.getString("accountExpired");
                    this.loginState.setErrorCode("101");
                    this.isFailed = true;
                    break block33;
                }
                this.loginState = (LoginState)loginHash.get(this.sid);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("authContext is : " + this.authContext);
                    AuthD.debug.message("loginSTate is : " + this.loginState);
                }
                this.updateLoginState(this.loginState, this.indexType, this.indexName, this.configName);
                boolean bl4 = this.loginState.activateSession(this.subject);
                if (bl4) {
                    this.loginState.logSuccess();
                    aMAccountLockout.resetPasswdLockout(this.loginState.getUserToken());
                    this.st.setStatus(3);
                    this.loginState.updateSessionForFailover();
                    AuthD.debug.message("login success");
                    break block33;
                }
                throw new AuthException("115", null);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                AuthD.debug.message("Invalid Password : ");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception ", (Throwable)invalidPasswordException);
                }
                String string2 = invalidPasswordException.getTokenId();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Invalid Password Exception " + string2);
                }
                if (string2 != null) {
                    aMAccountLockout = new AMAccountLockout(this.loginState);
                    this.accountLocked = aMAccountLockout.isLockedOut(string2);
                    if (!this.accountLocked) {
                        this.accountLocked = aMAccountLockout.isAccountLocked(string2);
                        if (!this.accountLocked) {
                            aMAccountLockout.invalidPasswd(string2);
                            this.checkWarningCount(aMAccountLockout);
                            this.accountLocked = aMAccountLockout.isAccountLocked(string2);
                        }
                    }
                }
                string = this.bundle.getString("invalidPasswd");
                if (this.accountLocked) {
                    this.loginState.setErrorCode("104");
                } else {
                    this.loginState.setErrorCode("103");
                }
                this.isFailed = true;
                this.authContext.setLoginException(invalidPasswordException);
            }
            catch (MessageLoginException messageLoginException) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("LOGINFAILED MessageAuthLoginException....");
                    AuthD.debug.message("Exception ", (Throwable)messageLoginException);
                }
                Locale locale = com.iplanet.am.util.Locale.getLocale((String)this.loginState.getLocale());
                this.loginState.setModuleErrorMessage(messageLoginException.getL10NMessage(locale));
                this.isFailed = true;
                this.authContext.setLoginException(messageLoginException);
            }
            catch (AuthLoginException authLoginException) {
                if ("110".equals(authLoginException.getMessage())) {
                    AuthD.debug.message("LOGINFAILED Error Timed Out....");
                } else {
                    AuthD.debug.message("LOGINFAILED Error....");
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception ", (Throwable)authLoginException);
                }
                this.isFailed = true;
                if (this.loginState.isTimedOut()) {
                    string = this.bundle.getString("loginTimeout");
                    this.loginState.setErrorCode("110");
                } else {
                    this.loginState.setErrorCode("107");
                }
                this.authContext.setLoginException(authLoginException);
            }
            catch (AuthException authException) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception " + authException.getMessage());
                }
                this.isFailed = true;
                this.loginState.setErrorCode(authException.getErrorCode());
                this.loginState.logFailed(this.bundle.getString("loginFailed"));
                this.authContext.setLoginException(new AuthLoginException(bundleName, "loginFailed", null, (Throwable)((Object)authException)));
            }
            catch (Exception exception) {
                AuthD.debug.message("Error during login.. ");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception ", (Throwable)exception);
                }
                this.isFailed = true;
                this.loginState.setErrorCode("102");
                this.loginState.logFailed(this.bundle.getString("loginFailed"));
                this.authContext.setLoginException(new AuthLoginException(bundleName, "loginFailed", null, exception));
            }
        }
        AuthD.debug.message("Came to before if Failed loop");
        if (this.isFailed) {
            if (bl) {
                this.loginState.setFailureModuleList(this.getSuccessModuleString());
            } else {
                this.loginState.setFailureModuleList(this.getFailureModuleList());
            }
            this.loginState.logFailed(string);
            this.setErrorMsgAndTemplate();
            this.st.setStatus(4);
            loginHash.remove(this.sid);
            if (this.indexType == AuthContext.IndexType.USER) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Set failureId in user based auth " + this.indexName);
                }
                this.loginState.setFailureId(this.indexName);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("finished...login notify all threads\nAMLoginContext:LoginStatus: " + this.st.getStatus());
        }
        authThread.removeFromHash(thread, "timeoutHash");
        this.loginState.setReceivedCallback(null, this);
        this.isFailed = false;
    }

    public void logout() throws AuthLoginException {
        block5: {
            AuthD.debug.message("in logout:");
            try {
                if (this.lc != null) {
                    this.lc.logout();
                }
                this.loginState.logLogout();
                this.loginState.onLogoutProcess(this.indexType, this.indexName);
                this.destroySession();
                this.st.setStatus(5);
            }
            catch (AuthLoginException authLoginException) {
                AuthD.debug.message("Error during logout : ");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception ", (Throwable)authLoginException);
                }
                throw new AuthLoginException(bundleName, "failedLogout", null, authLoginException);
            }
            catch (Exception exception) {
                AuthD.debug.message("Error during logout : ");
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Exception ", (Throwable)exception);
            }
        }
        loginHash.remove(this.sid);
    }

    void destroySession() {
        this.loginState = (LoginState)loginHash.get(this.sid);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AMLoginContext:destroySession: " + this.loginState);
        }
        this.loginState.destroySession();
        AuthUtils.removeLoginStateFromHash(this.authContext);
    }

    public Callback[] getRequiredInfo() {
        if (this.st.getStatus() != 2) {
            return null;
        }
        if (this.indexType == AuthContext.IndexType.LEVEL) {
            AuthD.debug.message("Index type level, send choice callback");
            this.indexType = null;
        } else {
            this.recdCallback = this.getRequiredInfoCallback();
        }
        if (this.recdCallback != null) {
            int n = 0;
            while (n < this.recdCallback.length) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Recd Callback in amlc.getRequiredInfo : " + this.recdCallback[n]);
                }
                ++n;
            }
        } else {
            AuthD.debug.message("Recd Callback in amlc.getRequiredInfo is NULL");
        }
        return this.recdCallback;
    }

    public synchronized Callback[] getRequiredInfoCallback() {
        this.loginState = (LoginState)loginHash.get(this.sid);
        if (this.loginState == null) {
            AuthD.debug.message("LoginState is null, returning");
            return null;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getRequiredInfo.. " + this.st.getStatus());
        }
        if (this.isFailed || this.st.getStatus() != 2) {
            AuthD.debug.message("no more requirements returning null");
            return null;
        }
        Thread thread = Thread.currentThread();
        long l = this.loginState.getLastCallbackSent();
        long l2 = this.loginState.getPageTimeOut();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getRequiredInfo. ThreadName is.. :" + thread);
            AuthD.debug.message("lastCallbackSent : " + l);
            AuthD.debug.message("pageTimeOut : " + l2);
        }
        authThread.setHash(thread, l2, l);
        while (!this.isFailed && this.loginState.getReceivedInfo() == null && this.st.getStatus() == 2) {
            try {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message(Thread.currentThread() + "Waiting.." + this.st.getStatus());
                }
                if (this.st.getStatus() != 2) {
                    return null;
                }
                if (this.isFailed || this.st.getStatus() != 2 || this.loginState.getReceivedInfo() != null) continue;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                AuthD.debug.message("getRecdinfo INTERRUPTED");
                break;
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Thread woke up... " + this.loginState.getReceivedInfo());
        }
        this.getRequiredInfo = this.loginState.getReceivedInfo();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning getRequiredInfo... :" + this.getRequiredInfo);
        }
        authThread.removeFromHash(thread, "timeoutHash");
        return this.getRequiredInfo;
    }

    public void submitRequiredInfo(Callback[] callbackArray) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("submit required info... :" + callbackArray[0]);
        }
        this.loginState.setSubmittedCallback(callbackArray, this);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Retunring from submitRequiredInfo");
        }
    }

    public synchronized Callback[] submitCallbackInfo() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("submitRequiredInfo. ThreadName is.. :" + Thread.currentThread().getName());
        }
        this.loginState = (LoginState)loginHash.get(this.sid);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("loginState is ... : " + this.loginState);
        }
        if (this.st.getStatus() != 2 || this.isFailed) {
            AuthD.debug.message("submitReq no more requirements returning null");
            return null;
        }
        Thread thread = Thread.currentThread();
        long l = this.loginState.getLastCallbackSent();
        long l2 = this.loginState.getPageTimeOut();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("submitRequiredInfo. ThreadName is.. :" + thread);
            AuthD.debug.message("lastCallbackSent : " + l);
            AuthD.debug.message("pageTimeOut : " + l2);
        }
        authThread.setHash(thread, l2, l);
        while (this.loginState.getSubmittedInfo() == null && this.st.getStatus() == 2) {
            try {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message(Thread.currentThread() + " Waiting...." + this.st.getStatus());
                }
                if (this.st.getStatus() != 2) {
                    return null;
                }
                if (this.loginState.getSubmittedInfo() != null) continue;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                AuthD.debug.message("submitRequired info INTERRUPTED");
                break;
            }
        }
        AuthD.debug.message("Threadwaking up go submit info...");
        authThread.removeFromHash(thread, "timeoutHash");
        this.setSubmittedInfo = this.loginState.getSubmittedInfo();
        AuthD.debug.message("Returning submitted info: ");
        return this.setSubmittedInfo;
    }

    public int getStatus() {
        int n = this.st.getStatus();
        if (this.isFailed || n == 4) {
            this.postProcessOnFail();
        } else if (n == 3) {
            this.postProcessOnSuccess();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getStatus : status is... : " + n);
        }
        return n;
    }

    public LoginState getLoginState() {
        return AuthUtils.getLoginState(this.authContext);
    }

    public void abort() throws AuthLoginException {
        AuthD.debug.message("in abort");
        try {
            this.logout();
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error logging out.. :");
                AuthD.debug.message("Exception ", (Throwable)exception);
            }
            try {
                this.destroySession();
                this.st.setStatus(5);
            }
            catch (Exception exception2) {
                AuthD.debug.message("Error aborting");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Exception ", (Throwable)exception2);
                }
                throw new AuthLoginException(bundleName, "abortFailed", null);
            }
        }
    }

    public Set getModuleInstanceNames() {
        try {
            LoginState loginState = AuthUtils.getLoginState(this.authContext);
            if (loginState != null) {
                this.moduleSet = loginState.getModuleInstances();
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("moduleSet is : " + this.moduleSet);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Error : ", (Throwable)exception);
        }
        return this.moduleSet;
    }

    public String getOrganizationName() {
        return this.loginState.getQueryOrg();
    }

    public SSOToken getSSOToken() {
        try {
            return this.loginState.getSSOToken();
        }
        catch (SSOException sSOException) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("error getting ssoToken : ");
                AuthD.debug.message("Exception ", (Throwable)sSOException);
            }
            return null;
        }
    }

    public Subject getSubject() {
        try {
            return this.loginState.getSubject();
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("error getting Subject :");
                AuthD.debug.message("Exception ", (Throwable)exception);
            }
            return null;
        }
    }

    private void parseLoginParams(HashMap hashMap) {
        block5: {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("loginParamsMap is.. :" + hashMap);
            }
            try {
                this.indexType = (AuthContext.IndexType)hashMap.get("indexType");
                this.indexName = (String)hashMap.get("indexName");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("indexType = " + this.indexType + "\nindexName = " + this.indexName);
                }
                this.principal = (Principal)hashMap.get("principal");
                this.password = (char[])hashMap.get("password");
                this.subject = (Subject)hashMap.get("subject");
                Boolean bl = (Boolean)hashMap.get("pCookieMode");
                if (bl != null) {
                    this.pCookieMode = bl;
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error parsing login Params");
                AuthD.debug.message("Exception ", (Throwable)exception);
            }
        }
    }

    String getConfigName(AuthContext.IndexType indexType, String string, String string2, String string3) {
        String string4;
        block8: {
            string4 = null;
            String string5 = null;
            if (indexType == null) {
                string4 = AMAuthConfigUtils.getAuthConfigName(string2, "html");
            } else {
                if (indexType == AuthContext.IndexType.USER) {
                    string5 = this.loginState.getUserDN(string);
                } else if (indexType == AuthContext.IndexType.ROLE) {
                    this.roleDN = string5 = this.loginState.getRoleDN(string, string2);
                } else {
                    string5 = string;
                }
                try {
                    string4 = AMAuthConfigUtils.getAuthConfigName(indexType, string5, string2, string3);
                }
                catch (Exception exception) {
                    if (!AuthD.debug.messageEnabled()) break block8;
                    AuthD.debug.message("Error retrieving configName ");
                    AuthD.debug.message("Exception : ", (Throwable)exception);
                }
            }
        }
        return string4;
    }

    boolean processLevel(AuthContext.IndexType indexType, String string, String string2, String string3) throws AuthException {
        Object var5_5 = null;
        indexType = AuthContext.IndexType.LEVEL;
        this.authLevel = string;
        Locale locale = com.iplanet.am.util.Locale.getLocale((String)this.loginState.getLocale());
        AuthLevel authLevel = new AuthLevel(indexType, string, string2, string3, locale);
        int n = authLevel.getNumberOfAuthModules();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("number of Modules : " + n);
        }
        if (n <= 0) {
            this.loginState.logFailed(this.bundle.getString("noConfig"));
            throw new AuthException("105", null);
        }
        if (n == 1) {
            this.indexType = AuthContext.IndexType.MODULE_INSTANCE;
            this.loginState.setIndexType(this.indexType);
            this.indexName = authLevel.getModuleName();
            return false;
        }
        try {
            this.recdCallback = authLevel.createChoiceCallback();
            this.loginState.setPrevCallback(this.recdCallback);
            return true;
        }
        catch (AuthException authException) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error creating choiceCallback");
                AuthD.debug.message("Exception ", (Throwable)((Object)authException));
            }
            return false;
        }
    }

    void updateLoginState(LoginState loginState, AuthContext.IndexType indexType, String string, String string2) {
        this.authLevel = indexType == AuthContext.IndexType.LEVEL ? string : this.getAuthLevel();
        loginState.setAuthLevel(this.authLevel);
        String string3 = null;
        string3 = indexType == AuthContext.IndexType.MODULE_INSTANCE ? string : this.getSuccessModuleString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("moduleName : " + string3);
        }
        loginState.setAuthModuleName(string3);
        if (indexType == AuthContext.IndexType.ROLE) {
            loginState.setAuthRoleName(string);
        }
        if (indexType == AuthContext.IndexType.USER) {
            loginState.setUserName(string);
        }
    }

    boolean validateUser(String string) {
        try {
            boolean bl = this.loginState.getUserProfile(string, true);
            this.indexName = this.loginState.getUserDN();
            return bl && this.loginState.isUserEnabled();
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error retrieving profile for : " + string);
            }
            return false;
        }
    }

    void checkWarningCount(AMAccountLockout aMAccountLockout) {
        try {
            int n = aMAccountLockout.getWarnUserCount();
            if (n == 0) {
                this.lockoutMsg = "";
            } else if (n < 0) {
                this.accountLocked = true;
            } else {
                String string = this.bundle.getString("lockOutWarning");
                Object[] objectArray = new Object[]{new Integer(n)};
                this.lockoutMsg = MessageFormat.format(string, objectArray);
                this.loginState.setLockoutMsg(this.lockoutMsg);
                this.accountLocked = false;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("WARNING COUNT : " + n);
                AuthD.debug.message("WARNING COUNT MESSAGE: " + this.lockoutMsg);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Error : ", (Throwable)exception);
        }
    }

    void setErrorMsgAndTemplate() {
        if (this.loginState == null) {
            return;
        }
        String string = this.loginState.getErrorCode();
        if (string != null) {
            String string2 = this.bundle.getString(string);
            String string3 = null;
            String string4 = null;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("resProperty is.. :" + string2);
            }
            string3 = ad.getErrorVal(string, "Error_Message");
            string4 = ad.getErrorVal(string, "Error_Template");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error Message : " + string3);
                AuthD.debug.message("Error Template: " + string4);
            }
            this.loginState.setErrorMessage(string3);
            this.loginState.setErrorTemplate(string4);
        }
    }

    String getTimedOutTemplate() {
        this.loginState.setErrorCode("110");
        this.loginState.logFailed(this.bundle.getString("loginTimeout"));
        this.loginState.setErrorMessage(ad.getErrorVal("110", "Error_Message"));
        return ad.getErrorVal("110", "Error_Template");
    }

    String getModuleErrorTemplate() {
        String string = this.loginState.getModuleErrorTemplate();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Error Template is : " + string);
        }
        return string;
    }

    public String getErrorTemplate() {
        String string = null;
        if (this.loginState == null) {
            string = AuthD.getAuth().getErrorVal("102", "Error_Template");
            return string;
        }
        if (this.loginState.isTimedOut()) {
            string = this.getTimedOutTemplate();
        } else {
            string = this.loginState.getModuleErrorTemplate();
            if (string == null || string.equals("")) {
                string = this.loginState.getErrorTemplate();
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Error Template is : " + string);
        }
        this.loginState.setErrorTemplate(string);
        return string;
    }

    public String getErrorMessage() {
        String string = null;
        if (this.loginState == null) {
            string = AuthD.getAuth().getErrorVal("102", "Error_Message");
            return string;
        }
        string = this.loginState.getModuleErrorMessage();
        if (string == null) {
            string = this.loginState.getErrorMessage();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Error message is : " + string);
        }
        return string;
    }

    public String getErrorCode() {
        if (this.loginState == null) {
            return "102";
        }
        String string = this.loginState.getErrorCode();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Error Code is.. : " + string);
        }
        return string;
    }

    public String getLockoutMsg() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("lockout Msg returned  : " + this.lockoutMsg);
        }
        return this.lockoutMsg;
    }

    public boolean isLockedOut() {
        return this.accountLocked;
    }

    String getAuthLevel() {
        AMAuthLevelManager aMAuthLevelManager = AMAuthLevelManager.getInstance();
        int n = Integer.MIN_VALUE;
        if (this.moduleSet.isEmpty()) {
            this.moduleSet = this.getSuccessModuleSet();
        }
        Iterator iterator = this.moduleSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = aMAuthLevelManager.getLevelForModule(string, this.loginState.getOrgDN());
            if (n2 > n) {
                n = n2;
            }
            if (!AuthD.debug.messageEnabled()) continue;
            AuthD.debug.message("AuthLevel is : " + n2);
            AuthD.debug.message("New AuthLevel is : " + n);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning AuthLevel is : " + n);
        }
        return new Integer(n).toString();
    }

    Set getSuccessModuleSet() {
        try {
            Set set = this.loginState.getSuccessModuleSet();
            this.moduleSet = this.getModuleFromAuthConfiguration(set);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("ModuleSet is : " + this.moduleSet);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Exception : getSuccessModuleList ", (Throwable)exception);
        }
        return this.moduleSet;
    }

    String getModuleString(Set set) {
        String string = "";
        if (set != null && !set.isEmpty()) {
            String string2;
            Iterator iterator = set.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                stringBuffer.append(string2).append(LIST_DELIMITER);
            }
            string2 = stringBuffer.toString();
            int n = string2.lastIndexOf(LIST_DELIMITER);
            string = n != -1 ? string2.substring(0, n) : string2;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("ModuleList is : " + string);
        }
        return string;
    }

    static String getModuleNameFromAuthenticator(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(n + 1, string.length());
            return string2;
        }
        return string;
    }

    boolean processIndexType(AuthContext.IndexType indexType, String string) throws AuthLoginException {
        boolean bl = false;
        this.loginState = (LoginState)loginHash.get(this.sid);
        if (indexType == AuthContext.IndexType.LEVEL) {
            AuthD.debug.message("IndexType is level");
            String string2 = this.loginState.getOrgDN();
            HttpServletRequest httpServletRequest = this.loginState.getHttpServletRequest();
            boolean bl2 = false;
            if (httpServletRequest != null) {
                Object object;
                Object object2;
                try {
                    object2 = SSOTokenManager.getInstance();
                    object = object2.createSSOToken(httpServletRequest);
                    if (object2.isValidToken(object)) {
                        AuthD.debug.message("Existing Valid session");
                        bl2 = true;
                    }
                }
                catch (Exception exception) {
                    AuthD.debug.message("ERROR processIndexType/SSOToken validation - " + exception.toString());
                }
                if (!bl2) {
                    AuthD.debug.message("No existing valid session");
                    object2 = this.loginState.getRequestParamHash();
                    object = ad.getOrgParam((Hashtable)object2);
                    String string3 = AuthUtils.getQueryOrgName(httpServletRequest, (String)object);
                    String string4 = ad.getOrganizationDN(string3, true, httpServletRequest);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("orgDN from existing auth context: " + string2 + ", orgDN from query string: " + string4);
                    }
                    if (string2 != null && !string2.equals(string4)) {
                        this.st.setStatus(7);
                        this.loginState.setErrorCode("102");
                        this.setErrorMsgAndTemplate();
                        this.internalAuthError = true;
                        throw new AuthLoginException(bundleName, "102", null);
                    }
                }
            }
            try {
                if (this.processLevel(indexType, string, string2, this.clientType)) {
                    AuthD.debug.message("multiple modules found");
                    return true;
                }
                return false;
            }
            catch (AuthException authException) {
                this.loginState.setErrorCode("105");
                this.loginState.logFailed(this.bundle.getString("noConfig"));
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException((Throwable)((Object)authException));
            }
        }
        if (indexType == AuthContext.IndexType.USER) {
            AuthD.debug.message("IndexType is user");
            boolean bl3 = false;
            if (!this.loginState.ignoreProfile()) {
                bl3 = this.validateUser(string);
            } else {
                bl = true;
            }
            if (this.pCookieMode) {
                try {
                    this.processPCookieMode(bl3);
                    return true;
                }
                catch (AuthLoginException authLoginException) {
                    throw new AuthLoginException(authLoginException);
                }
            }
            if (!bl3 && !bl) {
                AuthD.debug.message("User is not active");
                this.loginState.logFailed(this.bundle.getString("userInactive"));
                this.loginState.setErrorCode("104");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "104", null);
            }
            if (bl) {
                this.setAuthError("100", "loginDenied");
                throw new AuthLoginException(bundleName, "100", null);
            }
            return false;
        }
        if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
            AuthD.debug.message("indexType is module");
            Set set = this.loginState.getDomainAuthenticators();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("domainAuthenticators : " + set);
            }
            if (!(string.equals("Application") || set.isEmpty() || set.contains(string))) {
                AuthD.debug.message("Module denied!!");
                this.loginState.setErrorCode("111");
                this.loginState.logFailed(this.bundle.getString("moduleDenied"));
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "111", null);
            }
            return false;
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            AuthD.debug.message("indexType is Role");
            if (this.loginState.ignoreProfile()) {
                this.setAuthError("114", "loginDenied");
                throw new AuthLoginException(bundleName, "114", null);
            }
        }
        return false;
    }

    void processPCookieMode(boolean bl) throws AuthLoginException {
        Object object;
        if (!this.loginState.ignoreProfile()) {
            if (!bl) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("user is not valid");
                }
                this.loginState.setErrorCode("106");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "106", null);
            }
            object = new AMAccountLockout(this.loginState);
            boolean bl2 = ((AMAccountLockout)object).isAccountExpired();
            if (bl2) {
                this.loginState.logFailed(this.bundle.getString("accountExpired"));
                this.loginState.setErrorCode("101");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "101", null);
            }
        }
        if (this.loginState.ignoreProfile()) {
            try {
                this.loginState.populateDefaultUserAttributes();
            }
            catch (Exception exception) {
                AuthD.debug.message("Error get default attributes ", (Throwable)exception);
                this.setAuthError("102", "loginFailed");
                throw new AuthLoginException(bundleName, "102", null);
            }
        }
        if (this.loginState.isSessionUpgrade()) {
            this.loginState.setPCookieUserName(this.indexName);
            return;
        }
        this.updateLoginState(this.loginState, this.indexType, this.indexName, this.configName);
        object = new Subject();
        UserPrincipal userPrincipal = new UserPrincipal(this.indexName);
        ((Subject)object).getPrincipals().add(userPrincipal);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Subject is.. :" + object);
        }
        try {
            this.loginState.activateSession((Subject)object);
            this.loginState.updateSessionForFailover();
            this.loginState.logSuccess();
        }
        catch (Exception exception) {
            AuthD.debug.message("Error activating session ");
            this.setAuthError("102", "loginFailed");
            throw new AuthLoginException(bundleName, "102", null);
        }
        this.st.setStatus(3);
        AuthD.debug.message("login success");
    }

    void setLoginHash() {
        block5: {
            try {
                this.sid = AuthUtils.getSidString(this.authContext);
                this.loginState = AuthUtils.getLoginState(this.authContext);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("sid .. " + this.sid);
                    AuthD.debug.message("login state is .. : " + this.loginState);
                }
            }
            catch (Exception exception) {
                AuthD.debug.message("executLogin exception : ", (Throwable)exception);
            }
            try {
                loginHash.put(this.sid, this.loginState);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error : ", (Throwable)exception);
            }
        }
    }

    void setAuthError(String string, String string2) {
        this.loginState.setErrorCode(string);
        this.setErrorMsgAndTemplate();
        this.loginState.logFailed(this.bundle.getString(string2));
        this.st.setStatus(4);
        loginHash.remove(this.sid);
    }

    public void postProcessOnFail() {
        if (!this.internalAuthError && !this.processDone) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("postProcessOnFail ");
            }
            this.loginState.onFailureProcess(this.indexType, this.indexName);
            this.loginState.setFailureLoginURL(this.indexType, this.indexName);
            this.processDone = true;
        }
    }

    public void postProcessOnSuccess() {
        if (!this.processDone) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("postProcessOnSuccess ");
            }
            this.loginState.onSuccessProcess(this.indexType, this.indexName);
            this.loginState.setSuccessLoginURL(this.indexType, this.indexName);
            this.processDone = true;
        }
    }

    private Set getModuleFromAuthConfiguration(Set set) {
        Configuration configuration = Configuration.getConfiguration();
        if (this.configName == null) {
            this.configName = this.getConfigName(this.indexType, this.indexName, this.loginState.getOrgDN(), this.loginState.getClientType());
        }
        AppConfigurationEntry[] appConfigurationEntryArray = configuration.getAppConfigurationEntry(this.configName);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("configName is : " + this.configName);
        }
        String string = null;
        if (appConfigurationEntryArray != null && appConfigurationEntryArray.length != 0) {
            if (appConfigurationEntryArray.length == 1) {
                string = appConfigurationEntryArray[0].getLoginModuleName();
                String string2 = AMLoginContext.getModuleNameFromAuthenticator(string);
                set.add(string2);
            } else {
                int n = 0;
                while (n < appConfigurationEntryArray.length) {
                    AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = appConfigurationEntryArray[n].getControlFlag();
                    string = appConfigurationEntryArray[n].getLoginModuleName();
                    String string3 = AMLoginContext.getModuleNameFromAuthenticator(string);
                    if (this.isControlFlagMatchFound(loginModuleControlFlag)) {
                        set.add(string3);
                    }
                    ++n;
                }
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("ModuleSet is : " + set);
        }
        return set;
    }

    String getFailureModuleList() {
        String string = "";
        try {
            Set set = this.loginState.getFailureModuleSet();
            Set set2 = this.getModuleFromAuthConfiguration(set);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("ModuleSet is : " + set2);
            }
            string = this.getModuleString(set2);
        }
        catch (Exception exception) {
            AuthD.debug.message("Exception : getFailureModuleList ", (Throwable)exception);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("moduleList is :" + string);
        }
        return string;
    }

    boolean isControlFlagMatchFound(AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag) {
        boolean bl = false;
        if (loginModuleControlFlag != null) {
            bl = loginModuleControlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED || loginModuleControlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        return bl;
    }

    String getSuccessModuleString() {
        if (this.moduleSet.isEmpty()) {
            this.moduleSet = this.getSuccessModuleSet();
        }
        return this.getModuleString(this.moduleSet);
    }

    static {
        authThread.start();
    }
}

