/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Locale;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.common.AccountLockoutInfo;
import com.sun.identity.common.ISAccountLockout;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import netscape.ldap.util.DN;

class AMAccountLockout {
    LoginState loginState = null;
    private static AuthD ad = AuthD.getAuth();
    static Map loginFailHash = Collections.synchronizedMap(new HashMap());
    public boolean loginFailureLockoutMode = false;
    private long loginFailureLockoutTime = 300L;
    private int loginFailureLockoutCount = 5;
    private String loginLockoutNotification = null;
    private int loginLockoutUserWarning = 3;
    private int userWarningCount = 0;
    private long loginFailureLockoutDuration = 0L;
    public String loginLockoutAttrValue = null;
    public String loginLockoutAttrName = null;
    private ISAccountLockout isAccountLockout;
    private AccountLockoutInfo acInfo = null;
    static String bundleName = "amAuth";
    String token = null;
    private boolean accountLocked = false;
    private static final String USER_ACTIVE = "active";
    private static final String FALSE_VALUE = "false";
    private static final String INETUSERSTATUS_ATTR = "inetuserstatus";
    private static final String LOGIN_STATUS_ATTR = "iplanet-am-user-login-status";
    private static final String NSACCOUNTLOCK_ATTR = "nsaccountlock";

    public AMAccountLockout(LoginState loginState) {
        this.loginState = loginState;
        this.loginFailureLockoutTime = loginState.getLoginFailureLockoutTime();
        this.loginFailureLockoutCount = loginState.getLoginFailureLockoutCount();
        this.loginLockoutNotification = loginState.getLoginLockoutNotification();
        this.loginLockoutUserWarning = loginState.getLoginLockoutUserWarning();
        this.loginLockoutAttrName = loginState.getLoginLockoutAttrName();
        this.loginLockoutAttrValue = loginState.getLoginLockoutAttrValue();
        this.loginFailureLockoutDuration = loginState.getLoginFailureLockoutDuration();
        this.loginFailureLockoutMode = loginState.getLoginFailureLockoutMode();
        this.isAccountLockout = new ISAccountLockout(this.loginFailureLockoutMode, this.loginFailureLockoutTime, this.loginFailureLockoutCount, this.loginLockoutNotification, this.loginLockoutUserWarning, this.loginLockoutAttrName, this.loginLockoutAttrValue, this.loginFailureLockoutDuration, bundleName);
    }

    public void invalidPasswd(String string) {
        block6: {
            try {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("invalidPasswd ... :" + string);
                }
                this.token = string;
                if (!this.isAccountLockout.isLockoutEnabled()) {
                    AuthD.debug.message("Failure lockout mode disabled");
                } else {
                    String string2 = this.loginState.tokenToDN(string);
                    this.acInfo = (AccountLockoutInfo)loginFailHash.get(string2);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("userDN is. : " + string2);
                        AuthD.debug.message("LoginFailHash is.. :" + loginFailHash);
                        AuthD.debug.message("acInfo is.. :" + this.acInfo);
                    }
                    AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
                    AMUser aMUser = aMStoreConnection.getUser(string2);
                    this.acInfo = this.isAccountLockout.invalidPasswd(aMUser, this.acInfo);
                    loginFailHash.put(string2, this.acInfo);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block6;
                AuthD.debug.message("Error ", (Throwable)exception);
            }
        }
    }

    public boolean isAccountExpired() {
        AuthD.debug.message("in isAccountExpired");
        String string = this.loginState.getAccountLife();
        if (string == null) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("EXIT accountLife is null :" + string);
            }
            return false;
        }
        Date date = Locale.parseNormalizedDateString((String)string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("exprDate = " + date);
        }
        if (date != null) {
            return date.before(new Date());
        }
        return false;
    }

    public int getWarnUserCount() {
        return this.getWarnUserCount(this.token);
    }

    public int getWarnUserCount(String string) {
        String string2 = this.loginState.tokenToDN(string);
        AccountLockoutInfo accountLockoutInfo = (AccountLockoutInfo)loginFailHash.get(string2);
        if (accountLockoutInfo != null) {
            this.userWarningCount = accountLockoutInfo.getWarningCount();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Warning count is . :" + this.userWarningCount);
        }
        return this.userWarningCount;
    }

    public void sendLockOutNotice(String string) {
        this.isAccountLockout.sendLockOutNotice(string);
    }

    public void resetPasswdLockout(String string) {
        String string2 = this.loginState.tokenToDN(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("resetPasswordFailCount: token=" + string + "  useDN=" + string2);
            AuthD.debug.message("loginFailHash is : " + loginFailHash);
        }
        loginFailHash.remove(string2);
        this.userWarningCount = 0;
        this.acInfo = null;
    }

    public boolean isLockedOut() {
        String string = this.loginState.getUserDN().toLowerCase();
        return this.isLockedOut(string);
    }

    public boolean isLockedOut(String string) {
        boolean bl = false;
        try {
            if (this.isAccountLockout.isMemoryLocking()) {
                String string2 = string;
                if (!DN.isDN(string2)) {
                    string2 = this.loginState.tokenToDN(string);
                }
                string2 = string2.toLowerCase();
                if (loginFailHash != null && !loginFailHash.isEmpty()) {
                    this.acInfo = (AccountLockoutInfo)loginFailHash.get(string2);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("isLockedOut:userDN=" + string2);
                        AuthD.debug.message("isLockedOut:loginFailHash=" + loginFailHash);
                        AuthD.debug.message("isLockedOut:acInfo=" + this.acInfo);
                    }
                    if (this.acInfo != null && !(bl = this.isAccountLockout.isLockedOut(this.acInfo)) && this.acInfo.isLockout()) {
                        loginFailHash.remove(string2);
                    }
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("isLockedOut :" + bl);
                    }
                }
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Exception ", (Throwable)exception);
        }
        return bl;
    }

    public boolean isAccountLocked(String string) {
        boolean bl = false;
        try {
            String string2 = string;
            if (!DN.isDN(string)) {
                string2 = this.loginState.tokenToDN(string);
            }
            string2 = string2.toLowerCase();
            this.acInfo = (AccountLockoutInfo)loginFailHash.get(string2);
            AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
            AMUser aMUser = aMStoreConnection.getUser(string2);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("userDN=" + string2);
                AuthD.debug.message("loginFailHash=" + loginFailHash);
                AuthD.debug.message("acInfo=" + this.acInfo);
            }
            if (this.isAccountValid(aMUser)) {
                if (this.isAccountLockout.isMemoryLocking() && this.acInfo != null) {
                    bl = this.acInfo.isLockout();
                } else {
                    bl = this.isAccountLockout.isAccountLocked(aMUser);
                    if (bl) {
                        this.resetPasswdLockout(string);
                    }
                }
            } else {
                bl = true;
                this.resetPasswdLockout(string);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("isLockedOut :" + bl);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Exception ", (Throwable)exception);
        }
        return bl;
    }

    boolean isAccountValid(AMUser aMUser) {
        boolean bl = true;
        try {
            String string;
            String string2 = aMUser.getStringAttribute(INETUSERSTATUS_ATTR);
            String string3 = aMUser.getStringAttribute(LOGIN_STATUS_ATTR);
            if (string3 == null || string3.length() == 0) {
                string3 = USER_ACTIVE;
            }
            if ((string = aMUser.getStringAttribute(NSACCOUNTLOCK_ATTR)) == null || string.length() == 0) {
                string = FALSE_VALUE;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("nsAccountVal:" + string);
            }
            bl = string2.equalsIgnoreCase(USER_ACTIVE) && string3.equalsIgnoreCase(USER_ACTIVE) && string.equalsIgnoreCase(FALSE_VALUE);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error :", (Throwable)exception);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Userenabled..." + bl);
        }
        return bl;
    }
}

