/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.unix;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.unix.UnixHelper;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.security.auth.SolarisPrincipal;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;

public class Unix
extends AMLoginModule {
    private static int helper_config_done = 0;
    private static Locale locale = null;
    private ResourceBundle bundle = null;
    private static String amAuthUnix = "amAuthUnix";
    private static Debug debug = null;
    public int UNIX_CONFIG_PORT = 58946;
    public int UNIX_TIMEOUT = 3;
    public int UNIX_THREADS = 5;
    public static int UNIX_HELPER_PORT = 57946;
    public String str_UNIX_HELPER_PORT = "57946";
    public String str_UNIX_TIMEOUT = "3";
    public String str_UNIX_THREADS = "5";
    public static final String DEFAULT_UNIX_HELPER_PORT = "57946";
    public static final int DEFAULT_UNIX_CONFIG_PORT = 58946;
    public static final String DEFAULT_UNIX_TIMEOUT = "3";
    public static final String DEFAULT_UNIX_THREADS = "5";
    public String userTokenId;
    public Principal userPrincipal = null;
    private String userName;
    public char[] passwd;
    private String serviceModule;
    private String clientIPAddr;
    public String password;
    private UnixHelper unixClient;
    private static boolean _valid = true;
    private Map options = null;

    public Unix() throws AuthLoginException {
        try {
            debug = Debug.getInstance((String)amAuthUnix);
            debug.message("Unix constructor called");
        }
        catch (Exception exception) {
            debug.error("this is an error ", (Throwable)exception);
        }
    }

    public void init_helper() throws AuthLoginException {
        try {
            this.unixClient = new UnixHelper(this.UNIX_CONFIG_PORT, amAuthUnix);
            debug.message("Re-initializing helper.");
            int n = this.unixClient.configHelper(this.str_UNIX_HELPER_PORT, this.str_UNIX_TIMEOUT, this.str_UNIX_THREADS, debug, this.bundle);
            this.unixClient.destroy(this.bundle);
            if (n != 0) {
                debug.message("Unable to contact helper to re-initialize(1).");
                throw new AuthLoginException(amAuthUnix, "UnixconfigHelper", null);
            }
            Thread.sleep(1000L);
        }
        catch (AuthLoginException authLoginException) {
            _valid = false;
            debug.message("Unable to contact helper to re-initialize(2).");
            throw new AuthLoginException(amAuthUnix, "UnixInitializeLex", null, authLoginException);
        }
        catch (Exception exception) {
            _valid = false;
            debug.message("Unable to contact helper to re-initialize(3).");
            throw new AuthLoginException(amAuthUnix, "UnixInitializeEx", null, exception);
        }
        debug.message("Re-initialized helper.");
        try {
            this.unixClient = new UnixHelper(UNIX_HELPER_PORT, amAuthUnix);
            debug.message("Re-opened auth port to helper.");
        }
        catch (AuthenticationException authenticationException) {
            _valid = false;
            debug.message("Unable to re-open auth port to helper.");
            throw new AuthLoginException(amAuthUnix, "UnixInitLex", null, (Throwable)((Object)authenticationException));
        }
    }

    public void init(Subject subject, Map map, Map map2) {
        try {
            debug = Debug.getInstance((String)amAuthUnix);
            debug.message("in initlazz...");
            Locale locale = this.getLoginLocale();
            this.bundle = AMLoginModule.amCache.getResBundle(amAuthUnix, locale);
            if (debug.messageEnabled()) {
                debug.message("Unix resource bundle locale=" + locale);
            }
            this.options = map2;
            this.serviceModule = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-unix-pam-service-name");
            debug.message("serviceModule is : " + this.serviceModule);
        }
        catch (Exception exception) {
            debug.error("Error....", (Throwable)exception);
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        char[] cArray;
        debug.message("in process...");
        this.initialize_helper();
        debug.message("initialized helper");
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        if (httpServletRequest != null) {
            this.clientIPAddr = this.getHttpServletRequest().getRemoteAddr();
            if (debug.messageEnabled()) {
                debug.message("Unix client IPAddr = " + this.clientIPAddr);
            }
        }
        if (n != 1) {
            debug.message("Inavlid login state");
            throw new AuthLoginException(amAuthUnix, "UnixInvalidState", new Object[]{new Integer(n)});
        }
        String string = ((NameCallback)callbackArray[0]).getName();
        if (debug.messageEnabled()) {
            debug.message("user is.. " + string);
        }
        if ((cArray = ((PasswordCallback)callbackArray[1]).getPassword()) == null) {
            cArray = new char[]{};
        }
        this.passwd = new char[cArray.length];
        this.password = new String(cArray);
        System.arraycopy(cArray, 0, this.passwd, 0, cArray.length);
        ((PasswordCallback)callbackArray[1]).clearPassword();
        if (string == null || string.equals("")) {
            debug.message("user id empty....");
            throw new AuthLoginException(amAuthUnix, "UnixUserIdNull", null);
        }
        try {
            if (!string.equals(new String(string.getBytes("ASCII"), "ASCII"))) {
                debug.message("enter ascii for user");
                this.setFailureID(string);
                throw new AuthLoginException(amAuthUnix, "UnixUseridNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.message("unsupported encodidng..");
            throw new AuthLoginException(amAuthUnix, "UnixInputEncodingException", null);
        }
        if (this.password == null) {
            this.password = "";
        } else {
            try {
                if (!this.password.equals(new String(this.password.getBytes("ASCII"), "ASCII"))) {
                    throw new AuthLoginException(amAuthUnix, "UnixPasswordNotASCII", null);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setFailureID(string);
                throw new AuthLoginException(amAuthUnix, "UnixInputEncodingException", null);
            }
        }
        debug.message("before calling unixClient...");
        int n2 = 0;
        try {
            if (debug.messageEnabled()) {
                debug.message("unixClient is... " + this.unixClient);
            }
            n2 = this.unixClient.authenticate(string, this.password, this.serviceModule, this.clientIPAddr, this.bundle);
            this.unixClient.destroy(this.bundle);
        }
        catch (Exception exception) {
            debug.error("Exception unixClient... :", (Throwable)exception);
        }
        if (debug.messageEnabled()) {
            debug.message("ires...... is... " + n2);
        }
        if (n2 == -1) {
            if (debug.messageEnabled()) {
                debug.message("Auth failed... : " + string);
                debug.message("Thread name " + Thread.currentThread().getName());
            }
            this.setFailureID(string);
            throw new InvalidPasswordException(amAuthUnix, "UnixLoginFailed", new Object[]{string}, string, null);
        }
        if (n2 == 2) {
            if (debug.messageEnabled()) {
                debug.message("Auth failed for user " + string + "; password expired.");
            }
            this.setFailureID(string);
            return 2;
        }
        this.userTokenId = string;
        if (debug.messageEnabled()) {
            debug.message("Authentication for " + string + " succeeded!!");
        }
        return -1;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SolarisPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void setPortValues() {
        int n;
        String string = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-unix-config-port");
        String string2 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-unix-helper-port");
        String string3 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-unix-helper-timeout");
        String string4 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-unix-helper-threads");
        try {
            this.UNIX_CONFIG_PORT = n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.UNIX_CONFIG_PORT = 58946;
        }
        try {
            n = Integer.parseInt(string2);
            this.str_UNIX_HELPER_PORT = string2;
        }
        catch (NumberFormatException numberFormatException) {
            this.str_UNIX_HELPER_PORT = DEFAULT_UNIX_HELPER_PORT;
        }
        try {
            int n2 = Integer.parseInt(string3);
            this.str_UNIX_TIMEOUT = string3;
        }
        catch (NumberFormatException numberFormatException) {
            this.str_UNIX_TIMEOUT = DEFAULT_UNIX_TIMEOUT;
        }
        try {
            int n3 = Integer.parseInt(string4);
            this.str_UNIX_THREADS = string4;
        }
        catch (NumberFormatException numberFormatException) {
            this.str_UNIX_THREADS = DEFAULT_UNIX_THREADS;
        }
    }

    public void initialize_helper() throws AuthLoginException {
        if (helper_config_done == 0) {
            try {
                this.setPortValues();
                this.unixClient = new UnixHelper(this.UNIX_CONFIG_PORT, amAuthUnix);
                int n = this.unixClient.configHelper(this.str_UNIX_HELPER_PORT, this.str_UNIX_TIMEOUT, this.str_UNIX_THREADS, debug, this.bundle);
                this.unixClient.destroy(this.bundle);
                if (n != 0) {
                    debug.error("ires error " + n);
                    throw new AuthLoginException(amAuthUnix, "UnixconfigHelper", new Object[]{new Integer(n)});
                }
                helper_config_done = 1;
                Thread.sleep(1000L);
            }
            catch (AuthenticationException authenticationException) {
                _valid = false;
                debug.error("AuthException.. inithelper", (Throwable)((Object)authenticationException));
                throw new AuthLoginException(amAuthUnix, "UnixInitializeLex", null);
            }
            catch (Exception exception) {
                debug.error("Exception.. inithelper..", (Throwable)exception);
                _valid = false;
                throw new AuthLoginException(amAuthUnix, "UnixInitializeEx", null);
            }
        }
        try {
            String string = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-unix-helper-port");
            UNIX_HELPER_PORT = Integer.parseInt(string);
            this.unixClient = new UnixHelper(UNIX_HELPER_PORT, amAuthUnix);
        }
        catch (NumberFormatException numberFormatException) {
            _valid = false;
            debug.error("Numberformatexception...", (Throwable)numberFormatException);
            throw new AuthLoginException(amAuthUnix, "UnixInitNex", null);
        }
        catch (AuthenticationException authenticationException) {
            debug.message("Unable to connect to auth port; Try init again.");
            try {
                this.init_helper();
                debug.message("Successfully re-initialized helper.");
                try {
                    this.unixClient = new UnixHelper(UNIX_HELPER_PORT, amAuthUnix);
                    debug.message("Re-opened auth port tohelper(2).");
                }
                catch (AuthenticationException authenticationException2) {
                    _valid = false;
                    debug.error("Unable to open auth port to helper(2)", (Throwable)((Object)authenticationException2));
                    throw new AuthLoginException(amAuthUnix, "UnixInitializeLex", null, (Throwable)((Object)authenticationException2));
                }
            }
            catch (AuthLoginException authLoginException) {
                _valid = false;
                debug.error("Unable to contact helper to re-init", (Throwable)authLoginException);
                throw new AuthLoginException(amAuthUnix, "UnixInitLex", null);
            }
        }
        catch (Exception exception) {
            _valid = false;
            debug.error("Exception... ", (Throwable)exception);
            throw new AuthLoginException(amAuthUnix, "UnixInitEx", null);
        }
    }
}

