/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.safeword;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.safeword.SafeWordPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import securecomputing.swec.AuthenState;
import securecomputing.swec.AuthenticatorData;
import securecomputing.swec.DynamicPwdData;
import securecomputing.swec.EasspMessage;
import securecomputing.swec.FixedPwdData;
import securecomputing.swec.SafeWordClient;
import securecomputing.swec.SwecConfig;

public class SafeWord
extends AMLoginModule {
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private static final String ATTRIBUTE_SERVER_SPECIFICATION = "iplanet-am-auth-safeword-server-specification";
    private static final String ATTRIBUTE_SYSTEM_NAME = "iplanet-am-auth-safeword-system-name";
    private static final String ATTRIBUTE_SRVR_VERIF_PATH = "iplanet-am-auth-safeword-srvr-verif-path";
    private static final String ATTRIBUTE_LOG_LEVEL = "iplanet-am-auth-safeword-log-level";
    private static final String ATTRIBUTE_LOG_PATH = "iplanet-am-auth-safeword-log-path";
    private static final String ATTRIBUTE_AUTH_LEVEL = "iplanet-am-auth-safeword-auth-level";
    private static final String DEFAULT_EASSP_VERSION = "101";
    private static final String DEFAULT_SERVER_SPECIFICATION = "localhost 7482";
    private static final String DEFAULT_SYSTEM_NAME = "STANDARD";
    private static final String DEFAULT_SRVR_VERIF_PATH = "/var/opt/SUNWam/auth/safeword/serverVerification";
    private static final String DEFAULT_LOG_PATH = "/var/opt/SUNWam/auth/safeword/safe.log";
    private String serverSpec;
    private String systemName;
    private String serverVerifFilesPath;
    private String statusLogLevel;
    private String statusLogFilePath;
    private String authLevel;
    private SafeWordClient swClient = null;
    private AuthenState aState = null;
    private String challengeID;
    private String userTokenId;
    private SafeWordPrincipal userPrincipal;
    private Map options;
    private static final int PAGE_USERNAME = 1;
    private static final int PAGE_PASSWORD = 2;
    private static final int FINISHED = -1;
    private static final String amAuthSafeWord = "amAuthSafeWord";

    public void init(Subject subject, Map map, Map map2) {
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthSafeWord, locale);
        if (debug.messageEnabled()) {
            debug.message("SafeWord resource bundle locale=" + locale);
        }
        this.options = map2;
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        try {
            if (n == 1) {
                this.initAuthConfig();
                this.userTokenId = this.getUserName(callbackArray);
                this.initSafeWordClient();
                if (this.sendRequestForChallengeID()) {
                    this.setDynamicText(2);
                }
                return 2;
            }
            if (n == 2) {
                String string = this.getPassword(callbackArray);
                this.authenticate(string);
                return -1;
            }
            debug.message("Invalid login state: " + n);
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInvalidState", new Object[]{new Integer(n)});
        }
        catch (AuthLoginException authLoginException) {
            this.setFailureID(this.userTokenId);
            throw authLoginException;
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SafeWordPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options != null) {
            this.serverSpec = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_SERVER_SPECIFICATION);
            if (this.serverSpec == null) {
                this.serverSpec = DEFAULT_SERVER_SPECIFICATION;
            }
            this.systemName = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_SYSTEM_NAME);
            if (this.systemName == null) {
                this.systemName = DEFAULT_SYSTEM_NAME;
            }
            this.serverVerifFilesPath = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_SRVR_VERIF_PATH);
            if (this.serverVerifFilesPath == null) {
                this.serverVerifFilesPath = DEFAULT_SRVR_VERIF_PATH;
            }
            this.statusLogLevel = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_LOG_LEVEL);
            this.statusLogFilePath = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_LOG_PATH);
            if (this.statusLogFilePath == null) {
                this.statusLogFilePath = DEFAULT_LOG_PATH;
            }
            this.authLevel = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_AUTH_LEVEL);
            if (debug.messageEnabled()) {
                debug.message("SafeWord Auth config parameters:\niplanet-am-auth-safeword-server-specification: " + this.serverSpec + "\n" + ATTRIBUTE_SYSTEM_NAME + ": " + this.systemName + "\n" + ATTRIBUTE_SRVR_VERIF_PATH + ": " + this.serverVerifFilesPath + "\n" + ATTRIBUTE_LOG_LEVEL + ": " + this.statusLogLevel + "\n" + ATTRIBUTE_LOG_PATH + ": " + this.statusLogFilePath + "\n" + ATTRIBUTE_AUTH_LEVEL + ": " + this.authLevel + "\n");
            }
        } else {
            debug.error("options is null");
            throw new AuthLoginException(amAuthSafeWord, "SafeWordOptInit", null);
        }
    }

    private String getUserName(Callback[] callbackArray) throws AuthLoginException {
        return ((NameCallback)callbackArray[0]).getName();
    }

    private void initSafeWordClient() throws AuthLoginException {
        SwecConfig swecConfig = new SwecConfig();
        swecConfig = new SwecConfig();
        swecConfig.setDefaults();
        swecConfig.setProperty("Eassp_Version", DEFAULT_EASSP_VERSION);
        swecConfig.setProperty("Server_Spec", this.serverSpec);
        swecConfig.setProperty("Server_Verification_Files_Path", this.serverVerifFilesPath);
        swecConfig.setProperty("Status_Log_File_Path", this.statusLogFilePath);
        if (debug.messageEnabled()) {
            debug.message("About to get new SafeWordClient");
        }
        try {
            this.swClient = new SafeWordClient(swecConfig);
            if (debug.messageEnabled()) {
                debug.message("New SafeWordClient: " + this.swClient.getResultText());
            }
        }
        catch (Exception exception) {
            debug.error("Failed to create new SafeWordClient.", (Throwable)exception);
            throw new AuthLoginException(amAuthSafeWord, "SafeWordNewSWClient", null, exception);
        }
        debug.message("Done init new SafeWordClient");
    }

    private boolean sendRequestForChallengeID() throws AuthLoginException {
        if (this.userTokenId == null || this.userTokenId.equals("")) {
            this.swClient.close();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordUserIdNull", null);
        }
        try {
            if (!this.userTokenId.equals(new String(this.userTokenId.getBytes("ASCII"), "ASCII"))) {
                this.swClient.close();
                throw new AuthLoginException(amAuthSafeWord, "SafeWordUseridNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.swClient.close();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInputEncodingException", null);
        }
        EasspMessage easspMessage = this.swClient.createRequestMsg(this.userTokenId, "name");
        if (debug.messageEnabled()) {
            debug.message("Submitting requestMsg for userID: " + this.userTokenId);
        }
        EasspMessage easspMessage2 = this.swClient.sendMessage(easspMessage);
        String string = easspMessage2.getIdData();
        String string2 = easspMessage2.getStatusText();
        switch (easspMessage2.getMessageType()) {
            case 1: {
                if (debug.messageEnabled()) {
                    debug.message("Received challenge to auth request by " + string);
                }
                EasspMessage easspMessage3 = easspMessage2;
                this.aState = new AuthenState(easspMessage3);
                AuthenticatorData authenticatorData = this.aState.getCurrentAuthenticator();
                try {
                    if (authenticatorData instanceof FixedPwdData) {
                        debug.message("Current Authenticator Fixed Password");
                        return false;
                    }
                    if (authenticatorData instanceof DynamicPwdData) {
                        debug.message("Current Authenticator Dynamic Password");
                        DynamicPwdData dynamicPwdData = (DynamicPwdData)authenticatorData;
                        this.challengeID = dynamicPwdData.getChallenge();
                        return true;
                    }
                }
                catch (Exception exception) {
                    debug.error("Received Non-Dynamic Authenticator");
                    this.setFailureID(this.userTokenId);
                    this.swClient.close();
                    throw new AuthLoginException(amAuthSafeWord, "SafeWordUnsupportedAuthenticator", null, exception);
                }
            }
            case 3: {
                this.swClient.close();
                if (easspMessage2.passedCheck()) {
                    debug.error("Successful Authentication, but only id sent. Msg: " + string2);
                    this.setFailureID(this.userTokenId);
                    throw new AuthLoginException(amAuthSafeWord, "SafeWordSuccessOnlyUserID", new Object[]{string2});
                }
                debug.error("Authentication Failed, only id sent. Check for lockout on server. Msg: " + string2);
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthSafeWord, "SafeWordLoginFailed", new Object[]{string2});
            }
        }
        this.swClient.close();
        this.setFailureID(this.userTokenId);
        debug.error("Authentication Failed, unknown return value: " + easspMessage2.getMessageType());
        throw new AuthLoginException(amAuthSafeWord, "SafeWordLoginFailedUnknown", new Object[]{string2});
    }

    private void setDynamicText(int n) throws AuthLoginException {
        Callback[] callbackArray = this.getCallback(n);
        String string = ((PasswordCallback)callbackArray[0]).getPrompt();
        boolean bl = ((PasswordCallback)callbackArray[0]).isEchoOn();
        if (debug.messageEnabled()) {
            debug.message("Set dynamic text: challengeID: " + this.challengeID);
        }
        if (this.challengeID != null) {
            string = string + "[" + this.challengeID + "]: ";
        }
        callbackArray[0] = new PasswordCallback(string, bl);
        this.replaceCallback(n, 0, callbackArray[0]);
    }

    private String getPassword(Callback[] callbackArray) throws AuthLoginException {
        char[] cArray = ((PasswordCallback)callbackArray[0]).getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callbackArray[0]).clearPassword();
        return new String(cArray2);
    }

    private void authenticate(String string) throws AuthLoginException {
        FixedPwdData fixedPwdData;
        if (string == null || string.equals("")) {
            if (debug.messageEnabled()) {
                debug.message(this.userTokenId + " supplied no challenge response");
            }
            this.swClient.close();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordNoChallRsp", null);
        }
        try {
            if (!string.equals(new String(string.getBytes("ASCII"), "ASCII"))) {
                this.swClient.close();
                throw new AuthLoginException(amAuthSafeWord, "SafeWordChalRspNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.swClient.close();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInputEncodingException", null);
        }
        int n = this.aState.getAuthenComboCount();
        if (n > 1 && debug.messageEnabled()) {
            debug.message("Authenticator Combo (" + n + " authenticators) not supported");
        }
        if (debug.messageEnabled()) {
            debug.message("Anthenticator Combo count = " + n);
        }
        AuthenticatorData authenticatorData = this.aState.getCurrentAuthenticator();
        debug.message("Checking challenge response return message type");
        try {
            if (authenticatorData instanceof FixedPwdData) {
                fixedPwdData = (FixedPwdData)authenticatorData;
                fixedPwdData.setPwd(string);
            } else if (authenticatorData instanceof DynamicPwdData) {
                fixedPwdData = (DynamicPwdData)authenticatorData;
                fixedPwdData.setPwd(string);
            }
        }
        catch (Exception exception) {
            this.swClient.close();
            debug.error("Received unknown Authenticator");
            throw new AuthLoginException(amAuthSafeWord, "SafeWordUnsupportedAuthenticator", null, exception);
        }
        debug.message("Challenge response return message type Dynamic");
        fixedPwdData = this.swClient.createResponseMsg(this.aState);
        debug.message("After creating new responseMsg");
        EasspMessage easspMessage = this.swClient.sendMessage((EasspMessage)fixedPwdData);
        debug.message("After creating new returnMsg");
        String string2 = easspMessage.getIdData();
        String string3 = easspMessage.getStatusText();
        if (debug.messageEnabled()) {
            debug.message("Challenge response returns '" + string3 + "' for userid " + string2);
        }
        this.swClient.close();
        if (easspMessage.passedCheck()) {
            if (debug.messageEnabled()) {
                debug.message("Authentication successful for userid = " + this.userTokenId + ", id = " + string2);
            }
        } else {
            debug.error("SafeWord authentication failed for userid = " + this.userTokenId + ", id = " + string2);
            throw new InvalidPasswordException(amAuthSafeWord, "SafeWordChallFailed", null, this.userTokenId, null);
        }
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthSafeWord);
        }
    }
}

