/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.controls.LDAPPasswordExpiredControl;
import netscape.ldap.controls.LDAPPasswordExpiringControl;
import netscape.ldap.util.ConnectionPool;

public class LDAPAuthUtils {
    private boolean returnUserDN = true;
    private String authDN = "";
    private Set userSearchAttrs = null;
    private String searchFilter = "";
    private String userNamingValue = null;
    private String userNamingAttr = null;
    private String ssl;
    private String baseDN;
    private String serverHost;
    private String secServerHost;
    private int serverPort = 389;
    private int secServerPort;
    private String userDN;
    private String userPassword;
    private String userId;
    private String authPassword = "";
    private String expiryTime;
    private int searchScope = 2;
    private int screenState;
    private int version = 3;
    private static Debug debug;
    private boolean ldapSSL = false;
    private ResourceBundle bundle;
    static final int USER_NOT_FOUND = 1;
    static final int PASSWORD_EXP = 2;
    static final int PASSWORD_INVALID = 3;
    static final int CONFIG_ERROR = 4;
    static final int CANNOT_CONTACT_SERVER = 5;
    static final int PASSWORD_EXPIRED_STATE = 20;
    static final int PASSWORD_EXPIRING = 21;
    static final int PASSWORD_CHANGED = 22;
    static final int PASSWORD_MISMATCH = 23;
    static final int PASSWORD_USERNAME_SAME = 24;
    static final int PASSWORD_NOT_UPDATE = 25;
    static final int SUCCESS = 26;
    static final int WRONG_PASSWORD_ENTERED = 27;
    static final int PASSWORD_UPDATED_SUCCESSFULLY = 28;
    static final int USER_PASSWORD_SAME = 29;
    static final int PASSWORD_MIN_CHARACTERS = 30;
    static final int SERVER_DOWN = 31;
    static final int PASSWORD_RESET_STATE = 32;
    private static HashMap connectionPools;
    private ConnectionPool cPool = null;
    private static final int NO_PASSWORD_CONTROLS = 0;
    private static final int PASSWORD_EXPIRED = -1;
    private static final int MIN_CONNECTION_POOL_SIZE = 1;
    private static final int MAX_CONNECTION_POOL_SIZE = 10;
    private static final String CONNECTION_POOL_SIZE_ATTR = "iplanet-am-auth-ldap-connection-pool-size";
    private static final String CONNECTION_POOL_DEFAULT_SIZE_ATTR = "iplanet-am-auth-ldap-connection-pool-default-size";
    private static int minDefaultPoolSize;
    private static int maxDefaultPoolSize;
    private static Set poolSize;
    private Set userAttributes = new HashSet();
    private Map userAttributeValues = new HashMap();

    public LDAPAuthUtils() throws LDAPUtilException {
    }

    public LDAPAuthUtils(String string, int n, boolean bl, ResourceBundle resourceBundle) throws LDAPUtilException {
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthLDAP");
        }
        this.bundle = resourceBundle;
        this.serverHost = string;
        this.serverPort = n;
        this.ldapSSL = bl;
        if (this.serverHost.length() < 1) {
            debug.message("Invalid host name");
            throw new LDAPUtilException("HostInvalid", (Object[])null);
        }
    }

    private void createConnectionPool() throws LDAPException {
        block19: {
            try {
                Object object;
                Object object2;
                String string = InetAddress.getByName(this.serverHost).getHostAddress();
                String string2 = string + ":" + this.serverPort;
                this.cPool = (ConnectionPool)connectionPools.get(string2);
                if (this.cPool != null) break block19;
                if (debug.messageEnabled()) {
                    debug.message("Create ConnectionPool: " + this.serverHost + ":" + this.serverPort);
                }
                int n = minDefaultPoolSize;
                int n2 = maxDefaultPoolSize;
                if (poolSize != null && !poolSize.isEmpty()) {
                    object2 = null;
                    object = null;
                    Iterator iterator = poolSize.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                        if (stringTokenizer.countTokens() != 4) continue;
                        String string4 = stringTokenizer.nextToken();
                        String string5 = null;
                        try {
                            string5 = InetAddress.getByName(string4).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue;
                        }
                        String string6 = stringTokenizer.nextToken();
                        if (!string2.equals(string5 + ":" + string6)) continue;
                        object2 = stringTokenizer.nextToken();
                        object = stringTokenizer.nextToken();
                        break;
                    }
                    if (object2 != null) {
                        try {
                            n = Integer.parseInt((String)object2);
                            n2 = Integer.parseInt(object);
                            if (n2 < n) {
                                debug.error("ldap connection pool max size is less than min size");
                                n = minDefaultPoolSize;
                                n2 = maxDefaultPoolSize;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            debug.error("Invalid ldap connection pool size", (Throwable)numberFormatException);
                            n = minDefaultPoolSize;
                            n2 = maxDefaultPoolSize;
                        }
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("LDAPAuthUtils.LDAPAuthUtils: min=" + n + ", max=" + n2);
                }
                object2 = connectionPools;
                synchronized (object2) {
                    this.cPool = (ConnectionPool)connectionPools.get(string2);
                    if (this.cPool == null) {
                        object = this.ldapSSL ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
                        ((LDAPConnection)object).connect(string, this.serverPort);
                        this.cPool = new ConnectionPool(n, n2, (LDAPConnection)object);
                        connectionPools.put(string2, this.cPool);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                throw lDAPException;
            }
            catch (UnknownHostException unknownHostException) {
                throw new LDAPUtilException("UnknownHost", new Object[]{this.serverHost});
            }
            catch (Exception exception) {
                if (debug.messageEnabled()) {
                    debug.message("Unable to create ConnectionPool", (Throwable)exception);
                }
                throw new LDAPUtilException(exception);
            }
        }
    }

    public LDAPAuthUtils(String string, int n, boolean bl, ResourceBundle resourceBundle, String string2) throws LDAPUtilException {
        this(string, n, bl, resourceBundle);
        this.baseDN = string2;
        if (this.baseDN.length() < 1) {
            debug.message("Invalid  search Base");
            throw new LDAPUtilException("SchBaseInvalid", (Object[])null);
        }
    }

    protected void setDefaultReferralCredentials(LDAPConnection lDAPConnection) {
        final LDAPConnection lDAPConnection2 = lDAPConnection;
        LDAPRebind lDAPRebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String string, int n) {
                return new LDAPRebindAuth(lDAPConnection2.getAuthenticationDN(), lDAPConnection2.getAuthenticationPassword());
            }
        };
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setReferrals(true);
        lDAPSearchConstraints.setRebindProc(lDAPRebind);
        lDAPConnection.setSearchConstraints(lDAPSearchConstraints);
    }

    public void authenticateUser(String string, String string2) throws LDAPUtilException {
        if (string2 == null || string2.equals("")) {
            throw new LDAPUtilException("PwdInvalid", 49, null);
        }
        this.userId = string;
        this.userPassword = string2;
        this.searchForUser();
        if (this.screenState == 31 || this.screenState == 1) {
            return;
        }
        this.authenticate();
    }

    private LDAPConnection getConnection() throws LDAPException {
        if (this.cPool == null) {
            this.createConnectionPool();
        }
        LDAPConnection lDAPConnection = this.cPool.getConnection();
        return lDAPConnection;
    }

    private void releaseConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return;
        }
        this.cPool.close(lDAPConnection);
    }

    public void authenticateSuperAdmin(String string, String string2, String string3) throws LDAPUtilException {
        if (string2 == null || string2.equals("")) {
            throw new LDAPUtilException("PwdInvalid", 49, null);
        }
        this.userDN = string3;
        this.userPassword = string2;
        this.authenticate();
        this.userId = string;
    }

    public void changePassword(String string, String string2, String string3) throws LDAPUtilException {
        if (string2.equals(string)) {
            this.setState(27);
            return;
        }
        if (!string2.equals(string3)) {
            this.setState(23);
            return;
        }
        if (string2.equals(this.userId)) {
            this.setState(29);
            return;
        }
        LDAPConnection lDAPConnection = null;
        try {
            try {
                lDAPConnection = this.getConnection();
                lDAPConnection.authenticate(this.userDN, string);
                this.setDefaultReferralCredentials(lDAPConnection);
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute("userpassword", string2);
                lDAPModificationSet.add(2, lDAPAttribute);
                lDAPConnection.modify(this.userDN, lDAPModificationSet);
                this.setState(28);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 19) {
                    this.setState(30);
                } else {
                    if (lDAPException.getLDAPResultCode() == 91 || lDAPException.getLDAPResultCode() == 81 || lDAPException.getLDAPResultCode() == 52) {
                        if (debug.messageEnabled()) {
                            debug.message("changepassword:Cannot connect to " + this.serverHost + ": ", (Throwable)lDAPException);
                        }
                        this.setState(31);
                        Object var8_9 = null;
                        this.releaseConnection(lDAPConnection);
                        return;
                    }
                    this.setState(25);
                }
                debug.error("Cannot update : ", (Throwable)lDAPException);
                Object var8_10 = null;
                this.releaseConnection(lDAPConnection);
            }
            Object var8_8 = null;
            this.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
    }

    private String buildUserFilter() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("(");
        if (this.userSearchAttrs.size() == 1) {
            stringBuffer.append((String)this.userSearchAttrs.iterator().next());
            stringBuffer.append("=");
            stringBuffer.append(this.userId);
        } else {
            stringBuffer.append("|");
            Iterator iterator = this.userSearchAttrs.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("(");
                stringBuffer.append((String)iterator.next());
                stringBuffer.append("=");
                stringBuffer.append(this.userId);
                stringBuffer.append(")");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void searchForUser() throws LDAPUtilException {
        StringBuffer stringBuffer;
        if (this.searchScope == 0) {
            this.userDN = (String)this.userSearchAttrs.iterator().next() + "=" + this.userId + "," + this.baseDN;
            if (debug.messageEnabled()) {
                debug.message("searchForUser, searchScope = BASE, userDN = " + this.userDN);
            }
            if (this.userAttributes == null || this.userAttributes.isEmpty()) {
                debug.message("userAttribute is null");
                return;
            }
            this.baseDN = this.userDN;
        }
        if (this.searchFilter == null || this.searchFilter.equals("")) {
            this.searchFilter = this.buildUserFilter();
        } else {
            stringBuffer = new StringBuffer(200);
            stringBuffer.append("(&");
            stringBuffer.append(this.buildUserFilter());
            stringBuffer.append(this.searchFilter);
            stringBuffer.append(")");
            this.searchFilter = stringBuffer.toString();
        }
        stringBuffer = null;
        this.userDN = null;
        LDAPConnection lDAPConnection = null;
        try {
            try {
                int n;
                Object object;
                String[] stringArray;
                if (debug.messageEnabled()) {
                    debug.message("Connecting to " + this.serverHost + ":" + this.serverPort + "\nSearching " + this.baseDN + " for " + this.searchFilter + "\nscope = " + this.searchScope);
                }
                lDAPConnection = this.getConnection();
                lDAPConnection.authenticate(this.authDN, this.authPassword);
                int n2 = 0;
                if (this.userAttributes == null || this.userAttributes.isEmpty()) {
                    n2 = 2;
                    stringArray = new String[n2];
                    stringArray[0] = "dn";
                    stringArray[1] = this.userNamingAttr;
                } else {
                    n2 = this.userAttributes.size();
                    stringArray = new String[n2 + 2];
                    stringArray[0] = "dn";
                    stringArray[1] = this.userNamingAttr;
                    object = this.userAttributes.iterator();
                    n = 2;
                    while (n < n2 + 2) {
                        stringArray[n] = (String)object.next();
                        ++n;
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("userAttrSize is : " + n2);
                }
                object = lDAPConnection.search(this.baseDN, this.searchScope, this.searchFilter, stringArray, false);
                n = 0;
                LDAPEntry lDAPEntry = null;
                while (((LDAPSearchResults)object).hasMoreElements()) {
                    try {
                        lDAPEntry = ((LDAPSearchResults)object).next();
                        this.userDN = lDAPEntry.getDN();
                        ++n;
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                        continue;
                    }
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.userNamingAttr);
                    if (lDAPAttribute != null) {
                        this.userNamingValue = lDAPAttribute.getStringValueArray()[0];
                    }
                    if (stringArray == null || stringArray.length <= 2) continue;
                    int n3 = 2;
                    while (n3 < n2 + 2) {
                        lDAPAttribute = lDAPEntry.getAttribute(stringArray[n3]);
                        if (lDAPAttribute != null) {
                            HashSet<String> hashSet = new HashSet<String>();
                            int n4 = 0;
                            while (n4 < lDAPAttribute.size()) {
                                hashSet.add(lDAPAttribute.getStringValueArray()[n4]);
                                ++n4;
                            }
                            this.userAttributeValues.put(stringArray[n3], hashSet);
                        }
                        ++n3;
                    }
                }
                if (this.userDN == null || this.userNamingValue == null) {
                    if (debug.messageEnabled()) {
                        debug.message("Cannot find entries for " + this.searchFilter);
                    }
                    this.setState(1);
                    Object var13_14 = null;
                    this.releaseConnection(lDAPConnection);
                    return;
                }
                if (n > 1) {
                    debug.error("searchForUser : Multiple matches found for user '" + this.userId + "'. Please modify search start DN/filter/scope " + "to make sure unique match returned. Contact your " + "administrator to fix the problem");
                    throw new LDAPUtilException("multipleUserMatchFound", (Object[])null);
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 91 || lDAPException.getLDAPResultCode() == 81 || lDAPException.getLDAPResultCode() == 52) {
                    if (debug.messageEnabled()) {
                        debug.message("Cannot connect to " + this.serverHost + ": ", (Throwable)lDAPException);
                    }
                    this.setState(31);
                    Object var13_16 = null;
                    this.releaseConnection(lDAPConnection);
                    return;
                }
                if (lDAPException.getLDAPResultCode() == 49) {
                    debug.message("Cannot authenticate ");
                    throw new LDAPUtilException("FConnect", 49, null);
                }
                if (lDAPException.getLDAPResultCode() == 53) {
                    debug.message("Account Inactivated or Locked ");
                    throw new LDAPUtilException("FConnect", 53, null);
                }
                if (lDAPException.getLDAPResultCode() == 32) {
                    throw new LDAPUtilException("noUserMatchFound", 32, null);
                }
                debug.message("Exception while searching", (Throwable)lDAPException);
                this.setState(1);
                Object var13_17 = null;
                this.releaseConnection(lDAPConnection);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var13_15 = null;
        this.releaseConnection(lDAPConnection);
    }

    /*
     * Unable to fully structure code
     */
    private void authenticate() throws LDAPUtilException {
        var1_1 = null;
        try {
            block19: {
                try {
                    var1_1 = this.getConnection();
                    var1_1.authenticate(this.version, this.userDN, this.userPassword);
                    if (var1_1 == null) break block19;
                    var2_2 = this.checkControls(var1_1);
                    switch (var2_2) {
                        case 0: {
                            LDAPAuthUtils.debug.message("No controls returned");
                            this.setState(26);
                            ** break;
                        }
                        case -1: {
                            if (LDAPAuthUtils.debug.messageEnabled()) {
                                LDAPAuthUtils.debug.message("Password expired and must be reset");
                            }
                            this.setState(32);
                            ** break;
                        }
                        default: {
                            this.setExpTime(var2_2);
                            if (LDAPAuthUtils.debug.messageEnabled()) {
                                LDAPAuthUtils.debug.message("Password expires in " + var2_2 + " seconds");
                            }
                            this.setState(21);
                        }
                    }
                }
                catch (LDAPException var2_3) {
                    if (var2_3.getLDAPResultCode() == 49) {
                        if (this.checkControls(var1_1) == -1) {
                            if (LDAPAuthUtils.debug.messageEnabled()) {
                                LDAPAuthUtils.debug.message("Password expired and must be reset");
                            }
                            this.setState(20);
                            var4_5 = null;
                            this.releaseConnection(var1_1);
                            return;
                        }
                        LDAPAuthUtils.debug.message("Failed auth due to invalid credentials");
                        throw new LDAPUtilException("CredInvalid", 49, null);
                    }
                    if (var2_3.getLDAPResultCode() == 32) {
                        LDAPAuthUtils.debug.message("user does not exist");
                        throw new LDAPUtilException("UsrNotExist", 32, null);
                    }
                    if (var2_3.getLDAPResultCode() == 91 || var2_3.getLDAPResultCode() == 81 || var2_3.getLDAPResultCode() == 52) {
                        if (LDAPAuthUtils.debug.messageEnabled()) {
                            LDAPAuthUtils.debug.message("Cannot connect to " + this.serverHost + ": ", (Throwable)var2_3);
                        }
                        this.setState(31);
                        var4_6 = null;
                        this.releaseConnection(var1_1);
                        return;
                    }
                    if (var2_3.getLDAPResultCode() == 53) {
                        LDAPAuthUtils.debug.message("Account Inactivated or Locked ");
                        throw new LDAPUtilException("FConnect", 53, null);
                    }
                    if (var2_3.getLDAPResultCode() == 48) {
                        LDAPAuthUtils.debug.message("Failed auth due to inappropriate authentication");
                        throw new LDAPUtilException("InappAuth", 48, null);
                    }
                    if (LDAPAuthUtils.debug.messageEnabled()) {
                        LDAPAuthUtils.debug.message("Cannot authenticate to " + this.serverHost + ": ", (Throwable)var2_3);
                        throw new LDAPUtilException("FAuth", (Object[])null);
                    }
                    var4_7 = null;
                    this.releaseConnection(var1_1);
                }
lbl58:
                // 3 sources

            }
            var4_4 = null;
            this.releaseConnection(var1_1);
        }
        catch (Throwable var3_9) {
            var4_8 = null;
            this.releaseConnection(var1_1);
            throw var3_9;
        }
    }

    private int checkControls(LDAPConnection lDAPConnection) {
        block7: {
            LDAPControl[] lDAPControlArray = lDAPConnection.getResponseControls();
            boolean bl = false;
            if (lDAPControlArray != null && lDAPControlArray.length >= 1) {
                LDAPPasswordExpiringControl lDAPPasswordExpiringControl = null;
                int n = 0;
                while (n < lDAPControlArray.length) {
                    if (lDAPControlArray[n] instanceof LDAPPasswordExpiredControl) {
                        return -1;
                    }
                    if (lDAPControlArray[n] instanceof LDAPPasswordExpiringControl) {
                        lDAPPasswordExpiringControl = (LDAPPasswordExpiringControl)lDAPControlArray[n];
                    }
                    ++n;
                }
                if (lDAPPasswordExpiringControl != null) {
                    try {
                        return lDAPPasswordExpiringControl.getSecondsToExpiration();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!debug.messageEnabled()) break block7;
                        debug.message("Unexpected message <" + lDAPPasswordExpiringControl.getMessage() + "> in password expiring control");
                    }
                }
            }
        }
        return 0;
    }

    public String getUserId() {
        if (this.returnUserDN) {
            return this.userDN;
        }
        return this.userNamingValue;
    }

    public String getUserId(String string) {
        String string2 = this.getUserId();
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public void setUserNamingAttribute(String string) throws LDAPUtilException {
        if (string == null || string.length() < 1) {
            throw new LDAPUtilException("UNAttr", (Object[])null);
        }
        this.userNamingAttr = string;
    }

    public void setUserSearchAttribute(Set set) throws LDAPUtilException {
        if (set == null || set.isEmpty()) {
            throw new LDAPUtilException("USchAttr", (Object[])null);
        }
        this.userSearchAttrs = set;
    }

    public void setFilter(String string) {
        this.searchFilter = string;
    }

    public void setBase(String string) {
        this.baseDN = string;
    }

    private void setAuthProtocol(String string) {
        this.ssl = string;
    }

    public void setAuthDN(String string) {
        this.authDN = string;
    }

    public void setAuthPassword(String string) {
        this.authPassword = string;
    }

    public void setScope(int n) {
        this.searchScope = n;
    }

    public int getState() {
        return this.screenState;
    }

    public void setState(int n) {
        this.screenState = n;
    }

    private void setExpTime(int n) {
        this.expiryTime = null;
        int n2 = n / 86400;
        int n3 = n % 86400 / 3600;
        int n4 = n % 3600 / 60;
        int n5 = n % 60;
        if (n3 <= 0 && n4 <= 0 && n5 <= 0) {
            this.expiryTime = n2 + " days: ";
            return;
        }
        String string = this.bundle.getString("days");
        String string2 = this.bundle.getString("hours");
        String string3 = this.bundle.getString("minutes");
        String string4 = this.bundle.getString("seconds");
        this.expiryTime = n2 + " " + string + ": " + n3 + " " + string2 + ": " + n4 + " " + string3 + ": " + n5 + " " + string4;
    }

    public String getExpTime() {
        return this.expiryTime;
    }

    public boolean isServerRunning(String string, int n) {
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this.ldapSSL ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
            lDAPConnection.connect(string, n);
        }
        catch (Exception exception) {
            debug.message("Primary Server is not running");
        }
        return lDAPConnection.isConnected();
    }

    public void setReturnUserDN(String string) {
        this.returnUserDN = string.equalsIgnoreCase("true");
    }

    public void setUserAttributes(Set set) {
        this.userAttributes = set;
    }

    public Map getUserAttributeValues() {
        return this.userAttributeValues;
    }

    static {
        block8: {
            debug = null;
            connectionPools = new HashMap();
            minDefaultPoolSize = 1;
            maxDefaultPoolSize = 10;
            poolSize = null;
            debug = Debug.getInstance((String)"amAuthLDAP");
            SSOToken sSOToken = null;
            try {
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                String string = (String)AccessController.doPrivileged(new AdminDNAction());
                String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
                sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthService", sSOToken);
                ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
                Map map = serviceSchema.getAttributeDefaults();
                poolSize = (Set)map.get(CONNECTION_POOL_SIZE_ATTR);
                String string3 = Misc.getMapAttr((Map)map, (String)CONNECTION_POOL_DEFAULT_SIZE_ATTR, (String)"");
                int n = string3.indexOf(":");
                if (n != -1) {
                    try {
                        minDefaultPoolSize = Integer.parseInt(string3.substring(0, n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        debug.error("Invalid ldap connection pool min size", (Throwable)numberFormatException);
                    }
                    try {
                        maxDefaultPoolSize = Integer.parseInt(string3.substring(n + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        debug.error("Invalid ldap connection pool max size", (Throwable)numberFormatException);
                    }
                    if (maxDefaultPoolSize < minDefaultPoolSize) {
                        debug.error("ldap connection pool max size is less than min size");
                        minDefaultPoolSize = 1;
                        maxDefaultPoolSize = 10;
                    }
                    break block8;
                }
                debug.error("Invalid ldap connection pool size");
            }
            catch (Exception exception) {
                debug.error("Unable to get ldap connection pool size", (Throwable)exception);
            }
        }
    }
}

