/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.sm.ServiceConfig;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class LDAP
extends AMLoginModule {
    ResourceBundle bundle = null;
    private static Debug debug = null;
    private String validatedUserID;
    private static String adminDN;
    private static String hostName;
    private static boolean ldapSSL;
    private String userName;
    private String userPassword;
    private String regEx;
    private Map sharedState;
    private Map currentConfig;
    private String currentConfigName;
    private Iterator subConfigNamesIter = null;
    private ServiceConfig sc;
    private boolean firstTry = true;
    private int currentState;
    private boolean primary = true;
    private int previousScreen;
    private static int port;
    private final int FINISHED = -1;
    private final int LOGIN = 1;
    private final int PASSWORD_CHANGE = 2;
    private final int PASSWORD_EXPIRED_SCREEN = 3;
    private final int USER_INACTIVE = 4;
    private LDAPAuthUtils ldapUtil;
    private LDAPPrincipal userPrincipal;
    private static HashMap orgMap;
    private volatile FailbackManager fMgr;
    private boolean isReset;
    private static final long DEFAULT_SERVER_CHECK_INTERVAL = 15L;
    private static long interval;
    private String serverHost = null;
    private int serverPort = 389;
    private int primaryServerPort;
    private String primaryServerHost;
    private Set userCreationAttrs = new HashSet();
    private static final String USER_CREATION_ATTR = "iplanet-am-ldap-user-creation-attr-list";
    private static final String INVALID_CHARS = "iplanet-am-auth-ldap-invalid-chars";
    private HashMap userAttrMap = new HashMap();
    private static final String PIPE_SEPARATOR = "|";
    private static final String amAuthLDAP = "amAuthLDAP";
    private static final String DEFAULT_REG_EX = "*|(|)|&|!";

    public void init(Subject subject, Map map, Map map2) {
        this.sc = (ServiceConfig)map2.get("ServiceConfig");
        this.currentConfig = this.sc.getAttributes();
        this.currentConfigName = "default";
        this.primary = this.getPrimaryFlag(this.currentConfigName);
        java.util.Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthLDAP, locale);
        if (debug.messageEnabled()) {
            debug.message("LDAP resbundle locale=" + locale);
        }
    }

    public boolean initializeLDAP() throws AuthLoginException {
        block20: {
            debug.message("LDAP initialize()");
            try {
                String string;
                if (this.currentConfig == null) break block20;
                try {
                    string = "iplanet-am-auth-ldap-server-check";
                    interval = Long.parseLong(Misc.getServerMapAttr((Map)this.currentConfig, (String)string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (debug.messageEnabled()) {
                        debug.message("Server Check Interval is not set.\nSetting it to default value 15 min");
                    }
                    interval = 15L;
                }
                this.setInterval(interval);
                if (this.primary) {
                    if (this.fMgr != null && this.fMgr.isAlive()) {
                        this.fMgr = null;
                    }
                    this.serverHost = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server");
                    if (this.serverHost == null) {
                        debug.message("No primary server for confing " + this.currentConfigName);
                        return false;
                    }
                } else {
                    this.serverHost = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server2");
                    if (this.serverHost == null) {
                        debug.message("No secondary server for confing " + this.currentConfigName);
                        return false;
                    }
                }
                if ((string = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-base-dn")) == null) {
                    debug.error("Fatal error: baseDN for search has invalid value");
                }
                String string2 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-dn", (String)"");
                String string3 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-passwd", (String)"");
                String string4 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-user-naming-attribute", (String)"uid");
                Set set = (Set)this.currentConfig.get("iplanet-am-auth-ldap-user-search-attributes");
                String string5 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-filter", (String)"");
                boolean bl = Boolean.valueOf(Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-ssl-enabled", (String)"false"));
                this.getUserCreationAttrs(this.currentConfig);
                String string6 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-scope", (String)"SUBTREE");
                String string7 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-auth-level");
                if (string7 != null) {
                    try {
                        this.setAuthLevel(Integer.parseInt(string7));
                    }
                    catch (Exception exception) {
                        debug.error("Unable to set auth level " + string7, (Throwable)exception);
                    }
                }
                int n = 2;
                if (string6.equalsIgnoreCase("OBJECT")) {
                    n = 0;
                } else if (string6.equalsIgnoreCase("ONELEVEL")) {
                    n = 1;
                }
                String string8 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-return-user-dn", (String)"true");
                this.regEx = Misc.getMapAttr((Map)this.currentConfig, (String)INVALID_CHARS, (String)DEFAULT_REG_EX);
                int n2 = this.serverHost.indexOf(58);
                int n3 = 389;
                String string9 = null;
                if (n2 != -1) {
                    string9 = this.serverHost.substring(n2 + 1);
                    n3 = Integer.parseInt(string9);
                    this.serverHost = this.serverHost.substring(0, n2);
                }
                if (this.primary) {
                    this.primaryServerHost = this.serverHost;
                    this.primaryServerPort = n3;
                }
                this.ldapUtil = new LDAPAuthUtils(this.serverHost, n3, bl, this.bundle, string);
                this.ldapUtil.setScope(n);
                this.ldapUtil.setFilter(string5);
                this.ldapUtil.setUserNamingAttribute(string4);
                this.ldapUtil.setUserSearchAttribute(set);
                this.ldapUtil.setAuthPassword(string3);
                this.ldapUtil.setAuthDN(string2);
                this.ldapUtil.setReturnUserDN(string8);
                this.ldapUtil.setUserAttributes(this.userCreationAttrs);
                if (debug.messageEnabled()) {
                    debug.message("bindDN-> " + string2 + "\nbaseDN-> " + string + "\nuserNamingAttr-> " + string4 + "\nuserSearchAttr(s)-> " + set + "\nuserCreationAttrs-> " + this.userCreationAttrs + "\nsearchFilter-> " + string5 + "\nsearchScope-> " + n + "\nssl-> " + bl + "\nauthLevel: " + string7 + "\nHost: " + this.serverHost + "\nPORT : " + n3 + "\nPattern : " + this.regEx);
                }
                return true;
            }
            catch (Exception exception) {
                debug.error("Init Exception", (Throwable)exception);
                throw new AuthLoginException(amAuthLDAP, "LDAPex", null, exception);
            }
        }
        return false;
    }

    private boolean getPrimaryFlag(String string) {
        HashMap hashMap = orgMap;
        synchronized (hashMap) {
            String string2 = this.getRequestOrg();
            HashMap<String, String> hashMap2 = (HashMap<String, String>)orgMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, String>();
                hashMap2.put(string, "true");
                orgMap.put(string2, hashMap2);
                boolean bl = true;
                return bl;
            }
            String string3 = (String)hashMap2.get(string);
            if (string3 == null) {
                hashMap2.put(string, "true");
                boolean bl = true;
                return bl;
            }
            boolean bl = string3.equals("true");
            return bl;
        }
    }

    private void setPrimaryFlag(String string, boolean bl) {
        HashMap hashMap = orgMap;
        synchronized (hashMap) {
            String string2 = this.getRequestOrg();
            HashMap<String, String> hashMap2 = (HashMap<String, String>)orgMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, String>();
                orgMap.put(string2, hashMap2);
            }
            if (bl) {
                hashMap2.put(string, "true");
            } else {
                hashMap2.put(string, "false");
            }
        }
    }

    private boolean getSubConfig() {
        block6: {
            this.firstTry = true;
            try {
                Object object;
                if (this.subConfigNamesIter == null) {
                    object = this.sc.getSubConfigNames();
                    if (object == null || object.size() == 0) {
                        return false;
                    }
                    this.subConfigNamesIter = object.iterator();
                }
                while (this.subConfigNamesIter.hasNext()) {
                    object = (String)this.subConfigNamesIter.next();
                    ServiceConfig serviceConfig = this.sc.getSubConfig((String)object);
                    if (serviceConfig == null) continue;
                    if (debug.messageEnabled()) {
                        debug.message("LDAP.getSubConfig subConfigName = " + (String)object);
                    }
                    this.currentConfig = serviceConfig.getAttributes();
                    this.currentConfigName = object;
                    this.primary = this.getPrimaryFlag((String)object);
                    return true;
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block6;
                debug.warning("LDAP.getSubConfig unable to get sub config", (Throwable)exception);
            }
        }
        return false;
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        this.currentState = n;
        debug.message("currentState : " + n);
        int n2 = 0;
        try {
            if (this.currentState == 1) {
                this.userName = ((NameCallback)callbackArray[0]).getName();
                this.userPassword = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
                debug.message("you are in LoginScreen:" + this.currentState);
                if (this.isSuperAdmin(this.userName)) {
                    this.ldapUtil = new LDAPAuthUtils(hostName, port, ldapSSL, this.bundle);
                    this.ldapUtil.authenticateSuperAdmin(this.userName, this.userPassword, adminDN);
                    if (this.ldapUtil.getState() == 26) {
                        this.validatedUserID = adminDN;
                        return -1;
                    }
                    debug.message("Invalid adminID or admin Password");
                    this.setFailureID(this.ldapUtil.getUserId(this.userName));
                    throw new AuthLoginException(amAuthLDAP, "InvalidUP", null);
                }
                if (this.initializeLDAP()) {
                    this.validateUserName(this.userName, this.regEx);
                    this.validatePassword(this.userPassword);
                    this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                    n2 = this.ldapUtil.getState();
                } else {
                    n2 = 31;
                }
                this.processLoginScreen(n2);
                return this.currentState;
            }
            if (this.currentState == 2) {
                debug.message("you are in PWd Screen:" + this.currentState);
                int n3 = ((ConfirmationCallback)callbackArray[3]).getSelectedIndex();
                if (n3 == 0) {
                    String string = this.charToString(((PasswordCallback)callbackArray[0]).getPassword(), callbackArray[0]);
                    String string2 = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
                    String string3 = this.charToString(((PasswordCallback)callbackArray[2]).getPassword(), callbackArray[2]);
                    this.validatePassword(string2);
                    this.ldapUtil.changePassword(string, string2, string3);
                    n2 = this.ldapUtil.getState();
                    this.processPasswordScreen(n2);
                    if (debug.messageEnabled()) {
                        debug.message("Password change state :" + n2);
                    }
                    return this.currentState;
                }
                if (this.isReset) {
                    this.isReset = false;
                    return 1;
                }
                this.validatedUserID = this.ldapUtil.getUserId();
                return -1;
            }
            this.setFailureID(this.ldapUtil.getUserId(this.userName));
            throw new AuthLoginException(amAuthLDAP, "LDAPex", null);
        }
        catch (LDAPUtilException lDAPUtilException) {
            this.setFailureID(this.ldapUtil.getUserId(this.userName));
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist.");
                    throw new AuthLoginException(amAuthLDAP, "NoUser", null);
                }
                case 49: {
                    debug.message("Invalid password.");
                    String string = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(amAuthLDAP, "InvalidUP", null, string, null);
                }
                case 53: {
                    debug.message("Unwilling to perform. Account inactivated.");
                    this.currentState = 4;
                    return this.currentState;
                }
                case 48: {
                    debug.message("Inappropriate authentication.");
                    throw new AuthLoginException(amAuthLDAP, "InappAuth", null);
                }
            }
            throw new AuthLoginException(amAuthLDAP, "LDAPex", null);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new LDAPPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    private void processLoginScreen(int n) throws AuthLoginException {
        try {
            switch (n) {
                case 26: {
                    this.validatedUserID = this.ldapUtil.getUserId();
                    if (this.userCreationAttrs.size() > 0) {
                        Map map = this.ldapUtil.getUserAttributeValues();
                        if (debug.messageEnabled()) {
                            debug.message("user creation attributes: " + this.ldapUtil.getUserAttributeValues());
                        }
                        Map map2 = this.getAttributeMap(map);
                        this.setUserAttributes(map2);
                    }
                    this.currentState = -1;
                    break;
                }
                case 21: {
                    String string = this.bundle.getString("PasswordExp");
                    String string2 = Locale.formatMessage((String)string, (Object)this.ldapUtil.getExpTime());
                    this.replaceHeader(2, string2);
                    this.currentState = 2;
                    break;
                }
                case 32: {
                    this.isReset = true;
                    String string = this.bundle.getString("PasswordReset");
                    this.replaceHeader(2, string);
                    this.currentState = 2;
                    break;
                }
                case 20: {
                    this.currentState = 3;
                    break;
                }
                case 1: {
                    if (!this.getSubConfig()) {
                        throw new LDAPUtilException("noUserMatchFound", (Object[])null);
                    }
                    if (this.initializeLDAP()) {
                        this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                        n = this.ldapUtil.getState();
                    } else {
                        n = 31;
                    }
                    this.processLoginScreen(n);
                    break;
                }
                case 31: {
                    if (this.firstTry) {
                        this.firstTry = false;
                        this.primary = !this.primary;
                        this.setPrimaryFlag(this.currentConfigName, this.primary);
                        if (this.fMgr == null || !this.fMgr.isAlive()) {
                            this.fMgr = new FailbackManager();
                        }
                        this.fMgr.start();
                        if (this.initializeLDAP()) {
                            this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                            n = this.ldapUtil.getState();
                            this.processLoginScreen(n);
                            break;
                        }
                    }
                    if (!this.getSubConfig()) {
                        throw new AuthLoginException(amAuthLDAP, "LDAPex", null);
                    }
                    if (this.initializeLDAP()) {
                        this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                        n = this.ldapUtil.getState();
                    } else {
                        n = 31;
                    }
                    this.processLoginScreen(n);
                }
            }
        }
        catch (LDAPUtilException lDAPUtilException) {
            if (n != 1) {
                debug.error("Unknown Login State:", (Throwable)lDAPUtilException);
            }
            throw new AuthLoginException(amAuthLDAP, "LDAPex", null, lDAPUtilException);
        }
    }

    private void processPasswordScreen(int n) throws AuthLoginException {
        switch (n) {
            case 28: {
                this.validatedUserID = this.ldapUtil.getUserId();
                this.currentState = -1;
                break;
            }
            case 25: {
                this.replaceHeader(2, this.bundle.getString("PInvalid"));
                this.currentState = 2;
                break;
            }
            case 23: {
                this.replaceHeader(2, this.bundle.getString("PasswdMismatch"));
                this.currentState = 2;
                break;
            }
            case 24: {
                this.replaceHeader(2, this.bundle.getString("UPSame"));
                this.currentState = 2;
                break;
            }
            case 27: {
                this.replaceHeader(2, this.bundle.getString("PasswdSame"));
                this.currentState = 2;
                break;
            }
            case 30: {
                this.replaceHeader(2, this.bundle.getString("PasswdMinChars"));
                this.currentState = 2;
                break;
            }
            case 29: {
                this.replaceHeader(2, this.bundle.getString("UPsame"));
                this.currentState = 2;
                break;
            }
        }
    }

    private static void initializeSystemProperties() {
        adminDN = AMLoginModule.getSuperAdminUser();
        hostName = SystemProperties.get((String)"com.iplanet.am.directory.host");
        String string = SystemProperties.get((String)"com.iplanet.am.directory.port");
        port = Integer.parseInt(string);
        if (debug.messageEnabled()) {
            debug.message("adminDN-> " + adminDN + "\nHost: " + hostName + "\nPORT : " + port);
        }
        ldapSSL = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.directory.ssl.enabled", (String)"false"));
    }

    private String charToString(char[] cArray, Callback callback) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callback).clearPassword();
        return new String(cArray2);
    }

    private void setReplaceText(int n, int n2, String string) throws AuthLoginException {
        debug.message("Entered in setReplaceText");
        Callback[] callbackArray = this.getCallback(2);
        this.resetCallback(n, 0);
        String string2 = ((PasswordCallback)callbackArray[0]).getPrompt();
        int n3 = string2.indexOf("#REPLACE#");
        String string3 = string + string2.substring(n3 + 9);
        this.replaceCallback(n, 0, new PasswordCallback(string3, ((PasswordCallback)callbackArray[0]).isEchoOn()));
        if (debug.messageEnabled()) {
            debug.message("origmessage:" + string2 + ":::+setMsg" + string3);
        }
    }

    private void setInterval(long l) {
        interval = l * 60000L;
    }

    private void getUserCreationAttrs(Map map) {
        Set set = (Set)map.get(USER_CREATION_ATTR);
        if (debug.messageEnabled()) {
            debug.message("attrs is : " + set);
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf(PIPE_SEPARATOR);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1, string.length());
                    if (string3 == null || string3.equals("")) {
                        this.userCreationAttrs.add(string2);
                        this.userAttrMap.put(string2, string2);
                        continue;
                    }
                    this.userCreationAttrs.add(string3);
                    this.userAttrMap.put(string2, string3);
                    continue;
                }
                this.userCreationAttrs.add(string);
                this.userAttrMap.put(string, string);
            }
        }
    }

    private Map getAttributeMap(Map map) {
        if (debug.messageEnabled()) {
            debug.message("In getAttribute Map: " + map);
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Iterator iterator = this.userAttrMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.userAttrMap.get(string);
            Set set = (Set)map.get(string2);
            if (debug.messageEnabled()) {
                debug.message("key is : " + string);
                debug.message("value is : " + set);
            }
            if (set == null) continue;
            hashMap.put(string, set);
        }
        if (debug.messageEnabled()) {
            debug.message("New attr map is : " + hashMap);
        }
        return hashMap;
    }

    static {
        ldapSSL = false;
        orgMap = new HashMap();
        interval = 15L;
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthLDAP);
        }
        LDAP.initializeSystemProperties();
    }

    class FailbackManager
    extends Thread {
        public void run() {
            Thread thread = Thread.currentThread();
            while (!LDAP.this.primary) {
                try {
                    if (LDAP.this.ldapUtil.isServerRunning(LDAP.this.primaryServerHost, LDAP.this.primaryServerPort)) {
                        debug.message("primary is up");
                        LDAP.this.primary = true;
                        LDAP.this.setPrimaryFlag(LDAP.this.currentConfigName, LDAP.this.primary);
                        LDAP.this.fMgr = null;
                        continue;
                    }
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

