/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.application;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.application.ApplicationPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.DecodeAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;

public class Application
extends AMLoginModule {
    private String userTokenId = null;
    private Principal userPrincipal = null;
    private String errorMsg = null;
    private static String secret = null;
    private static final String amAuthApplication = "amAuthApplication";
    private static Debug debug = Debug.getInstance((String)"amAuthApplication");
    private ResourceBundle bundle = null;
    private static boolean ldapSSL = false;
    private static String ldapHost = null;
    private static int ldapPort = 389;
    private static String rootSuffix = null;

    public void init(Subject subject, Map map, Map map2) {
        try {
            debug.message("in initialize...");
            Locale locale = this.getLoginLocale();
            this.bundle = AMLoginModule.amCache.getResBundle(amAuthApplication, locale);
            if (debug.messageEnabled()) {
                debug.message("ApplicationAuth resbundle locale=" + locale);
            }
        }
        catch (Exception exception) {
            debug.error("ApplicationAuthModule Init: " + exception.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)exception);
            }
            this.errorMsg = "appInitFalied";
        }
        if (secret == null || secret.equals("")) {
            debug.error("ApplicationAuthModule Init failed : null secret");
            this.errorMsg = "nullSecret";
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthApplication, this.errorMsg, null);
        }
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        String string = null;
        String string2 = null;
        if (httpServletRequest != null) {
            string = httpServletRequest.getParameter("IDToken0");
            string2 = httpServletRequest.getParameter("IDToken1");
            if (string == null && string2 == null) {
                string = httpServletRequest.getParameter("Login.Token0");
                string2 = httpServletRequest.getParameter("Login.Token1");
            }
        }
        if (string2 == null && string == null) {
            Map map = this.sendCallback();
            if (map == null) {
                throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
            }
            string2 = (String)map.get("secret");
            string = (String)map.get("uid");
        }
        if (string2 == null) {
            throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
        }
        if (string2.equals(secret)) {
            if (debug.messageEnabled()) {
                debug.message("App.validate, secret matched : " + string);
            }
            this.userTokenId = string == null || string.equals("") ? "amService-gateway" : "amService-" + string;
            if (!this.dnEntryExist(this.userTokenId)) {
                debug.error(this.userTokenId + " is not a valid ldap entry");
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
            }
        } else {
            debug.error("App.validate, secret not matched: " + string);
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
        }
        return -1;
    }

    private boolean dnEntryExist(String string) {
        String string2 = "cn=" + string + ",ou=DSAME Users," + rootSuffix;
        boolean bl = this.isValidUserEntry(string2);
        return bl;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new ApplicationPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    private Map sendCallback() {
        try {
            CallbackHandler callbackHandler = this.getCallbackHandler();
            if (callbackHandler == null) {
                throw new AuthLoginException(amAuthApplication, "NoCallbackHandler", null);
            }
            Callback[] callbackArray = new Callback[]{new NameCallback(this.bundle.getString("appname")), new PasswordCallback(this.bundle.getString("secret"), true)};
            if (debug.messageEnabled()) {
                debug.message("Callback is.. :" + callbackArray);
            }
            callbackHandler.handle(callbackArray);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                Callback callback = callbackArray[n2];
                if (callback instanceof PasswordCallback) {
                    object = ((PasswordCallback)callback).getPassword();
                    if (object != null) {
                        hashMap.put("secret", new String((char[])object));
                    }
                } else if (callback instanceof NameCallback && (object = (Object)((NameCallback)callback).getName()) != null) {
                    hashMap.put("uid", object);
                }
                ++n2;
            }
            return hashMap;
        }
        catch (Exception exception) {
            debug.error("sendCallback: " + exception.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)exception);
            }
            return null;
        }
    }

    static {
        debug.message("Application module getting secret");
        String string = SystemProperties.get((String)"com.iplanet.am.service.secret").trim();
        secret = (String)AccessController.doPrivileged(new DecodeAction(string));
        ldapHost = SystemProperties.get((String)"com.iplanet.am.directory.host");
        ldapPort = Integer.parseInt(SystemProperties.get((String)"com.iplanet.am.directory.port"));
        ldapSSL = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.directory.ssl.enabled"));
        rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    }
}

