/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import javax.security.auth.login.LoginException;

public class AuthSSOToken
implements SSOToken {
    protected static HashMap allSSOTokens = new HashMap();
    protected static Random random = new Random();
    public static final int INVALID = 0;
    public static final int VALID = 1;
    public static final int DESTROYED = 3;
    protected AuthContext authContext;
    protected HashMap session = new HashMap();
    protected HashSet callbackObjects = new HashSet();
    protected String key;

    private AuthSSOToken() {
    }

    protected AuthSSOToken(AuthContext authContext) throws InvalidAuthContextException {
        if (authContext == null) {
            throw new InvalidAuthContextException();
        }
        if (authContext.getLoginStatus() != 3) {
            throw new InvalidAuthContextException();
        }
        this.authContext = authContext;
        this.key = AuthSSOToken.getNewKey();
        allSSOTokens.put(this.key, this);
    }

    protected static String getNewKey() {
        byte[] byArray = new byte[12];
        random.nextBytes(byArray);
        String string = Base64.encode((byte[])byArray);
        try {
            string = string + Base64.encode((byte[])InetAddress.getLocalHost().getAddress());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = string + Long.toString(System.currentTimeMillis());
        return Base64.encode((byte[])string.getBytes());
    }

    public Principal getPrincipal() throws SSOException {
        return this.authContext.getPrincipal();
    }

    public String getAuthType() throws SSOException {
        return "ldap";
    }

    public int getAuthLevel() throws SSOException {
        return 1;
    }

    public InetAddress getIPAddress() throws SSOException {
        try {
            String string = this.getProperty("Host");
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            throw new SSOException((Throwable)exception);
        }
    }

    public String getHostName() throws SSOException {
        try {
            String string = this.getProperty("HostName");
            return string;
        }
        catch (Exception exception) {
            throw new SSOException((Throwable)exception);
        }
    }

    public byte[] getAddress() throws SSOException {
        return this.getIPAddress().getAddress();
    }

    public long getTimeLeft() throws SSOException {
        return 0L;
    }

    public String encodeURL(String string) {
        return null;
    }

    public long getMaxSessionTime() throws SSOException {
        return 0L;
    }

    public long getIdleTime() throws SSOException {
        return 0L;
    }

    public long getMaxIdleTime() throws SSOException {
        return -1L;
    }

    public SSOTokenID getTokenID() {
        return new AuthSSOTokenID(this.key);
    }

    protected int getState() throws SSOException {
        if (this.authContext != null && this.authContext.getLoginStatus() == 3) {
            return 1;
        }
        return 0;
    }

    public void setProperty(String string, String string2) throws SSOException {
        this.session.put(string, string2);
    }

    public String getProperty(String string) throws SSOException {
        return (String)this.session.get(string);
    }

    public void addSSOTokenListener(SSOTokenListener sSOTokenListener) throws SSOException {
        this.callbackObjects.add(sSOTokenListener);
    }

    protected boolean isValid() {
        return this.authContext != null && this.authContext.getLoginStatus() == 3;
    }

    protected void validate() throws SSOException {
        if (this.authContext != null && this.authContext.getLoginStatus() == 3) {
            return;
        }
        throw new SSOException("amAuth", "invalidcontext", null);
    }

    protected void invalidate() {
        allSSOTokens.remove(this.key);
        try {
            this.authContext.logout();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    protected class AuthSSOTokenID
    implements SSOTokenID {
        private String tokenID;

        protected AuthSSOTokenID(String string) {
            this.tokenID = string;
        }

        public String toString() {
            return this.tokenID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AuthSSOTokenID authSSOTokenID = (AuthSSOTokenID)object;
            return this.tokenID.equals(authSSOTokenID.tokenID);
        }

        public int hashCode() {
            return AuthSSOToken.this.authContext.hashCode();
        }
    }
}

