/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.https.Handler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLHandler;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.L10NMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthContext {
    private static String server_host = "";
    private static String server_port = "";
    private static String server_proto = "";
    private static String server_pass_file = "";
    private static final String amAuthContext = "amAuthContext";
    private static final String JSS_PASSWORD_UTIL = "com.sun.identity.authentication.util.JSSPasswordUtil";
    protected static Debug authDebug = Debug.getInstance((String)"amAuthContext");
    protected static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amAuthContext");
    AuthContextLocal ac = null;
    Status loginStatus;
    String organizationName = "";
    Document receivedDocument;
    AuthLoginException loginException = null;
    String hostName = "";
    static String nickName = null;
    private HashMap cookieTable = new HashMap();

    public AuthContext(String string) throws AuthLoginException {
        try {
            this.createAuthContext(string);
        }
        catch (Exception exception) {
            throw new AuthLoginException(exception);
        }
        this.reset();
    }

    public AuthContext(String string, URL uRL) throws AuthLoginException {
        try {
            this.createAuthContext(string, null, uRL);
        }
        catch (Exception exception) {
            throw new AuthLoginException(exception);
        }
        this.reset();
    }

    public AuthContext(String string, String string2) throws AuthLoginException {
        if (string2 != null) {
            nickName = string2;
        }
        try {
            this.createAuthContext(string);
        }
        catch (Exception exception) {
            throw new AuthLoginException(exception);
        }
        this.reset();
    }

    public AuthContext(String string, String string2, URL uRL) throws AuthLoginException {
        if (string2 != null) {
            nickName = string2;
        }
        try {
            this.createAuthContext(string, null, uRL);
        }
        catch (Exception exception) {
            throw new AuthLoginException(exception);
        }
        this.reset();
    }

    public AuthContext(SSOToken sSOToken) throws AuthLoginException {
        try {
            String string = sSOToken.getProperty("Organization");
            String string2 = sSOToken.getTokenID().toString();
            SessionID sessionID = new SessionID(string2);
            Session session = Session.getSession((SessionID)sessionID);
            URL uRL = Session.getSessionServiceURL((SessionID)sessionID);
            this.createAuthContext(string, string2, uRL);
        }
        catch (Exception exception) {
            throw new AuthLoginException(exception);
        }
        this.reset();
    }

    public void login() throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.login();
            return;
        }
        this.login(null);
    }

    public void login(Subject subject) throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.login(subject);
            return;
        }
        this.login(null, null, subject, null, false);
    }

    public void login(Principal principal, char[] cArray) throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.login(principal, cArray);
            return;
        }
        HashSet<Principal> hashSet = new HashSet<Principal>();
        hashSet.add(principal);
        Subject subject = new Subject(false, hashSet, Collections.EMPTY_SET, Collections.EMPTY_SET);
        this.login(null, null, subject, cArray, false);
    }

    public void login(IndexType indexType, String string) throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.login(indexType, string);
            return;
        }
        this.login(indexType, string, null, null, false);
    }

    public void login(IndexType indexType, String string, boolean bl) throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.login(indexType, string, bl);
            return;
        }
        this.login(indexType, string, null, null, bl);
    }

    public SSOToken login(IndexType indexType, String string, Callback[] callbackArray) throws AuthLoginException {
        SSOToken sSOToken = null;
        if (AuthXMLHandler.localFlag) {
            this.ac.login(indexType, string);
        } else {
            this.login(indexType, string, null, null, false);
        }
        Callback[] callbackArray2 = null;
        while (this.hasMoreRequirements()) {
            callbackArray2 = this.getRequirements();
            if (callbackArray2 == null) continue;
            try {
                this.submitRequirements(callbackArray);
            }
            catch (Exception exception) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("Error: submitRequirements with userInfo : " + exception.getMessage());
                }
                throw new AuthLoginException(exception);
            }
        }
        try {
            if (this.getStatus() == Status.SUCCESS) {
                sSOToken = this.getSSOToken();
            }
        }
        catch (Exception exception) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Error: getSSOToken : " + exception.getMessage());
            }
            throw new AuthLoginException(exception);
        }
        return sSOToken;
    }

    protected void login(IndexType indexType, String string, Subject subject, char[] cArray, boolean bl) throws AuthLoginException {
        if (!this.loginStatus.equals(Status.NOT_STARTED)) {
            throw new AuthLoginException(amAuthContext, "invalidState", null);
        }
        if (authDebug.messageEnabled()) {
            authDebug.message("Login Parameters : Subject = " + subject + " IndexType = " + indexType + " IndexName = " + string);
        }
        this.loginStatus = Status.IN_PROGRESS;
        StringBuffer stringBuffer = new StringBuffer(100);
        Object[] objectArray = new String[1];
        if (this.receivedDocument == null) {
            objectArray[0] = "0";
        } else {
            objectArray[0] = this.getAuthenticationHandle(this.receivedDocument);
            if (objectArray[0] == null) {
                objectArray[0] = "0";
            }
        }
        stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<Login>");
        if (indexType != null) {
            stringBuffer.append("<IndexTypeNamePair").append(" ").append("indexType").append("=").append("\"");
            if (indexType == IndexType.USER) {
                stringBuffer.append("user");
            }
            if (indexType == IndexType.ROLE) {
                stringBuffer.append("role");
            }
            if (indexType == IndexType.SERVICE) {
                stringBuffer.append("service");
            }
            if (indexType == IndexType.MODULE_INSTANCE) {
                stringBuffer.append("moduleInstance");
            }
            if (indexType == IndexType.LEVEL) {
                stringBuffer.append("authLevel");
            }
            stringBuffer.append("\"").append(">").append("<IndexName>").append(string).append("</IndexName>").append("</IndexTypeNamePair>");
        }
        if (subject != null) {
            stringBuffer.append(AuthContext.getXMLforSubject(subject));
        }
        if (cArray != null) {
            stringBuffer.append("<Password><Value>").append(cArray).append("</Value></Password>");
        }
        stringBuffer.append("</Login>").append("</Request></AuthContext>");
        this.receivedDocument = this.processRequest(stringBuffer.toString());
        this.checkAndSetLoginStatus();
    }

    public Subject getSubject() {
        if (AuthXMLHandler.localFlag) {
            if (!this.ac.getStatus().equals(Status.SUCCESS)) {
                return null;
            }
            return this.ac.getSubject();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            return null;
        }
        return AuthContext.getSubject(this.receivedDocument);
    }

    public boolean hasMoreRequirements() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.hasMoreRequirements(false);
        }
        return this.loginStatus.equals(Status.IN_PROGRESS) && AuthContext.getCallbacks(this.receivedDocument, false) != null;
    }

    public boolean hasMoreRequirements(boolean bl) {
        if (AuthXMLHandler.localFlag) {
            return this.ac.hasMoreRequirements(bl);
        }
        return this.loginStatus.equals(Status.IN_PROGRESS) && AuthContext.getCallbacks(this.receivedDocument, bl) != null;
    }

    public Callback[] getRequirements() {
        if (AuthXMLHandler.localFlag) {
            if (!this.ac.getStatus().equals(Status.IN_PROGRESS)) {
                return null;
            }
            return this.ac.getRequirements(false);
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return null;
        }
        return AuthContext.getCallbacks(this.receivedDocument, false);
    }

    public Callback[] getRequirements(boolean bl) {
        if (AuthXMLHandler.localFlag) {
            if (!this.ac.getStatus().equals(Status.IN_PROGRESS)) {
                return null;
            }
            return this.ac.getRequirements(bl);
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return null;
        }
        return AuthContext.getCallbacks(this.receivedDocument, bl);
    }

    public void submitRequirements(Callback[] callbackArray) {
        if (authDebug.messageEnabled()) {
            authDebug.message("submitRequirements with Callbacks : " + callbackArray);
        }
        if (AuthXMLHandler.localFlag) {
            if (!this.ac.getStatus().equals(Status.IN_PROGRESS)) {
                return;
            }
            this.ac.submitRequirements(callbackArray);
            return;
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<SubmitRequirements>").append(AuthXMLUtils.getXMLForCallbacks(callbackArray)).append("</SubmitRequirements>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public void logout() throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.logout();
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<Logout>").append("</Logout>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public AuthLoginException getLoginException() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.getLoginException();
        }
        return this.loginException;
    }

    public SSOToken getSSOToken() throws Exception {
        if (AuthXMLHandler.localFlag) {
            if (!this.ac.getStatus().equals(Status.SUCCESS)) {
                throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
            }
            return this.ac.getSSOToken();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
        }
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (node == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"ssoToken");
        try {
            return SSOTokenManager.getInstance().createSSOToken(string);
        }
        catch (SSOException sSOException) {
            sSOException.printStackTrace();
            throw new L10NMessageImpl(amAuthContext, "createSSOTokenError", null);
        }
    }

    public Status getStatus() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.getStatus();
        }
        return this.loginStatus;
    }

    public void reset() {
        this.loginStatus = Status.NOT_STARTED;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Set getModuleInstanceNames() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.getModuleInstanceNames();
        }
        this.sendQueryInformation("moduleInstanceNames");
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"QueryResult");
        if (node == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                String string = XMLUtils.getValueOfValueNode((Node)node2);
                hashSet.add(string);
                ++n;
            }
        }
        return hashSet;
    }

    public void abort() throws AuthLoginException {
        if (AuthXMLHandler.localFlag) {
            this.ac.abort();
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<Abort>").append("</Abort>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public static void setCertDBPassword(String string) {
        try {
            Class<?> clazz = Class.forName(JSS_PASSWORD_UTIL);
            Constructor<?> constructor = clazz.getConstructor(Class.forName("java.lang.String"));
            constructor.newInstance(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            authDebug.message("Error in setCertDBPassword : " + exception.getMessage());
        }
    }

    public String getErrorTemplate() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.getErrorTemplate();
        }
        String string = "";
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (node != null) {
            string = XMLUtils.getNodeAttributeValue((Node)node, (String)"templateName");
        }
        return string;
    }

    public String getErrorMessage() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.getErrorMessage();
        }
        String string = null;
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (node != null) {
            string = XMLUtils.getNodeAttributeValue((Node)node, (String)"message");
        }
        return string;
    }

    public String getErrorCode() {
        if (AuthXMLHandler.localFlag) {
            return this.ac.getErrorCode();
        }
        String string = "";
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (node != null) {
            string = XMLUtils.getNodeAttributeValue((Node)node, (String)"errorCode");
        }
        return string;
    }

    public void setClientHostName(String string) {
        this.hostName = string;
    }

    public String getClientHostName() {
        return this.hostName;
    }

    protected void checkAndSetLoginStatus() {
        Node node;
        String string = this.getErrorMessage();
        if (string != null) {
            this.loginException = new AuthLoginException(string);
        }
        if ((node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus")) == null) {
            return;
        }
        String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"status");
        if (string2 != null) {
            if (string2.equals("success")) {
                this.loginStatus = Status.SUCCESS;
            } else if (string2.equals("failed")) {
                this.loginStatus = Status.FAILED;
            } else if (string2.equals("completed")) {
                this.loginStatus = Status.COMPLETED;
            } else if (string2.equals("in_progress")) {
                this.loginStatus = Status.IN_PROGRESS;
            }
        }
        if (authDebug.messageEnabled()) {
            authDebug.message("LoginStatus : " + this.loginStatus);
        }
    }

    protected void sendQueryInformation(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[1];
            if (this.receivedDocument == null) {
                objectArray[0] = "0";
            } else {
                objectArray[0] = this.getAuthenticationHandle(this.receivedDocument);
                if (objectArray[0] == null) {
                    objectArray[0] = "0";
                }
            }
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<QueryInformation").append(" ").append("requestedInformation").append("=").append("\"").append(string).append("\"").append(">").append("</QueryInformation>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    private void createAuthContext(String string) throws Exception {
        this.createAuthContext(string, null, null);
    }

    private void createAuthContext(String string, String string2, URL uRL) throws Exception {
        try {
            this.organizationName = string;
            if (uRL != null) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("IS URL : " + uRL.toString());
                }
                server_proto = uRL.getProtocol();
                server_host = uRL.getHost();
                server_port = Integer.toString(uRL.getPort());
            } else {
                server_proto = SystemProperties.get((String)"com.iplanet.am.server.protocol");
                server_host = SystemProperties.get((String)"com.iplanet.am.server.host");
                server_port = SystemProperties.get((String)"com.iplanet.am.server.port");
            }
            server_pass_file = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.passfile");
            if (authDebug.messageEnabled()) {
                authDebug.message("server Host : " + server_host + " server Port : " + server_port + " server Protocol : " + server_proto);
            }
            if (!AuthXMLHandler.localFlag) {
                this.setLocalFlag();
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Local flag : " + AuthXMLHandler.localFlag);
                authDebug.message("Org Name : " + string);
                authDebug.message("ssoTokenID: " + string2);
            }
            if (AuthXMLHandler.localFlag) {
                AuthUtils authUtils = new AuthUtils();
                this.ac = string2 == null ? AuthUtils.getAuthContext(string) : AuthUtils.getAuthContext(string, string2);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{"0"};
            if (string2 != null) {
                objectArray[0] = string2;
            }
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<NewAuthContext").append(" ").append("orgName").append("=").append("\"").append(string).append("\"").append(">").append("</NewAuthContext>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (Exception exception) {
            throw new L10NMessageImpl(amAuthContext, "constructError", new Object[]{exception.getMessage()});
        }
    }

    private void setLocalFlag() {
        try {
            URL uRL = WebtopNaming.getServiceURL((String)"auth", (String)server_proto, (String)server_host, (String)server_port);
            String string = uRL.getProtocol() + "://" + uRL.getHost() + ":" + Integer.toString(uRL.getPort());
            if (authDebug.messageEnabled()) {
                authDebug.message("in setLocalFlag(), url : " + string);
                authDebug.message("AuthXMLHandler.localAuthServiceID : " + AuthXMLHandler.localAuthServiceID);
            }
            if (AuthXMLHandler.localAuthServiceID != null && string.equalsIgnoreCase(AuthXMLHandler.localAuthServiceID)) {
                AuthXMLHandler.localFlag = true;
            }
        }
        catch (Exception exception) {
            authDebug.error("AuthContext::setLocalFlag:: " + exception);
        }
    }

    protected Document processRequest(String string) throws AuthLoginException {
        Document document = null;
        try {
            Object object;
            Request request = new Request(string);
            RequestSet requestSet = new RequestSet("auth");
            requestSet.addRequest(request);
            if (authDebug.messageEnabled()) {
                authDebug.message("In processRequest - Host : " + server_host + " Port : " + server_port + " Protocol : " + server_proto);
            }
            URL uRL = null;
            uRL = WebtopNaming.getServiceURL((String)"auth", (String)server_proto, (String)server_host, (String)server_port);
            if (uRL.getProtocol().equals("https") && nickName != null) {
                object = new Handler(nickName);
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile(), (URLStreamHandler)object);
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Service URL : " + uRL.toString());
            }
            if (((Vector)(object = PLLClient.send((URL)uRL, (RequestSet)requestSet, (HashMap)this.cookieTable))).isEmpty() || ((Vector)object).size() != 1) {
                throw new L10NMessageImpl(amAuthContext, "responseError", null);
            }
            Response response = (Response)((Vector)object).elementAt(0);
            String string2 = response.getContent();
            if (authDebug.messageEnabled()) {
                authDebug.message("Received XML data : " + string2);
            }
            document = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string2.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            authDebug.message("error in getting service url : " + exception.getMessage(), (Throwable)exception);
            throw new AuthLoginException(amAuthContext, "xmlProcessError", null, exception);
        }
        AuthContext.checkForException(document);
        return document;
    }

    protected static void checkForException(Document document) throws AuthLoginException {
        Node node = XMLUtils.getRootNode((Document)document, (String)"Exception");
        if (node != null) {
            throw new AuthLoginException(XMLUtils.getNodeAttributeValue((Node)node, (String)"message"));
        }
    }

    protected String getAuthenticationHandle(Document document) throws AuthLoginException {
        Node node = XMLUtils.getRootNode((Document)document, (String)"Response");
        if (node == null) {
            throw new AuthLoginException(amAuthContext, "responseError", null);
        }
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"authIdentifier");
        return string;
    }

    protected static Callback[] getCallbacks(Document document, boolean bl) {
        return AuthXMLUtils.getCallbacks(XMLUtils.getRootNode((Document)document, (String)"Callbacks"), bl);
    }

    protected static Subject getSubject(Document document) {
        Node node = XMLUtils.getRootNode((Document)document, (String)"LoginStatus");
        if (node == null) {
            return null;
        }
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Subject");
        if (node2 == null) {
            return null;
        }
        String string = XMLUtils.getValueOfValueNode((Node)node2);
        try {
            Subject subject = AuthXMLUtils.getDeSerializedSubject(string);
            if (authDebug.messageEnabled()) {
                authDebug.message("Deserialized subject : " + subject.toString());
            }
            return subject;
        }
        catch (Exception exception) {
            authDebug.message("get Deserialized subject error : ", (Throwable)exception);
            return null;
        }
    }

    protected static String getXMLforSubject(Subject subject) {
        if (subject == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<Subject>");
        String string = AuthXMLUtils.getSerializedSubject(subject);
        stringBuffer.append(string);
        stringBuffer.append("</Subject>");
        return stringBuffer.toString();
    }

    public static class IndexType {
        private String index;
        public static final IndexType USER = new IndexType("user");
        public static final IndexType ROLE = new IndexType("role");
        public static final IndexType SERVICE = new IndexType("service");
        public static final IndexType LEVEL = new IndexType("level");
        public static final IndexType MODULE_INSTANCE = new IndexType("module_instance");

        private IndexType() {
        }

        private IndexType(String string) {
            this.index = string;
        }

        public String toString() {
            return this.index;
        }

        public boolean equals(Object object) {
            if (object instanceof IndexType) {
                IndexType indexType = (IndexType)object;
                return indexType.index.equalsIgnoreCase(this.index);
            }
            return false;
        }
    }

    public static class Status {
        private String status;
        public static final Status NOT_STARTED = new Status("not_started");
        public static final Status IN_PROGRESS = new Status("in_progress");
        public static final Status SUCCESS = new Status("success");
        public static final Status FAILED = new Status("failed");
        public static final Status COMPLETED = new Status("completed");
        public static final Status RESET = new Status("reset");
        public static final Status ORG_MISMATCH = new Status("org_mismatch");

        private Status() {
        }

        private Status(String string) {
            this.status = string;
        }

        public String toString() {
            return this.status;
        }

        public boolean equals(Object object) {
            if (object instanceof Status) {
                Status status = (Status)object;
                return status.status.equalsIgnoreCase(this.status);
            }
            return false;
        }
    }
}

