/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.ldap.aci.ACI;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.EntityManager;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IMembership;
import com.iplanet.ums.ISearch;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.validation.Validation;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class PersistentObject
implements ISearch,
Serializable,
IUMSConstants {
    public static final String COMPUTED_MEMBER_ATTR_NAME = "nsRole";
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private Principal m_principal;
    private Guid m_guid;
    private AttrSet m_attrSet;
    private ArrayList m_nullAttributes;
    private ModSet m_modSet;
    private String m_namingAttribute = null;

    protected PersistentObject() {
    }

    PersistentObject(Principal principal, Guid guid) throws UMSException {
        String string = guid.getDn();
        if (principal == null || string == null) {
            String string2 = principal == null ? i18n.getString("ums-bad-principal-hdl") : i18n.getString("ums-badguid");
            throw new IllegalArgumentException(string2);
        }
        this.setGuid(guid);
        this.setPrincipal(principal);
        this.read();
    }

    public PersistentObject(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        this.m_attrSet = attrSet;
        if (creationTemplate == null) {
            throw new UMSException("ums-bad-template");
        }
        this.m_namingAttribute = creationTemplate.getNamingAttribute();
        creationTemplate.validateAttrSet(attrSet);
        creationTemplate.validateAttributes(attrSet);
    }

    PersistentObject(CreationTemplate creationTemplate, AttrSet attrSet, String string) throws UMSException {
        this.m_attrSet = attrSet;
        if (creationTemplate == null) {
            throw new UMSException("ums-bad-template");
        }
        creationTemplate.validateAttrSet(attrSet);
        creationTemplate.validateAttributes(attrSet);
        this.m_namingAttribute = string;
    }

    public Attr getAttribute(String string) {
        Attr attr = this.getAttributeFromCache(string);
        if (attr == null && this.isAttributeNotRead(string) && this.getGuid() != null && this.getPrincipal() != null) {
            attr = this.readAttributeFromDataStore(string);
        }
        return attr;
    }

    public Attr getAttribute(String string, Locale locale) throws UMSException {
        if (locale == null) {
            return this.getAttribute(string);
        }
        return this.getAttribute(Attr.getName(string, locale));
    }

    public AttrSet getAttributes(String[] stringArray) throws UMSException {
        return this.getAttributes(stringArray, false);
    }

    public AttrSet getAttributes(String[] stringArray, boolean bl) throws UMSException {
        Collection collection;
        if (stringArray == null) {
            throw new IllegalArgumentException(i18n.getString("ums-badattrnames"));
        }
        AttrSet attrSet = new AttrSet();
        if (!bl && (collection = this.findAttributesNotRead(stringArray)).size() != 0 && this.getGuid() != null && this.getPrincipal() != null) {
            this.readAttributesFromDataStore(collection);
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attr attr = this.getAttributeFromCache(stringArray[n2]);
            if (attr != null) {
                attrSet.add(attr);
            }
            ++n2;
        }
        return attrSet;
    }

    public AttrSet getAttributes(String[] stringArray, Locale locale) throws UMSException {
        if (locale == null) {
            return this.getAttributes(stringArray);
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = Attr.getName(stringArray[n], locale);
            ++n;
        }
        return this.getAttributes(stringArray2);
    }

    public void setAttribute(Attr attr) {
        if (attr == null || attr.getName() == null) {
            throw new IllegalArgumentException(i18n.getString("ums-addnullobj"));
        }
        this.checkCache();
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_attrSet.contains(attr.getName())) {
            this.modify(attr, 2);
        } else {
            this.modify(attr, 0);
        }
    }

    public void setAttribute(Attr attr, Locale locale) {
        if (locale == null) {
            this.setAttribute(attr);
            return;
        }
        Attr attr2 = new Attr(Attr.getName(attr.getBaseName(), locale));
        attr2.addValues(attr.getStringValues());
        this.setAttribute(attr2);
    }

    public void removeAttribute(Attr attr) {
        this.checkCache();
        if (this.m_attrSet == null || this.m_attrSet.size() == 0) {
            return;
        }
        this.modify(attr, 1);
    }

    public String[] getAttributeNames() {
        block4: {
            if (this.m_principal != null && this.m_guid != null && this.m_attrSet == null) {
                try {
                    this.read();
                }
                catch (UMSException uMSException) {
                    if (!debug.messageEnabled()) break block4;
                    debug.message("PersistentObject.getAttributeNames: UMSException: " + uMSException.getMessage());
                }
            }
        }
        if (this.m_attrSet != null) {
            return this.m_attrSet.getAttributeNames();
        }
        return null;
    }

    public void modify(ModSet modSet) {
        this.checkCache();
        if (this.m_modSet == null) {
            this.m_modSet = new ModSet();
        }
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        int n = modSet.size();
        LDAPModification lDAPModification = null;
        int n2 = 0;
        while (n2 < n) {
            lDAPModification = modSet.elementAt(n2);
            switch (lDAPModification.getOp()) {
                case 0: {
                    this.m_attrSet.add(new Attr(lDAPModification.getAttribute()));
                    break;
                }
                case 1: {
                    if (lDAPModification.getAttribute().size() == 0) {
                        this.m_attrSet.remove(lDAPModification.getAttribute().getName());
                        break;
                    }
                    LDAPAttribute lDAPAttribute = lDAPModification.getAttribute();
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements()) {
                        this.m_attrSet.remove(lDAPAttribute.getName(), (String)enumeration.nextElement());
                    }
                    break;
                }
                case 2: {
                    this.m_attrSet.replace(new Attr(lDAPModification.getAttribute()));
                    break;
                }
            }
            this.m_modSet.add(lDAPModification.getOp(), lDAPModification.getAttribute());
            ++n2;
        }
    }

    public void modify(Attr attr, int n) {
        ModSet modSet = new ModSet();
        modSet.add(n, attr.toLDAPAttribute());
        this.modify(modSet);
    }

    public void modify(String string, String string2, int n) {
        ModSet modSet = new ModSet();
        modSet.add(n, new LDAPAttribute(string, string2));
        this.modify(modSet);
    }

    public Guid getGuid() {
        return this.m_guid;
    }

    public void rename(String string, boolean bl) throws AccessRightsException, EntryNotFoundException, UMSException {
        String string2 = null;
        if (this.m_principal == null) {
            string2 = "principal";
        } else if (this.m_guid == null) {
            string2 = "guid";
        }
        if (string2 != null) {
            Object[] objectArray = new String[]{string2};
            String string3 = i18n.getString("ums-norequired", objectArray);
            throw new UMSException(string3);
        }
        try {
            DataLayer.getInstance().rename(this.getPrincipal(), this.getGuid(), string, bl);
            Object var7_6 = null;
            RDN rDN = new RDN(string);
            DN dN = new DN(this.m_guid.toString()).getParent();
            dN.addRDN(rDN);
            this.m_guid.setDn(dN.toRFCString());
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            RDN rDN = new RDN(string);
            DN dN = new DN(this.m_guid.toString()).getParent();
            dN.addRDN(rDN);
            this.m_guid.setDn(dN.toRFCString());
            throw throwable;
        }
    }

    public void save() throws AccessRightsException, EntryNotFoundException, UMSException {
        String string = null;
        if (this.m_modSet == null) {
            return;
        }
        if (this.m_principal == null) {
            string = "principal";
        } else if (this.m_guid == null) {
            string = "guid";
        }
        if (string != null) {
            Object[] objectArray = new String[]{string};
            String string2 = i18n.getString("ums-norequired", objectArray) + " - " + i18n.getString("ums-objectnotpersistent");
            throw new UMSException(string2);
        }
        try {
            DataLayer.getInstance().modify(this.getPrincipal(), this.getGuid(), this.m_modSet);
            Object var5_4 = null;
            this.m_modSet = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_modSet = null;
            throw throwable;
        }
    }

    public String getNamingAttribute() {
        if (this.m_guid == null) {
            return this.m_namingAttribute;
        }
        DN dN = new DN(this.getDN());
        String[] stringArray = dN.explodeDN(false);
        if (stringArray != null && stringArray.length > 0) {
            RDN rDN = new RDN(stringArray[0]);
            return rDN.getTypes()[0];
        }
        return null;
    }

    public PersistentObject getParentObject() throws UMSException {
        if (this.m_guid == null || this.m_principal == null) {
            String string = this.m_principal == null ? i18n.getString("ums-bad-principal-hdl") : i18n.getString("ums-badguid");
            throw new IllegalArgumentException(string);
        }
        PersistentObject persistentObject = UMSObject.getObject(this.getPrincipal(), this.getParentGuid());
        return persistentObject;
    }

    public void addChild(PersistentObject persistentObject) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        block5: {
            if (persistentObject == null) {
                Object[] objectArray = new String[]{this.toString()};
                String string = i18n.getString("ums-addnullobj", objectArray);
                throw new IllegalArgumentException(string);
            }
            String string = persistentObject.getNamingAttribute();
            String string2 = null;
            Attr attr = persistentObject.getAttribute(string);
            if (attr == null) {
                throw new UMSException("ums-badnamingattr" + string);
            }
            string2 = attr.getValue();
            if (string == null || string2 == null || string2.length() == 0) {
                Object[] objectArray = new String[]{persistentObject.toString()};
                String string3 = i18n.getString("ums-composeguidfailed", objectArray);
                throw new IllegalArgumentException(string3);
            }
            String string4 = null;
            string4 = this.getGuid().getDn().length() > 0 ? string + "=" + string2 + "," + this.getGuid().getDn() : string + "=" + string2;
            Guid guid = new Guid(string4);
            persistentObject.setGuid(guid);
            DataLayer.getInstance().addEntry(this.getPrincipal(), guid, persistentObject.getAttrSet());
            persistentObject.setModSet(null);
            persistentObject.setPrincipal(this.getPrincipal());
            EntityManager entityManager = EntityManager.getEntityManager();
            try {
                entityManager.execute(this.getPrincipal(), persistentObject, this.m_guid);
            }
            catch (UMSException uMSException) {
                if (!debug.messageEnabled()) break block5;
                debug.message("PersistentObject.addChild : UMSException : " + uMSException.getMessage());
            }
        }
    }

    public void removeChild(PersistentObject persistentObject) throws AccessRightsException, EntryNotFoundException, UMSException {
        Object object;
        Object object2;
        if (persistentObject == null) {
            Object[] objectArray = new String[]{this.toString()};
            String string = i18n.getString("ums-delnullobj", objectArray);
            throw new IllegalArgumentException(string);
        }
        String string = persistentObject.getGuid().getDn();
        if (string == null) {
            object2 = persistentObject.getNamingAttribute();
            object = persistentObject.getAttribute((String)object2).getValue();
            if (object2 == null || object == null || ((String)object).length() == 0) {
                Object[] objectArray = new String[]{persistentObject.toString()};
                String string2 = i18n.getString("ums-composeguidfailed", objectArray);
                throw new IllegalArgumentException(string2);
            }
            string = this.getGuid().getDn().length() > 0 ? (String)object2 + "=" + (String)object + "," + this.getGuid() : (String)object2 + "=" + (String)object;
        }
        if (!((DN)(object = new DN(string))).isDescendantOf((DN)(object2 = new DN(this.getDN())))) {
            String string3 = i18n.getString("ums-badchildobj");
            throw new IllegalArgumentException(string3);
        }
        DataLayer.getInstance().deleteEntry(this.getPrincipal(), new Guid(string));
        persistentObject.setGuid(new Guid("DELETED"));
        persistentObject.setPrincipal(null);
    }

    public void removeChild(Guid guid) throws AccessRightsException, EntryNotFoundException, UMSException {
        DN dN = new DN(this.getDN());
        DN dN2 = new DN(guid.getDn());
        if (!dN2.isDescendantOf(dN)) {
            String string = i18n.getString("ums-badchildobj");
            throw new IllegalArgumentException(string);
        }
        DataLayer.getInstance().deleteEntry(this.getPrincipal(), guid);
    }

    public void remove() throws AccessRightsException, EntryNotFoundException, UMSException {
        if (this.m_guid == null || this.m_principal == null) {
            return;
        }
        DataLayer.getInstance().deleteEntry(this.getPrincipal(), this.getGuid());
        this.setGuid(null);
        this.setPrincipal(null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Object ID        :" + this.m_guid + "\n");
        stringBuffer.append("Naming attribute :" + this.getNamingAttribute() + "\n");
        stringBuffer.append("Class            :" + this.getClass().getName() + "\n");
        stringBuffer.append("Principal        :" + this.m_principal + "\n");
        stringBuffer.append("Attribute Set    :" + this.m_attrSet + "\n");
        return stringBuffer.toString();
    }

    public Guid getParentGuid() {
        if (this.m_guid == null || this.m_principal == null) {
            return null;
        }
        DN dN = new DN(this.getDN());
        return new Guid(dN.getParent().toString());
    }

    public SearchResults getChildren(String string, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int n = 1;
        if (searchControl != null) {
            n = searchControl.getSearchScope(n);
        }
        SearchResults searchResults = DataLayer.getInstance().searchIDs(this.getPrincipal(), this.getGuid(), n, string, searchControl);
        searchResults.setPrincipal(this.getPrincipal());
        return searchResults;
    }

    public SearchResults getChildren(String string, String[] stringArray, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int n = 1;
        if (searchControl != null) {
            n = searchControl.getSearchScope(n);
        }
        SearchResults searchResults = DataLayer.getInstance().search(this.getPrincipal(), this.getGuid(), n, string, stringArray, false, searchControl);
        searchResults.setPrincipal(this.getPrincipal());
        return searchResults;
    }

    public SearchResults getChildren(SearchTemplate searchTemplate, SearchControl searchControl) throws UMSException {
        return this.getChildren(searchTemplate.getSearchFilter(), searchTemplate.getAttributeSet().getAttributeNames(), searchControl);
    }

    public SearchResults search(String string, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int n = 2;
        if (searchControl != null) {
            n = searchControl.getSearchScope(n);
        }
        SearchResults searchResults = DataLayer.getInstance().searchIDs(this.getPrincipal(), this.getGuid(), n, string, searchControl);
        searchResults.setPrincipal(this.getPrincipal());
        return searchResults;
    }

    public SearchResults search(String string, String[] stringArray, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int n = 2;
        if (searchControl != null) {
            n = searchControl.getSearchScope(n);
        }
        SearchResults searchResults = DataLayer.getInstance().search(this.getPrincipal(), this.getGuid(), n, string, stringArray, false, searchControl);
        searchResults.setPrincipal(this.getPrincipal());
        return searchResults;
    }

    public SearchResults search(SearchTemplate searchTemplate, SearchControl searchControl) throws UMSException {
        return this.search(searchTemplate.getSearchFilter(), searchTemplate.getAttributeSet().getAttributeNames(), searchControl);
    }

    public String getDN() {
        if (this.m_guid != null) {
            return this.m_guid.getDn();
        }
        return null;
    }

    protected void setGuid(Guid guid) {
        this.m_guid = guid;
    }

    Principal getPrincipal() {
        return this.m_principal;
    }

    void setPrincipal(Principal principal) {
        this.m_principal = principal;
    }

    protected void setAttrSet(AttrSet attrSet) {
        this.m_attrSet = attrSet;
    }

    protected AttrSet getAttrSet() {
        return this.m_attrSet;
    }

    void verifyClass() throws UMSException {
        Class clazz = TemplateManager.getTemplateManager().getJavaClassForEntry(this.getGuid().getDn(), this.getAttrSet());
        if (this.getClass() != clazz) {
            String string = i18n.getString("ums-unmatchedclass");
            throw new IllegalArgumentException(string);
        }
    }

    public static String idToDN(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "=" + string2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                stringBuffer.append(",o=" + stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String dnToGuid(String string) {
        return string;
    }

    static String guidToDN(String string) {
        return string;
    }

    private synchronized void read() throws UMSException {
        if (this.m_principal == null || this.m_guid == null) {
            return;
        }
        this.m_attrSet = DataLayer.getInstance().read(this.getPrincipal(), this.getGuid());
    }

    private void checkCache() {
        block3: {
            if (this.m_principal != null && this.m_guid != null && this.m_attrSet == null) {
                try {
                    this.read();
                }
                catch (UMSException uMSException) {
                    if (!debug.messageEnabled()) break block3;
                    debug.message("PersistentObject.checkCache() : UMSException : " + uMSException.getMessage());
                }
            }
        }
    }

    void setModSet(ModSet modSet) {
        this.m_modSet = modSet;
    }

    public boolean isMemberOf(IMembership iMembership) throws UMSException {
        return iMembership.hasMember(this.getGuid());
    }

    public Collection getRoles() throws UMSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Attr attr = this.getAttribute(COMPUTED_MEMBER_ATTR_NAME);
        if (attr != null && attr.getStringValues() != null) {
            arrayList.addAll(Arrays.asList(attr.getStringValues()));
        }
        return arrayList;
    }

    public Collection getACI() throws ACIParseException, UMSException {
        ArrayList<ACI> arrayList = new ArrayList<ACI>();
        Attr attr = this.getAttribute("aci");
        if (attr != null) {
            String[] stringArray = attr.getStringValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(ACI.valueOf(stringArray[n2]));
                ++n2;
            }
        }
        return arrayList;
    }

    public Collection getACI(String string) throws ACIParseException, UMSException {
        ArrayList<ACI> arrayList = new ArrayList<ACI>();
        Attr attr = this.getAttribute("aci");
        if (attr != null) {
            String[] stringArray = attr.getStringValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                ACI aCI = ACI.valueOf(stringArray[n2]);
                if (aCI.getName().equals(string)) {
                    arrayList.add(aCI);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public void addACI(ACI aCI) throws AccessRightsException, UMSException {
        Attr attr = new Attr("aci", aCI.toString());
        this.modify(attr, 0);
        this.save();
    }

    public void deleteACI(ACI aCI) throws AccessRightsException, UMSException {
        Attr attr = new Attr("aci", aCI.getACIText());
        this.modify(attr, 1);
        this.save();
    }

    public void replaceACI(ACI aCI, ACI aCI2) throws AccessRightsException, UMSException {
        Attr attr = new Attr("aci", aCI.getACIText());
        this.modify(attr, 1);
        attr = new Attr("aci", aCI2.toString());
        this.modify(attr, 0);
        this.save();
    }

    public static void addAttributeValue(SSOToken sSOToken, Guid guid, String string, String string2) throws UMSException {
        if (guid == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        if (sSOToken == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-token"));
        }
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        Attr attr = new Attr(string, string2);
        attr = null;
        Validation.validateAttribute(attr, UMSObject.getObject(sSOToken, guid).getClass(), guid);
        try {
            DataLayer.getInstance().addAttributeValue(sSOToken.getPrincipal(), guid, string, string2);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), sSOException);
        }
    }

    public static void removeAttributeValue(SSOToken sSOToken, Guid guid, String string, String string2) throws UMSException {
        if (guid == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        if (sSOToken == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-token"));
        }
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        try {
            DataLayer.getInstance().removeAttributeValue(sSOToken.getPrincipal(), guid, string, string2);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), sSOException);
        }
    }

    protected boolean isPersistent() {
        return this.m_principal != null && this.m_guid != null && this.m_guid.getDn().length() > 0;
    }

    private Collection findAttributesNotRead(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.m_attrSet.getAttribute(stringArray[n2]) == null && !this.m_nullAttributes.contains(stringArray[n2])) {
                arrayList.add(stringArray[n2]);
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean isAttributeNotRead(String string) {
        boolean bl = false;
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        if (this.m_attrSet.getAttribute(string) == null && !this.m_nullAttributes.contains(string)) {
            bl = true;
        }
        return bl;
    }

    private Collection readAttributesFromDataStore(Collection collection) throws UMSException {
        Object object;
        Collection collection2 = DataLayer.getInstance().getAttributes(this.getPrincipal(), this.getGuid(), collection);
        if (collection2 == null) {
            Object[] objectArray = new String[]{this.getDN()};
            throw new UMSException(i18n.getString("ums-readattributeserror", objectArray));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            object = (Attr)iterator.next();
            arrayList.add(((Attr)object).getName());
            this.m_attrSet.replace((Attr)object);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (arrayList.contains(object) || this.m_nullAttributes.contains(object)) continue;
            this.m_nullAttributes.add(object);
        }
        return collection2;
    }

    private Attr readAttributeFromDataStore(String string) {
        Attr attr = DataLayer.getInstance().getAttribute(this.getPrincipal(), this.getGuid(), string);
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        if (attr != null) {
            this.m_attrSet.replace(attr);
        } else if (!this.m_nullAttributes.contains(string)) {
            this.m_nullAttributes.add(string);
        }
        return attr;
    }

    private Attr getAttributeFromCache(String string) {
        Attr attr = null;
        if (this.m_attrSet != null) {
            attr = this.m_attrSet.getAttribute(string);
        }
        return attr;
    }

    private Collection getAttributesFromCache(Collection collection) {
        ArrayList<Attr> arrayList = new ArrayList<Attr>();
        if (this.m_attrSet != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Attr attr = this.m_attrSet.getAttribute(string);
                if (attr == null) continue;
                arrayList.add(attr);
            }
        }
        return arrayList;
    }
}

