/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.BaseRole;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IFilteredMembership;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.security.Principal;

public class FilteredRole
extends BaseRole
implements IFilteredMembership,
IUMSConstants {
    public static final String FILTER_ATTR_NAME = "nsRoleFilter";
    public static final String[] FILTEREDROLE_OBJECTCLASSES = new String[]{"top", "ldapsubentry", "nsroledefinition", "nscomplexroledefinition", "nsfilteredroledefinition"};
    public static final String[] FILTEREDROLE_ATTRIBUTES = new String[]{"cn", "nsRoleFilter"};
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static final Class _class = class$com$iplanet$ums$FilteredRole == null ? (class$com$iplanet$ums$FilteredRole = FilteredRole.class$("com.iplanet.ums.FilteredRole")) : class$com$iplanet$ums$FilteredRole;
    static /* synthetic */ Class class$com$iplanet$ums$FilteredRole;

    public FilteredRole() {
    }

    public FilteredRole(String string, String string2) throws UMSException {
        this(new AttrSet(new Attr("cn", string)));
    }

    FilteredRole(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public FilteredRole(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public void setFilter(String string) throws UMSException {
        this.setAttribute(new Attr(FILTER_ATTR_NAME, string));
    }

    public String getFilter() throws UMSException {
        return this.getAttribute(FILTER_ATTR_NAME).getValue();
    }

    protected SearchResults getMembers(String[] stringArray) throws UMSException {
        Guid guid = this.getGuid();
        String string = guid.getDn();
        int n = string.indexOf(",");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        Guid guid2 = new Guid(string);
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        return DataLayer.getInstance().search(principal, guid2, 2, this.getFilter(), stringArray, false, null);
    }

    protected SearchResults getMembers(String[] stringArray, String string) throws InvalidSearchFilterException, UMSException {
        Guid guid = this.getGuid();
        String string2 = guid.getDn();
        int n = string2.indexOf(",");
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        Guid guid2 = new Guid(string2);
        return DataLayer.getInstance().search(this.getPrincipal(), guid2, 2, " ( &  ( " + this.getFilter() + ")" + " ( " + string + " ) " + " ) ", stringArray, false, null);
    }

    public SearchResults getMemberIDs() throws UMSException {
        String[] stringArray = new String[]{"objectclass"};
        return this.getMembers(stringArray);
    }

    public SearchResults getMemberIDs(String string) throws UMSException {
        String[] stringArray = new String[]{"objectclass"};
        return this.getMembers(stringArray, string);
    }

    public int getMemberCount() throws UMSException {
        int n = 0;
        String[] stringArray = new String[]{"dn"};
        SearchResults searchResults = this.getMembers(stringArray);
        while (searchResults.hasMoreElements()) {
            searchResults.next().getDN();
            ++n;
        }
        return n;
    }

    public Guid getMemberIDAt(int n) throws UMSException {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        String[] stringArray = new String[]{"dn"};
        SearchResults searchResults = this.getMembers(stringArray);
        int n2 = 0;
        while (searchResults.hasMoreElements()) {
            String string = searchResults.next().getDN();
            if (n2 == n) {
                searchResults.abandon();
                return new Guid(string);
            }
            ++n2;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
    }

    public boolean hasMember(Guid guid) throws UMSException {
        boolean bl = false;
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        PersistentObject persistentObject = UMSObject.getObject(principal, guid);
        return this.hasMember(persistentObject);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

