/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IAssignableMembership;
import com.iplanet.ums.IDynamicMembership;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class AssignableDynamicGroup
extends DynamicGroup
implements IAssignableMembership,
IDynamicMembership {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static final String MEMBER_ATTR_NAME = "memberof";
    private static final String MEMBER_URL_NAME = "memberurl";
    private static final Class _class = new AssignableDynamicGroup().getClass();

    public AssignableDynamicGroup() {
    }

    AssignableDynamicGroup(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public AssignableDynamicGroup(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    AssignableDynamicGroup(AttrSet attrSet, Guid guid, int n) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet, guid, n);
    }

    public AssignableDynamicGroup(CreationTemplate creationTemplate, AttrSet attrSet, Guid guid, int n) throws UMSException {
        super(creationTemplate, attrSet);
        this.setUrl(guid, null, n);
    }

    public void setSearchFilter(String string) {
        LDAPUrl lDAPUrl = this.getUrl();
        int n = lDAPUrl.getScope();
        if (n != 1 && n != 2) {
            String string2 = i18n.getString("ums-illegaladgroupscope");
            throw new IllegalArgumentException(string2);
        }
        Guid guid = new Guid(lDAPUrl.getDN());
        this.setUrl(guid, string, n);
    }

    protected void setGuid(Guid guid) {
        block2: {
            super.setGuid(guid);
            try {
                this.setSearchFilter("memberof=" + this.getDN());
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block2;
                debug.message("AssignableDynamicGroup.setGuid() : Exception : " + exception.getMessage());
            }
        }
    }

    public void addMember(Guid guid) throws UMSException {
        if (this.getPrincipal() == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-principal"));
        }
        this.addMember(UMSObject.getObject(this.getPrincipal(), guid));
    }

    public void addMember(PersistentObject persistentObject) throws UMSException {
        LDAPUrl lDAPUrl;
        DN dN;
        DN dN2 = new DN(persistentObject.getGuid().getDn());
        if (!dN2.isDescendantOf(dN = new DN((lDAPUrl = this.getUrl()).getDN())) || dN2.equals(dN)) {
            Object[] objectArray = new String[]{dN2.toString(), lDAPUrl.toString()};
            String string = i18n.getString("ums-usernotingroupscope", objectArray);
            throw new UMSException(string);
        }
        if (dN2.countRDNs() - dN.countRDNs() > 1 && lDAPUrl.getScope() == 1) {
            Object[] objectArray = new String[]{dN2.toString(), lDAPUrl.toString()};
            String string = i18n.getString("ums-usernotingroupscope", objectArray);
            throw new UMSException(string);
        }
        persistentObject.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 0);
        persistentObject.save();
    }

    public void addMembers(Guid[] guidArray) throws UMSException {
        if (guidArray == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        int n = 0;
        while (n < guidArray.length) {
            this.addMember(guidArray[n]);
            ++n;
        }
    }

    public void removeMember(Guid guid) throws UMSException {
        PersistentObject persistentObject = UMSObject.getObject(this.getPrincipal(), guid);
        this.removeMember(persistentObject);
    }

    public void removeMember(PersistentObject persistentObject) throws UMSException {
        persistentObject.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 1);
        persistentObject.save();
    }

    public void removeAllMembers() throws UMSException {
        String string = this.getSearchFilter();
        if (string == null) {
            return;
        }
        String[] stringArray = new String[]{"dn"};
        SearchResults searchResults = this.getMemberIDs(stringArray);
        while (searchResults.hasMoreElements()) {
            PersistentObject persistentObject = searchResults.next();
            persistentObject.setPrincipal(this.getPrincipal());
            this.removeMember(persistentObject);
        }
    }

    public boolean hasMember(Guid guid) throws UMSException {
        if (this.getPrincipal() == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-principal"));
        }
        PersistentObject persistentObject = UMSObject.getObject(this.getPrincipal(), guid);
        Attr attr = persistentObject.getAttribute(MEMBER_ATTR_NAME);
        if (attr == null) {
            if (debug.messageEnabled()) {
                debug.message("AssignableDynamicGroup.hasMember: no attribute memberof in " + guid.getDn());
            }
            return false;
        }
        String string = this.getGuid().getDn();
        String[] stringArray = attr.getStringValues();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (debug.messageEnabled()) {
                debug.message("AssignableDynamicGroup.hasMember: comparing " + string + " to " + string2);
            }
            if (Guid.equals(string, string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

