/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIComposeException;
import com.iplanet.services.ldap.aci.ACIException;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACIParser;
import com.iplanet.services.ldap.aci.ACR;
import com.iplanet.services.ldap.aci.BindRule;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ACI {
    public static final String ACI = "aci";
    static final String[] SUPPORTED_ATTR_RULES = new String[]{"userdnattr", "groupdnattr", "userattr"};
    static final Collection SUPPORTED_ATTR_RULES_COLLECTION = Arrays.asList(SUPPORTED_ATTR_RULES);
    static final String TARGET = "target";
    static final String TARGETFILTER = "targetfilter";
    static final String TARGETATTR = "targetattr";
    static final String TARGETATTRFILTERS = "targetattrfilters";
    static final String VERSION = "version";
    static final String ACL = "acl";
    static final String ALLOW = "allow";
    static final String DENY = "deny";
    static final String USERDN = "userdn";
    static final String GROUPDN = "groupdn";
    static final String ROLEDN = "roledn";
    static final String USERDNATTR = "userdnattr";
    static final String GROUPDNATTR = "groupdnattr";
    static final String USERATTR = "userattr";
    static final String AUTHMETHOD = "authmethod";
    static final String IP = "ip";
    static final String DNS = "dns";
    static final String TIMEOFDAY = "timeofday";
    static final String DAYOFWEEK = "dayofweek";
    static final String PRINCIPAL_SET = "principal";
    static final String AUTHMETHOD_SET = "authmethod";
    static final String IP_SET = "IP";
    static final String TOD_SET = "tod";
    static final String DOW_SET = "dow";
    static final String KEYWORD = "keyword";
    static final String OPERATOR = "operator";
    static final String VALUE = "value";
    static final String OPENPARENTH = "(";
    static final String CLOSEPARENTH = ")";
    static final String EXPRESSIONCONNECTOR = "expressionconnector";
    static final String EQ = "=";
    static final String NE = "!=";
    static final String GE = ">=";
    static final String LE = "<=";
    static final String GT = ">";
    static final String LT = "<";
    static final String AND = "and";
    static final String OR = "or";
    static final String OR_PIPE = "||";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String NEWLINE = "\n";
    static final String SEMICOLON = ";";
    static final String COMMA = ",";
    static final String LDAP_PREFIX = "ldap:///";
    private String _target;
    private String _targetFilter;
    private String _targetAttrFilters;
    private QualifiedCollection _targetAttributes;
    private String _name = "Unnamed";
    private String _version = "3.0";
    private QualifiedCollection _permissions;
    private Collection _users;
    private Collection _groups;
    private Collection _roles;
    private Collection _clientIP;
    private Collection _clientHostNames;
    private Collection _timesOfDay;
    private Collection _daysOfWeek;
    private Collection _authMethods;
    private Collection _userDNAttrs;
    private Collection _groupDNAttrs;
    private Collection _userAttrs;
    private String _aciText = "";

    public ACI() {
    }

    public ACI(String string) {
        this._name = string;
    }

    public ACI(String string, String string2, String string3, QualifiedCollection qualifiedCollection, Collection collection, QualifiedCollection qualifiedCollection2) {
        this.setName(string);
        this.setTarget(string2);
        this.setTargetFilter(string3);
        this.setTargetAttributes(qualifiedCollection);
        this.setUsers(collection);
        this.setPermissions(qualifiedCollection2);
    }

    public boolean equals(Object object) {
        ACI aCI;
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object.getClass().equals(this.getClass()) && (aCI = (ACI)object).getName().equals(this.getName()) && aCI.getTarget().equals(this.getTarget()) && aCI.getTargetFilter().equals(this.getTargetFilter()) && aCI.getTargetAttributes().equals(this.getTargetAttributes()) && aCI.getPermissions().equals(this.getPermissions()) && aCI.getUsers().equals(this.getUsers()) && aCI.getGroups().equals(this.getGroups()) && aCI.getRoles().equals(this.getRoles()) && aCI.getClientHostNames().equals(this.getClientHostNames()) && aCI.getTimesOfDay().equals(this.getTimesOfDay()) && aCI.getDaysOfWeek().equals(this.getDaysOfWeek()) && aCI.getAuthMethods().equals(this.getAuthMethods())) {
            bl = true;
        }
        return bl;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setTarget(String string) {
        this._target = string;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTargetFilter(String string) {
        this._targetFilter = string;
    }

    public String getTargetFilter() {
        return this._targetFilter;
    }

    public void removeTargetFilter() {
        this._targetFilter = null;
    }

    public void setTargetAttributes(QualifiedCollection qualifiedCollection) {
        this._targetAttributes = qualifiedCollection;
    }

    public QualifiedCollection getTargetAttributes() {
        return this._targetAttributes;
    }

    public void removeTargetAttributes() {
        this._targetAttributes = null;
    }

    private static Collection getSupportedRights() {
        return null;
    }

    public void setPermissions(QualifiedCollection qualifiedCollection) {
        this._permissions = qualifiedCollection;
    }

    public QualifiedCollection getPermissions() {
        return this._permissions;
    }

    public void setUsers(Collection collection) {
        this._users = collection;
    }

    public Collection getUsers() {
        return this._users;
    }

    public void setGroups(Collection collection) {
        this._groups = collection;
    }

    public Collection getGroups() {
        return this._groups;
    }

    public void setRoles(Collection collection) {
        this._roles = collection;
    }

    public Collection getRoles() {
        return this._roles;
    }

    public void setClientIP(Collection collection) {
        this._clientIP = collection;
    }

    public Collection getClientIP() {
        return this._clientIP;
    }

    public void setClientHostNames(Collection collection) {
        this._clientHostNames = collection;
    }

    public Collection getClientHostNames() {
        return this._clientHostNames;
    }

    public void setTimesOfDay(Collection collection) {
        this._timesOfDay = collection;
    }

    public Collection getTimesOfDay() {
        return this._timesOfDay;
    }

    public void setDaysOfWeek(Collection collection) {
        this._daysOfWeek = collection;
    }

    public Collection getDaysOfWeek() {
        return this._daysOfWeek;
    }

    public void setAuthMethods(Collection collection) {
        this._authMethods = collection;
    }

    public Collection getAuthMethods() {
        return this._authMethods;
    }

    public void setAttrRuleValue(String string, Collection collection) throws ACIComposeException {
        if ((string = string.toLowerCase()).equals(USERDNATTR)) {
            this.setUserDNAttrs(collection);
        } else if (string.equals(GROUPDNATTR)) {
            this.setGroupDNAttrs(collection);
        } else if (string.equals(USERATTR)) {
            this.setUserAttrs(collection);
        } else {
            throw new ACIComposeException("Unsupported attr rule name : " + string);
        }
    }

    public Collection getAttrRuleValue(String string) throws ACIException {
        Collection collection = null;
        if (string.equals(USERDNATTR)) {
            collection = this.getUserDNAttrs();
        } else if (string.equals(GROUPDNATTR)) {
            collection = this.getGroupDNAttrs();
        } else if (string.equals(USERATTR)) {
            collection = this.getUserAttrs();
        } else {
            throw new ACIException("Unsupported attr rule name : " + string);
        }
        return collection;
    }

    public Collection getSupportedAttrRules() {
        return SUPPORTED_ATTR_RULES_COLLECTION;
    }

    public void setTargetAttrFilters(String string) {
        this._targetAttrFilters = string;
    }

    public String getTargetAttrFilters() {
        return this._targetAttrFilters;
    }

    public String toString() {
        Object object;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = null;
        string = this.getTarget();
        if (string != null && string.length() != 0) {
            stringBuffer.append(SPACE).append(OPENPARENTH).append(TARGET).append(SPACE).append(EQ).append(SPACE).append(QUOTE).append(string).append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        QualifiedCollection qualifiedCollection = null;
        Iterator iterator = null;
        qualifiedCollection = this.getTargetAttributes();
        if (qualifiedCollection != null && qualifiedCollection.getCollection() != null && qualifiedCollection.getCollection().size() != 0) {
            bl = qualifiedCollection.isExclusive();
            String string2 = bl ? NE : EQ;
            stringBuffer.append(SPACE).append(OPENPARENTH).append(TARGETATTR).append(SPACE).append(string2).append(SPACE);
            iterator = qualifiedCollection.getCollection().iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(QUOTE).append(string);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(OR_PIPE).append(string);
            }
            stringBuffer.append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        if ((string = this.getTargetFilter()) != null && string.length() != 0) {
            stringBuffer.append(SPACE).append(OPENPARENTH).append(TARGETFILTER).append(SPACE).append(EQ).append(SPACE).append(QUOTE).append(string).append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        if ((string = this.getTargetAttrFilters()) != null && string.length() != 0) {
            stringBuffer.append(SPACE).append(OPENPARENTH).append(TARGETATTRFILTERS).append(SPACE).append(EQ).append(SPACE).append(QUOTE).append(string).append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        stringBuffer.append(SPACE).append(OPENPARENTH).append(VERSION).append(SPACE).append(this.getVersion()).append(SEMICOLON);
        stringBuffer.append(ACL).append(SPACE).append(QUOTE).append(this.getName()).append(QUOTE).append(SEMICOLON);
        qualifiedCollection = this.getPermissions();
        if (qualifiedCollection != null && qualifiedCollection.getCollection() != null && qualifiedCollection.getCollection().size() != 0) {
            bl = qualifiedCollection.isExclusive();
            object = bl ? DENY : ALLOW;
            stringBuffer.append((String)object).append(OPENPARENTH);
            iterator = qualifiedCollection.getCollection().iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(string);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(COMMA).append(SPACE).append(string);
            }
            stringBuffer.append(CLOSEPARENTH).append(NEWLINE);
        }
        object = null;
        object = this.getUsers();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(USERDN).append(EQ).append(QUOTE).append(LDAP_PREFIX).append(string);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR_PIPE).append(SPACE).append(LDAP_PREFIX).append(string);
            }
            stringBuffer3.append(QUOTE).append(SPACE);
        }
        if (stringBuffer3.length() != 0) {
            stringBuffer2.append((Object)stringBuffer3);
        }
        stringBuffer3.setLength(0);
        object = this.getGroups();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(GROUPDN).append(EQ).append(QUOTE).append(LDAP_PREFIX).append(string);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR_PIPE).append(SPACE).append(LDAP_PREFIX).append(string);
            }
            stringBuffer3.append(QUOTE).append(SPACE);
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(SPACE).append(OR).append(SPACE);
            }
            stringBuffer2.append((Object)stringBuffer3);
        }
        stringBuffer3.setLength(0);
        object = this.getRoles();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(ROLEDN).append(EQ).append(QUOTE).append(LDAP_PREFIX).append(string);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR_PIPE).append(SPACE).append(LDAP_PREFIX).append(string);
            }
            stringBuffer3.append(QUOTE).append(SPACE);
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(" or ");
            }
            stringBuffer2.append((Object)stringBuffer3);
        }
        stringBuffer3.setLength(0);
        object = this.getUserDNAttrs();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(USERDNATTR).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR).append(SPACE);
                stringBuffer3.append(USERDNATTR).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(SPACE).append(OR).append(SPACE);
            }
            stringBuffer2.append((Object)stringBuffer3);
        }
        stringBuffer3.setLength(0);
        object = this.getGroupDNAttrs();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(GROUPDNATTR).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR).append(SPACE);
                stringBuffer3.append(GROUPDNATTR).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(SPACE).append(OR).append(SPACE);
            }
            stringBuffer2.append((Object)stringBuffer3);
        }
        stringBuffer3.setLength(0);
        object = this.getUserAttrs();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(USERATTR).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR).append(SPACE);
                stringBuffer3.append(USERATTR).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(SPACE).append(OR).append(SPACE);
            }
            stringBuffer2.append((Object)stringBuffer3);
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer2.insert(0, SPACE);
            stringBuffer2.insert(1, OPENPARENTH);
            stringBuffer2.append(CLOSEPARENTH).append(NEWLINE);
        }
        stringBuffer3.setLength(0);
        object = this.getAuthMethods();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append("authmethod").append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR).append(SPACE);
                stringBuffer3.append("authmethod").append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(SPACE).append(AND).append(SPACE);
            }
            stringBuffer2.append(OPENPARENTH).append((Object)stringBuffer3).append(CLOSEPARENTH);
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        object = this.getClientIP();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer4.append(IP).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer4.append(SPACE).append(OR).append(SPACE);
                stringBuffer4.append(IP).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
        }
        stringBuffer3.setLength(0);
        object = this.getClientHostNames();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(DNS).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR).append(SPACE);
                stringBuffer3.append(DNS).append(EQ).append(QUOTE).append(string).append(QUOTE);
            }
        }
        if (stringBuffer4.length() != 0) {
            stringBuffer4.append(SPACE).append(OR).append(SPACE).append((Object)stringBuffer3);
        } else {
            stringBuffer4.append((Object)stringBuffer3);
        }
        if (stringBuffer4.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(NEWLINE).append(SPACE).append(AND);
            }
            stringBuffer2.append(SPACE).append(OPENPARENTH).append((Object)stringBuffer4).append(CLOSEPARENTH);
        }
        stringBuffer3.setLength(0);
        object = this.getDaysOfWeek();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(DAYOFWEEK).append(EQ).append(QUOTE).append(string);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(COMMA).append(SPACE).append(string);
            }
            stringBuffer3.append(QUOTE).append(SPACE);
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(NEWLINE).append(SPACE).append(AND).append(SPACE);
            }
            stringBuffer2.append(OPENPARENTH).append((Object)stringBuffer3).append(CLOSEPARENTH);
        }
        stringBuffer3.setLength(0);
        object = this.getTimesOfDay();
        if (object != null && object.size() != 0) {
            iterator = object.iterator();
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(TIMEOFDAY).append(GE).append(QUOTE).append(string).append(QUOTE);
            }
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(AND).append(SPACE);
                stringBuffer3.append(TIMEOFDAY).append(LE).append(QUOTE).append(string).append(QUOTE);
            }
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(OR).append(SPACE);
                stringBuffer3.append(TIMEOFDAY).append(GE).append(QUOTE).append(string).append(QUOTE);
                if (!iterator.hasNext()) continue;
                string = (String)iterator.next();
                stringBuffer3.append(SPACE).append(AND).append(SPACE);
                stringBuffer3.append(TIMEOFDAY).append(LE).append(QUOTE).append(string).append(QUOTE);
            }
        }
        if (stringBuffer3.length() != 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(NEWLINE).append(SPACE).append(AND).append(SPACE);
            }
            stringBuffer2.append(OPENPARENTH).append((Object)stringBuffer3).append(CLOSEPARENTH);
        }
        if (stringBuffer2.length() != 0) {
            stringBuffer.append((Object)stringBuffer2);
        }
        stringBuffer.append(SEMICOLON).append(SPACE).append(CLOSEPARENTH);
        return stringBuffer.toString().replace('\n', ' ');
    }

    public static ACI valueOf(String string) throws ACIParseException {
        return ACIParser.parseACI(string);
    }

    public void setUserDNAttrs(Collection collection) {
        this._userDNAttrs = collection;
    }

    public Collection getUserDNAttrs() {
        return this._userDNAttrs;
    }

    public void setGroupDNAttrs(Collection collection) {
        this._groupDNAttrs = collection;
    }

    Collection getGroupDNAttrs() {
        return this._groupDNAttrs;
    }

    public void setUserAttrs(Collection collection) {
        this._userAttrs = collection;
    }

    public Collection getUserAttrs() {
        return this._userAttrs;
    }

    public void setACIText(String string) {
        this._aciText = string;
    }

    public String getACIText() {
        return this._aciText;
    }

    public void setACR(ACR aCR) {
        this.setVersion(aCR.getVersion());
        this.setName(aCR.getName());
        this.setPermissions(aCR.getPermissions());
        BindRule bindRule = aCR.getBindRule();
        this.setUsers(bindRule.getUsers());
        this.setGroups(bindRule.getGroups());
        this.setRoles(bindRule.getRoles());
        this.setUserDNAttrs(bindRule.getUserDNAttrs());
        this.setGroupDNAttrs(bindRule.getGroupDNAttrs());
        this.setUserAttrs(bindRule.getUserAttrs());
        this.setAuthMethods(bindRule.getAuthMethods());
        this.setClientIP(bindRule.getClientIP());
        this.setClientHostNames(bindRule.getClientHostNames());
        this.setDaysOfWeek(bindRule.getDaysOfWeek());
        this.setTimesOfDay(bindRule.getTimesOfDay());
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public String getVersion() {
        return this._version;
    }
}

