/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm.clientschema;

import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.service.UserPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AMClientCapData
implements ServiceListener {
    private static final String SERVICE_VERSION = "1.0";
    private static final String SERVICE_NAME = "SunAMClientData";
    private static final int PRIORITY = 0;
    private static final String BUNDLE_NAME = "amClientData";
    private static final String CREATE_FAILED = "901";
    private static final String GET_CONFIG_FAILED = "902";
    private static final String MISSING_PROP_CT = "903";
    private static final String CT_EXISTS = "904";
    private static final String ADD_FAILED = "905";
    private static final String CANNOT_MOD_INT_DB = "906";
    private static final String MODIFY_FAILED = "907";
    private static final String DELETE_FAILED = "908";
    private static final String[] dsameAttributeNames = new String[]{"generalPropertyNames", "hardwarePlatformNames", "softwarePlatformNames", "networkCharacteristicsNames", "browserUANames", "wapCharacteristicsNames", "pushCharacteristicsNames", "additionalPropertiesNames"};
    private static final String DBSTORE_SUBSCHEMA_ID = "clientDBStore";
    private static final String INTERNAL_SUBCONFIG_NAME = "internalData";
    private static final String EXTERNAL_SUBCONFIG_NAME = "externalData";
    public static final int INTERNAL = 1;
    public static final int EXTERNAL = 2;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int MODIFIED = 4;
    private static final String CLIENT_SUBSCHEMA_ID = "clientData";
    private static final String CLIENT_TYPE = "clientType";
    private static final String PROFILE_MANAGER_XML_ATTR = "profileManagerXML";
    private static final String ENABLE_CLIENT_CREATION_ATTR = "enableClientCreation";
    private static final char COMPONENT_SEPARATOR = '/';
    public static final String ADDITIONAL_PROPERTIES_ATTR = "additionalProperties";
    public static final String ADD_PROP_SEPARATOR = "=";
    private static final String COMMA = ",";
    private static final String adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
    private static final String adminPW = (String)AccessController.doPrivileged(new AdminPasswordAction());
    private static SSOToken adminToken = null;
    private static Debug debug = Debug.getInstance((String)"amClientSchema");
    private static AMClientCapData internalInstance = null;
    private static AMClientCapData externalInstance = null;
    private String clientSubConfigName = null;
    private int databaseType = 0;
    private String dbStr = null;
    private ServiceManager sManager = null;
    private ServiceConfigManager scManager = null;
    private ServiceConfig clientServiceConfig = null;
    private ServiceConfig clientData = null;
    private ServiceSchemaManager schemaManager = null;
    private ServiceSchema clientServiceSchema = null;
    private ServiceSchema clientSchema = null;
    private Map schemaMap = null;
    private List listeners = new ArrayList(2);

    private AMClientCapData(int n) throws Exception {
        this.databaseType = n;
        if (this.isInternalInstance()) {
            this.clientSubConfigName = INTERNAL_SUBCONFIG_NAME;
            this.dbStr = "InternalDB:: ";
        } else {
            this.clientSubConfigName = EXTERNAL_SUBCONFIG_NAME;
            this.dbStr = "ExternalDB:: ";
        }
        this.init();
    }

    private synchronized void init() throws Exception {
        Object object;
        Object object2;
        if (adminToken == null) {
            object2 = SSOTokenManager.getInstance();
            object = new UserPrincipal(adminDN);
            adminToken = object2.createSSOToken((Principal)object, adminPW);
        }
        this.sManager = new ServiceManager(adminToken);
        object2 = this.getServiceName();
        object = this.getClientSubConfigName();
        this.scManager = this.sManager.getConfigManager((String)object2, SERVICE_VERSION);
        this.clientServiceConfig = this.scManager.getGlobalConfig(null);
        this.clientData = this.getConfiguration(this.clientServiceConfig, (String)object);
        this.schemaManager = this.sManager.getSchemaManager((String)object2, SERVICE_VERSION);
        this.clientServiceSchema = this.schemaManager.getGlobalSchema();
        this.clientSchema = this.clientServiceSchema.getSubSchema(DBSTORE_SUBSCHEMA_ID);
        this.clientSchema = this.clientSchema.getSubSchema(CLIENT_SUBSCHEMA_ID);
        this.scManager.addListener(this);
    }

    private boolean isInternalInstance() {
        return this.databaseType == 1;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private String getClientSubConfigName() {
        return this.clientSubConfigName;
    }

    private ServiceConfig getConfiguration(ServiceConfig serviceConfig, String string) {
        String string2 = "Get SubConfig failed";
        return this.getConfiguration(serviceConfig, string, string2);
    }

    private ServiceConfig getConfiguration(ServiceConfig serviceConfig, String string, String string2) {
        ServiceConfig serviceConfig2 = null;
        try {
            serviceConfig2 = serviceConfig.getSubConfig(string);
        }
        catch (Exception exception) {
            String string3 = string2 + " for :: " + string + " : ";
            if (debug.messageEnabled()) {
                debug.message(this.dbStr + string3, (Throwable)exception);
            }
            serviceConfig2 = null;
        }
        return serviceConfig2;
    }

    private Set getConfigurationNames(ServiceConfig serviceConfig) {
        String string = "Get SubConfigNames failed";
        return this.getConfigurationNames(serviceConfig, string);
    }

    private Set getConfigurationNames(ServiceConfig serviceConfig, String string) {
        Set set = null;
        try {
            set = serviceConfig.getSubConfigNames();
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message(this.dbStr + string, (Throwable)exception);
            }
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public static synchronized AMClientCapData getInternalInstance() throws AMClientCapException {
        if (internalInstance == null) {
            try {
                internalInstance = new AMClientCapData(1);
            }
            catch (Exception exception) {
                internalInstance = null;
                debug.error("InternalDB:: Create instance object failed: ", (Throwable)exception);
                throw new AMClientCapException(BUNDLE_NAME, CREATE_FAILED, null);
            }
        }
        return internalInstance;
    }

    public static synchronized AMClientCapData getExternalInstance() throws AMClientCapException {
        if (externalInstance == null) {
            try {
                externalInstance = new AMClientCapData(2);
            }
            catch (Exception exception) {
                externalInstance = null;
                debug.error("ExternalDB:: Create instance object failed: ", (Throwable)exception);
                throw new AMClientCapException(BUNDLE_NAME, CREATE_FAILED, null);
            }
        }
        return externalInstance;
    }

    public Set getClients() {
        Set set = this.getConfigurationNames(this.clientData);
        return set;
    }

    public String getProfileManagerXML() {
        String string = null;
        Set set = this.getServiceAttribute(PROFILE_MANAGER_XML_ATTR);
        if (set != null) {
            Iterator iterator = set.iterator();
            string = (String)iterator.next();
        }
        return string;
    }

    private Set getServiceAttribute(String string) {
        Set set = null;
        Map map = this.clientServiceConfig.getAttributes();
        if (map != null) {
            set = (Set)map.get(string);
        }
        return set;
    }

    public Set getPropertyNames(String string) {
        Set set = null;
        if (string != null) {
            set = this.getServiceAttribute(string);
        }
        return set;
    }

    public boolean isClientPresent(String string) {
        boolean bl = false;
        ServiceConfig serviceConfig = this.getConfiguration(this.clientData, string);
        if (serviceConfig != null) {
            bl = true;
        }
        return bl;
    }

    public Map getProperties(String string) {
        Map map = null;
        ServiceConfig serviceConfig = this.getConfiguration(this.clientData, string);
        if (serviceConfig == null) {
            return map;
        }
        map = serviceConfig.getAttributes();
        map = this.removeNonExistentProperties(map);
        return map;
    }

    private Map removeNonExistentProperties(Map map) {
        if (map == null) {
            return map;
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            if (set2 == null || set2.size() <= 0) continue;
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    private ServiceConfig getClientDataConfig(SSOToken sSOToken) throws AMClientCapException {
        String string = this.getClientSubConfigName();
        ServiceConfig serviceConfig = null;
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, this.getServiceName(), SERVICE_VERSION);
            serviceConfig = serviceConfigManager.getGlobalConfig(null);
            serviceConfig = this.getConfiguration(serviceConfig, string);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message(this.dbStr, (Throwable)exception);
            }
            throw new AMClientCapException(BUNDLE_NAME, GET_CONFIG_FAILED, null);
        }
        return serviceConfig;
    }

    private String getClientType(Map map) {
        String string = null;
        Set set = (Set)map.get(CLIENT_TYPE);
        if (set != null && set.size() > 0) {
            Iterator iterator = set.iterator();
            string = (String)iterator.next();
        }
        return string;
    }

    public int addClient(SSOToken sSOToken, Map map) throws AMClientCapException {
        int n = 0;
        ServiceConfig serviceConfig = this.getClientDataConfig(sSOToken);
        String string = this.getClientType(map);
        if (string == null || string.equals("")) {
            throw new AMClientCapException(BUNDLE_NAME, MISSING_PROP_CT, null);
        }
        if (this.getConfiguration(serviceConfig, string) != null) {
            String string2 = string;
            Object[] objectArray = new String[]{string2};
            throw new AMClientCapException(BUNDLE_NAME, CT_EXISTS, objectArray);
        }
        Object var6_7 = null;
        String string3 = ADD_FAILED;
        map = this.copyMap(map);
        map = this.getKnownProperties(map);
        boolean bl = true;
        this.modifyClient(serviceConfig, string, map, string3, bl);
        return n;
    }

    public int modifyClient(SSOToken sSOToken, Map map) throws AMClientCapException {
        int n = 0;
        if (this.isInternalInstance()) {
            throw new AMClientCapException(BUNDLE_NAME, CANNOT_MOD_INT_DB, null);
        }
        ServiceConfig serviceConfig = this.getClientDataConfig(sSOToken);
        String string = this.getClientType(map = this.copyMap(map));
        if (string == null || string.equals("")) {
            throw new AMClientCapException(BUNDLE_NAME, MISSING_PROP_CT, null);
        }
        String string2 = MODIFY_FAILED;
        map = this.getKnownProperties(map);
        this.modifyClient(serviceConfig, string, map, string2, false);
        return n;
    }

    private void modifyClient(ServiceConfig serviceConfig, String string, Map map, String string2, boolean bl) throws AMClientCapException {
        ServiceConfig serviceConfig2;
        ServiceConfig serviceConfig3 = serviceConfig2 = bl ? null : this.getConfiguration(serviceConfig, string);
        if (serviceConfig2 == null) {
            try {
                serviceConfig.addSubConfig(string, CLIENT_SUBSCHEMA_ID, 0, map);
            }
            catch (Exception exception) {
                String string3 = string;
                Object[] objectArray = new String[]{string3};
                AMClientCapException aMClientCapException = new AMClientCapException(BUNDLE_NAME, string2, objectArray);
                String string4 = aMClientCapException.getMessage();
                debug.error(this.dbStr + string4, (Throwable)exception);
                throw aMClientCapException;
            }
        }
        try {
            serviceConfig2.setAttributes(map);
        }
        catch (Exception exception) {
            String string5 = string;
            Object[] objectArray = new String[]{string5};
            AMClientCapException aMClientCapException = new AMClientCapException(BUNDLE_NAME, string2, objectArray);
            String string6 = aMClientCapException.getMessage();
            debug.error(this.dbStr + string6, (Throwable)exception);
            throw aMClientCapException;
        }
    }

    private Map getKnownProperties(Map map) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>(5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set set = this.getSchemaElements();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (set.contains(object)) continue;
            arrayList.add(object);
            Set set2 = (Set)map.get(object);
            if (set2 == null || set2.size() == 0) continue;
            String string = null;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = string = string == null ? string2 : string + COMMA + string2;
            }
            hashSet.add((String)object + ADD_PROP_SEPARATOR + string);
        }
        if (hashSet.size() > 0) {
            object = (Set)map.get(ADDITIONAL_PROPERTIES_ATTR);
            if (object != null) {
                hashSet.addAll((Collection<String>)object);
            }
            map.put(ADDITIONAL_PROPERTIES_ATTR, hashSet);
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            map.remove((String)arrayList.get(n2));
            ++n2;
        }
        return map;
    }

    public int removeClient(SSOToken sSOToken, String string) throws AMClientCapException {
        boolean bl = false;
        if (this.isInternalInstance()) {
            throw new AMClientCapException(BUNDLE_NAME, CANNOT_MOD_INT_DB, null);
        }
        ServiceConfig serviceConfig = this.getClientDataConfig(sSOToken);
        if (string == null || string.equals("")) {
            throw new AMClientCapException(BUNDLE_NAME, MISSING_PROP_CT, null);
        }
        this.removeFromConfig(serviceConfig, string);
        return 0;
    }

    private Map copyMap(Map map) {
        int n = map.size();
        HashMap hashMap = new HashMap(n);
        hashMap.putAll(map);
        return hashMap;
    }

    private void removeFromConfig(ServiceConfig serviceConfig, String string) throws AMClientCapException {
        try {
            serviceConfig.removeSubConfig(string);
        }
        catch (Exception exception) {
            String string2 = string;
            Object[] objectArray = new String[]{string2};
            AMClientCapException aMClientCapException = new AMClientCapException(BUNDLE_NAME, DELETE_FAILED, objectArray);
            String string3 = aMClientCapException.getMessage();
            debug.error(this.dbStr + string3, (Throwable)exception);
            throw aMClientCapException;
        }
    }

    public synchronized Set getSchemaElements() {
        Map map = this.getSchemaMap();
        Set set = map.keySet();
        return set;
    }

    public AttributeSchema getAttributeSchema(String string) {
        Map map = this.getSchemaMap();
        AttributeSchema attributeSchema = (AttributeSchema)map.get(string);
        return attributeSchema;
    }

    private synchronized Map getSchemaMap() {
        if (this.schemaMap == null) {
            Set set = this.clientSchema.getAttributeSchemas();
            this.schemaMap = new HashMap();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getName();
                this.schemaMap.put(string, attributeSchema);
            }
        }
        return this.schemaMap;
    }

    public boolean canCreateInternalClients() {
        boolean bl = false;
        Set set = this.getServiceAttribute(ENABLE_CLIENT_CREATION_ATTR);
        if (set != null) {
            Iterator iterator = set.iterator();
            Boolean bl2 = new Boolean((String)iterator.next());
            bl = bl2;
        }
        return bl;
    }

    public void addListener(AMClientDataListener aMClientDataListener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(aMClientDataListener)) {
                this.listeners.add(aMClientDataListener);
            }
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        if (debug.messageEnabled()) {
            debug.message(this.dbStr + ": globalConfigChanged(): " + "ServiceName = " + string + " :Version = " + string2 + " :GroupName = " + string3 + " :Component = " + string4 + " :Type = " + n);
        }
        if (string4 == null) {
            return;
        }
        String string5 = string4.trim();
        int n2 = string5.indexOf(47);
        if (n2 == -1) {
            debug.error("globalConfigChanged(): first == -1 ");
            return;
        }
        int n3 = string5.indexOf(47, n2 + 1);
        if (n3 == -1) {
            debug.error("globalConfigChanged(): second == -1");
            return;
        }
        String string6 = string5.substring(n2 + 1, n3);
        if (!string6.equalsIgnoreCase(this.clientSubConfigName)) {
            return;
        }
        String string7 = string5.substring(n3 + 1);
        if (n != 2) {
            string7 = this.getCaseExactName(string7);
        }
        List list = this.listeners;
        synchronized (list) {
            int n4 = this.listeners.size();
            int n5 = 0;
            while (n5 < n4) {
                AMClientDataListener aMClientDataListener = (AMClientDataListener)this.listeners.get(n5);
                try {
                    aMClientDataListener.clientChanged(string7, this.databaseType, n);
                }
                catch (Throwable throwable) {
                    debug.error("Event Notification failed: ", throwable);
                }
                ++n5;
            }
        }
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    public void schemaChanged(String string, String string2) {
    }

    private String getCaseExactName(String string) {
        String string2 = null;
        ServiceConfig serviceConfig = this.getConfiguration(this.clientData, string);
        if (serviceConfig != null) {
            Map map = serviceConfig.getAttributes();
            string2 = this.getClientType(map);
        }
        return string2;
    }

    public String[] getClassifications() {
        return dsameAttributeNames;
    }
}

