/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.CDMBundle;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientDetectionException;
import com.iplanet.services.cdm.ClientDetectionInterface;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class ClientDetectionDefaultImpl
implements ClientDetectionInterface {
    protected static Debug debug = Debug.getInstance((String)"amClientDetection");
    protected static DefaultClientTypesManager defCTM = (DefaultClientTypesManager)AMClientDetector.getClientTypesManagerInstance();

    public String getClientType(HttpServletRequest httpServletRequest) throws ClientDetectionException {
        String string = httpServletRequest.getHeader("user-agent");
        String string2 = null;
        int n = 0;
        if (debug.messageEnabled()) {
            debug.message("UserAgent : httpUA is : " + string);
            debug.message("Looking in UA/PartialMatch Maps");
        }
        Client client = null;
        client = defCTM.getFromUserAgentMap(string);
        if (client != null) {
            string2 = client.getClientType();
            if (debug.messageEnabled()) {
                debug.message("Perf: from UA Map: " + string2);
            }
            return string2;
        }
        string2 = defCTM.getPartiallyMatchedClient(string);
        if (string2 != null) {
            if (debug.messageEnabled()) {
                debug.message("Perf: from PartialMatch Map: " + string2);
            }
            return string2;
        }
        int n2 = 0;
        Iterator iterator = ClientsManager.getAllInstances();
        while (iterator.hasNext()) {
            client = (Client)iterator.next();
            ++n2;
            String string3 = client.getProperty("userAgent");
            if (string3 == null) continue;
            if (debug.messageEnabled()) {
                debug.message("(" + n2 + ") Client user-agent = " + string3 + " :: clientType = " + client.getClientType());
            }
            if (!this.userAgentCheck(string, string3)) continue;
            String string4 = client.getProperty("clientType");
            int n3 = string3.length();
            if (n3 <= n) continue;
            string2 = string4;
            n = n3;
            if (!debug.messageEnabled()) continue;
            debug.message("Longest user-agent match client type =\t\t\t\t " + string2);
        }
        if (string2 == null) {
            string2 = Client.getDefaultInstance().getProperty("clientType");
            if (debug.messageEnabled()) {
                debug.message("Default client type = " + string2);
            }
        } else {
            defCTM.addToPartialMatchMap(string, string2);
        }
        if (string2 == null) {
            debug.message("Unable to obtain default client type");
            throw new ClientDetectionException(CDMBundle.getString("null_clientType"));
        }
        if (debug.messageEnabled()) {
            debug.message("Returning client type : " + string2);
        }
        return string2;
    }

    protected boolean userAgentCheck(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2) || string.indexOf(string2) > -1;
    }
}

