/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVAValueConverter;
import com.iplanet.security.x509.DirStrConverter;
import com.iplanet.security.x509.IA5StringConverter;
import com.iplanet.security.x509.PrintableConverter;
import java.util.Enumeration;
import java.util.Hashtable;

public class X500NameAttrMap {
    Hashtable name2OID = new Hashtable();
    Hashtable oid2Name = new Hashtable();
    Hashtable oid2ValueConverter = new Hashtable();
    private static X500NameAttrMap defMap = new X500NameAttrMap();

    public String getName(ObjectIdentifier objectIdentifier) {
        return (String)this.oid2Name.get(objectIdentifier);
    }

    public ObjectIdentifier getOid(String string) {
        return (ObjectIdentifier)this.name2OID.get(string.toUpperCase());
    }

    public AVAValueConverter getValueConverter(String string) {
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)this.name2OID.get(string.toUpperCase());
        if (objectIdentifier == null) {
            return null;
        }
        return (AVAValueConverter)this.oid2ValueConverter.get(objectIdentifier);
    }

    public AVAValueConverter getValueConverter(ObjectIdentifier objectIdentifier) {
        return (AVAValueConverter)this.oid2ValueConverter.get(objectIdentifier);
    }

    public Enumeration getAllNames() {
        return this.name2OID.keys();
    }

    public Enumeration getAllOIDs() {
        return this.oid2Name.keys();
    }

    public ObjectIdentifier getOid(ObjectIdentifier objectIdentifier) {
        String string = (String)this.oid2Name.get(objectIdentifier);
        if (string == null) {
            return null;
        }
        return (ObjectIdentifier)this.name2OID.get(string);
    }

    public void addNameOID(String string, ObjectIdentifier objectIdentifier, AVAValueConverter aVAValueConverter) {
        ObjectIdentifier objectIdentifier2 = (ObjectIdentifier)this.name2OID.get(string);
        if (objectIdentifier2 != null) {
            Class<?> clazz = this.oid2ValueConverter.get(objectIdentifier2).getClass();
            if (!objectIdentifier2.equals(objectIdentifier) || clazz != aVAValueConverter.getClass()) {
                throw new IllegalArgumentException("Another keyword-oid-valueConverter triple already exists in the X500NameAttrMap ");
            }
            return;
        }
        this.name2OID.put(string.toUpperCase(), objectIdentifier);
        this.oid2Name.put(objectIdentifier, string.toUpperCase());
        this.oid2ValueConverter.put(objectIdentifier, aVAValueConverter);
    }

    public static X500NameAttrMap getDefault() {
        return defMap;
    }

    public static void setDefault(X500NameAttrMap x500NameAttrMap) {
        defMap = x500NameAttrMap;
    }

    static {
        DirStrConverter dirStrConverter = new DirStrConverter();
        IA5StringConverter iA5StringConverter = new IA5StringConverter();
        defMap.addNameOID("CN", new ObjectIdentifier("2.5.4.3"), dirStrConverter);
        defMap.addNameOID("OU", new ObjectIdentifier("2.5.4.11"), dirStrConverter);
        defMap.addNameOID("O", new ObjectIdentifier("2.5.4.10"), dirStrConverter);
        defMap.addNameOID("SERIALNUMBER", new ObjectIdentifier("2.5.4.5"), new PrintableConverter());
        defMap.addNameOID("C", new ObjectIdentifier("2.5.4.6"), new PrintableConverter());
        defMap.addNameOID("L", new ObjectIdentifier("2.5.4.7"), dirStrConverter);
        defMap.addNameOID("ST", new ObjectIdentifier("2.5.4.8"), dirStrConverter);
        defMap.addNameOID("STREET", new ObjectIdentifier("2.5.4.9"), dirStrConverter);
        defMap.addNameOID("TITLE", new ObjectIdentifier("2.5.4.12"), dirStrConverter);
        defMap.addNameOID("UID", new ObjectIdentifier("0.9.2342.19200300.100.1.1"), dirStrConverter);
        defMap.addNameOID("MAIL", new ObjectIdentifier("0.9.2342.19200300.100.1.3"), iA5StringConverter);
        defMap.addNameOID("E", new ObjectIdentifier("1.2.840.113549.1.9.1"), iA5StringConverter);
        defMap.addNameOID("DC", new ObjectIdentifier("0.9.2342.19200300.100.1.25"), iA5StringConverter);
        defMap.addNameOID("SN", new ObjectIdentifier("2.5.4.4"), dirStrConverter);
        defMap.addNameOID("GIVENNAME", new ObjectIdentifier("2.5.4.42"), dirStrConverter);
        defMap.addNameOID("INITIALS", new ObjectIdentifier("2.5.4.43"), dirStrConverter);
        defMap.addNameOID("GENERATIONQUALIFIER", new ObjectIdentifier("2.5.4.44"), dirStrConverter);
        defMap.addNameOID("DNQUALIFIER", new ObjectIdentifier("2.5.4.46"), dirStrConverter);
        defMap.addNameOID("UNSTRUCTUREDNAME", new ObjectIdentifier("1.2.840.113549.1.9.2"), iA5StringConverter);
        defMap.addNameOID("UNSTRUCTUREDADDRESS", new ObjectIdentifier("1.2.840.113549.1.9.8"), new PrintableConverter());
    }
}

