/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class IA5StringConverter
implements AVAValueConverter {
    public DerValue getValue(String string) throws IOException {
        return this.getValue(string, null);
    }

    public DerValue getValue(String string, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[string.length()];
        ASN1CharStrConvMap aSN1CharStrConvMap = ASN1CharStrConvMap.getDefault();
        try {
            CharToByteConverter charToByteConverter = aSN1CharStrConvMap.getCBC((byte)22);
            if (charToByteConverter == null) {
                throw new IOException("No CharToByteConverter for IA5String");
            }
            charToByteConverter.convert(string.toCharArray(), 0, string.length(), byArray2, 0, byArray2.length);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException("Invalid IA5String AVA Value string");
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Cannot instantiate CharToByteConverter");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Illegal access loading CharToByteConverter");
        }
        return new DerValue(22, byArray2);
    }

    public DerValue getValue(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 22) {
            throw new IOException("Invalid IA5String AVA Value.");
        }
        return derValue;
    }

    public String getAsString(DerValue derValue) throws IOException {
        return derValue.getIA5String();
    }
}

