/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class DirStrConverter
implements AVAValueConverter {
    private static byte[] DefEncodingOrder = new byte[]{19, 20, 28};

    public static synchronized void setDefEncodingOrder(byte[] byArray) {
        DefEncodingOrder = byArray;
    }

    public DerValue getValue(String string) throws IOException {
        return this.getValue(string, DefEncodingOrder);
    }

    public DerValue getValue(String string, byte[] byArray) throws IOException {
        int n = -1;
        if (byArray == null || byArray.length == 0) {
            byArray = DefEncodingOrder;
        }
        byte[] byArray2 = new byte[4 * string.length()];
        int n2 = 0;
        while (n2 < byArray.length) {
            try {
                CharToByteConverter charToByteConverter = ASN1CharStrConvMap.getDefault().getCBC(byArray[n2]);
                if (charToByteConverter != null) {
                    n = charToByteConverter.convert(string.toCharArray(), 0, string.length(), byArray2, 0, byArray2.length);
                    break;
                }
            }
            catch (CharConversionException charConversionException) {
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Cannot instantiate CharToByteConverter");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Illegal Access loading CharToByteConverter");
            }
            ++n2;
        }
        if (n == -1) {
            throw new IOException("Cannot convert the directory string value to a ASN.1 type");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return new DerValue(byArray[n2], byArray3);
    }

    public DerValue getValue(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        return derValue;
    }

    public String getAsString(DerValue derValue) throws IOException {
        return derValue.getASN1CharString();
    }
}

