/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerEncoder;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVAValueConverter;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class Attribute
implements DerEncoder {
    ObjectIdentifier oid;
    Vector valueSet = new Vector();
    protected X500NameAttrMap attrMap;

    public Attribute(ObjectIdentifier objectIdentifier, String string) throws IOException {
        if (objectIdentifier == null || string == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.oid = objectIdentifier;
        this.valueSet.addElement(string);
    }

    public Attribute(ObjectIdentifier objectIdentifier, Vector vector) throws IOException {
        if (objectIdentifier == null || vector == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.oid = objectIdentifier;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof String) {
                this.valueSet.addElement(e);
                continue;
            }
            throw new IOException("values vectore must consist of String object");
        }
    }

    public Attribute(String string, Vector vector) throws IOException {
        if (string == null || vector == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        ObjectIdentifier objectIdentifier = this.attrMap.getOid(string);
        if (objectIdentifier == null) {
            throw new IOException("Attr is not supported - does not contain in attr map");
        }
        this.oid = objectIdentifier;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof String) {
                this.valueSet.addElement(e);
                continue;
            }
            throw new IOException("Values vectore must consist of String object");
        }
    }

    public Attribute(DerValue derValue) throws IOException {
        if (derValue == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.decodeThis(derValue);
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public Enumeration getValues() {
        if (this.valueSet == null) {
            return null;
        }
        return this.valueSet.elements();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.encodeThis(derOutputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        this.encodeThis(outputStream);
    }

    public String toString() {
        String string = "Attribute: " + this.oid + "\n";
        String string2 = "Values: ";
        Enumeration enumeration = this.valueSet.elements();
        if (enumeration.hasMoreElements()) {
            string2 = string2 + (String)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + "," + (String)enumeration.nextElement();
            }
        }
        return string + string2 + "\n";
    }

    private void encodeThis(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.encodeValueSet(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    private void encodeValueSet(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        AVAValueConverter aVAValueConverter = this.attrMap.getValueConverter(this.oid);
        if (aVAValueConverter == null) {
            throw new IOException("Converter not found: unsupported attribute type");
        }
        Enumeration enumeration = this.valueSet.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DerValue derValue = aVAValueConverter.getValue(string);
            derValue.encode(derOutputStream);
        }
        derOutputStream2.write((byte)49, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    private void decodeThis(DerValue derValue) throws IOException {
        if (derValue == null) {
            throw new IOException("Invalid Input - null passed.");
        }
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for Attribute.");
        }
        if (derValue.data.available() == 0) {
            throw new IOException("No data available in passed DER encoded value.");
        }
        this.oid = derValue.data.getDerValue().getOID();
        if (derValue.data.available() == 0) {
            throw new IOException("Invalid encoding for Attribute - value missing");
        }
        this.decodeValueSet(derValue.data.getDerValue());
        if (this.oid == null) {
            throw new IOException("Invalid encoding for Attribute - OID missing");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decodeValueSet(DerValue var1_1) throws IOException {
        if (var1_1 == null) {
            throw new IOException("Invalid Input - null passed.");
        }
        var2_2 = this.attrMap.getValueConverter(this.oid);
        if (var2_2 == null) {
            throw new IOException("Attribute is not supported - not in attr map");
        }
        if (var1_1.tag != 49) {
            throw new IOException("Invalid encoding for Attribute Value Set.");
        }
        if (var1_1.data.available() != 0) ** GOTO lbl12
        throw new IOException("No data available in passed DER encoded attribute value set.");
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.data.getDerValue();
            this.valueSet.addElement(var2_2.getAsString(var3_3));
lbl12:
            // 2 sources

            ** while (var1_1.data.available() != 0)
        }
lbl13:
        // 1 sources

    }
}

