/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.BigInt;
import com.iplanet.security.util.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] byArray) {
        super(byArray);
    }

    DerInputBuffer(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    byte[] toByteArray() {
        int n = this.available();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        return byArray;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)object);
        }
        return false;
    }

    boolean equals(DerInputBuffer derInputBuffer) {
        if (this == derInputBuffer) {
            return true;
        }
        int n = this.available();
        if (derInputBuffer.available() != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.buf[this.pos + n2] != derInputBuffer.buf[derInputBuffer.pos + n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void truncate(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n;
    }

    BigInt getUnsigned(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read, getInteger");
        }
        if (n > 1 && this.buf[this.pos] == 0) {
            --n;
            this.skip(1L);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.skip(n);
        return new BigInt(byArray);
    }

    byte[] getBitString() {
        if (this.pos >= this.count || this.buf[this.pos] != 0) {
            return null;
        }
        int n = this.available();
        byte[] byArray = new byte[n - 1];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n - 1);
        this.pos = this.count;
        return byArray;
    }

    BitArray getUnalignedBitString() {
        if (this.pos >= this.count) {
            return null;
        }
        int n = this.available();
        byte[] byArray = new byte[n - 1];
        int n2 = byArray.length * 8 - this.buf[this.pos];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n - 1);
        BitArray bitArray = new BitArray(n2, byArray);
        this.pos = this.count;
        return bitArray;
    }

    void dump(OutputStream outputStream, int n) throws IOException {
        if (this.count < this.mark + n) {
            throw new IOException("short DER value (encode)");
        }
        outputStream.write(this.buf, this.mark, n);
    }
}

