/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.Set;

class AMTemplateImpl
extends AMObjectImpl
implements AMTemplate {
    private String serviceName;
    private int type;
    private ServiceSchema serviceSchema = null;
    static String cospriorityAN = "cospriority";

    public AMTemplateImpl(SSOToken sSOToken, String string, String string2, int n) throws AMException, SSOException {
        super(sSOToken, string, 13);
        this.serviceName = string2;
        this.type = n;
        this.profileType = n;
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string2, sSOToken);
            this.serviceSchema = n == 300 ? serviceSchemaManager.getPolicySchema() : serviceSchemaManager.getDynamicSchema();
            if (this.serviceSchema == null) {
                if (AMObjectImpl.debug.warningEnabled()) {
                    AMObjectImpl.debug.warning("AMTemplateImpl:" + AMSDKBundle.getString("484"));
                }
                throw new AMException(AMSDKBundle.getString("484"), "484");
            }
        }
        catch (SMSException sMSException) {
            if (AMObjectImpl.debug.warningEnabled()) {
                AMObjectImpl.debug.warning("AMTemplateImpl:", (Throwable)sMSException);
            }
            throw new AMException(AMSDKBundle.getString("484"), "484");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Set getAttributeSchemas() throws AMException, SSOException {
        return this.serviceSchema.getAttributeSchemas();
    }

    public int getPriority() throws SSOException {
        try {
            return this.getIntegerAttribute(cospriorityAN);
        }
        catch (AMException aMException) {
            AMObjectImpl.debug.message("AMTemplateImpl.getPriority", (Throwable)aMException);
            return -1;
        }
    }

    public void setPriority(int n) throws AMException, SSOException {
        this.setIntegerAttribute(cospriorityAN, n);
        this.store();
    }

    public int getType() {
        return this.type;
    }

    public Set getPolicyNames() throws AMException, SSOException {
        return this.getAttribute("iplanet-am-named-policy-dn");
    }

    public void setAttributes(Map map) throws AMException, SSOException {
        map = AMCrypt.encryptPasswords(map, this.serviceSchema);
        try {
            this.serviceSchema.validateAttributes(map);
        }
        catch (SMSException sMSException) {
            AMObjectImpl.debug.error("AMTemplateImpl.setAttributes", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("334"), "334");
        }
        super.setAttributes(map);
    }

    public Set getAttribute(String string) throws AMException, SSOException {
        Set set = super.getAttribute(string);
        return AMCrypt.decryptPasswords(set, string, this.serviceSchema);
    }

    public Map getAttributes(Set set) throws AMException, SSOException {
        Map map = super.getAttributes(set);
        map = AMCrypt.decryptPasswords(map, this.serviceSchema);
        return map;
    }
}

