/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMFilteredRoleImpl;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMGroupContainerImpl;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMOrganizationalUnitImpl;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMPreCallBackException;
import com.iplanet.am.sdk.AMResource;
import com.iplanet.am.sdk.AMResourceImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMTemplateImpl;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public final class AMStoreConnection
implements AMConstants {
    protected static String rootSuffix;
    protected static String defaultOrg;
    protected static Map orgMapCache;
    protected static Debug debug;
    private AMDirectoryManager dsManager;
    private SSOToken internalToken;
    private SSOToken token;

    public AMStoreConnection(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.token = sSOToken;
        this.internalToken = AMCommonUtils.getInternalToken();
        this.dsManager = AMDirectoryWrapper.getInstance();
    }

    public static String getFilteredRoleNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(8);
    }

    public static String getGroupContainerNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(4);
    }

    public static String getGroupNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(9);
    }

    public static String getNamingAttribute(int n) throws AMException {
        return AMNamingAttrManager.getNamingAttr(n);
    }

    public static String getOrganizationNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(2);
    }

    public static String getOrganizationalUnitNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(3);
    }

    public static String getPeopleContainerNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(5);
    }

    public static String getRoleNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(6);
    }

    public static String getUserNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(1);
    }

    public int getAMObjectType(String string) throws AMException, SSOException {
        return AMDirectoryWrapper.getInstance().getObjectType(this.token, string);
    }

    public AMAssignableDynamicGroup getAssignableDynamicGroup(String string) throws SSOException {
        AMAssignableDynamicGroupImpl aMAssignableDynamicGroupImpl = new AMAssignableDynamicGroupImpl(this.token, string);
        return aMAssignableDynamicGroupImpl;
    }

    public Set getAttributeNames(String string, AMSchema.Type type) throws AMException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            SchemaType schemaType = type.getInternalSchemaType();
            return serviceSchemaManager.getServiceAttributeNames(schemaType);
        }
        catch (SSOException sSOException) {
            debug.message("AMStoreConnection.getAttributeNames(service,token): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.message("AMStoreConnection.getAttributeNames(service,token): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("911"), "911");
        }
    }

    public AMDynamicGroup getDynamicGroup(String string) throws SSOException {
        AMDynamicGroupImpl aMDynamicGroupImpl = new AMDynamicGroupImpl(this.token, string);
        return aMDynamicGroupImpl;
    }

    public AMFilteredRole getFilteredRole(String string) throws SSOException {
        AMFilteredRoleImpl aMFilteredRoleImpl = new AMFilteredRoleImpl(this.token, string);
        return aMFilteredRoleImpl;
    }

    public AMGroupContainer getGroupContainer(String string) throws SSOException {
        AMGroupContainerImpl aMGroupContainerImpl = new AMGroupContainerImpl(this.token, string);
        return aMGroupContainerImpl;
    }

    public String getI18NPropertiesFileName(String string) throws AMException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            return serviceSchemaManager.getI18NFileName();
        }
        catch (SSOException sSOException) {
            debug.error("AMStoreConnection.getI18NPropertiesFileName(): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("909"), "909");
        }
    }

    public AMOrganization getOrganization(String string) throws SSOException {
        AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, string);
        return aMOrganizationImpl;
    }

    public String getOrganizationDN(String string, String string2) throws AMException, SSOException {
        Object object;
        String string3;
        if (string == null) {
            return rootSuffix;
        }
        if (DN.isDN(string) && this.isValidEntry(string) && this.getAMObjectType(string) == 2) {
            return string;
        }
        if (!string.startsWith("http://") && string.indexOf("/") > -1) {
            String string4 = AMStoreConnection.orgNameToDN(string);
            if (this.isValidEntry(string4) && this.getAMObjectType(string4) == 2) {
                return string4;
            }
            Object[] objectArray = new Object[]{string4};
            String string5 = AMCommonUtils.getUserLocale(this.token);
            throw new AMException(AMSDKBundle.getString("467", objectArray, string5), "467", objectArray);
        }
        try {
            if (AMDCTree.isRequired() && (string3 = AMDCTree.getOrganizationDN(this.token, string)) != null) {
                return string3;
            }
        }
        catch (AMException aMException) {
            debug.error("AMStoreConnection.getOrganizationDN-> In DC tree mode, unabe to find organization  for domain: " + string);
        }
        string3 = (String)orgMapCache.get(string.toLowerCase());
        if (string3 != null) {
            return string3;
        }
        String string6 = AMSearchFilterManager.getSearchFilter(2, null, string2, false);
        if (string2 != null && string6.indexOf("%V") > -1) {
            string6 = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(2), string6, string);
        } else {
            object = new StringBuffer();
            ((StringBuffer)object).append("(|(&(").append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(string).append(")").append(string6).append(")(&(").append("sunPreferredDomain=").append(string).append(")").append(string6).append(")(&(").append("associatedDomain=").append(string).append(")").append(string6).append(")(&(").append("sunOrganizationAlias=").append(string).append(")").append(string6).append("))");
            string6 = ((StringBuffer)object).toString();
        }
        if (debug.messageEnabled()) {
            debug.message("AMSC:getOrgDN-> using searchfilter " + string6);
        }
        if ((object = this.dsManager.search(this.token, rootSuffix, string6, 2)) == null || object.size() > 1 || object.isEmpty()) {
            Object[] objectArray = new Object[]{string};
            String string7 = AMCommonUtils.getUserLocale(this.token);
            throw new AMException(AMSDKBundle.getString("971", objectArray, string7), "971", objectArray);
        }
        Iterator iterator = object.iterator();
        string3 = (String)iterator.next();
        AMStoreConnection.addToOrgMapCache(string3);
        return string3;
    }

    public AMOrganizationalUnit getOrganizationalUnit(String string) throws SSOException {
        AMOrganizationalUnitImpl aMOrganizationalUnitImpl = new AMOrganizationalUnitImpl(this.token, string);
        return aMOrganizationalUnitImpl;
    }

    public AMPeopleContainer getPeopleContainer(String string) throws SSOException {
        AMPeopleContainerImpl aMPeopleContainerImpl = new AMPeopleContainerImpl(this.token, string);
        return aMPeopleContainerImpl;
    }

    public AMTemplate getPolicyTemplate(String string) throws AMException, SSOException {
        if (!DN.isDN(string)) {
            throw new AMException(AMSDKBundle.getString("742"), "742");
        }
        DN dN = new DN(string);
        DN dN2 = dN.getParent();
        String string2 = ((RDN)dN2.getRDNs().firstElement()).getValues()[0];
        if (string2 == null || string2.equals("")) {
            throw new AMException(AMSDKBundle.getString("742"), "742");
        }
        int n = string2.indexOf("Policy");
        if (n == -1) {
            throw new AMException(AMSDKBundle.getString("742"), "742");
        }
        String string3 = string2.substring(0, n);
        return new AMTemplateImpl(this.token, string, string3, 300);
    }

    public String getPropertiesViewBeanURL(String string) throws AMException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            return serviceSchemaManager.getPropertiesViewBeanURL();
        }
        catch (SSOException sSOException) {
            debug.error("AMStoreConnection.getPropertiesViewBeanURL(): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("910"), "910");
        }
    }

    public AMResource getResource(String string) throws SSOException {
        AMResourceImpl aMResourceImpl = new AMResourceImpl(this.token, string);
        return aMResourceImpl;
    }

    public AMRole getRole(String string) throws SSOException {
        AMRoleImpl aMRoleImpl = new AMRoleImpl(this.token, string);
        return aMRoleImpl;
    }

    public AMSchema getSchema(String string, AMSchema.Type type) throws AMException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            SchemaType schemaType = type.getInternalSchemaType();
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            if (serviceSchema == null) {
                debug.error("AMStoreConnection.getSchema(): null schema");
                throw new AMException(AMSDKBundle.getString("908"), "908");
            }
            return new AMSchema(serviceSchema);
        }
        catch (SSOException sSOException) {
            debug.error("AMStoreConnection.getSchema(): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.error("AMStoreConnection.getSchema(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("908"), "908");
        }
    }

    public Set getSchemaTypes(String string) throws AMException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            Set set = serviceSchemaManager.getSchemaTypes();
            Iterator iterator = set.iterator();
            HashSet<AMSchema.Type> hashSet = new HashSet<AMSchema.Type>();
            while (iterator.hasNext()) {
                SchemaType schemaType = (SchemaType)iterator.next();
                hashSet.add(new AMSchema.Type(schemaType));
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            debug.error("AMStoreConnection.getServiceTypes(): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.error("AMStoreConnection.getServiceTypes(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("907"), "907");
        }
    }

    public Set getServiceHierarchy() throws AMException {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            ServiceManager serviceManager = new ServiceManager(this.token);
            Set set = serviceManager.getServiceNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                String string2 = serviceSchemaManager.getServiceHierarchy();
                if (string2 == null || string2.length() == 0) continue;
                hashSet.add(string2);
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("905"), "905");
        }
    }

    public Set getServiceNames() throws AMException {
        try {
            ServiceManager serviceManager = new ServiceManager(this.token);
            return serviceManager.getServiceNames();
        }
        catch (SSOException sSOException) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
        catch (SMSException sMSException) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("906"), "906");
        }
    }

    public AMStaticGroup getStaticGroup(String string) throws SSOException {
        AMStaticGroupImpl aMStaticGroupImpl = new AMStaticGroupImpl(this.token, string);
        return aMStaticGroupImpl;
    }

    public Set getTopLevelContainers() throws AMException, SSOException {
        Object object;
        Object object2;
        HashSet<Object> hashSet;
        SSOTokenManager.getInstance().validateToken(this.token);
        String string = this.token.getPrincipal().getName();
        AMUserImpl aMUserImpl = new AMUserImpl(this.internalToken, string);
        Set set = new HashSet();
        Set set2 = aMUserImpl.getRoleDNs();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            hashSet = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.getTopLevelContainers: roleDN=" + (String)((Object)hashSet));
            }
            object2 = new AMRoleImpl(this.internalToken, (String)((Object)hashSet));
            set.addAll(object2.getAttribute("iplanet-am-role-managed-container-dn"));
        }
        if (set.isEmpty()) {
            hashSet = "(|" + AMSearchFilterManager.getGlobalSearchFilter(2) + AMSearchFilterManager.getGlobalSearchFilter(3) + AMSearchFilterManager.getGlobalSearchFilter(5) + AMSearchFilterManager.getGlobalSearchFilter(11) + AMSearchFilterManager.getGlobalSearchFilter(12) + AMSearchFilterManager.getGlobalSearchFilter(9) + ")";
            set = this.dsManager.search(this.token, rootSuffix, (String)((Object)hashSet), 2);
        }
        hashSet = new HashSet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = new DN((String)object2);
            Iterator iterator2 = hashSet.iterator();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            boolean bl = true;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                DN dN = new DN(string2);
                if (((DN)object).isDescendantOf(dN)) {
                    bl = false;
                    hashSet2.add(string2);
                    break;
                }
                if (dN.isDescendantOf((DN)object)) continue;
                hashSet2.add(string2);
            }
            if (bl) {
                hashSet2.add(object2);
            }
            hashSet = hashSet2;
        }
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.getTopLevelContainers");
            iterator = hashSet.iterator();
            object2 = new StringBuffer();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                ((StringBuffer)object2).append((String)object).append("\n");
            }
            debug.message("containerDNs\n" + ((StringBuffer)object2).toString());
        }
        return hashSet;
    }

    public Set getTopLevelOrganizations() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsManager.search(this.token, rootSuffix, AMSearchFilterManager.getGlobalSearchFilter(2), 1);
    }

    public AMUser getUser(String string) throws SSOException {
        AMUserImpl aMUserImpl = new AMUserImpl(this.token, string);
        return aMUserImpl;
    }

    public boolean isValidEntry(String string) throws SSOException {
        if (!DN.isDN(string)) {
            return false;
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.isValidEntry(): DN=" + string);
        }
        return this.dsManager.doesEntryExists(this.token, string);
    }

    public AMOrganization createTopOrganization(String string, Map map) throws AMException, SSOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(string).append(",").append(rootSuffix);
        AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, stringBuffer.toString());
        aMOrganizationImpl.setAttributes(map);
        aMOrganizationImpl.create();
        return aMOrganizationImpl;
    }

    public void purge(String string, int n) throws AMException, SSOException {
        Object object;
        Set set;
        String string2;
        boolean bl = false;
        if (AMDCTree.isRequired()) {
            string2 = AMDCTree.getOrganizationDN(this.token, string);
            set = new HashSet<String>();
            set.add(string2);
        } else {
            object = AMCompliance.getDeletedObjectFilter(2);
            object = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(2), (String)object, string);
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.purgeOrg: Using org filter= " + (String)object);
            }
            if ((set = this.dsManager.search(this.token, rootSuffix, (String)object, 2)) == null || set.isEmpty()) {
                set = this.getOrganizations(string, null);
                bl = false;
            } else {
                bl = true;
            }
        }
        if (set == null || set.isEmpty()) {
            return;
        }
        object = set.iterator();
        while (object.hasNext()) {
            int n2;
            int n3;
            Set set2;
            string2 = (String)object.next();
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.purge: Organization= " + string2);
            }
            AMOrganization aMOrganization = this.getOrganization(string2);
            if (bl && n < AMStoreConnection.daysSinceModified(string2)) {
                aMOrganization.purge(true, -1);
                continue;
            }
            String string3 = AMCompliance.getDeletedObjectFilter(-1);
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.purge: Searching deleted objects. Filter: " + string3);
            }
            if ((set2 = this.dsManager.search(this.token, string2, string3, 2)) == null && debug.messageEnabled()) {
                debug.message("AMStoreConnection.purge: No objects to be deleted found for " + string2);
            }
            Iterator iterator = set2.iterator();
            ArrayList<DN> arrayList = new ArrayList<DN>();
            int n4 = n3 = new DN(string2).countRDNs();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                DN dN = new DN(string4);
                n2 = dN.countRDNs();
                if (n2 > n4) {
                    n4 = n2;
                }
                arrayList.add(dN);
            }
            int n5 = arrayList.size();
            int n6 = n4;
            while (n6 >= n3) {
                n2 = 0;
                while (n2 < n5) {
                    DN dN = (DN)arrayList.get(n2);
                    if (dN.countRDNs() == n6) {
                        String string5 = dN.toRFCString();
                        int n7 = this.getAMObjectType(string5);
                        if (debug.messageEnabled()) {
                            debug.message("AMStoreConnection:purgeOrg: deleting child " + string5);
                        }
                        try {
                            switch (n7) {
                                case 1: {
                                    AMObject aMObject = this.getUser(string5);
                                    aMObject.purge(false, n);
                                    break;
                                }
                                case 12: {
                                    AMObject aMObject = this.getAssignableDynamicGroup(string5);
                                    aMObject.purge(false, n);
                                    break;
                                }
                                case 11: {
                                    AMObject aMObject = this.getDynamicGroup(string5);
                                    aMObject.purge(false, n);
                                    break;
                                }
                                case 9: 
                                case 10: {
                                    AMObject aMObject = this.getStaticGroup(string5);
                                    aMObject.purge(false, n);
                                    break;
                                }
                                case 21: {
                                    AMObject aMObject = this.getResource(string5);
                                    aMObject.purge(false, -1);
                                    break;
                                }
                                case 2: {
                                    AMObject aMObject = this.getOrganization(string5);
                                    if (new DN(string5).equals(new DN(string2))) break;
                                    aMObject.purge(true, n);
                                    break;
                                }
                            }
                        }
                        catch (AMPreCallBackException aMPreCallBackException) {
                            debug.error("AMStoreConnection.purge: Aborting delete of: " + string5 + " due to pre-callback exception", (Throwable)aMPreCallBackException);
                        }
                    }
                    ++n2;
                }
                --n6;
            }
        }
    }

    public void purgeUser(String string, String string2, int n) throws AMException, SSOException {
        Set set;
        String string3 = this.getOrganizationDN(string2, null);
        String string4 = AMCompliance.getDeletedObjectFilter(1);
        string4 = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(1), string4, string);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.purgeGroup: Using deleted user filter= " + string4);
        }
        if ((set = this.dsManager.search(this.token, string3, string4, 2)) == null || set.size() > 1 || set.isEmpty()) {
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("971", objectArray), "971", objectArray);
        }
        String string5 = (String)set.iterator().next();
        AMUser aMUser = this.getUser(string5);
        aMUser.purge(false, n);
    }

    public void purgeResource(String string, String string2, int n) throws AMException, SSOException {
        Set set;
        String string3 = this.getOrganizationDN(string2, null);
        String string4 = AMCompliance.getDeletedObjectFilter(21);
        string4 = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(21), string4, string);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.purgeGroup: Using deleted user filter= " + string4);
        }
        if ((set = this.dsManager.search(this.token, string3, string4, 2)) == null || set.size() > 1 || set.isEmpty()) {
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("971", objectArray), "971", objectArray);
        }
        String string5 = (String)set.iterator().next();
        AMResource aMResource = this.getResource(string5);
        aMResource.purge(false, n);
    }

    public void purgeGroup(String string, String string2, int n) throws AMException, SSOException {
        Set set;
        String string3 = this.getOrganizationDN(string2, null);
        String string4 = AMCompliance.getDeletedObjectFilter(9);
        string4 = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(9), string4, string);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.purgeGroup: Using deleted group filter= " + string4);
        }
        if ((set = this.dsManager.search(this.token, string3, string4, 2)) == null || set.size() > 1 || set.isEmpty()) {
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("971", objectArray), "971", objectArray);
        }
        String string5 = (String)set.iterator().next();
        AMObject aMObject = null;
        int n2 = this.getAMObjectType(string5);
        switch (n2) {
            case 9: 
            case 10: {
                aMObject = new AMStaticGroupImpl(this.token, string5);
                break;
            }
            case 12: {
                aMObject = new AMAssignableDynamicGroupImpl(this.token, string5);
                break;
            }
            case 11: {
                aMObject = new AMDynamicGroupImpl(this.token, string5);
                break;
            }
        }
        if (aMObject != null) {
            aMObject.purge(false, n);
        }
    }

    protected String getBaseDN(ServiceConfig serviceConfig) {
        if (serviceConfig != null) {
            Map map = serviceConfig.getAttributes();
            Set set = (Set)map.get("baseDN");
            if (set == null || set.isEmpty()) {
                return null;
            }
            Iterator iterator = set.iterator();
            return (String)iterator.next();
        }
        return null;
    }

    protected boolean isRFC2247(ServiceConfig serviceConfig) {
        if (serviceConfig != null) {
            Map map = serviceConfig.getAttributes();
            Set set = (Set)map.get("rfc2247flag");
            if (set == null || set.isEmpty()) {
                return false;
            }
            Iterator iterator = set.iterator();
            return ((String)iterator.next()).equalsIgnoreCase("true");
        }
        return false;
    }

    protected static void addToOrgMapCache(String string) throws AMException, SSOException {
        if (string == null || !DN.isDN(string)) {
            return;
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("objectclass");
        hashSet.add("sunpreferreddomain");
        hashSet.add("associateddomain");
        hashSet.add("sunorganizationalias");
        Map map = AMDirectoryWrapper.getInstance().getAttributes(AMCommonUtils.getInternalToken(), string, hashSet, 2);
        DN dN = new DN(string);
        String string3 = dN.explodeDN(true)[0];
        Set set = (Set)map.get("sunpreferreddomain");
        Set set2 = (Set)map.get("associateddomain");
        Set set3 = (Set)map.get("sunorganizationalias");
        Map map2 = orgMapCache;
        synchronized (map2) {
            String string4;
            Iterator iterator;
            orgMapCache.put(string3.toLowerCase(), string2);
            if (set != null && set.size() == 1) {
                iterator = (String)set.iterator().next();
                orgMapCache.put(iterator, string2);
            }
            if (set2 != null && !set2.isEmpty()) {
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    orgMapCache.put(string4, string2);
                }
            }
            if (set3 != null && !set3.isEmpty()) {
                iterator = set3.iterator();
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    orgMapCache.put(string4, string2);
                }
            }
        }
    }

    protected static int daysSinceModified(String string) throws AMException, SSOException {
        Number number;
        NumberFormat numberFormat = NumberFormat.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        ParsePosition parsePosition = new ParsePosition(0);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add("modifytimestamp");
        Map map = AMDirectoryWrapper.getInstance().getAttributes(AMCommonUtils.getInternalToken(), string, hashSet, -9999);
        Set set = (Set)map.get("modifytimestamp");
        if (set == null || set.isEmpty()) {
            return -1;
        }
        String string2 = (String)set.iterator().next();
        if (string2 == null || string2.equals("")) {
            return -1;
        }
        try {
            number = numberFormat.parse(string2);
        }
        catch (ParseException parseException) {
            if (debug.warningEnabled()) {
                debug.warning("AMStoreConnection.daysSinceModified: unable to parse date: " + string2 + " :Returning default= -1", (Throwable)parseException);
            }
            return -1;
        }
        Date date = simpleDateFormat.parse(number.toString(), parsePosition);
        int n = (int)(date.getTime() / 86400000L);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.daysSinceModified() for dn: " + string + ", days: " + n + "days");
        }
        return n;
    }

    protected static void removeFromOrgMapCache(String string) throws AMException, SSOException {
        String string2 = new DN(string).toRFCString().toLowerCase();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("objectclass");
        hashSet.add("sunpreferreddomain");
        hashSet.add("associateddomain");
        hashSet.add("sunorganizationalias");
        Map map = AMDirectoryWrapper.getInstance().getAttributes(AMCommonUtils.getInternalToken(), string, hashSet, 2);
        DN dN = new DN(string);
        String string3 = dN.explodeDN(true)[0];
        Set set = (Set)map.get("sunpreferreddomain");
        Set set2 = (Set)map.get("associateddomain");
        Set set3 = (Set)map.get("sunOrganizationAlias");
        Map map2 = orgMapCache;
        synchronized (map2) {
            String string4;
            Iterator iterator;
            orgMapCache.remove(string3.toLowerCase());
            if (set != null && set.size() == 1) {
                iterator = (String)set.iterator().next();
                orgMapCache.remove(iterator);
            }
            if (set2 != null && !set2.isEmpty()) {
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    orgMapCache.remove(string4);
                }
            }
            if (set3 != null && !set3.isEmpty()) {
                iterator = set3.iterator();
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    orgMapCache.remove(string4);
                }
            }
        }
    }

    protected static void updateCache(DSEvent dSEvent, String string) {
        if (string == null || !DN.isDN(string)) {
            return;
        }
        String string2 = AMCommonUtils.formatToRFC(string);
        int n = dSEvent.getEventType();
        switch (n) {
            case 1: {
                return;
            }
            case 8: {
                Map map = orgMapCache;
                synchronized (map) {
                    orgMapCache.clear();
                }
                return;
            }
            case 2: 
            case 4: {
                Map map = orgMapCache;
                synchronized (map) {
                    String string3;
                    Iterator<Object> iterator = orgMapCache.keySet().iterator();
                    HashSet<String> hashSet = new HashSet<String>();
                    while (iterator.hasNext()) {
                        string3 = (String)iterator.next();
                        String string4 = (String)orgMapCache.get(string3);
                        if (!string4.equalsIgnoreCase(string2)) continue;
                        hashSet.add(string3);
                    }
                    if (hashSet != null) {
                        iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            string3 = (String)iterator.next();
                            orgMapCache.remove(string3);
                        }
                    }
                    break;
                }
            }
        }
    }

    private Set getOrganizations(String string, String string2) throws AMException, SSOException {
        Object object;
        if (string == null) {
            return Collections.EMPTY_SET;
        }
        Object var3_3 = null;
        String string3 = AMSearchFilterManager.getSearchFilter(2, null, string2, false);
        if (string2 != null && string3.indexOf("%V") > -1) {
            string3 = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(2), string3, string);
        } else {
            object = new StringBuffer();
            ((StringBuffer)object).append("(|(&(").append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(string).append(")").append(string3).append(")(&(").append("sunPreferredDomain=").append(string).append(")").append(string3).append(")(&(").append("associatedDomain=").append(string).append(")").append(string3).append(")(&(").append("sunOrganizationAlias=").append(string).append(")").append(string3).append("))");
            string3 = ((StringBuffer)object).toString();
        }
        if (debug.messageEnabled()) {
            debug.message("AMSC:getOrgDN-> using searchfilter " + string3);
        }
        object = this.dsManager.search(this.token, rootSuffix, string3, 2);
        return object;
    }

    private String getDeletedObjectFilter(int n) {
        if (n == -1) {
            return "(|(&(sunPreferredDomain=%V)(inetDomainStatus=deleted))(&(objectclass=inetorgperson)(inetUserStatus=deleted))(&(objectclass=iplanet-am-managed-group)(inetgroupstatus=deleted)))";
        }
        switch (n) {
            case 2: {
                return "(&(sunPreferredDomain=%V)(inetDomainStatus=deleted))";
            }
            case 1: {
                return "(&(objectClass=inetOrgPerson)(inetUserStatus=deleted))";
            }
            case 10: 
            case 11: 
            case 12: {
                return "(&(objectClass=iplanet-am-managed-group)(inetgroupstatus=deleted))";
            }
        }
        return "(&(objectclass=*)(objectclass=ldapsubentry))";
    }

    private ServiceConfig getSearchTemplateConfig(String string) {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("DAI", this.token);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            serviceConfig = serviceConfig.getSubConfig("templates");
            serviceConfig = serviceConfig.getSubConfig("SearchTemplates");
            serviceConfig = serviceConfig.getSubConfig(string);
            return serviceConfig;
        }
        catch (SSOException sSOException) {
            return null;
        }
        catch (SMSException sMSException) {
            return null;
        }
    }

    private static String orgNameToDN(String string) {
        if (string == null || string.length() == 0) {
            return rootSuffix;
        }
        if (DN.isDN(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)arrayList.get(n2);
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(2));
            stringBuffer.append('=').append(string2).append(',');
            ++n2;
        }
        if (rootSuffix.length() > 0) {
            stringBuffer.append(rootSuffix);
        } else {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    static {
        orgMapCache = new AMHashMap();
        debug = AMCommonUtils.debug;
        rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
        rootSuffix = new DN(rootSuffix).toRFCString().toLowerCase();
        if (debug.messageEnabled()) {
            debug.message("com.iplanet.am.rootsuffix " + rootSuffix);
        }
        defaultOrg = SystemProperties.get((String)"com.iplanet.am.defaultOrg") + "," + rootSuffix;
        if (debug.messageEnabled()) {
            debug.message("default org: " + defaultOrg);
        }
    }
}

