/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class AMServiceUtils {
    private static Debug debug = AMCommonUtils.debug;

    AMServiceUtils() {
    }

    protected static Set getServiceAttributeNames(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, SSOException {
        ServiceSchema serviceSchema;
        block3: {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchema = null;
            try {
                serviceSchema = serviceSchemaManager.getSchema(schemaType);
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMServiceUtils.getServiceAttributeNames(): No schema defined for " + schemaType);
            }
        }
        if (serviceSchema == null || schemaType == SchemaType.POLICY) {
            return Collections.EMPTY_SET;
        }
        return serviceSchema.getAttributeSchemaNames();
    }

    protected static Set getServiceAttributesWithQualifier(SSOToken sSOToken, String string) throws SMSException, SSOException {
        ServiceSchema serviceSchema;
        block4: {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchema = null;
            try {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMServiceUtils.getServiceAttributesWithQualifier(): No schema defined for SchemaType.DYNAMIC type");
            }
        }
        if (serviceSchema == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = serviceSchema.getAttributeSchemaNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            String string3 = string2 + " " + attributeSchema.getCosQualifier();
            hashSet.add(string3);
        }
        return hashSet;
    }

    protected static boolean serviceHasSubSchema(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
        Set set = serviceSchemaManager.getSchemaTypes();
        if (debug.messageEnabled()) {
            debug.message("AMServiceUtils.serviceHasSubSchema() SchemaTypes types for " + string + " are: " + set);
        }
        return set.contains(schemaType);
    }

    protected static Map getServiceConfig(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, SSOException {
        Map map = null;
        if (schemaType != SchemaType.POLICY) {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            map = serviceSchema.getAttributeDefaults();
        }
        return map;
    }

    protected static ServiceConfig createOrgConfig(SSOToken sSOToken, String string, String string2, Map map) throws SSOException, AMException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.createOrganizationConfig(string, map);
            return serviceConfig;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            String string3 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("481", objectArray, string3), "481", objectArray);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            Object[] objectArray = new Object[]{string2};
            String string4 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("479", objectArray, string4), "479", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string2};
            String string5 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("482", objectArray, string5), "482", objectArray);
        }
    }

    protected static ServiceConfig getOrgConfig(SSOToken sSOToken, String string, String string2) throws SSOException, AMException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
            DN dN = new DN(string);
            if (dN.equals(new DN(AMStoreConnection.rootSuffix)) && serviceConfig != null) {
                Map map = serviceConfig.getAttributes();
                Set set = serviceConfig.getSubConfigNames();
                if (map.isEmpty() && (set == null || set.isEmpty())) {
                    return null;
                }
            }
            return serviceConfig;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            String string3 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("481", objectArray, string3), "481", objectArray);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            Object[] objectArray = new Object[]{string2};
            String string4 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("479", objectArray, string4), "479", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string2};
            String string5 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("482", objectArray, string5), "482", objectArray);
        }
    }

    static Set getServiceObjectClasses(SSOToken sSOToken, Set set) throws SSOException, AMException {
        HashSet hashSet = new HashSet();
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map map;
                Set set2;
                String string = (String)iterator.next();
                if (!AMServiceUtils.serviceHasSubSchema(sSOToken, string, SchemaType.GLOBAL) || (set2 = (Set)(map = AMServiceUtils.getServiceConfig(sSOToken, string, SchemaType.GLOBAL)).get("serviceObjectClasses")) == null) continue;
                hashSet.addAll(set2);
            }
        }
        catch (SMSException sMSException) {
            debug.error("AMServiceUtils.getServiceObjectClasses() Unable to get them: ", (Throwable)sMSException);
            throw new AMException(sSOToken, "161");
        }
        return hashSet;
    }
}

