/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRoleImpl;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainerImpl;
import com.iplanet.am.sdk.AMGroupImpl;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMOrganizationalUnitImpl;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSDKUtil;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMTemplateImpl;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class AMOrganizationImpl
extends AMObjectImpl
implements AMOrganization {
    public AMOrganizationImpl(SSOToken sSOToken, String string) {
        super(sSOToken, string, 2);
    }

    public Set createSubOrganizations(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMOrganizationImpl> hashSet = new HashSet<AMOrganizationImpl>();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(2)).append("=").append((String)iterator.next()).append(",").append(this.entryDN);
            AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, stringBuffer.toString());
            aMOrganizationImpl.create();
            hashSet.add(aMOrganizationImpl);
        }
        return hashSet;
    }

    public Set createSubOrganizations(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMOrganizationImpl> hashSet = new HashSet<AMOrganizationImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(string).append(",").append(this.entryDN);
            Map map2 = (Map)map.get(string);
            AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, stringBuffer.toString());
            aMOrganizationImpl.setAttributes(map2);
            aMOrganizationImpl.create();
            hashSet.add(aMOrganizationImpl);
        }
        return hashSet;
    }

    public String createOrganization(String string, String string2, Map hashMap, Map map) throws AMException, SSOException {
        String string3 = string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AMNamingAttrManager.getNamingAttr(2));
        stringBuffer.append("=").append(string3).append(",");
        stringBuffer.append(this.entryDN);
        AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, stringBuffer.toString());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put("sunPreferredDomain", hashSet);
        aMOrganizationImpl.setAttributes(hashMap);
        if (map != null && !map.isEmpty()) {
            Set set = map.keySet();
            aMOrganizationImpl.setAttribute("sunRegisteredServiceName", set);
            aMOrganizationImpl.assignServices(map, false);
        }
        aMOrganizationImpl.create();
        return aMOrganizationImpl.getDN();
    }

    public void deleteSubOrganizations(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, string);
            aMOrganizationImpl.delete();
        }
    }

    public AMOrganization getSubOrganization(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return new AMOrganizationImpl(this.token, string);
    }

    public Set getSubOrganizations(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(2));
    }

    public long getNumberOfSubOrganizations(int n) throws AMException, SSOException {
        return this.getSubOrganizations(n).size();
    }

    public Set searchSubOrganizations(String string, int n) throws AMException, SSOException {
        return this.searchSubOrganizations(string, null, n);
    }

    public AMSearchResults searchSubOrganizations(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchSubOrganizations(string, null, aMSearchControl);
    }

    public Set searchSubOrganizations(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(2), this.getSearchFilter(2), string, map, n);
    }

    public AMSearchResults searchSubOrganizations(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(2), this.getSearchFilter(2), string, map, aMSearchControl);
    }

    public Set createOrganizationalUnits(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMOrganizationalUnitImpl> hashSet = new HashSet<AMOrganizationalUnitImpl>();
        while (iterator.hasNext()) {
            String string = AMNamingAttrManager.getNamingAttr(3) + "=" + (String)iterator.next() + "," + this.entryDN;
            AMOrganizationalUnitImpl aMOrganizationalUnitImpl = new AMOrganizationalUnitImpl(this.token, string);
            aMOrganizationalUnitImpl.create();
            hashSet.add(aMOrganizationalUnitImpl);
        }
        return hashSet;
    }

    public Set createOrganizationalUnits(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMOrganizationalUnitImpl> hashSet = new HashSet<AMOrganizationalUnitImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(3) + "=" + string + "," + this.entryDN;
            Map map2 = (Map)map.get(string);
            AMOrganizationalUnitImpl aMOrganizationalUnitImpl = new AMOrganizationalUnitImpl(this.token, string2);
            aMOrganizationalUnitImpl.setAttributes(map2);
            aMOrganizationalUnitImpl.create();
            hashSet.add(aMOrganizationalUnitImpl);
        }
        return hashSet;
    }

    public void deleteOrganizationalUnits(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMOrganizationalUnitImpl aMOrganizationalUnitImpl = new AMOrganizationalUnitImpl(this.token, string);
            aMOrganizationalUnitImpl.delete();
        }
    }

    public AMOrganizationalUnit getOrganizationalUnit(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return new AMOrganizationalUnitImpl(this.token, string);
    }

    public Set getOrganizationalUnits(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(3));
    }

    public long getNumberOfOrganizationalUnits(int n) throws AMException, SSOException {
        return this.getOrganizationalUnits(n).size();
    }

    public Set searchOrganizationalUnits(String string, int n) throws AMException, SSOException {
        return this.searchOrganizationalUnits(string, null, n);
    }

    public AMSearchResults searchOrganizationalUnits(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchOrganizationalUnits(string, null, aMSearchControl);
    }

    public Set searchOrganizationalUnits(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(3), this.getSearchFilter(3), string, map, n);
    }

    public AMSearchResults searchOrganizationalUnits(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(3), this.getSearchFilter(3), string, map, aMSearchControl);
    }

    public Set createRoles(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMRoleImpl> hashSet = new HashSet<AMRoleImpl>();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(6)).append("=").append((String)iterator.next()).append(",").append(this.entryDN);
            AMRoleImpl aMRoleImpl = new AMRoleImpl(this.token, stringBuffer.toString());
            aMRoleImpl.create();
            hashSet.add(aMRoleImpl);
        }
        return hashSet;
    }

    public Set createRoles(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMRoleImpl> hashSet = new HashSet<AMRoleImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(6) + "=" + string + "," + this.entryDN;
            Map map2 = (Map)map.get(string);
            AMRoleImpl aMRoleImpl = new AMRoleImpl(this.token, string2);
            Set set = new HashSet();
            if (!map2.isEmpty()) {
                set = (Set)map2.remove("iplanet-am-role-aci-list");
            }
            if (set != null && !set.isEmpty()) {
                Iterator iterator2 = set.iterator();
                HashSet<String> hashSet2 = new HashSet<String>();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "##");
                    while (stringTokenizer.hasMoreTokens()) {
                        hashSet2.add(stringTokenizer.nextToken());
                    }
                }
                map2.put("iplanet-am-role-aci-list", this.replaceAciListMacros(hashSet2, string2, this.entryDN, null, null));
            }
            aMRoleImpl.setAttributes(map2);
            aMRoleImpl.create();
            hashSet.add(aMRoleImpl);
        }
        return hashSet;
    }

    public void deleteRoles(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMRoleImpl aMRoleImpl = new AMRoleImpl(this.token, string);
            aMRoleImpl.delete();
        }
    }

    public Set getRoles(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(6));
    }

    public long getNumberOfRoles(int n) throws AMException, SSOException {
        return this.getRoles(n).size();
    }

    public Set searchRoles(String string, int n) throws AMException, SSOException {
        return this.searchRoles(string, null, n);
    }

    public AMSearchResults searchRoles(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchRoles(string, null, aMSearchControl);
    }

    public Set searchRoles(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(6), this.getSearchFilter(6), string, map, n);
    }

    public AMSearchResults searchRoles(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(6), this.getSearchFilter(6), string, map, aMSearchControl);
    }

    public Set createFilteredRoles(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMFilteredRoleImpl> hashSet = new HashSet<AMFilteredRoleImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + this.entryDN;
            AMFilteredRoleImpl aMFilteredRoleImpl = new AMFilteredRoleImpl(this.token, string2);
            aMFilteredRoleImpl.create();
            hashSet.add(aMFilteredRoleImpl);
        }
        return hashSet;
    }

    public Set createFilteredRoles(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMFilteredRoleImpl> hashSet = new HashSet<AMFilteredRoleImpl>();
        while (iterator.hasNext()) {
            Set set;
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + this.entryDN;
            Map map2 = (Map)map.get(string);
            AMFilteredRoleImpl aMFilteredRoleImpl = new AMFilteredRoleImpl(this.token, string2);
            if (!map2.isEmpty() && (set = (Set)map2.remove("iplanet-am-role-aci-list")) != null && !set.isEmpty()) {
                Iterator iterator2 = set.iterator();
                HashSet<String> hashSet2 = new HashSet<String>();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "##");
                    while (stringTokenizer.hasMoreTokens()) {
                        hashSet2.add(stringTokenizer.nextToken());
                    }
                }
                map2.put("iplanet-am-role-aci-list", this.replaceAciListMacros(hashSet2, string2, this.entryDN, null, null));
            }
            aMFilteredRoleImpl.setAttributes(map2);
            aMFilteredRoleImpl.create();
            hashSet.add(aMFilteredRoleImpl);
        }
        return hashSet;
    }

    public void deleteFilteredRoles(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMFilteredRoleImpl aMFilteredRoleImpl = new AMFilteredRoleImpl(this.token, string);
            aMFilteredRoleImpl.delete();
        }
    }

    public Set getFilteredRoles(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(8));
    }

    public long getNumberOfFilteredRoles(int n) throws AMException, SSOException {
        return this.getFilteredRoles(n).size();
    }

    public Set searchFilteredRoles(String string, int n) throws AMException, SSOException {
        return this.searchFilteredRoles(string, null, n);
    }

    public AMSearchResults searchFilteredRoles(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchFilteredRoles(string, null, aMSearchControl);
    }

    public Set searchFilteredRoles(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(8), this.getSearchFilter(8), string, map, n);
    }

    public AMSearchResults searchFilteredRoles(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(8), this.getSearchFilter(8), string, map, aMSearchControl);
    }

    public Set searchAllRoles(String string, int n) throws AMException, SSOException {
        return this.searchAllRoles(string, null, n);
    }

    public AMSearchResults searchAllRoles(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchAllRoles(string, null, aMSearchControl);
    }

    public Set searchAllRoles(String string, Map map, int n) throws AMException, SSOException {
        int[] nArray = new int[]{6, 8};
        return this.searchObjects(nArray, string, map, n);
    }

    public AMSearchResults searchAllRoles(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        int[] nArray = new int[]{6, 8};
        return this.searchObjects(nArray, string, map, aMSearchControl);
    }

    public Set createAssignableDynamicGroups(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMAssignableDynamicGroupImpl> hashSet = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iterator.hasNext()) {
            String string = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iterator.next() + "," + this.entryDN;
            AMAssignableDynamicGroupImpl aMAssignableDynamicGroupImpl = new AMAssignableDynamicGroupImpl(this.token, string);
            aMAssignableDynamicGroupImpl.create();
            hashSet.add(aMAssignableDynamicGroupImpl);
        }
        return hashSet;
    }

    public AMGroup createAssignableDynamicGroup(String string, Map map, Map map2) throws AMException, SSOException {
        return this.createGroup(string, map, map2, 12);
    }

    public void deleteAssignableDynamicGroups(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMAssignableDynamicGroupImpl aMAssignableDynamicGroupImpl = new AMAssignableDynamicGroupImpl(this.token, string);
            aMAssignableDynamicGroupImpl.delete();
        }
    }

    public Set getAssignableDynamicGroups(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(12));
    }

    public long getNumberOfAssignableDynamicGroups(int n) throws AMException, SSOException {
        return this.getAssignableDynamicGroups(n).size();
    }

    public Set searchAssignableDynamicGroups(String string, int n) throws AMException, SSOException {
        return this.searchAssignableDynamicGroups(string, null, n);
    }

    public Set searchAssignableDynamicGroups(String string, int n, String string2, Map map) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (AMObjectImpl.debug.warningEnabled()) {
                AMObjectImpl.debug.warning("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12, string2), string, map, n);
    }

    public AMSearchResults searchAssignableDynamicGroups(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchAssignableDynamicGroups(string, null, aMSearchControl);
    }

    public Set searchAssignableDynamicGroups(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12), string, map, n);
    }

    public AMSearchResults searchAssignableDynamicGroups(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12), string, map, aMSearchControl);
    }

    public Set createDynamicGroups(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMDynamicGroupImpl> hashSet = new HashSet<AMDynamicGroupImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + this.entryDN;
            Map map2 = (Map)map.get(string);
            AMDynamicGroupImpl aMDynamicGroupImpl = new AMDynamicGroupImpl(this.token, string2);
            aMDynamicGroupImpl.setAttributes(map2);
            aMDynamicGroupImpl.create();
            hashSet.add(aMDynamicGroupImpl);
        }
        return hashSet;
    }

    public AMGroup createDynamicGroup(String string, Map map, Map map2) throws AMException, SSOException {
        return this.createGroup(string, map, map2, 11);
    }

    public void deleteDynamicGroups(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMDynamicGroupImpl aMDynamicGroupImpl = new AMDynamicGroupImpl(this.token, string);
            aMDynamicGroupImpl.delete();
        }
    }

    public Set getDynamicGroups(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(11));
    }

    public long getNumberOfDynamicGroups(int n) throws AMException, SSOException {
        return this.getDynamicGroups(n).size();
    }

    public Set searchDynamicGroups(String string, int n) throws AMException, SSOException {
        return this.searchDynamicGroups(string, null, n);
    }

    public Set searchDynamicGroups(String string, int n, String string2, Map map) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (AMObjectImpl.debug.warningEnabled()) {
                AMObjectImpl.debug.warning("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11, string2), string, map, n);
    }

    public AMSearchResults searchDynamicGroups(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchDynamicGroups(string, null, aMSearchControl);
    }

    public Set searchDynamicGroups(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11), string, map, n);
    }

    public AMSearchResults searchDynamicGroups(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11), string, map, aMSearchControl);
    }

    public Set createStaticGroups(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMStaticGroupImpl> hashSet = new HashSet<AMStaticGroupImpl>();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(9)).append("=").append((String)iterator.next()).append(",").append(this.entryDN);
            AMStaticGroupImpl aMStaticGroupImpl = new AMStaticGroupImpl(this.token, stringBuffer.toString());
            aMStaticGroupImpl.create();
            hashSet.add(aMStaticGroupImpl);
        }
        return hashSet;
    }

    public AMGroup createStaticGroup(String string, Map map, Map map2) throws AMException, SSOException {
        return this.createGroup(string, map, map2, 10);
    }

    public void deleteStaticGroups(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMStaticGroupImpl aMStaticGroupImpl = new AMStaticGroupImpl(this.token, string);
            aMStaticGroupImpl.delete();
        }
    }

    public Set getStaticGroups(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(9));
    }

    public long getNumberOfStaticGroups(int n) throws AMException, SSOException {
        return this.getStaticGroups(n).size();
    }

    public Set searchStaticGroups(String string, int n) throws AMException, SSOException {
        return this.searchStaticGroups(string, null, n);
    }

    public Set searchStaticGroups(String string, int n, String string2, Map map) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (AMObjectImpl.debug.messageEnabled()) {
                AMObjectImpl.debug.message("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9, string2), string, map, n);
    }

    public AMSearchResults searchStaticGroups(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchStaticGroups(string, null, aMSearchControl);
    }

    public Set searchStaticGroups(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9), string, map, n);
    }

    public AMSearchResults searchStaticGroups(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9), string, map, aMSearchControl);
    }

    public Set searchGroups(String string, Map map, int n) throws AMException, SSOException {
        String string2 = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), string2, string, map, n);
    }

    public AMSearchResults searchGroups(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        String string2 = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), string2, string, map, aMSearchControl);
    }

    public Set createPeopleContainers(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMPeopleContainerImpl> hashSet = new HashSet<AMPeopleContainerImpl>();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(5)).append("=").append((String)iterator.next()).append(",").append(this.entryDN);
            AMPeopleContainerImpl aMPeopleContainerImpl = new AMPeopleContainerImpl(this.token, stringBuffer.toString());
            aMPeopleContainerImpl.create();
            hashSet.add(aMPeopleContainerImpl);
        }
        return hashSet;
    }

    public Set createPeopleContainers(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMPeopleContainerImpl> hashSet = new HashSet<AMPeopleContainerImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMNamingAttrManager.getNamingAttr(5)).append("=").append(string).append(",").append(this.entryDN);
            Map map2 = (Map)map.get(string);
            AMPeopleContainerImpl aMPeopleContainerImpl = new AMPeopleContainerImpl(this.token, stringBuffer.toString());
            aMPeopleContainerImpl.setAttributes(map2);
            aMPeopleContainerImpl.create();
            hashSet.add(aMPeopleContainerImpl);
        }
        return hashSet;
    }

    public void deletePeopleContainers(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMPeopleContainerImpl aMPeopleContainerImpl = new AMPeopleContainerImpl(this.token, string);
            aMPeopleContainerImpl.delete();
        }
    }

    public Set getPeopleContainers(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(5));
    }

    public long getNumberOfPeopleContainers(int n) throws AMException, SSOException {
        return this.getPeopleContainers(n).size();
    }

    public Set searchPeopleContainers(String string, int n) throws AMException, SSOException {
        return this.searchPeopleContainers(string, null, n);
    }

    public AMSearchResults searchPeopleContainers(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchPeopleContainers(string, null, aMSearchControl);
    }

    public Set searchPeopleContainers(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), string, map, n);
    }

    public AMSearchResults searchPeopleContainers(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), string, map, aMSearchControl);
    }

    public Set createGroupContainers(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        HashSet<AMGroupContainerImpl> hashSet = new HashSet<AMGroupContainerImpl>();
        while (iterator.hasNext()) {
            String string = AMNamingAttrManager.getNamingAttr(4) + "=" + (String)iterator.next() + "," + this.entryDN;
            AMGroupContainerImpl aMGroupContainerImpl = new AMGroupContainerImpl(this.token, string);
            aMGroupContainerImpl.create();
            hashSet.add(aMGroupContainerImpl);
        }
        return hashSet;
    }

    public Set createGroupContainers(Map map) throws AMException, SSOException {
        Iterator iterator = map.keySet().iterator();
        HashSet<AMGroupContainerImpl> hashSet = new HashSet<AMGroupContainerImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(4) + "=" + string + "," + this.entryDN;
            Map map2 = (Map)map.get(string);
            AMGroupContainerImpl aMGroupContainerImpl = new AMGroupContainerImpl(this.token, string2);
            aMGroupContainerImpl.setAttributes(map2);
            aMGroupContainerImpl.create();
            hashSet.add(aMGroupContainerImpl);
        }
        return hashSet;
    }

    public void deleteGroupContainers(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMGroupContainerImpl aMGroupContainerImpl = new AMGroupContainerImpl(this.token, string);
            aMGroupContainerImpl.delete();
        }
    }

    public Set getGroupContainers(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(4));
    }

    public long getNumberOfGroupContainers(int n) throws AMException, SSOException {
        return this.getGroupContainers(n).size();
    }

    public Set searchGroupContainers(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), string, map, n);
    }

    public AMSearchResults searchGroupContainers(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), string, map, aMSearchControl);
    }

    public Set createUsers(Set set) throws AMException, SSOException {
        HashSet<AMUserImpl> hashSet = new HashSet<AMUserImpl>();
        Set set2 = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set set3 = null;
        if (set2 != null && !set2.isEmpty()) {
            set3 = AMServiceUtils.getServiceObjectClasses(this.token, set2);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = AMNamingAttrManager.getNamingAttr(1) + "=" + (String)iterator.next() + "," + this.entryDN;
            AMUserImpl aMUserImpl = new AMUserImpl(this.token, string);
            if (set3 != null && !set3.isEmpty()) {
                aMUserImpl.setAttribute("objectclass", set3);
            }
            aMUserImpl.create();
            hashSet.add(aMUserImpl);
        }
        return hashSet;
    }

    public Set createUsers(Map map) throws AMException, SSOException {
        HashSet<AMUserImpl> hashSet = new HashSet<AMUserImpl>();
        Set set = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set set2 = null;
        if (set != null && !set.isEmpty()) {
            set2 = AMServiceUtils.getServiceObjectClasses(this.token, set);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMNamingAttrManager.getNamingAttr(1) + "=" + string + "," + this.entryDN;
            AMUserImpl aMUserImpl = new AMUserImpl(this.token, string2);
            Map map2 = (Map)map.get(string);
            aMUserImpl.setAttributes(map2);
            if (set2 != null && !set2.isEmpty()) {
                Set set3 = (Set)map2.get("objectclass");
                if (set3 != null && !set3.isEmpty()) {
                    set2 = AMCommonUtils.combineOCs(set2, set3);
                }
                aMUserImpl.setAttribute("objectclass", set2);
            }
            aMUserImpl.create();
            hashSet.add(aMUserImpl);
        }
        return hashSet;
    }

    public AMUser createUser(String string, Map map, Map map2) throws AMException, SSOException {
        Object object;
        Object object2;
        HashSet<String> hashSet = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        if (hashSet == Collections.EMPTY_SET) {
            hashSet = new HashSet<String>();
        }
        Set set = map2.keySet();
        Set set2 = this.dsManager.getRegisteredServiceNames(this.internalToken, this.entryDN);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (set2.contains(object2)) continue;
            Object[] objectArray = new Object[]{object2};
            throw new AMException(AMSDKBundle.getString("459", objectArray), "459", objectArray);
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            hashSet.add((String)object2);
        }
        object2 = null;
        if (hashSet != null && !hashSet.isEmpty()) {
            object2 = AMServiceUtils.getServiceObjectClasses(this.token, hashSet);
            object = (Set)map.get("objectclass");
            object2 = AMCommonUtils.combineOCs((Set)object, (Set)object2);
        }
        object = AMNamingAttrManager.getNamingAttr(1) + "=" + string + "," + this.entryDN;
        AMUserImpl aMUserImpl = new AMUserImpl(this.token, (String)object);
        aMUserImpl.setAttributes(map);
        iterator = set.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            String string2 = (String)iterator.next();
            Map map3 = (Map)map2.get(string2);
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string2, this.internalToken);
                objectArray = serviceSchemaManager.getSchema(SchemaType.USER);
                map3 = objectArray.validateAndInheritDefaults(map3, true);
                map3 = AMCommonUtils.removeEmptyValues(map3);
                aMUserImpl.setAttributes(map3);
            }
            catch (SMSException sMSException) {
                AMObjectImpl.debug.error("AMOrganizationImpl: Data validation failed-> " + string2, (Throwable)sMSException);
                objectArray = new Object[]{string2};
                throw new AMException(AMSDKBundle.getString("976", objectArray), "976", objectArray);
            }
        }
        if (object2 != null && !object2.isEmpty()) {
            aMUserImpl.setAttribute("objectclass", (Set)object2);
        }
        aMUserImpl.create();
        return aMUserImpl;
    }

    public void deleteUsers(Set set) throws AMException, SSOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMUserImpl aMUserImpl = new AMUserImpl(this.token, string);
            aMUserImpl.delete();
        }
    }

    public Set getUserDNs() throws AMException, SSOException {
        return this.search(1, this.getSearchFilter(1));
    }

    public AMUser getUser(String string, String string2) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (AMObjectImpl.debug.messageEnabled()) {
                AMObjectImpl.debug.message("AMOrganization.getUser: ancestor org is deleted for: " + this.entryDN + " :returning null");
            }
            return null;
        }
        Set set = this.searchUsers(string, 2, string2, null);
        if (set.size() > 1) {
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("969", objectArray), "969", objectArray);
        }
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            return new AMUserImpl(this.token, (String)iterator.next());
        }
        return null;
    }

    public long getNumberOfUsers(int n) throws AMException, SSOException {
        return this.getUsers(n).size();
    }

    public Set searchUsers(String string, int n) throws AMException, SSOException {
        return this.searchUsers(string, null, n);
    }

    public Set searchUsers(String string, int n, String string2, Map map) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (AMObjectImpl.debug.warningEnabled()) {
                AMObjectImpl.debug.warning("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, string2), string, map, n);
    }

    public AMSearchResults searchUsers(String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchUsers(string, null, aMSearchControl);
    }

    public Set searchUsers(String string, Map map, int n) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), string, map, n);
    }

    public AMSearchResults searchUsers(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), string, map, aMSearchControl);
    }

    public AMSearchResults searchUsers(String string, AMSearchControl aMSearchControl, String string2) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), string, aMSearchControl, string2);
    }

    public AMSearchResults searchUsers(AMSearchControl aMSearchControl, String string) throws AMException, SSOException {
        return this.searchObjects(this.getSearchFilter(1), aMSearchControl, string);
    }

    public long getNumberOfServices() throws AMException, SSOException {
        return this.getRegisteredServiceNames().size();
    }

    public Set getRegisteredServiceNames() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsManager.getRegisteredServiceNames(this.token, this.entryDN);
    }

    public void registerService(String string, boolean bl, boolean bl2) throws AMException, SSOException {
        Object object;
        if (AMObjectImpl.debug.messageEnabled()) {
            AMObjectImpl.debug.message("AMOrganizationImpl.registerService(" + string + ", " + bl + ", " + bl2 + ")");
        }
        this.dsManager.registerService(this.token, this.entryDN, string);
        HashSet<String> hashSet = this.getAttribute("sunRegisteredServiceName");
        if (!hashSet.equals(Collections.EMPTY_SET)) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).equalsIgnoreCase(string)) continue;
                Object[] objectArray = new Object[]{string};
                throw new AMException(AMSDKBundle.getString("464", objectArray), "464", objectArray);
            }
        } else {
            hashSet = new HashSet<String>();
        }
        hashSet.add(string);
        this.setAttribute("sunRegisteredServiceName", hashSet);
        try {
            this.store();
        }
        catch (AMException aMException) {
            try {
                object = this.getAttribute("objectclass");
                if (AMObjectImpl.debug.messageEnabled()) {
                    AMObjectImpl.debug.message("object class=" + object);
                }
                if (!object.contains("sunManagedOrganization")) {
                    object.add("sunManagedOrganization");
                    this.setAttribute("objectclass", (Set)object);
                    this.setAttribute("sunRegisteredServiceName", hashSet);
                    this.store();
                }
                throw aMException;
            }
            catch (Exception exception) {
                if (AMObjectImpl.debug.messageEnabled()) {
                    AMObjectImpl.debug.message("error adding objectclass", (Throwable)exception);
                }
                throw aMException;
            }
        }
        if (bl) {
            try {
                if (AMServiceUtils.serviceHasSubSchema(this.token, string, SchemaType.POLICY)) {
                    this.createTemplate(300, string, null);
                }
                if (AMServiceUtils.serviceHasSubSchema(this.token, string, SchemaType.DYNAMIC)) {
                    this.createTemplate(301, string, null);
                }
            }
            catch (SMSException sMSException) {
                throw new AMException(AMSDKBundle.getString("451"), "451");
            }
        }
    }

    public void unregisterService(String string) throws AMException, SSOException {
        if (AMObjectImpl.debug.messageEnabled()) {
            AMObjectImpl.debug.message("AMOrganizationImpl.unregisterService(" + string + ")");
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.isRegisteredForSubOrgs(string)) {
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("445", objectArray), "445", objectArray);
        }
        try {
            Object[] objectArray;
            Object object;
            if (AMServiceUtils.serviceHasSubSchema(this.token, string, SchemaType.DYNAMIC)) {
                this.dsManager.unRegisterService(this.token, this.entryDN, this.profileType, string, 301);
            }
            if (AMServiceUtils.serviceHasSubSchema(this.token, string, SchemaType.ORGANIZATION) && this.orgTemplateExists(string)) {
                object = this.getTemplate(string, 302);
                object.delete();
            }
            object = this.getAttribute("sunRegisteredServiceName");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                if (!objectArray.equalsIgnoreCase(string)) continue;
                object.remove(objectArray);
                this.setAttribute("sunRegisteredServiceName", (Set)object);
                this.store();
                return;
            }
            objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("463", objectArray), "463", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("913", objectArray), "913", objectArray);
        }
    }

    public Set getUsers(int n) throws AMException, SSOException {
        return this.search(n, this.getSearchFilter(1));
    }

    public void unassignAllPolicies(String string, Set set) throws AMException, SSOException {
        String string2;
        if (set == null || set.isEmpty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&(objectclass=").append("iplanet-am-managed-policy").append(")(|");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            stringBuffer.append("(").append("iplanet-am-named-policy-dn").append("=").append(string2).append(")");
        }
        stringBuffer.append("))");
        string2 = "cn=" + string + "Policy," + this.entryDN;
        Set set2 = this.dsManager.search(this.token, string2, stringBuffer.toString(), 1);
        if (set2 == null || set2.isEmpty()) {
            return;
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            AMTemplateImpl aMTemplateImpl = new AMTemplateImpl(this.token, string3, string, 300);
            this.unassignPolicies(aMTemplateImpl, set, false);
        }
    }

    public void modifyAllPolicyTemplates(String string, Set set) throws AMException, SSOException {
        String string2;
        if (set == null || set.isEmpty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&(objectclass=").append("iplanet-am-managed-policy").append(")(|");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            stringBuffer.append("(").append("iplanet-am-named-policy-dn").append("=").append(string2).append(")");
        }
        stringBuffer.append("))");
        string2 = "cn=" + string + "Policy," + this.entryDN;
        Set set2 = this.dsManager.search(this.token, string2, stringBuffer.toString(), 1);
        if (set2 == null || set2.isEmpty()) {
            return;
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            AMTemplateImpl aMTemplateImpl = new AMTemplateImpl(this.token, string3, string, 300);
            Set set3 = aMTemplateImpl.getAttribute("iplanet-am-named-policy-dn");
            this.setPolicyTemplate(aMTemplateImpl, set3);
        }
    }

    public boolean deleteAllNamedPolicyTemplates(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return AMSDKUtil.deleteAllPolicyTemplates(this.token, this.entryDN, string);
    }

    public Set getAssignedPolicyDNs() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&(objectclass=").append("iplanet-am-managed-policy");
        stringBuffer.append(")(").append("iplanet-am-named-policy-dn");
        stringBuffer.append("=*)(cn=\"cn=").append("ContainerDefaultTemplateRole");
        stringBuffer.append(",").append(this.entryDN).append("\"))");
        if (AMObjectImpl.debug.messageEnabled()) {
            AMObjectImpl.debug.message("AMOrganizationImpl.getNamedPolicyTemplates(): searchFilter: " + stringBuffer.toString());
        }
        Set set = this.dsManager.search(this.token, this.entryDN, stringBuffer.toString(), 2);
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AMObjectImpl aMObjectImpl = new AMObjectImpl(this.token, string, 13);
            hashSet.addAll(aMObjectImpl.getAttribute("iplanet-am-named-policy-dn"));
        }
        return hashSet;
    }

    public boolean isPolicyAssigned(String string, String string2) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return AMSDKUtil.checkIfTemplateExists(this.token, this.entryDN, string, string2);
    }

    public boolean orgTemplateExists(String string) throws AMException, SSOException {
        ServiceConfig serviceConfig = AMServiceUtils.getOrgConfig(this.token, this.entryDN, string);
        return serviceConfig != null;
    }

    protected Set getOrgTypeAttributes(String string, String string2) throws SSOException {
        Set set = null;
        try {
            AMTemplate aMTemplate = this.getTemplate(string, 302);
            set = aMTemplate.getAttribute(string2);
            if (AMObjectImpl.debug.messageEnabled()) {
                AMObjectImpl.debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org template " + string + " : " + string2 + "\n" + this.entryDN + " : " + set);
            }
        }
        catch (AMException aMException) {
            try {
                Map map = AMServiceUtils.getServiceConfig(this.token, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                set = (Set)map.get(string2);
                if (AMObjectImpl.debug.messageEnabled()) {
                    AMObjectImpl.debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org defaults " + string + " : " + string2 + "\n" + this.entryDN + " : " + set);
                }
            }
            catch (Exception exception) {
                AMObjectImpl.debug.warning("AMOrganizationImpl.getOrgTypeAttributes(): Error encountered in retrieving default org attrs for", (Throwable)exception);
            }
        }
        return set;
    }

    private boolean isRegisteredForSubOrgs(String string) throws SSOException {
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashMap.put("sunRegisteredServiceName", hashSet);
        Set set = null;
        try {
            set = this.searchSubOrganizations("*", hashMap, 2);
        }
        catch (AMException aMException) {
            // empty catch block
        }
        return set != null && !set.isEmpty() && set.size() > 1;
    }

    protected AMGroup createGroup(String string, Map map, Map map2, int n) throws AMException, SSOException {
        AMGroupImpl aMGroupImpl;
        String string2 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + this.entryDN;
        switch (n) {
            case 10: {
                aMGroupImpl = new AMStaticGroupImpl(this.token, string2);
                break;
            }
            case 11: {
                aMGroupImpl = new AMDynamicGroupImpl(this.token, string2);
                break;
            }
            case 12: {
                aMGroupImpl = new AMAssignableDynamicGroupImpl(this.token, string2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (map2 != null && !map2.isEmpty()) {
            Object object;
            Object object2;
            Set set = map2.keySet();
            Set set2 = this.dsManager.getRegisteredServiceNames(this.internalToken, this.entryDN);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                if (set2.contains(object2)) continue;
                Object[] objectArray = new Object[]{object2};
                throw new AMException(AMSDKBundle.getString("459", objectArray), "459", objectArray);
            }
            object2 = null;
            if (set != null && !set.isEmpty()) {
                object2 = AMServiceUtils.getServiceObjectClasses(this.token, set);
                object = (Set)map.get("objectclass");
                object2 = AMCommonUtils.combineOCs((Set)object, (Set)object2);
            }
            iterator = set.iterator();
            if (iterator.hasNext()) {
                Object[] objectArray;
                object = (String)iterator.next();
                Map map3 = (Map)map2.get(object);
                try {
                    objectArray = new ServiceSchemaManager((String)object, this.internalToken);
                    ServiceSchema serviceSchema = objectArray.getSchema(SchemaType.GROUP);
                    map3 = serviceSchema.validateAndInheritDefaults(map3, true);
                    map3 = AMCommonUtils.removeEmptyValues(map3);
                    aMGroupImpl.setAttributes(map3);
                }
                catch (SMSException sMSException) {
                    AMObjectImpl.debug.error("AMGroupContainerImpl.createStaticGroup: Data validation failed.. ", (Throwable)sMSException);
                }
                objectArray = new Object[]{object};
                throw new AMException(AMSDKBundle.getString("976", objectArray), "976", objectArray);
            }
            if (object2 != null && !object2.isEmpty()) {
                aMGroupImpl.setAttribute("objectclass", (Set)object2);
            }
        }
        aMGroupImpl.setAttributes(map);
        aMGroupImpl.create();
        return aMGroupImpl;
    }

    public AMSearchResults searchAssignableDynamicGroups(String string, Map map, String string2, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12, string2), string, map, aMSearchControl);
    }

    public AMSearchResults searchDynamicGroups(String string, Map map, String string2, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11, string2), string, map, aMSearchControl);
    }

    public AMSearchResults searchStaticGroups(String string, Map map, String string2, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(10, string2), string, map, aMSearchControl);
    }

    public AMSearchResults searchUsers(String string, Map map, String string2, AMSearchControl aMSearchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, string2), string, map, aMSearchControl);
    }
}

