/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.Guid;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

class AMCommonUtils {
    private static final String LOCALE_PROPERTY = "Locale";
    private static final String AM_SDK_DEBUG_FILE = "amProfile";
    private static SSOToken internalToken = null;
    private static final String LOCALE_INTEGRATION_PROPERTY = "locale.integration";
    protected static boolean integrateLocale = true;
    protected static Debug debug = Debug.getInstance((String)"amProfile");

    AMCommonUtils() {
    }

    protected static SSOToken getInternalToken() {
        if (internalToken == null) {
            try {
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                String string = (String)AccessController.doPrivileged(new AdminDNAction());
                String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
                internalToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            }
            catch (SSOException sSOException) {
                debug.error("AMCommonUtils.getInternalToken(): Unable to obtain internal token", (Throwable)sSOException);
            }
        }
        return internalToken;
    }

    protected static String getUserLocale(SSOToken sSOToken) {
        try {
            String string = sSOToken.getProperty(LOCALE_PROPERTY);
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.getUserLocale(): locale = " + string);
            }
            return string;
        }
        catch (SSOException sSOException) {
            debug.error("AMCommonUtils.getUserLocale(): missing locale, setting to null");
            return null;
        }
    }

    protected static AttrSet combineAttrSets(AttrSet attrSet, AttrSet attrSet2) {
        Attr attr;
        int n;
        int n2;
        AttrSet attrSet3 = new AttrSet();
        if (attrSet != null) {
            n2 = attrSet.size();
            n = 0;
            while (n < n2) {
                attr = attrSet.elementAt(n);
                attrSet3.add(attr);
                ++n;
            }
        }
        if (attrSet2 != null) {
            n2 = attrSet2.size();
            n = 0;
            while (n < n2) {
                attr = attrSet2.elementAt(n);
                attrSet3.add(attr);
                ++n;
            }
        }
        return attrSet3;
    }

    protected static Map mergeMaps(Map map, Map map2) {
        if (map == null && map2 == null) {
            return null;
        }
        if (map == null || map.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map;
        }
        Map map3 = map.size() > map2.size() ? map : map2;
        Map map4 = map.size() <= map2.size() ? map : map2;
        Iterator iterator = map4.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map3.get(string);
            if (set != null) {
                set.addAll((Set)map4.get(string));
                continue;
            }
            map3.put(string, (Set)map4.get(string));
        }
        return map3;
    }

    protected static String mapSetToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                stringBuffer.append("\n\tName: ").append(string);
                stringBuffer.append(" Values: ").append(set.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        return stringBuffer.toString();
    }

    protected static String mapByteToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])map.get(string);
                stringBuffer.append("\n\tName: ").append(string);
                stringBuffer.append(" Values: ").append(byArray);
            }
        } else {
            stringBuffer.append("<empty>");
        }
        return stringBuffer.toString();
    }

    protected static Set getSetCopy(Set set) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (!set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    protected static Set stringArrayToSet(String[] stringArray) {
        int n = stringArray.length;
        HashSet<String> hashSet = n > 0 ? new HashSet<String>(n) : new HashSet();
        int n2 = 0;
        while (n2 < n) {
            hashSet.add(stringArray[n2]);
            ++n2;
        }
        return hashSet;
    }

    protected static Map attrSetToMap(AttrSet attrSet) {
        return AMCommonUtils.attrSetToMap(attrSet, false);
    }

    protected static Map attrSetToMap(AttrSet attrSet, boolean bl) {
        AMHashMap aMHashMap = new AMHashMap(bl);
        if (attrSet == null) {
            return aMHashMap;
        }
        int n = attrSet.size();
        if (!bl) {
            int n2 = 0;
            while (n2 < n) {
                Attr attr = attrSet.elementAt(n2);
                String[] stringArray = attr.getStringValues();
                aMHashMap.put(attr.getName(), AMCommonUtils.stringArrayToSet(stringArray));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                Attr attr = attrSet.elementAt(n3);
                aMHashMap.put(attr.getName(), attr.getByteValues());
                ++n3;
            }
        }
        return aMHashMap;
    }

    protected static AttrSet mapToAttrSet(Map map) {
        return AMCommonUtils.mapToAttrSet(map, false);
    }

    protected static AttrSet mapToAttrSet(Map map, boolean bl) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        if (!bl) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
                attrSet.replace(new Attr(string, stringArray));
            }
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])map.get(string);
                attrSet.replace(new Attr(string, byArray));
            }
        }
        return attrSet;
    }

    protected static Guid[] toGuidArray(Set set) {
        Object[] objectArray = set.toArray();
        Guid[] guidArray = new Guid[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            guidArray[n] = new Guid((String)objectArray[n]);
            ++n;
        }
        return guidArray;
    }

    protected static Guid[] getGuidArray(Set set) {
        return set.toArray(new Guid[set.size()]);
    }

    private static String[] stringToArray(String string) {
        if (string == null || string.trim().length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    protected static String formatToRFC(String string) {
        return new DN(string).toRFCString().toLowerCase();
    }

    protected static String getPrincipalDN(SSOToken sSOToken) throws SSOException {
        String string = sSOToken.getPrincipal().getName();
        return AMCommonUtils.formatToRFC(string);
    }

    protected static Set combineOCs(Set set, Set set2) {
        Object object;
        if (set == null || set.isEmpty()) {
            return set2;
        }
        if (set2 == null || set2.isEmpty()) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashSet.add(((String)object).toLowerCase());
        }
        object = set2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashSet.add(string.toLowerCase());
        }
        return hashSet;
    }

    protected static boolean isObjectClassPresent(Set set, String string) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set updateAndGetRemovableOCs(Set set, Set hashSet) {
        HashSet<String> hashSet2 = hashSet;
        if (hashSet != null && !hashSet.isEmpty()) {
            hashSet2 = new HashSet<String>();
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    hashSet2.add(string);
                    continue block0;
                }
            }
            set.removeAll(hashSet2);
        }
        return hashSet2;
    }

    protected static Map removeEmptyValues(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set.isEmpty()) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    static {
        String string = SystemProperties.get((String)LOCALE_INTEGRATION_PROPERTY);
        if (string == null || string.equalsIgnoreCase("true")) {
            integrateLocale = true;
            if (debug.messageEnabled()) {
                debug.message("AM SDK: Locale integration enabled");
            }
        } else {
            integrateLocale = false;
        }
    }
}

