/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.backup;

import com.iplanet.am.backup.BackupException;
import com.iplanet.am.backup.BackupResourceBundle;
import com.iplanet.am.backup.CommonUtils;
import com.iplanet.am.backup.IBackupConstants;
import com.iplanet.am.util.SystemProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;

class DoRestore
implements IBackupConstants {
    private static ResourceBundle bundle = null;
    private static final int INVALID = 0;
    private static final int VERBOSE = 1;
    private static final int DIRECTORY = 2;
    private static final int HELP = 3;
    private static final int VERSION = 4;
    private static Map arguments = new HashMap();
    private boolean verbose = false;
    private boolean config = false;
    private boolean debug = false;
    private boolean log = false;
    private boolean cert = false;
    private boolean ds = false;
    private boolean runningDS = false;
    private boolean runningAM = false;
    private int comptype;
    private String packageDir = null;
    private String webServerDir = null;
    private String dsServerDir = null;
    private String amConfigPropertiesFile = null;
    private String dirName = null;
    private String backupDir = null;
    private boolean validDSLocation = false;
    private String logLocation = null;
    private String debugLocation = null;
    private String infFileName = "backup.inf";
    private String fileSep = System.getProperty("file.separator");
    private String lineSep = System.getProperty("line.separator");

    DoRestore() {
    }

    public static void main(String[] stringArray) throws BackupException {
        bundle = BackupResourceBundle.getResources();
        DoRestore doRestore = new DoRestore();
        try {
            doRestore.packageDir = stringArray[0];
            doRestore.webServerDir = stringArray[1];
            doRestore.amConfigPropertiesFile = doRestore.packageDir + "\\lib\\AMConfig.properties";
            doRestore.backupDir = doRestore.packageDir + doRestore.fileSep + bundle.getString("default-backupdir");
            int n = stringArray.length;
            int n2 = n - 2;
            String[] stringArray2 = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray2[n3] = stringArray[n3 + 2];
                ++n3;
            }
            doRestore.parseCommandLine(stringArray2);
            System.out.println(bundle.getString("inspecting-system"));
            doRestore.doProcessing();
            System.out.println(bundle.getString("success"));
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(bundle.getString("operation-failed") + " " + exception.getLocalizedMessage());
            System.exit(1);
        }
    }

    private void parseCommandLine(String[] stringArray) throws BackupException {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.getToken(stringArray[n].toLowerCase());
            switch (n2) {
                case 1: {
                    this.verbose = true;
                    break;
                }
                case 2: {
                    if (++n >= stringArray.length) {
                        this.displayUsage();
                        System.exit(1);
                    }
                    this.dirName = stringArray[n];
                    if (this.dirName != null && (this.comptype = this.getToken(this.dirName.toLowerCase())) == 0) break;
                    throw new BackupException(bundle.getString("no-directory-name"));
                }
                case 3: {
                    this.displayHelp();
                    System.exit(0);
                    break;
                }
                case 4: {
                    this.displayVersion();
                    System.exit(0);
                    break;
                }
                default: {
                    System.err.println(bundle.getString("invalid-option") + stringArray[n]);
                    this.displayUsage();
                    System.exit(1);
                }
            }
            ++n;
        }
        if (stringArray.length < 2) {
            this.displayUsage();
            System.exit(1);
        }
    }

    private void setRunningServices() throws BackupException {
        String string = null;
        String string2 = null;
        try {
            Object object;
            String[] stringArray = new String[]{"net", "start"};
            String string3 = System.getProperty("java.io.tmpdir") + "\\amRestoreTempFile";
            if (CommonUtils.executeCommand(stringArray, string3) != 0) {
                CommonUtils.deleteFileAndDir(string3);
                throw new BackupException(bundle.getString("get-running-services-failed"));
            }
            String string4 = null;
            string4 = this.webServerDir.substring(this.webServerDir.lastIndexOf(45) + 1, this.webServerDir.length());
            string4 = "Sun ONE Web Server 6.1 (https-" + string4 + ")";
            String string5 = CommonUtils.grepAndSed(this.infFileName, "ds.location.key=");
            if (!string5.equals("$")) {
                object = this.dsServerDir;
                string2 = ((String)object).substring(((String)object).lastIndexOf(45) + 1, ((String)object).length());
                String[] stringArray2 = new String[]{(String)object + "\\..\\bin\\slapd\\server\\slapd.exe", "-v"};
                String string6 = System.getProperty("java.io.tmpdir") + "\\amDSVersion";
                CommonUtils.executeCommand(stringArray2, string6);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));
                String string7 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().indexOf("Sun-ONE-Directory/5.2") == -1) continue;
                    string7 = "5.2";
                }
                string2 = string7.equals("5.2") ? "Sun ONE Directory Server 5.2 (" + string2 + ")" : "iPlanet Directory Server 5 (" + string2 + ")";
                CommonUtils.deleteFileAndDir(string6);
            }
            object = new BufferedReader(new FileReader(string3));
            int n = 0;
            n = this.validDSLocation ? 2 : 1;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.trim().equalsIgnoreCase(string4)) {
                    this.runningAM = true;
                    --n;
                } else if (!string5.equals("$") && string.trim().equalsIgnoreCase(string2) && this.validDSLocation) {
                    this.runningDS = true;
                    --n;
                }
                if (n == 0) break;
            }
            ((BufferedReader)object).close();
            CommonUtils.deleteFileAndDir(string3);
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("get-running-services-failed"));
        }
    }

    private void doProcessing() throws BackupException {
        boolean bl;
        this.backupDir = this.dirName.indexOf(92) == -1 && this.dirName.indexOf(47) == -1 ? this.backupDir + this.fileSep + this.dirName : this.dirName;
        File file = new File(this.backupDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new BackupException(bundle.getString("no-such-directory") + this.backupDir);
        }
        this.backupDir = file.getAbsolutePath();
        this.infFileName = this.backupDir + this.fileSep + this.infFileName;
        if (!CommonUtils.doesFileExist(this.infFileName)) {
            throw new BackupException(bundle.getString("invalid-backup-directory") + this.backupDir);
        }
        System.out.println(bundle.getString("restore-in-progress"));
        String string = null;
        string = CommonUtils.grepAndSed(this.infFileName, "config.backup.key=");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.config = true;
        }
        if ((string = CommonUtils.grepAndSed(this.infFileName, "debug.backup.key=")) != null && string.equalsIgnoreCase("true")) {
            this.debug = true;
        }
        if ((string = CommonUtils.grepAndSed(this.infFileName, "log.backup.key=")) != null && string.equalsIgnoreCase("true")) {
            this.log = true;
        }
        if ((string = CommonUtils.grepAndSed(this.infFileName, "cert.backup.key=")) != null && string.equalsIgnoreCase("true")) {
            this.cert = true;
        }
        if ((string = CommonUtils.grepAndSed(this.infFileName, "ds.backup.key=")) != null && string.equalsIgnoreCase("true")) {
            this.ds = true;
        }
        if (this.ds || this.config || this.cert) {
            this.getDSLocation();
        }
        this.setRunningServices();
        if (this.runningAM) {
            bl = CommonUtils.readLocalizedYesNo(bundle.getString("stop-is-question"), bundle.getString("no-value"), bundle.getString("yes-value"), bundle.getString("no-value"));
            if (bl) {
                System.out.println(bundle.getString("stopping-is"));
                this.stopIS();
                System.out.println(bundle.getString("stopped-is"));
            } else {
                throw new BackupException(bundle.getString("can-not-restore"));
            }
        }
        if (this.validDSLocation && this.runningDS) {
            bl = CommonUtils.readLocalizedYesNo(bundle.getString("stop-ds-question"), bundle.getString("no-value"), bundle.getString("yes-value"), bundle.getString("no-value"));
            if (bl) {
                System.out.println(bundle.getString("stopping-ds"));
                this.stopDS();
                System.out.println(bundle.getString("stopped-ds"));
            } else {
                throw new BackupException(bundle.getString("can-not-restore"));
            }
        }
        if (this.ds && this.validDSLocation) {
            this.doRestoreDS();
        }
        if (this.config) {
            this.doRestoreConfig();
        }
        if (this.debug) {
            this.doRestoreDebug();
        }
        if (this.log) {
            this.doRestoreLog();
        }
        if (this.cert) {
            this.doRestoreCert();
        }
        System.out.println(bundle.getString("restore-finished-msg"));
    }

    private void doRestoreDS() throws BackupException {
        System.out.println(bundle.getString("ds-restore-progress"));
        try {
            Object object;
            String string = this.backupDir + this.fileSep + "ds";
            String string2 = null;
            File file = new File(string);
            if (file.exists() && file.isDirectory() && ((String[])(object = file.list())).length > 0) {
                string2 = object[0];
            }
            if (!(file = new File(string2 = string + this.fileSep + string2.trim())).exists() || !file.isFile()) {
                throw new BackupException(bundle.getString("ds-restore-failed"));
            }
            object = null;
            object = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.rootsuffix");
            if (object == null) {
                throw new BackupException(bundle.getString("could-not-get-rootsuffix1"));
            }
            String string3 = null;
            string3 = CommonUtils.grepAndSed(this.infFileName, "ds.rootsuffix.key");
            if (string3 == null) {
                throw new BackupException(bundle.getString("could-not-get-old-rootsuffix"));
            }
            if (!((String)object).equalsIgnoreCase(string3)) {
                throw new BackupException(bundle.getString("rootsuffix-does-not-match"));
            }
            String string4 = this.dsServerDir;
            String string5 = string4.replace('/', '\\');
            String[] stringArray = new String[]{(string5 = string5.substring(0, string5.lastIndexOf(92))) + "\\bin\\slapd\\server\\slapd.exe", "ldif2db", "-D", string4.replace('/', '\\'), "-s", string3, "-i", string2};
            if (CommonUtils.executeCommand(stringArray) != 0) {
                throw new BackupException(bundle.getString("ds-export-failed"));
            }
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("ds-restore-failed"));
        }
        System.out.println(bundle.getString("ds-restore-finished"));
    }

    private void doRestoreConfig() throws BackupException {
        System.out.println(bundle.getString("config-restore-progress"));
        try {
            String string;
            String string2 = this.backupDir + this.fileSep + "config";
            String string3 = string2 + this.fileSep + "SunONEIS";
            this.copyIt(string3 + "\\config\\*", this.packageDir + "\\config");
            this.copyIt(string3 + "\\locale\\*", this.packageDir + "\\locale");
            this.copyIt(string3 + "\\Servers\\httpacl\\*", this.webServerDir + "\\..\\httpacl");
            this.copyIt(string3 + "\\lib\\*", this.packageDir + "\\lib");
            this.copyIt(string3 + "\\Servers\\https-host\\*", this.webServerDir);
            this.copyIt(string3 + "\\web-apps\\*", this.packageDir + "\\web-apps");
            if (this.validDSLocation) {
                string = string2 + this.fileSep + "ldap-host\\config";
                this.copyIt(string + "\\schema\\*", this.dsServerDir + "\\config\\schema");
                String string4 = CommonUtils.grepAndSed(this.infFileName, "ds.location.key=");
                string4 = string4.replace('\\', '/');
                int n = string4.length();
                String string5 = string + "\\dse.ldif";
                String string6 = this.dsServerDir;
                string6 = string6.replace('\\', '/');
                if (!string4.equalsIgnoreCase(string6)) {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string5));
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("dse.ldif"));
                    String string7 = null;
                    int n2 = 0;
                    while ((string7 = bufferedReader.readLine()) != null) {
                        string4 = string4.toLowerCase();
                        n2 = string7.trim().toLowerCase().indexOf(string4);
                        if (n2 != -1) {
                            StringBuffer stringBuffer = new StringBuffer(string7);
                            stringBuffer.replace(n2, n2 + n, string6);
                            string7 = stringBuffer.toString();
                        }
                        bufferedWriter.write(string7);
                        bufferedWriter.write(this.lineSep);
                    }
                    bufferedWriter.close();
                    bufferedReader.close();
                    this.copyIt("dse.ldif", string);
                    CommonUtils.deleteFileAndDir("dse.ldif");
                }
                this.copyIt(string + "\\dse.ldif", this.dsServerDir + "\\config");
            }
            string = CommonUtils.grepAndSed(this.infFileName, "ds.location.key=");
            boolean bl = false;
            String string8 = null;
            try {
                string8 = CommonUtils.grepAndSed(this.infFileName, "serviceconfiguration.backup.key=");
            }
            catch (Exception exception) {
                string8 = null;
            }
            if (string8 != null && string8.equalsIgnoreCase("true")) {
                if (string.equals("$")) {
                    bl = true;
                } else if (!this.ds) {
                    this.startDS();
                    bl = true;
                }
            }
            if (bl) {
                if (this.doRestoreServiceConfig(this.backupDir)) {
                    System.out.println(bundle.getString("service-config-restore-done"));
                } else {
                    System.out.println(bundle.getString("service-config-restore-failed"));
                }
            }
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("config-restore-failed"));
        }
        System.out.println(bundle.getString("config-restore-finished"));
    }

    private boolean doRestoreServiceConfig(String string) {
        String string2;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Object object;
        String string3;
        BufferedReader bufferedReader;
        String string4 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.directory.host");
        String string5 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.directory.port");
        String string6 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.rootsuffix");
        String string7 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.sun.identity.authentication.super.user");
        boolean bl = false;
        String string8 = string + "\\out";
        String string9 = string + "\\error";
        String[] stringArray4 = new String[]{this.packageDir + "\\tools\\ldapsearch.exe", "-h", string4, "-p", string5, "-D", string7, "-w", "testdummystring", "-b", string6, "entrydn=ou=services,*"};
        if (CommonUtils.execute(stringArray4, string8, string9) == -1) {
            CommonUtils.deleteFileAndDir(string8);
            CommonUtils.deleteFileAndDir(string9);
            return false;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string9));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("Can't connect") == -1) continue;
                bl = true;
                System.out.println(bundle.getString("ds-not-running"));
                System.out.println(bundle.getString("start-ds"));
                try {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    ((BufferedReader)object).readLine();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (bl) {
            if (CommonUtils.execute(stringArray4, string8, string9) == -1) {
                return false;
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(string9));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.indexOf("Can't connect") == -1) continue;
                    bl = true;
                    System.out.println(bundle.getString("ds-not-running"));
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        boolean bl2 = false;
        object = null;
        while (object == null || ((String)object).equals("")) {
            System.out.println(bundle.getString("enter-admin-password"));
            object = CommonUtils.readPassword();
            if (object != null && !((String)object).equals("")) continue;
            System.out.print(bundle.getString("password-cannotbe-empty") + " ");
        }
        String[] stringArray5 = new String[]{this.packageDir + "\\tools\\ldapsearch.exe", "-h", string4, "-p", string5, "-D", string7, "-w", object, "-b", string6, "entrydn=\"ou=services,*\""};
        if (CommonUtils.execute(stringArray5, string8, string9) == -1) {
            CommonUtils.deleteFileAndDir(string8);
            CommonUtils.deleteFileAndDir(string9);
            return false;
        }
        try {
            stringArray3 = new BufferedReader(new FileReader(string9));
            while ((string3 = stringArray3.readLine()) != null) {
                if (string3.indexOf("Invalid credentials") == -1) continue;
                bl2 = true;
                System.out.println(bundle.getString("admin-password-wrong"));
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (bl2) {
            object = null;
            while (object == null || ((String)object).equals("")) {
                System.out.println(bundle.getString("enter-admin-password"));
                object = CommonUtils.readPassword();
                if (object != null && !((String)object).equals("")) continue;
                System.out.print(bundle.getString("password-cannotbe-empty") + " ");
            }
            stringArray5[8] = object;
            if (CommonUtils.execute(stringArray5, string8, string9) != 0) {
                return false;
            }
        }
        if (CommonUtils.executeCommand(stringArray3 = new String[]{this.packageDir + "\\tools\\ldapmodify.exe", "-h", string4, "-p", string5, "-D", string7, "-w", object, "-a", "-c", "-e", "am2bak_rejected_Entries.ldif", "-f", string + "\\config\\updated_services.ldif"}) == -1) {
            CommonUtils.deleteFileAndDir(string8);
            return false;
        }
        try {
            stringArray2 = new BufferedReader(new FileReader("am2bak_rejected_Entries.ldif"));
            stringArray = new BufferedWriter(new FileWriter("am2bak_extracted_dn.ldif"));
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = stringArray2.readLine()) != null) {
                if (string2.startsWith("dn: ")) {
                    bl3 = true;
                    stringBuffer.append(string2);
                    continue;
                }
                if (bl3) {
                    if (string2.startsWith(" ")) {
                        int n = string2.length();
                        String string10 = string2.substring(1, string2.length());
                        stringBuffer.append(string10);
                    } else {
                        bl3 = false;
                        bl4 = true;
                    }
                }
                if (!bl4) continue;
                stringArray.write(stringBuffer + "\n");
                stringArray.flush();
                stringBuffer = new StringBuffer();
                bl4 = false;
            }
            stringArray2.close();
            stringArray.close();
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            stringArray2 = new BufferedReader(new FileReader("am2bak_extracted_dn.ldif"));
            stringArray = new BufferedWriter(new FileWriter("am2bak_reversed_dn.ldif"));
            Stack<String> stack = new Stack<String>();
            while ((string2 = stringArray2.readLine()) != null) {
                stack.push(string2 + "\n");
            }
            while (!stack.empty()) {
                string2 = (String)stack.pop();
                stringArray.write(string2 + "changetype: delete\n\n");
                stringArray.flush();
            }
            stringArray2.close();
            stringArray.close();
        }
        catch (IOException iOException) {
            return false;
        }
        stringArray2 = new String[]{this.packageDir + "\\tools\\ldapmodify.exe", "-h", string4, "-p", string5, "-D", string7, "-w", object, "-c", "-f", "am2bak_reversed_dn.ldif"};
        if (CommonUtils.executeCommand(stringArray2) == -1) {
            CommonUtils.deleteFileAndDir(string8);
            return false;
        }
        stringArray = new String[]{this.packageDir + "\\tools\\ldapmodify.exe", "-h", string4, "-p", string5, "-D", string7, "-w", object, "-a", "-c", "-f", "am2bak_rejected_Entries.ldif"};
        if (CommonUtils.executeCommand(stringArray) == -1) {
            CommonUtils.deleteFileAndDir(string8);
            CommonUtils.deleteFileAndDir("am2bak_extracted_dn.ldif");
            CommonUtils.deleteFileAndDir("am2bak_reversed_dn.ldif");
            CommonUtils.deleteFileAndDir("am2bak_rejected_Entries.ldif");
            return false;
        }
        CommonUtils.deleteFileAndDir("am2bak_extracted_dn.ldif");
        CommonUtils.deleteFileAndDir("am2bak_reversed_dn.ldif");
        CommonUtils.deleteFileAndDir("am2bak_rejected_Entries.ldif");
        return true;
    }

    private void doRestoreDebug() throws BackupException {
        System.out.println(bundle.getString("debug-restore-progress"));
        try {
            String string = this.backupDir + this.fileSep + "debug";
            String string2 = null;
            string2 = CommonUtils.grepAndSed(this.infFileName, "debug.location.key=");
            if (string2 == null) {
                throw new BackupException(bundle.getString("could-not-read-debug-loc"));
            }
            File file = new File(string2 = string2.replace('/', '\\'));
            if (!file.exists() || !file.isDirectory()) {
                CommonUtils.makeDirs(string2);
            }
            this.copyIt(string + "\\*", string2);
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("debug-restore-failed"));
        }
        System.out.println(bundle.getString("debug-restore-finished"));
    }

    private void doRestoreLog() throws BackupException {
        System.out.println(bundle.getString("log-restore-progress"));
        try {
            File file;
            String string = this.backupDir + this.fileSep + "log";
            String string2 = null;
            string2 = CommonUtils.grepAndSed(this.infFileName, "log.location.key=");
            if (string2 == null) {
                throw new BackupException(bundle.getString("could-not-read-log-loc"));
            }
            if ((string2 = string2.replace('/', '\\')).endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!(file = new File(string2)).exists() || !file.isDirectory()) {
                CommonUtils.makeDirs(string2);
            }
            this.copyIt(string + "\\*", string2);
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("log-restore-failed"));
        }
        System.out.println(bundle.getString("log-restore-finished"));
    }

    private void doRestoreCert() throws BackupException {
        System.out.println(bundle.getString("cert-restore-progress"));
        try {
            String string = this.backupDir + this.fileSep + "cert";
            this.copyIt(string + "\\ws\\alias\\*", this.webServerDir + "\\..\\alias");
            if (this.validDSLocation) {
                String string2 = this.dsServerDir.replace('/', '\\');
                this.copyIt(string + "\\ds\\alias\\*", string2 + "\\..\\alias");
            }
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("cert-restore-failed"));
        }
        System.out.println(bundle.getString("cert-restore-finished"));
    }

    private void copyIt(String string, String string2) throws BackupException {
        if (this.verbose) {
            System.out.println(bundle.getString("restoring-to") + " " + string2);
        }
        if (CommonUtils.executeXcopy(string, string2) != 0) {
            throw new BackupException(bundle.getString("copy-failed") + " " + string);
        }
        if (this.verbose) {
            System.out.println(bundle.getString("restore-done") + " " + string2);
        }
    }

    private void stopIS() throws BackupException {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.webServerDir + "\\stopsvr.bat"));
            StringTokenizer stringTokenizer = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.trim().startsWith("net")) continue;
                stringTokenizer = new StringTokenizer(string);
                break;
            }
            if (stringTokenizer == null) {
                throw new BackupException(bundle.getString("can-not-get-service-name"));
            }
            String[] stringArray = new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken()};
            if (CommonUtils.executeCommand(stringArray) != 0) {
                throw new BackupException(bundle.getString("can-not-stop-is"));
            }
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("can-not-stop-is"));
        }
    }

    private void stopDS() throws BackupException {
        String string = null;
        String string2 = this.dsServerDir;
        string = string2.substring(string2.lastIndexOf(45), string2.length());
        string = "slapd" + string;
        String[] stringArray = new String[]{"net", "stop", string};
        if (CommonUtils.executeCommand(stringArray) != 0) {
            throw new BackupException(bundle.getString("can-not-stop-ds"));
        }
    }

    private int getToken(String string) {
        try {
            return (Integer)arguments.get(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void displayUsage() {
        System.out.println(bundle.getString("usage-bak2am"));
    }

    private void displayHelp() {
        this.displayUsage();
        System.out.println(bundle.getString("bak2am-help-where"));
        System.out.println(bundle.getString("bak2am-help-options"));
    }

    private void displayVersion() {
        String string = SystemProperties.get((String)"com.iplanet.am.version");
        System.out.println("\n" + bundle.getString("util-name") + " " + bundle.getString("restore-util-name-value"));
        System.out.println(bundle.getString("prod-version") + " " + string);
        System.out.println(bundle.getString("product") + " " + bundle.getString("product-value"));
        System.out.println(bundle.getString("rel-state") + " " + bundle.getString("rel-state-value"));
        System.out.println(bundle.getString("legal-notice") + " " + bundle.getString("legal-notice-value"));
    }

    public void getDSLocation() throws BackupException {
        String string = null;
        string = CommonUtils.grepAndSed(this.infFileName, "ds.location.key=");
        if (string.equals("$")) {
            return;
        }
        String string2 = string + "\\ldif2db.bat";
        File file = new File(string2);
        if (file.exists()) {
            this.dsServerDir = string;
            this.validDSLocation = true;
        } else {
            System.out.println(bundle.getString("ds_changed"));
            boolean bl = false;
            String string3 = null;
            while (!bl) {
                Object object;
                try {
                    object = new InputStreamReader(System.in);
                    BufferedReader bufferedReader = new BufferedReader((Reader)object);
                    System.out.println(bundle.getString("enter-ds-location"));
                    string3 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    throw new BackupException(iOException);
                }
                if (string3.equals("$")) {
                    bl = true;
                    this.validDSLocation = false;
                    continue;
                }
                object = new File(string3);
                if (!((File)object).exists() || !((File)object).isDirectory()) continue;
                bl = true;
                this.validDSLocation = true;
                this.dsServerDir = string3;
            }
        }
    }

    private void startDS() throws BackupException {
        String string = null;
        String string2 = this.dsServerDir;
        string = string2.substring(string2.lastIndexOf(45), string2.length());
        string = "slapd" + string;
        String[] stringArray = new String[]{"net", "start", string};
        if (CommonUtils.executeCommand(stringArray) != 0) {
            throw new BackupException(bundle.getString("can-not-stop-ds"));
        }
    }

    static {
        arguments.put("--verbose", new Integer(1));
        arguments.put("-v", new Integer(1));
        arguments.put("--directory", new Integer(2));
        arguments.put("-d", new Integer(2));
        arguments.put("--help", new Integer(3));
        arguments.put("-h", new Integer(3));
        arguments.put("--version", new Integer(4));
        arguments.put("-n", new Integer(4));
    }
}

