/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.RemoveServiceTemplateAttrValuesReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import java.util.Iterator;
import java.util.Set;

class OrgRemoveServiceTemplateAttrValuesReq
extends RemoveServiceTemplateAttrValuesReq {
    OrgRemoveServiceTemplateAttrValuesReq(String string) {
        super(string);
    }

    String getDescriptionString() {
        return "requestdescription76";
    }

    void modifyServiceTemplates(AMStoreConnection aMStoreConnection, String string) throws AdminException {
        AMOrganization aMOrganization = null;
        AMTemplate aMTemplate = null;
        try {
            aMOrganization = aMStoreConnection.getOrganization(string);
            aMTemplate = this.getTemplate(aMOrganization);
            if (aMTemplate != null) {
                this.removeAttributeValues(aMTemplate);
                if (this.roleTemplate) {
                    Set set = aMOrganization.getRoles(1);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        AMRole aMRole = aMStoreConnection.getRole(string2);
                        aMTemplate = this.getTemplate(aMRole);
                        if (aMTemplate == null) continue;
                        this.removeAttributeValues(aMTemplate);
                    }
                }
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        String string = AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteservicetemplateattributevalues") + "\n" + this.serviceName;
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(string);
        }
        AdminReq.writer.println(string);
        try {
            if (this.scope.equalsIgnoreCase("SCOPE_ONE")) {
                this.modifyServiceTemplates(aMStoreConnection, this.targetDN);
            } else {
                AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
                Set set = aMOrganization.getSubOrganizations(2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.modifyServiceTemplates(aMStoreConnection, (String)iterator.next());
                }
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

