/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.util.DN;

class OrgRegisterServicesReq
extends AdminReq {
    private Set serviceSet = new HashSet();

    OrgRegisterServicesReq(String string) {
        super(string);
    }

    void registerServicesReq(String string) {
        this.serviceSet.add(string);
    }

    Set getRegisterOrgReq() {
        return this.serviceSet;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription44") + " " + this.targetDN);
        printUtils.printSet(this.serviceSet, 1);
        printWriter.flush();
        return stringWriter.toString();
    }

    private Set getRegisterableServices(AMStoreConnection aMStoreConnection, AMOrganization aMOrganization) throws AdminException {
        Set set = null;
        String string = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        boolean bl = new DN(string).equals(new DN(this.targetDN));
        if (!bl) {
            try {
                AMOrganization aMOrganization2 = aMStoreConnection.getOrganization(aMOrganization.getParentDN());
                set = aMOrganization2.getRegisteredServiceNames();
            }
            catch (AMException aMException) {
                throw new AdminException(aMException.toString());
            }
            catch (SSOException sSOException) {
                throw new AdminException(sSOException.toString());
            }
        }
        return set;
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("registeredservices"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("registeredservices"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            Set set = this.getRegisterableServices(aMStoreConnection, aMOrganization);
            Iterator iterator = this.serviceSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (set == null || set.contains(string)) {
                    aMOrganization.registerService(string, false, false);
                    AdminReq.writer.println(string);
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(string);
                    }
                    this.doLog(string, aMOrganization, "register-service");
                    continue;
                }
                throw new AdminException(string + " " + AdminReq.bundle.getString("unableToRegisterService"));
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

