/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.cos.COSManager;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class OrgModifyServiceTemplateReq
extends AdminReq {
    private Map ServiceTemplateReq = new HashMap();
    private String serviceName;
    private int stype;
    private String scope = "SCOPE_ONE";
    private boolean roleTemplate = false;
    private SSOToken ssoToken = null;

    OrgModifyServiceTemplateReq() {
    }

    OrgModifyServiceTemplateReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription65") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void addServiceTemplateReq(String string, String string2, String string3, String string4, Map map, SSOToken sSOToken) throws AdminException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new UnsupportedOperationException();
        }
        this.serviceName = string;
        this.ServiceTemplateReq = map;
        this.scope = string3;
        this.roleTemplate = string4.equalsIgnoreCase("true");
        this.stype = -1;
        this.ssoToken = sSOToken;
        if (string2.equalsIgnoreCase("dynamic")) {
            this.stype = 301;
        } else if (string2.equalsIgnoreCase("organization")) {
            this.stype = 302;
        } else if (string2.equalsIgnoreCase("policy")) {
            this.stype = 300;
        }
    }

    Map getServiceTemplateReq() {
        return this.ServiceTemplateReq;
    }

    void modifyServiceTemplates(AMStoreConnection aMStoreConnection, String string, ServiceSchema serviceSchema) throws AdminException {
        try {
            Object object;
            Iterator iterator;
            Object object2;
            Object object3;
            Guid guid = new Guid(string);
            DirectCOSDefinition directCOSDefinition = null;
            COSManager cOSManager = COSManager.getCOSManager(this.ssoToken, guid);
            try {
                directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(this.serviceName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (directCOSDefinition != null) {
                object3 = directCOSDefinition.getCOSAttributes();
                object2 = new HashSet();
                int n = 0;
                while (n < ((Object)object3).length) {
                    iterator = new StringTokenizer((String)object3[n]);
                    object2.add(((StringTokenizer)((Object)iterator)).nextToken());
                    ++n;
                }
                iterator = this.ServiceTemplateReq.keySet();
                object = iterator.iterator();
                while (object.hasNext()) {
                    boolean bl = false;
                    String string2 = object.next().toString();
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        if (!string2.equalsIgnoreCase(iterator2.next().toString())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
                    String string3 = attributeSchema.getCosQualifier();
                    directCOSDefinition.addCOSAttribute(string2, this.convertCosQualifier(string3));
                    directCOSDefinition.save();
                }
            }
            if (!(object2 = (object3 = aMStoreConnection.getOrganization(string)).getTemplate(this.serviceName, this.stype)).isExists()) {
                throw new AdminException(AdminReq.bundle.getString("templatedoesnotexist"));
            }
            object2.setAttributes(this.ServiceTemplateReq);
            object2.store();
            this.doLog((AMObject)object2, "modify-servtemplate");
            if (this.roleTemplate) {
                Set set = object3.getRoles(1);
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    AMRole aMRole = aMStoreConnection.getRole((String)object);
                    object2 = aMRole.getTemplate(this.serviceName, this.stype);
                    if (object2.isExists()) {
                        object2.setAttributes(this.ServiceTemplateReq);
                        object2.store();
                        this.doLog((AMObject)object2, "modify-servtemplate");
                        continue;
                    }
                    throw new AdminException(AdminReq.bundle.getString("roletemplatedoesnotexist"));
                }
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (UMSException uMSException) {
            throw new AdminException(uMSException);
        }
    }

    private int convertCosQualifier(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("default")) {
            n = 0;
        } else if (string.equalsIgnoreCase("override")) {
            n = 1;
        } else if (string.equalsIgnoreCase("merge-schemes")) {
            n = 3;
        } else if (string.equalsIgnoreCase("operational")) {
            n = 2;
        }
        return n;
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        block12: {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("modifyservicetemplates") + "\n" + this.serviceName);
            }
            AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("modifyservicetemplates") + "\n" + this.serviceName);
            try {
                ServiceSchemaManager serviceSchemaManager = null;
                ServiceSchema serviceSchema = null;
                if (this.stype != -1) {
                    block11: {
                        if (this.stype == 301) {
                            serviceSchemaManager = new ServiceSchemaManager(this.serviceName, this.ssoToken);
                            try {
                                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                            }
                            catch (SMSException sMSException) {
                                if (!AdminReq.debug.warningEnabled()) break block11;
                                AdminReq.debug.warning("AMSDKUtil.getServiceNames(): No schema defined for SchemaType.DYNAMIC type");
                            }
                        }
                    }
                    this.modifyServiceTemplates(aMStoreConnection, this.targetDN, serviceSchema);
                    if (this.scope.equalsIgnoreCase("SCOPE_SUB")) {
                        AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
                        Set set = aMOrganization.getSubOrganizations(2);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            this.modifyServiceTemplates(aMStoreConnection, (String)iterator.next(), serviceSchema);
                        }
                    }
                    break block12;
                }
                throw new AdminException("invalidArguments");
            }
            catch (AMException aMException) {
                throw new AdminException(aMException);
            }
            catch (SSOException sSOException) {
                throw new AdminException(sSOException);
            }
            catch (SMSException sMSException) {
                throw new AdminException(sMSException);
            }
        }
    }
}

