/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.RoleUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class OrgModifyRoleReq
extends AdminReq {
    private Map values = new HashMap();
    private String roleDN;

    OrgModifyRoleReq(String string) {
        super(string);
    }

    void addRoleReq(String string, Map map) {
        this.roleDN = string;
        this.values = map;
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("role DN: " + this.roleDN);
        }
        AdminReq.writer.println(AdminReq.bundle.getString(this.getType()) + " " + this.roleDN + "\n" + AdminReq.bundle.getString("modifyrole"));
        try {
            AMRole aMRole = null;
            int n = RoleUtils.getRoleType(this.roleDN, aMStoreConnection);
            if (n == 8) {
                Set set;
                AMFilteredRole aMFilteredRole = aMStoreConnection.getFilteredRole(this.roleDN);
                if (this.values != null && this.values.get("filterinfo") != null && (set = (Set)this.values.remove("filterinfo")) != null && !set.isEmpty()) {
                    aMFilteredRole.setFilter((String)set.iterator().next());
                }
                aMRole = aMFilteredRole;
            } else {
                aMRole = aMStoreConnection.getRole(this.roleDN);
            }
            aMRole.setAttributes(this.values);
            aMRole.store();
            this.doLog(aMRole, "modify-role");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    protected String getType() {
        return "organization";
    }
}

