/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class OrgGetSubOrgReq
extends AdminReq {
    private Set subOrgDNs = new HashSet();
    private boolean DNsOnly = true;

    OrgGetSubOrgReq() {
    }

    OrgGetSubOrgReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addSubOrgDNs(String string) {
        this.subOrgDNs.add(string);
    }

    Set getSubOrgDNs() {
        return this.subOrgDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription41") + " " + this.targetDN);
        printWriter.println("   DNsOnly =" + this.DNsOnly);
        if (this.subOrgDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.subOrgDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getsuborgs"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getsuborgs"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            AdminReq.writer.println(this.targetDN);
            boolean bl = false;
            if (this.subOrgDNs.isEmpty()) {
                this.subOrgDNs = aMOrganization.searchSubOrganizations("*", 2);
            } else {
                bl = true;
            }
            Iterator iterator = this.subOrgDNs.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMOrganization aMOrganization2 = aMOrganization.getSubOrganization(string);
                if (bl && (!aMOrganization2.isExists() || !AdminUtils.isDescendantOf(aMOrganization2, this.targetDN))) continue;
                AdminReq.writer.println("  " + string);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMOrganization2.getAttributes(), 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

