/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class OrgGetServiceTemplateReq
extends AdminReq {
    protected String serviceName;
    protected int schemaType;

    OrgGetServiceTemplateReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription69") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void setServiceNameSchemaType(String string, String string2) throws AdminException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new UnsupportedOperationException(AdminReq.bundle.getString("unsupportedSchemaType"));
        }
        this.serviceName = string;
        this.setSchemaType(string2);
    }

    protected void setSchemaType(String string) throws AdminException {
        this.schemaType = -1;
        if (string.equalsIgnoreCase("dynamic")) {
            this.schemaType = 301;
        } else if (string.equalsIgnoreCase("organization")) {
            this.schemaType = 302;
        } else {
            throw new UnsupportedOperationException(AdminReq.bundle.getString("unsupportedSchemaType"));
        }
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString(this.getType()) + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getservicetemplate") + "\n" + this.serviceName);
        }
        AdminReq.writer.println(AdminReq.bundle.getString(this.getType()) + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getservicetemplate") + "\n" + this.serviceName);
        AMTemplate aMTemplate = this.getTemplate(aMStoreConnection);
        try {
            if (aMTemplate == null || !aMTemplate.isExists()) {
                throw new AdminException(AdminReq.bundle.getString("templateDoesNotExist"));
            }
            PrintUtils printUtils = new PrintUtils(AdminReq.writer);
            printUtils.printAVPairs(aMTemplate.getAttributes(), 2);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    protected String getType() {
        return "organization";
    }

    protected AMTemplate getTemplate(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            return aMOrganization.getTemplate(this.serviceName, this.schemaType);
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

