/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class OrgCreateRoleReq
extends AdminReq {
    protected Map values;
    protected String roleDN;

    OrgCreateRoleReq(String string) {
        super(string);
    }

    void addRoleReq(String string, Map map) {
        this.roleDN = string;
        this.values = map;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println("Request Description: Create Roles in Organization " + this.targetDN);
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put(this.roleDN, this.values);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, hashMap);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createroles"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            hashMap.put(this.roleDN, this.values);
            Set set = aMOrganization.createRoles(hashMap);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg23"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMRole aMRole = (AMRole)iterator.next();
                AdminReq.writer.println(aMRole.getDN());
            }
            this.doLog(set, "create-role");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

