/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminResourceBundle;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.AdminXMLParser;
import com.iplanet.am.admin.cli.ArgumentValidator;
import com.iplanet.am.admin.cli.Authenticator;
import com.iplanet.am.admin.cli.SessionRequest;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPException;

class Main {
    static final String AUTH_CORE_SERVICE = "iPlanetAMAuthService";
    private static ResourceBundle bundle = null;
    private static final int INVALID = 0;
    private static final int RUN_AS_DN = 1;
    private static final int PASSWORD = 2;
    private static final int VERBOSE = 3;
    private static final int DEBUG = 4;
    private static final int SCHEMA = 5;
    private static final int DATA = 6;
    private static final int LOCALE_NAME = 7;
    private static final int HELP = 8;
    private static final int DELETE = 9;
    private static final int VERSION = 10;
    private static final int PASSWORDFILE = 11;
    private static final int SESSION = 12;
    private static final int CONTINUE = 13;
    private static final int IMPORT_REMOTE = 14;
    private static final int IMPORT_HOSTED = 15;
    private static final int ADD_ATTRIBUTES = 16;
    private static final int NOLOG = 17;
    private static Map arguments = new HashMap();
    private List infileNames = Collections.synchronizedList(new ArrayList());
    private List sessionNames = Collections.synchronizedList(new ArrayList());
    private String infileName;
    private static String bindDN = null;
    private static String bindPW = null;
    private String passwordfile = null;
    private String serverHost = "";
    private String serverPort = "";
    private String localeName = null;
    private static String inUserId = null;
    private String smUserId = null;
    private int operation = 0;
    private int comptype;
    private int debugFlg = 0;
    private int verboseFlg = 0;
    private boolean continueFlag = false;
    private AMStoreConnection connec = null;
    private SSOToken ssot;
    private String serverName = null;
    private boolean validSession = true;
    private String defaultUrlPrefix;
    private String addServiceName = null;
    private String addSchemaType = null;
    String sprotocol;
    String _sserver;
    String sserver;
    String sport;

    Main() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromPassword(String var1_1) throws AdminException {
        var2_2 = null;
        var3_3 = null;
        try {
            try {
                var3_3 = new BufferedReader(new FileReader(var1_1));
                if (var3_3.ready()) {
                    var2_2 = var3_3.readLine();
                }
                var4_4 = var2_2;
                var6_6 = null;
                if (var3_3 == null) return var4_4;
            }
            catch (IOException var4_5) {
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log("Could not open file " + var4_5.getMessage());
                }
                var6_7 = null;
                if (var3_3 == null) return null;
                try {
                    var3_3.close();
                    return null;
                }
                catch (Exception var7_10) {
                    if (AdminUtils.logEnabled() == false) return null;
                    AdminUtils.log("Unable to close the file: " + var7_10.getMessage());
                    return null;
                }
            }
        }
        catch (Throwable var5_12) {
            var6_8 = null;
            if (var3_3 == null) throw var5_12;
            ** try [egrp 2[TRYBLOCK] [2 : 95->102)] { 
lbl31:
            // 1 sources

            var3_3.close();
            throw var5_12;
lbl33:
            // 1 sources

            catch (Exception var7_11) {
                if (AdminUtils.logEnabled() == false) throw var5_12;
                AdminUtils.log("Unable to close the file: " + var7_11.getMessage());
            }
            throw var5_12;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 95->102)] { 
lbl39:
        // 1 sources

        var3_3.close();
        return var4_4;
lbl41:
        // 1 sources

        catch (Exception var7_9) {
            if (AdminUtils.logEnabled() == false) return var4_4;
            AdminUtils.log("Unable to close the file: " + var7_9.getMessage());
        }
        return var4_4;
    }

    private void parseCommandLine(String[] stringArray) throws AdminException {
        if (!ArgumentValidator.validateArguments(stringArray, bundle)) {
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.getToken(stringArray[n]);
            block0 : switch (n2) {
                case 14: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    int n3 = n;
                    while (n3 < stringArray.length) {
                        this.infileNames.add(stringArray[n3]);
                        ++n3;
                        ++n;
                    }
                    break;
                }
                case 15: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.defaultUrlPrefix = stringArray[n];
                    int n4 = ++n;
                    while (n4 < stringArray.length) {
                        this.infileNames.add(stringArray[n4]);
                        ++n4;
                        ++n;
                    }
                    break;
                }
                case 12: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if (arguments.containsKey(stringArray[n].toString())) {
                        throw new AdminException(bundle.getString("containsKey"));
                    }
                    this.serverName = stringArray[n] == null ? "*" : stringArray[n];
                    this.smUserId = ++n >= stringArray.length ? "*" : stringArray[n];
                    break;
                }
                case 1: {
                    String string;
                    String string2;
                    StringTokenizer stringTokenizer;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if ((this.comptype = this.getToken((bindDN = stringArray[n]).toLowerCase())) != 0) {
                        throw new AdminException(bundle.getString("nodnforadmin"));
                    }
                    StringTokenizer stringTokenizer2 = new StringTokenizer(bindDN, ",");
                    if (!stringTokenizer2.hasMoreTokens() || !(stringTokenizer = new StringTokenizer(string2 = stringTokenizer2.nextToken(), "=")).hasMoreTokens() || !(string = stringTokenizer.nextToken()).equals("uid") || !stringTokenizer.hasMoreTokens()) break;
                    inUserId = stringTokenizer.nextToken();
                    break;
                }
                case 2: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if ((this.comptype = this.getToken((bindPW = stringArray[n]).toLowerCase())) == 0) break;
                    throw new AdminException(bundle.getString("nopwdforadmin"));
                }
                case 11: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.passwordfile = stringArray[n];
                    bindPW = this.readFromPassword(this.passwordfile);
                    if (bindPW == null || (this.comptype = this.getToken(bindPW.toLowerCase())) != 0) {
                        throw new AdminException(bundle.getString("nopwdforadmin"));
                    }
                    bindPW = bindPW.trim();
                    break;
                }
                case 5: 
                case 6: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if (!stringArray[n].endsWith(".xml")) {
                        throw new AdminException(bundle.getString("nofile"));
                    }
                    int n5 = n;
                    while (n5 < stringArray.length) {
                        if (stringArray[n5].endsWith(".xml")) {
                            this.infileNames.add(stringArray[n5]);
                            n += n5;
                        } else {
                            n = n5 - 1;
                            break block0;
                        }
                        ++n5;
                    }
                    break;
                }
                case 7: {
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.localeName = stringArray[n];
                    if (this.localeName == null || (this.comptype = this.getToken(this.localeName.toLowerCase())) != 0) {
                        throw new AdminException(bundle.getString("nolocalename"));
                    }
                    if (this.debugFlg == 1) {
                        AdminResourceBundle.setLocale("en_US");
                        bundle = AdminResourceBundle.getResources();
                        break;
                    }
                    AdminResourceBundle.setLocale(this.localeName);
                    bundle = AdminResourceBundle.getResources();
                    break;
                }
                case 4: {
                    this.debugFlg = 1;
                    if (this.verboseFlg == 1) {
                        System.out.println(bundle.getString("dbgerror") + " --verbose|--debug");
                        System.exit(1);
                        break;
                    }
                    AdminUtils.setDebug(AdminReq.debug);
                    AdminUtils.setDebugStatus(3);
                    AdminUtils.enableDebug(true);
                    AdminResourceBundle.setLocale("en_US");
                    bundle = AdminResourceBundle.getResources();
                    break;
                }
                case 17: {
                    AdminUtils.setLog(false);
                    break;
                }
                case 3: {
                    this.verboseFlg = 1;
                    if (this.debugFlg == 1) {
                        System.out.println(bundle.getString("dbgerror") + " --verbose|--debug");
                        System.exit(1);
                        break;
                    }
                    AdminUtils.setDebug(AdminReq.debug);
                    AdminUtils.setDebugStatus(4);
                    AdminUtils.enableVerbose(true);
                    break;
                }
                case 8: {
                    this.printHelp();
                    System.exit(0);
                    break;
                }
                case 10: {
                    this.printVersion();
                    System.exit(0);
                    break;
                }
                case 13: {
                    this.continueFlag = true;
                    break;
                }
                case 9: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    if (stringArray[n] == null || arguments.containsKey(stringArray[n].toString())) {
                        throw new AdminException(bundle.getString("noservicename"));
                    }
                    int n6 = n;
                    while (n6 < stringArray.length) {
                        this.infileNames.add(stringArray[n6]);
                        ++n;
                        if (arguments.containsKey(stringArray[n6].toString())) {
                            n = n6 - 1;
                            this.infileNames.remove(stringArray[n6]);
                            break block0;
                        }
                        ++n6;
                    }
                    break;
                }
                case 16: {
                    this.operation = n2;
                    if (++n >= stringArray.length) {
                        System.err.println(bundle.getString("usage"));
                        System.exit(1);
                    }
                    this.addServiceName = stringArray[n];
                    this.addSchemaType = stringArray[++n];
                    int n7 = ++n;
                    while (n7 < stringArray.length) {
                        this.infileNames.add(stringArray[n7]);
                        ++n7;
                        ++n;
                    }
                    break;
                }
                default: {
                    AdminUtils.setDebug(AdminReq.debug);
                    AdminUtils.setDebugStatus(0);
                    System.err.println(bundle.getString("usage"));
                    System.err.println(bundle.getString("invopt") + stringArray[n]);
                    System.exit(1);
                }
            }
            ++n;
        }
        if (bindDN == null || bindPW == null) {
            AdminUtils.setDebug(AdminReq.debug);
            AdminUtils.setDebugStatus(0);
            System.err.println(bundle.getString("usage"));
            System.exit(1);
        }
    }

    private void runCommand() throws AdminException, LDAPException {
        if (this.operation != 12) {
            Authenticator authenticator = new Authenticator(bundle);
            authenticator.ldapLogin(bindDN, bindPW);
            this.ssot = authenticator.getSSOToken();
        }
        switch (this.operation) {
            case 14: {
                this.processImportRemoteRequests();
                break;
            }
            case 15: {
                this.processImportHostedRequests();
                break;
            }
            case 6: {
                this.processDataRequests();
                break;
            }
            case 5: {
                this.processSchemaRequests();
                break;
            }
            case 9: {
                this.processDeleteRequests();
                break;
            }
            case 12: {
                this.processSessionRequest();
                break;
            }
            case 16: {
                this.processAddAttributesRequests();
                break;
            }
            default: {
                AdminUtils.setDebug(AdminReq.debug);
                AdminUtils.setDebugStatus(0);
                System.err.println(bundle.getString("nodataschemawarning"));
                System.err.println(bundle.getString("usage"));
                System.exit(1);
            }
        }
    }

    private void processSessionRequest() throws AdminException {
        Authenticator authenticator = new Authenticator(bundle);
        String string = inUserId != null ? inUserId : bindDN;
        authenticator.sessionBasedLogin(string, bindPW);
        SSOToken sSOToken = authenticator.getSSOToken();
        AdminUtils.setSSOToken(sSOToken);
        SessionRequest sessionRequest = new SessionRequest(sSOToken, this.serverName, bundle);
        sessionRequest.displaySessions(this.smUserId);
    }

    private void processImportRemoteRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                this.convertImportMetaData(string, this.ssot, "remote", null);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processImportHostedRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                this.convertImportMetaData(string, this.ssot, "hosted", this.defaultUrlPrefix);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processDataRequests() throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg1"));
        }
        try {
            this.connec = new AMStoreConnection(this.ssot);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg2") + string);
            }
            try {
                this.processDataRequests(string, this.connec, this.ssot, this.continueFlag);
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processSchemaRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg3"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg4") + string);
            }
            try {
                Set set = this.registerServiceSchema(string);
                if (set == null || set.isEmpty()) continue;
                Object[] objectArray = new String[]{(String)set.iterator().next()};
                AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("service-loaded"), objectArray));
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processDeleteRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg28"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg29") + string);
            }
            try {
                this.processDeleteService(string);
                Object[] objectArray = new String[]{string};
                AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("service-deleted"), objectArray));
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void processAddAttributesRequests() {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("statusmsg34"));
        }
        Iterator iterator = this.infileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg35") + string);
            }
            try {
                this.processAddAttributes(this.addServiceName, this.addSchemaType, string);
                Object[] objectArray = new String[]{string};
                AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("addAttributes"), objectArray));
            }
            catch (AdminException adminException) {
                this.handleRunCommandException(adminException);
            }
        }
    }

    private void handleRunCommandException(Exception exception) {
        System.err.println(bundle.getString("execfailed") + "\n" + exception.getLocalizedMessage());
        if (AdminUtils.logEnabled() && this.debugFlg == 1) {
            AdminUtils.log(bundle.getString("execfailed"), exception);
        }
        AdminUtils.logOperation(1, bundle.getString("execfailed") + " " + exception);
        if (!this.continueFlag) {
            System.exit(1);
        }
    }

    void printVersion() {
        System.out.println("\n" + bundle.getString("version"));
    }

    void printHelp() {
        System.out.println(bundle.getString("usage"));
        System.out.println(bundle.getString("helpmsg1"));
        System.out.println(bundle.getString("helpmsg2"));
        System.out.println(bundle.getString("helpmsg3"));
        System.out.println(bundle.getString("helpmsg4"));
        System.out.println(bundle.getString("helpmsg5"));
        System.out.println(bundle.getString("helpmsg6"));
        System.out.println(bundle.getString("helpmsg7"));
        System.out.println(bundle.getString("helpmsg8"));
        System.out.println(bundle.getString("helpmsg9"));
        System.out.println(bundle.getString("helpmsg10"));
        System.out.println(bundle.getString("helpmsg11"));
        System.out.println(bundle.getString("helpmsg12"));
        System.out.println(bundle.getString("helpmsg13"));
        System.out.println(bundle.getString("helpmsg14"));
        System.out.println(bundle.getString("helpmsg15"));
        System.out.println(bundle.getString("helpmsg16"));
        System.out.println(bundle.getString("helpmsg17"));
        System.out.println(bundle.getString("helpmsg18"));
        System.out.println(bundle.getString("helpmsg19"));
        System.out.println(bundle.getString("helpmsg20"));
        System.out.println(bundle.getString("helpmsg21"));
    }

    void processDataRequests(String string, AMStoreConnection aMStoreConnection, SSOToken sSOToken, boolean bl) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("processingDataXML") + " " + string);
            AdminUtils.log(bundle.getString("statusmsg5"));
        }
        AdminXMLParser adminXMLParser = new AdminXMLParser();
        adminXMLParser.processAdminReqs(string, aMStoreConnection, sSOToken, bl);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("doneProcessingXML") + " " + string);
        }
    }

    void convertImportMetaData(String string, SSOToken sSOToken, String string2, String string3) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("processingDataXML") + " " + string);
            AdminUtils.log(bundle.getString("statusmsg5"));
        }
        AdminXMLParser adminXMLParser = new AdminXMLParser();
        adminXMLParser.processLibertyMetaData(string, sSOToken, string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(bundle.getString("doneProcessingXML") + " " + string);
        }
    }

    public static void main(String[] stringArray) throws AdminException {
        AdminResourceBundle.setLocale(null);
        bundle = AdminResourceBundle.getResources();
        Main main = new Main();
        try {
            main.parseCommandLine(stringArray);
            main.runCommand();
            System.out.println(bundle.getString("successful"));
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println(bundle.getString("oprfailed") + " " + exception.getLocalizedMessage());
            System.exit(1);
        }
    }

    int getToken(String string) {
        try {
            return (Integer)arguments.get(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Set registerServiceSchema(String string) throws AdminException {
        FileInputStream fileInputStream;
        Set set;
        block11: {
            set = Collections.EMPTY_SET;
            if (AdminUtils.logEnabled()) {
                AdminUtils.log("\n" + bundle.getString("loadingServiceSchema") + " " + string);
            }
            System.out.println(bundle.getString("loadServiceSchema") + " " + string);
            fileInputStream = null;
            ServiceManager serviceManager = new ServiceManager(this.ssot);
            fileInputStream = new FileInputStream(string);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg12") + string);
            }
            set = serviceManager.registerServices(fileInputStream);
            if (!AdminUtils.logEnabled()) break block11;
            AdminUtils.log(bundle.getString("doneLoadingServiceSchema") + " " + set.toString());
        }
        Object var8_6 = null;
        if (fileInputStream == null) return set;
        try {
            fileInputStream.close();
            return set;
        }
        catch (IOException iOException) {
            if (!AdminUtils.logEnabled()) return set;
            AdminUtils.log(bundle.getString("statusmsg15"), iOException);
        }
        return set;
        {
            catch (IOException iOException) {
                if (!AdminUtils.logEnabled()) throw new AdminException(bundle.getString("file"));
                AdminUtils.log(bundle.getString("file"), iOException);
                throw new AdminException(bundle.getString("file"));
            }
            catch (SSOException sSOException) {
                if (!AdminUtils.logEnabled()) throw new AdminException(sSOException);
                AdminUtils.log(bundle.getString("statusmsg13"), sSOException);
                throw new AdminException(sSOException);
            }
            catch (SMSException sMSException) {
                if (!AdminUtils.logEnabled()) throw new AdminException(sMSException);
                AdminUtils.log(bundle.getString("statusmsg14"), sMSException);
                throw new AdminException(sMSException);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (!AdminUtils.logEnabled()) throw throwable;
                AdminUtils.log(bundle.getString("statusmsg15"), iOException);
            }
            throw throwable;
        }
    }

    void processAddAttributes(String string, String string2, String string3) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("\n" + bundle.getString("addAttributes") + " " + string + " " + string2);
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.ssot);
            ServiceSchema serviceSchema = null;
            FileInputStream fileInputStream = null;
            if (string2.equalsIgnoreCase("global")) {
                serviceSchema = serviceSchemaManager.getGlobalSchema();
            } else if (string2.equalsIgnoreCase("organization")) {
                serviceSchema = serviceSchemaManager.getOrganizationSchema();
            } else if (string2.equalsIgnoreCase("dynamic")) {
                serviceSchema = serviceSchemaManager.getDynamicSchema();
            } else if (string2.equalsIgnoreCase("user")) {
                serviceSchema = serviceSchemaManager.getUserSchema();
            } else if (string2.equalsIgnoreCase("policy")) {
                serviceSchema = serviceSchemaManager.getPolicySchema();
            }
            fileInputStream = new FileInputStream(string3);
            serviceSchema.addAttributeSchema(fileInputStream);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("doneAddingAttributes") + " " + string);
            }
        }
        catch (IOException iOException) {
            if (AdminUtils.logEnabled() && this.debugFlg == 1) {
                AdminUtils.log(bundle.getString("file"), iOException);
            }
            throw new AdminException(bundle.getString("file"));
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled() && this.debugFlg == 1) {
                AdminUtils.log(bundle.getString("statusmsg13"), sSOException);
            }
            throw new AdminException("\n" + bundle.getString("smsdelexception") + "\n\n" + sSOException.getLocalizedMessage() + "\n");
        }
        catch (SMSException sMSException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg14"), sMSException);
            }
            throw new AdminException("\n" + bundle.getString("smsdelexception") + "\n\n" + sMSException.getLocalizedMessage() + "\n");
        }
    }

    void processDeleteService(String string) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("\n" + bundle.getString("deletingService") + " " + string);
        }
        System.out.println(bundle.getString("deleteServiceSchema") + " " + string);
        try {
            ServiceManager serviceManager = new ServiceManager(this.ssot);
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, this.ssot);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg12") + string);
            }
            if (serviceConfigManager.getGlobalConfig(null) != null) {
                serviceConfigManager.removeGlobalConfiguration(null);
            }
            if (string.equalsIgnoreCase(AUTH_CORE_SERVICE)) {
                serviceManager.deleteService(string);
            } else {
                Set set = serviceManager.getServiceVersions(string);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    serviceManager.removeService(string, (String)iterator.next());
                }
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("doneDeletingService") + " " + string);
            }
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg13"), sSOException);
            }
            throw new AdminException(sSOException);
        }
        catch (SMSException sMSException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg14"), sMSException);
            }
            throw new AdminException(sMSException);
        }
    }

    static {
        arguments.put("--debug", new Integer(4));
        arguments.put("-d", new Integer(4));
        arguments.put("--verbose", new Integer(3));
        arguments.put("-v", new Integer(3));
        arguments.put("--nolog", new Integer(17));
        arguments.put("-o", new Integer(17));
        arguments.put("--schema", new Integer(5));
        arguments.put("-s", new Integer(5));
        arguments.put("--data", new Integer(6));
        arguments.put("-t", new Integer(6));
        arguments.put("--runasdn", new Integer(1));
        arguments.put("-u", new Integer(1));
        arguments.put("--password", new Integer(2));
        arguments.put("-w", new Integer(2));
        arguments.put("--passwordfile", new Integer(11));
        arguments.put("-f", new Integer(11));
        arguments.put("--locale", new Integer(7));
        arguments.put("-l", new Integer(7));
        arguments.put("--help", new Integer(8));
        arguments.put("-h", new Integer(8));
        arguments.put("--deleteservice", new Integer(9));
        arguments.put("-r", new Integer(9));
        arguments.put("--version", new Integer(10));
        arguments.put("-n", new Integer(10));
        arguments.put("--session", new Integer(12));
        arguments.put("-m", new Integer(12));
        arguments.put("--continue", new Integer(13));
        arguments.put("-c", new Integer(13));
        arguments.put("--importRemote", new Integer(14));
        arguments.put("-i", new Integer(14));
        arguments.put("--importHosted", new Integer(15));
        arguments.put("-p", new Integer(15));
        arguments.put("--addAttribute", new Integer(16));
        arguments.put("-a", new Integer(16));
    }
}

